
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeletePriceQuoteRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="AirItineraryPricingInfo">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Record" minOccurs="0" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class Record -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="ReissueRecord" minOccurs="0" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class ReissueRecord -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.1.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class DeletePriceQuoteRQ implements Serializable
{
    private List<Record> recordList = new ArrayList<Record>();
    private List<ReissueRecord> reissueRecordList = new ArrayList<ReissueRecord>();
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the list of 'Record' element items.
     * 
     * @return list
     */
    public List<Record> getRecordList() {
        return recordList;
    }

    /** 
     * Set the list of 'Record' element items.
     * 
     * @param list
     */
    public void setRecordList(List<Record> list) {
        recordList = list;
    }

    /** 
     * Get the list of 'ReissueRecord' element items.
     * 
     * @return list
     */
    public List<ReissueRecord> getReissueRecordList() {
        return reissueRecordList;
    }

    /** 
     * Set the list of 'ReissueRecord' element items.
     * 
     * @param list
     */
    public void setReissueRecordList(List<ReissueRecord> list) {
        reissueRecordList = list;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Record" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="All"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Record implements Serializable
    {
        private Boolean all;
        private BigInteger endNumber;
        private BigInteger number;

        /** 
         * Get the 'All' attribute value.
         * 
         * @return value
         */
        public Boolean getAll() {
            return all;
        }

        /** 
         * Set the 'All' attribute value.
         * 
         * @param all
         */
        public void setAll(Boolean all) {
            this.all = all;
        }

        /** 
         * Get the 'EndNumber' attribute value.
         * 
         * @return value
         */
        public BigInteger getEndNumber() {
            return endNumber;
        }

        /** 
         * Set the 'EndNumber' attribute value.
         * 
         * @param endNumber
         */
        public void setEndNumber(BigInteger endNumber) {
            this.endNumber = endNumber;
        }

        /** 
         * Get the 'Number' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value.
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReissueRecord" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="All"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ReissueRecord implements Serializable
    {
        private Boolean all;
        private BigInteger endNumber;
        private BigInteger number;

        /** 
         * Get the 'All' attribute value.
         * 
         * @return value
         */
        public Boolean getAll() {
            return all;
        }

        /** 
         * Set the 'All' attribute value.
         * 
         * @param all
         */
        public void setAll(Boolean all) {
            this.all = all;
        }

        /** 
         * Get the 'EndNumber' attribute value.
         * 
         * @return value
         */
        public BigInteger getEndNumber() {
            return endNumber;
        }

        /** 
         * Set the 'EndNumber' attribute value.
         * 
         * @param endNumber
         */
        public void setEndNumber(BigInteger endNumber) {
            this.endNumber = endNumber;
        }

        /** 
         * Get the 'Number' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value.
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }
    }
}
