
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DesignatePrinterRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Printers" minOccurs="0">
 *         &lt;!-- Reference to inner class Printers -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Profile" minOccurs="0">
 *         &lt;!-- Reference to inner class Profile -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.0.2" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class DesignatePrinterRQ implements Serializable
{
    private Printers printers;
    private Profile profile;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'Printers' element value.
     * 
     * @return value
     */
    public Printers getPrinters() {
        return printers;
    }

    /** 
     * Set the 'Printers' element value.
     * 
     * @param printers
     */
    public void setPrinters(Printers printers) {
        this.printers = printers;
    }

    /** 
     * Get the 'Profile' element value.
     * 
     * @return value
     */
    public Profile getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value.
     * 
     * @param profile
     */
    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Printers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="BagTag" minOccurs="0">
     *         &lt;!-- Reference to inner class BagTag -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="BoardingPass" minOccurs="0">
     *         &lt;!-- Reference to inner class BoardingPass -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Hardcopy" minOccurs="0">
     *         &lt;!-- Reference to inner class Hardcopy -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="InvoiceItinerary" minOccurs="0">
     *         &lt;!-- Reference to inner class InvoiceItinerary -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ListLabel" minOccurs="0">
     *         &lt;!-- Reference to inner class ListLabel -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MiniItinerary" minOccurs="0">
     *         &lt;!-- Reference to inner class MiniItinerary -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Report" minOccurs="0">
     *         &lt;!-- Reference to inner class Report -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Ticket" minOccurs="0">
     *         &lt;!-- Reference to inner class Ticket -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Printers implements Serializable
    {
        private BagTag bagTag;
        private BoardingPass boardingPass;
        private Hardcopy hardcopy;
        private InvoiceItinerary invoiceItinerary;
        private ListLabel listLabel;
        private MiniItinerary miniItinerary;
        private Report report;
        private Ticket ticket;

        /** 
         * Get the 'BagTag' element value.
         * 
         * @return value
         */
        public BagTag getBagTag() {
            return bagTag;
        }

        /** 
         * Set the 'BagTag' element value.
         * 
         * @param bagTag
         */
        public void setBagTag(BagTag bagTag) {
            this.bagTag = bagTag;
        }

        /** 
         * Get the 'BoardingPass' element value.
         * 
         * @return value
         */
        public BoardingPass getBoardingPass() {
            return boardingPass;
        }

        /** 
         * Set the 'BoardingPass' element value.
         * 
         * @param boardingPass
         */
        public void setBoardingPass(BoardingPass boardingPass) {
            this.boardingPass = boardingPass;
        }

        /** 
         * Get the 'Hardcopy' element value.
         * 
         * @return value
         */
        public Hardcopy getHardcopy() {
            return hardcopy;
        }

        /** 
         * Set the 'Hardcopy' element value.
         * 
         * @param hardcopy
         */
        public void setHardcopy(Hardcopy hardcopy) {
            this.hardcopy = hardcopy;
        }

        /** 
         * Get the 'InvoiceItinerary' element value.
         * 
         * @return value
         */
        public InvoiceItinerary getInvoiceItinerary() {
            return invoiceItinerary;
        }

        /** 
         * Set the 'InvoiceItinerary' element value.
         * 
         * @param invoiceItinerary
         */
        public void setInvoiceItinerary(InvoiceItinerary invoiceItinerary) {
            this.invoiceItinerary = invoiceItinerary;
        }

        /** 
         * Get the 'ListLabel' element value.
         * 
         * @return value
         */
        public ListLabel getListLabel() {
            return listLabel;
        }

        /** 
         * Set the 'ListLabel' element value.
         * 
         * @param listLabel
         */
        public void setListLabel(ListLabel listLabel) {
            this.listLabel = listLabel;
        }

        /** 
         * Get the 'MiniItinerary' element value.
         * 
         * @return value
         */
        public MiniItinerary getMiniItinerary() {
            return miniItinerary;
        }

        /** 
         * Set the 'MiniItinerary' element value.
         * 
         * @param miniItinerary
         */
        public void setMiniItinerary(MiniItinerary miniItinerary) {
            this.miniItinerary = miniItinerary;
        }

        /** 
         * Get the 'Report' element value.
         * 
         * @return value
         */
        public Report getReport() {
            return report;
        }

        /** 
         * Set the 'Report' element value.
         * 
         * @param report
         */
        public void setReport(Report report) {
            this.report = report;
        }

        /** 
         * Get the 'Ticket' element value.
         * 
         * @return value
         */
        public Ticket getTicket() {
            return ticket;
        }

        /** 
         * Set the 'Ticket' element value.
         * 
         * @param ticket
         */
        public void setTicket(Ticket ticket) {
            this.ticket = ticket;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagTag" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Undesignate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BagTag implements Serializable
        {
            private String LNIATA;
            private Boolean undesignate;

            /** 
             * Get the 'LNIATA' attribute value.
             * 
             * @return value
             */
            public String getLNIATA() {
                return LNIATA;
            }

            /** 
             * Set the 'LNIATA' attribute value.
             * 
             * @param LNIATA
             */
            public void setLNIATA(String LNIATA) {
                this.LNIATA = LNIATA;
            }

            /** 
             * Get the 'Undesignate' attribute value.
             * 
             * @return value
             */
            public Boolean getUndesignate() {
                return undesignate;
            }

            /** 
             * Set the 'Undesignate' attribute value.
             * 
             * @param undesignate
             */
            public void setUndesignate(Boolean undesignate) {
                this.undesignate = undesignate;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BoardingPass" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="HostedCarrier"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Undesignate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BoardingPass implements Serializable
        {
            private Boolean hostedCarrier;
            private String LNIATA;
            private Boolean undesignate;

            /** 
             * Get the 'HostedCarrier' attribute value.
             * 
             * @return value
             */
            public Boolean getHostedCarrier() {
                return hostedCarrier;
            }

            /** 
             * Set the 'HostedCarrier' attribute value.
             * 
             * @param hostedCarrier
             */
            public void setHostedCarrier(Boolean hostedCarrier) {
                this.hostedCarrier = hostedCarrier;
            }

            /** 
             * Get the 'LNIATA' attribute value.
             * 
             * @return value
             */
            public String getLNIATA() {
                return LNIATA;
            }

            /** 
             * Set the 'LNIATA' attribute value.
             * 
             * @param LNIATA
             */
            public void setLNIATA(String LNIATA) {
                this.LNIATA = LNIATA;
            }

            /** 
             * Get the 'Undesignate' attribute value.
             * 
             * @return value
             */
            public Boolean getUndesignate() {
                return undesignate;
            }

            /** 
             * Set the 'Undesignate' attribute value.
             * 
             * @param undesignate
             */
            public void setUndesignate(Boolean undesignate) {
                this.undesignate = undesignate;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Hardcopy" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
         *     &lt;xs:attribute use="optional" name="Spacing">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Spacing -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Undesignate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Hardcopy implements Serializable
        {
            private String LNIATA;
            private Spacing spacing;
            private Boolean undesignate;

            /** 
             * Get the 'LNIATA' attribute value.
             * 
             * @return value
             */
            public String getLNIATA() {
                return LNIATA;
            }

            /** 
             * Set the 'LNIATA' attribute value.
             * 
             * @param LNIATA
             */
            public void setLNIATA(String LNIATA) {
                this.LNIATA = LNIATA;
            }

            /** 
             * Get the 'Spacing' attribute value.
             * 
             * @return value
             */
            public Spacing getSpacing() {
                return spacing;
            }

            /** 
             * Set the 'Spacing' attribute value.
             * 
             * @param spacing
             */
            public void setSpacing(Spacing spacing) {
                this.spacing = spacing;
            }

            /** 
             * Get the 'Undesignate' attribute value.
             * 
             * @return value
             */
            public Boolean getUndesignate() {
                return undesignate;
            }

            /** 
             * Set the 'Undesignate' attribute value.
             * 
             * @param undesignate
             */
            public void setUndesignate(Boolean undesignate) {
                this.undesignate = undesignate;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="1"/>
             *     &lt;xs:enumeration value="2"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Spacing implements Serializable {
                _1("1"), _2("2");
                private final String value;

                private Spacing(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static Spacing convert(String value) {
                    for (Spacing inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InvoiceItinerary" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Undesignate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class InvoiceItinerary implements Serializable
        {
            private String LNIATA;
            private Boolean undesignate;

            /** 
             * Get the 'LNIATA' attribute value.
             * 
             * @return value
             */
            public String getLNIATA() {
                return LNIATA;
            }

            /** 
             * Set the 'LNIATA' attribute value.
             * 
             * @param LNIATA
             */
            public void setLNIATA(String LNIATA) {
                this.LNIATA = LNIATA;
            }

            /** 
             * Get the 'Undesignate' attribute value.
             * 
             * @return value
             */
            public Boolean getUndesignate() {
                return undesignate;
            }

            /** 
             * Set the 'Undesignate' attribute value.
             * 
             * @param undesignate
             */
            public void setUndesignate(Boolean undesignate) {
                this.undesignate = undesignate;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListLabel" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Undesignate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ListLabel implements Serializable
        {
            private String LNIATA;
            private Boolean undesignate;

            /** 
             * Get the 'LNIATA' attribute value.
             * 
             * @return value
             */
            public String getLNIATA() {
                return LNIATA;
            }

            /** 
             * Set the 'LNIATA' attribute value.
             * 
             * @param LNIATA
             */
            public void setLNIATA(String LNIATA) {
                this.LNIATA = LNIATA;
            }

            /** 
             * Get the 'Undesignate' attribute value.
             * 
             * @return value
             */
            public Boolean getUndesignate() {
                return undesignate;
            }

            /** 
             * Set the 'Undesignate' attribute value.
             * 
             * @param undesignate
             */
            public void setUndesignate(Boolean undesignate) {
                this.undesignate = undesignate;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiniItinerary" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Undesignate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MiniItinerary implements Serializable
        {
            private String LNIATA;
            private Boolean undesignate;

            /** 
             * Get the 'LNIATA' attribute value.
             * 
             * @return value
             */
            public String getLNIATA() {
                return LNIATA;
            }

            /** 
             * Set the 'LNIATA' attribute value.
             * 
             * @param LNIATA
             */
            public void setLNIATA(String LNIATA) {
                this.LNIATA = LNIATA;
            }

            /** 
             * Get the 'Undesignate' attribute value.
             * 
             * @return value
             */
            public Boolean getUndesignate() {
                return undesignate;
            }

            /** 
             * Set the 'Undesignate' attribute value.
             * 
             * @param undesignate
             */
            public void setUndesignate(Boolean undesignate) {
                this.undesignate = undesignate;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Report" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Undesignate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Report implements Serializable
        {
            private String LNIATA;
            private Boolean undesignate;

            /** 
             * Get the 'LNIATA' attribute value.
             * 
             * @return value
             */
            public String getLNIATA() {
                return LNIATA;
            }

            /** 
             * Set the 'LNIATA' attribute value.
             * 
             * @param LNIATA
             */
            public void setLNIATA(String LNIATA) {
                this.LNIATA = LNIATA;
            }

            /** 
             * Get the 'Undesignate' attribute value.
             * 
             * @return value
             */
            public Boolean getUndesignate() {
                return undesignate;
            }

            /** 
             * Set the 'Undesignate' attribute value.
             * 
             * @param undesignate
             */
            public void setUndesignate(Boolean undesignate) {
                this.undesignate = undesignate;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticket" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="MiniItinerary" minOccurs="0">
         *         &lt;!-- Reference to inner class MiniItinerary -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Remote" minOccurs="0">
         *         &lt;!-- Reference to inner class Remote -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CountryCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Undesignate"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Ticket implements Serializable
        {
            private MiniItinerary miniItinerary;
            private Remote remote;
            private String countryCode;
            private String LNIATA;
            private Boolean undesignate;

            /** 
             * Get the 'MiniItinerary' element value.
             * 
             * @return value
             */
            public MiniItinerary getMiniItinerary() {
                return miniItinerary;
            }

            /** 
             * Set the 'MiniItinerary' element value.
             * 
             * @param miniItinerary
             */
            public void setMiniItinerary(MiniItinerary miniItinerary) {
                this.miniItinerary = miniItinerary;
            }

            /** 
             * Get the 'Remote' element value.
             * 
             * @return value
             */
            public Remote getRemote() {
                return remote;
            }

            /** 
             * Set the 'Remote' element value.
             * 
             * @param remote
             */
            public void setRemote(Remote remote) {
                this.remote = remote;
            }

            /** 
             * Get the 'CountryCode' attribute value.
             * 
             * @return value
             */
            public String getCountryCode() {
                return countryCode;
            }

            /** 
             * Set the 'CountryCode' attribute value.
             * 
             * @param countryCode
             */
            public void setCountryCode(String countryCode) {
                this.countryCode = countryCode;
            }

            /** 
             * Get the 'LNIATA' attribute value.
             * 
             * @return value
             */
            public String getLNIATA() {
                return LNIATA;
            }

            /** 
             * Set the 'LNIATA' attribute value.
             * 
             * @param LNIATA
             */
            public void setLNIATA(String LNIATA) {
                this.LNIATA = LNIATA;
            }

            /** 
             * Get the 'Undesignate' attribute value.
             * 
             * @return value
             */
            public Boolean getUndesignate() {
                return undesignate;
            }

            /** 
             * Set the 'Undesignate' attribute value.
             * 
             * @param undesignate
             */
            public void setUndesignate(Boolean undesignate) {
                this.undesignate = undesignate;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiniItinerary" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MiniItinerary implements Serializable
            {
                private String LNIATA;

                /** 
                 * Get the 'LNIATA' attribute value.
                 * 
                 * @return value
                 */
                public String getLNIATA() {
                    return LNIATA;
                }

                /** 
                 * Set the 'LNIATA' attribute value.
                 * 
                 * @param LNIATA
                 */
                public void setLNIATA(String LNIATA) {
                    this.LNIATA = LNIATA;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remote" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Remote implements Serializable
            {
                private String LNIATA;

                /** 
                 * Get the 'LNIATA' attribute value.
                 * 
                 * @return value
                 */
                public String getLNIATA() {
                    return LNIATA;
                }

                /** 
                 * Set the 'LNIATA' attribute value.
                 * 
                 * @param LNIATA
                 */
                public void setLNIATA(String LNIATA) {
                    this.LNIATA = LNIATA;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Profile" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Undesignate"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Profile implements Serializable
    {
        private BigInteger number;
        private Boolean undesignate;

        /** 
         * Get the 'Number' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value.
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }

        /** 
         * Get the 'Undesignate' attribute value.
         * 
         * @return value
         */
        public Boolean getUndesignate() {
            return undesignate;
        }

        /** 
         * Set the 'Undesignate' attribute value.
         * 
         * @param undesignate
         */
        public void setUndesignate(Boolean undesignate) {
            this.undesignate = undesignate;
        }
    }
}
