
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Diagnostic">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="ForceRouting" minOccurs="0" maxOccurs="2">
 *         &lt;!-- Reference to inner class ForceRouting -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="RequestedDiagnostic" minOccurs="0">
 *         &lt;!-- Reference to inner class RequestedDiagnostic -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Diagnostic implements Serializable
{
    private List<ForceRouting> forceRoutingList = new ArrayList<ForceRouting>();
    private RequestedDiagnostic requestedDiagnostic;

    /** 
     * Get the list of 'ForceRouting' element items.
     * 
     * @return list
     */
    public List<ForceRouting> getForceRoutingList() {
        return forceRoutingList;
    }

    /** 
     * Set the list of 'ForceRouting' element items.
     * 
     * @param list
     */
    public void setForceRoutingList(List<ForceRouting> list) {
        forceRoutingList = list;
    }

    /** 
     * Get the 'RequestedDiagnostic' element value.
     * 
     * @return value
     */
    public RequestedDiagnostic getRequestedDiagnostic() {
        return requestedDiagnostic;
    }

    /** 
     * Set the 'RequestedDiagnostic' element value.
     * 
     * @param requestedDiagnostic
     */
    public void setRequestedDiagnostic(RequestedDiagnostic requestedDiagnostic) {
        this.requestedDiagnostic = requestedDiagnostic;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ForceRouting" minOccurs="0" maxOccurs="2">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Value1"/>
     *     &lt;xs:attribute type="xs:string" name="Value2"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ForceRouting implements Serializable
    {
        private String value1;
        private String value2;

        /** 
         * Get the 'Value1' attribute value.
         * 
         * @return value
         */
        public String getValue1() {
            return value1;
        }

        /** 
         * Set the 'Value1' attribute value.
         * 
         * @param value1
         */
        public void setValue1(String value1) {
            this.value1 = value1;
        }

        /** 
         * Get the 'Value2' attribute value.
         * 
         * @return value
         */
        public String getValue2() {
            return value2;
        }

        /** 
         * Set the 'Value2' attribute value.
         * 
         * @param value2
         */
        public void setValue2(String value2) {
            this.value2 = value2;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestedDiagnostic" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Parameters" minOccurs="0">
     *         &lt;!-- Reference to inner class Parameters -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:int" use="required" name="Number"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RequestedDiagnostic implements Serializable
    {
        private Parameters parameters;
        private int number;

        /** 
         * Get the 'Parameters' element value.
         * 
         * @return value
         */
        public Parameters getParameters() {
            return parameters;
        }

        /** 
         * Set the 'Parameters' element value.
         * 
         * @param parameters
         */
        public void setParameters(Parameters parameters) {
            this.parameters = parameters;
        }

        /** 
         * Get the 'Number' attribute value. PRO/C10 for pricing and PRO/Q40 for FareDisplay
         * 
         * @return value
         */
        public int getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value. PRO/C10 for pricing and PRO/Q40 for FareDisplay
         * 
         * @param number
         */
        public void setNumber(int number) {
            this.number = number;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parameters" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Parameter" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Parameter -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Parameters implements Serializable
        {
            private List<Parameter> parameterList = new ArrayList<Parameter>();

            /** 
             * Get the list of 'Parameter' element items.
             * 
             * @return list
             */
            public List<Parameter> getParameterList() {
                return parameterList;
            }

            /** 
             * Set the list of 'Parameter' element items.
             * 
             * @param list
             */
            public void setParameterList(List<Parameter> list) {
                parameterList = list;
            }
            /** 
             * DIG
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parameter" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Parameter implements Serializable
            {
                private String value;

                /** 
                 * Get the 'Value' attribute value. DIG/S01
                 * 
                 * @return value
                 */
                public String getValue() {
                    return value;
                }

                /** 
                 * Set the 'Value' attribute value. DIG/S01
                 * 
                 * @param value
                 */
                public void setValue(String value) {
                    this.value = value;
                }
            }
        }
    }
}
