
package com.sabre.webservices.sabrexml;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DifferentialType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Departure" minOccurs="0">
 *       &lt;!-- Reference to inner class Departure -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Arrival" minOccurs="0">
 *       &lt;!-- Reference to inner class Arrival -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FareClass" minOccurs="0">
 *       &lt;!-- Reference to inner class FareClass -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="HigherIntermediateFare" minOccurs="0">
 *       &lt;!-- Reference to inner class HigherIntermediateFare -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:float" name="Amount"/>
 *   &lt;xs:attribute type="xs:double" name="MileageSurchargePercent"/>
 *   &lt;xs:attribute type="xs:string" name="HigherCabinCode"/>
 *   &lt;xs:attribute type="xs:string" name="LowerHIPCabinCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DifferentialType implements Serializable
{
    private Departure departure;
    private Arrival arrival;
    private FareClass fareClass;
    private HigherIntermediateFare higherIntermediateFare;
    private Float amount;
    private Double mileageSurchargePercent;
    private String higherCabinCode;
    private String lowerHIPCabinCode;

    /** 
     * Get the 'Departure' element value.
     * 
     * @return value
     */
    public Departure getDeparture() {
        return departure;
    }

    /** 
     * Set the 'Departure' element value.
     * 
     * @param departure
     */
    public void setDeparture(Departure departure) {
        this.departure = departure;
    }

    /** 
     * Get the 'Arrival' element value.
     * 
     * @return value
     */
    public Arrival getArrival() {
        return arrival;
    }

    /** 
     * Set the 'Arrival' element value.
     * 
     * @param arrival
     */
    public void setArrival(Arrival arrival) {
        this.arrival = arrival;
    }

    /** 
     * Get the 'FareClass' element value.
     * 
     * @return value
     */
    public FareClass getFareClass() {
        return fareClass;
    }

    /** 
     * Set the 'FareClass' element value.
     * 
     * @param fareClass
     */
    public void setFareClass(FareClass fareClass) {
        this.fareClass = fareClass;
    }

    /** 
     * Get the 'HigherIntermediateFare' element value.
     * 
     * @return value
     */
    public HigherIntermediateFare getHigherIntermediateFare() {
        return higherIntermediateFare;
    }

    /** 
     * Set the 'HigherIntermediateFare' element value.
     * 
     * @param higherIntermediateFare
     */
    public void setHigherIntermediateFare(
            HigherIntermediateFare higherIntermediateFare) {
        this.higherIntermediateFare = higherIntermediateFare;
    }

    /** 
     * Get the 'Amount' attribute value.  CAL/HIP/@C50
     * 
     * @return value
     */
    public Float getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' attribute value.  CAL/HIP/@C50
     * 
     * @param amount
     */
    public void setAmount(Float amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'MileageSurchargePercent' attribute value.  CAL/HIP/@Q48
     * 
     * @return value
     */
    public Double getMileageSurchargePercent() {
        return mileageSurchargePercent;
    }

    /** 
     * Set the 'MileageSurchargePercent' attribute value.  CAL/HIP/@Q48
     * 
     * @param mileageSurchargePercent
     */
    public void setMileageSurchargePercent(Double mileageSurchargePercent) {
        this.mileageSurchargePercent = mileageSurchargePercent;
    }

    /** 
     * Get the 'HigherCabinCode' attribute value.  CAL/HIP/@N04
     * 
     * @return value
     */
    public String getHigherCabinCode() {
        return higherCabinCode;
    }

    /** 
     * Set the 'HigherCabinCode' attribute value.  CAL/HIP/@N04
     * 
     * @param higherCabinCode
     */
    public void setHigherCabinCode(String higherCabinCode) {
        this.higherCabinCode = higherCabinCode;
    }

    /** 
     * Get the 'LowerHIPCabinCode' attribute value.  CAL/HIP/@N00
     * 
     * @return value
     */
    public String getLowerHIPCabinCode() {
        return lowerHIPCabinCode;
    }

    /** 
     * Set the 'LowerHIPCabinCode' attribute value.  CAL/HIP/@N00
     * 
     * @param lowerHIPCabinCode
     */
    public void setLowerHIPCabinCode(String lowerHIPCabinCode) {
        this.lowerHIPCabinCode = lowerHIPCabinCode;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Departure" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="CityCode"/>
     *     &lt;xs:attribute type="xs:unsignedByte" name="SegmentOrder"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Departure implements Serializable
    {
        private String cityCode;
        private String segmentOrder;

        /** 
         * Get the 'CityCode' attribute value.  CAL/HIP/@A13
         * 
         * @return value
         */
        public String getCityCode() {
            return cityCode;
        }

        /** 
         * Set the 'CityCode' attribute value.  CAL/HIP/@A13
         * 
         * @param cityCode
         */
        public void setCityCode(String cityCode) {
            this.cityCode = cityCode;
        }

        /** 
         * Get the 'SegmentOrder' attribute value.  CAL/HIP/@Q4S
         * 
         * @return value
         */
        public String getSegmentOrder() {
            return segmentOrder;
        }

        /** 
         * Set the 'SegmentOrder' attribute value.  CAL/HIP/@Q4S
         * 
         * @param segmentOrder
         */
        public void setSegmentOrder(String segmentOrder) {
            this.segmentOrder = segmentOrder;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Arrival" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="CityCode"/>
     *     &lt;xs:attribute type="xs:unsignedByte" name="SegmentOrder"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Arrival implements Serializable
    {
        private String cityCode;
        private String segmentOrder;

        /** 
         * Get the 'CityCode' attribute value.  CAL/HIP/@A14
         * 
         * @return value
         */
        public String getCityCode() {
            return cityCode;
        }

        /** 
         * Set the 'CityCode' attribute value.  CAL/HIP/@A14
         * 
         * @param cityCode
         */
        public void setCityCode(String cityCode) {
            this.cityCode = cityCode;
        }

        /** 
         * Get the 'SegmentOrder' attribute value.  CAL/HIP/@Q4T
         * 
         * @return value
         */
        public String getSegmentOrder() {
            return segmentOrder;
        }

        /** 
         * Set the 'SegmentOrder' attribute value.  CAL/HIP/@Q4T
         * 
         * @param segmentOrder
         */
        public void setSegmentOrder(String segmentOrder) {
            this.segmentOrder = segmentOrder;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareClass" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Low"/>
     *     &lt;xs:attribute type="xs:string" name="High"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareClass implements Serializable
    {
        private String low;
        private String high;

        /** 
         * Get the 'Low' attribute value.  CAL/HIP/@B30
         * 
         * @return value
         */
        public String getLow() {
            return low;
        }

        /** 
         * Set the 'Low' attribute value.  CAL/HIP/@B30
         * 
         * @param low
         */
        public void setLow(String low) {
            this.low = low;
        }

        /** 
         * Get the 'High' attribute value.  CAL/HIP/@BJ0
         * 
         * @return value
         */
        public String getHigh() {
            return high;
        }

        /** 
         * Set the 'High' attribute value.  CAL/HIP/@BJ0
         * 
         * @param high
         */
        public void setHigh(String high) {
            this.high = high;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HigherIntermediateFare" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Departure">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" name="LowCityCode"/>
     *           &lt;xs:attribute type="xs:string" name="HighCityCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Arrival">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" name="LowCityCode"/>
     *           &lt;xs:attribute type="xs:string" name="HighCityCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class HigherIntermediateFare implements Serializable
    {
        private String departureLowCityCode;
        private String departureHighCityCode;
        private String arrivalLowCityCode;
        private String arrivalHighCityCode;

        /** 
         * Get the 'LowCityCode' attribute value.  CAL/HIP/@A01
         * 
         * @return value
         */
        public String getDepartureLowCityCode() {
            return departureLowCityCode;
        }

        /** 
         * Set the 'LowCityCode' attribute value.  CAL/HIP/@A01
         * 
         * @param departureLowCityCode
         */
        public void setDepartureLowCityCode(String departureLowCityCode) {
            this.departureLowCityCode = departureLowCityCode;
        }

        /** 
         * Get the 'HighCityCode' attribute value.  CAL/HIP/@A03
         * 
         * @return value
         */
        public String getDepartureHighCityCode() {
            return departureHighCityCode;
        }

        /** 
         * Set the 'HighCityCode' attribute value.  CAL/HIP/@A03
         * 
         * @param departureHighCityCode
         */
        public void setDepartureHighCityCode(String departureHighCityCode) {
            this.departureHighCityCode = departureHighCityCode;
        }

        /** 
         * Get the 'LowCityCode' attribute value.  CAL/HIP/@A02
         * 
         * @return value
         */
        public String getArrivalLowCityCode() {
            return arrivalLowCityCode;
        }

        /** 
         * Set the 'LowCityCode' attribute value.  CAL/HIP/@A02
         * 
         * @param arrivalLowCityCode
         */
        public void setArrivalLowCityCode(String arrivalLowCityCode) {
            this.arrivalLowCityCode = arrivalLowCityCode;
        }

        /** 
         * Get the 'HighCityCode' attribute value.  CAL/HIP/@A04
         * 
         * @return value
         */
        public String getArrivalHighCityCode() {
            return arrivalHighCityCode;
        }

        /** 
         * Set the 'HighCityCode' attribute value.  CAL/HIP/@A04
         * 
         * @param arrivalHighCityCode
         */
        public void setArrivalHighCityCode(String arrivalHighCityCode) {
            this.arrivalHighCityCode = arrivalHighCityCode;
        }
    }
}
