
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DisplayCurrencyRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="Country" minOccurs="0" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Country -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class DisplayCurrencyRS implements Serializable
{
    private ApplicationResults applicationResults;
    private List<Country> countryList = new ArrayList<Country>();
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the list of 'Country' element items.
     * 
     * @return list
     */
    public List<Country> getCountryList() {
        return countryList;
    }

    /** 
     * Set the list of 'Country' element items.
     * 
     * @param list
     */
    public void setCountryList(List<Country> list) {
        countryList = list;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Country" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="CurrencyName" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="DecimalPlaces" minOccurs="0"/>
     *       &lt;xs:element name="Rate" minOccurs="0">
     *         &lt;!-- Reference to inner class Rate -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Country implements Serializable
    {
        private String currencyCode;
        private String currencyName;
        private String decimalPlaces;
        private Rate rate;
        private List<String> textList = new ArrayList<String>();
        private String name;
        private BigInteger RPH;

        /** 
         * Get the 'CurrencyCode' element value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'CurrencyCode' element value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'CurrencyName' element value.
         * 
         * @return value
         */
        public String getCurrencyName() {
            return currencyName;
        }

        /** 
         * Set the 'CurrencyName' element value.
         * 
         * @param currencyName
         */
        public void setCurrencyName(String currencyName) {
            this.currencyName = currencyName;
        }

        /** 
         * Get the 'DecimalPlaces' element value.
         * 
         * @return value
         */
        public String getDecimalPlaces() {
            return decimalPlaces;
        }

        /** 
         * Set the 'DecimalPlaces' element value.
         * 
         * @param decimalPlaces
         */
        public void setDecimalPlaces(String decimalPlaces) {
            this.decimalPlaces = decimalPlaces;
        }

        /** 
         * Get the 'Rate' element value.
         * 
         * @return value
         */
        public Rate getRate() {
            return rate;
        }

        /** 
         * Set the 'Rate' element value.
         * 
         * @param rate
         */
        public void setRate(Rate rate) {
            this.rate = rate;
        }

        /** 
         * Get the list of 'Text' element items.
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items.
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }

        /** 
         * Get the 'Name' attribute value.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'RPH' attribute value.
         * 
         * @return value
         */
        public BigInteger getRPH() {
            return RPH;
        }

        /** 
         * Set the 'RPH' attribute value.
         * 
         * @param RPH
         */
        public void setRPH(BigInteger RPH) {
            this.RPH = RPH;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rate" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Rate implements Serializable
        {
            private String string;
            private String type;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Type' attribute value.
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value.
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }
        }
    }
}
