
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="eTicketCouponRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="TicketingInfos" minOccurs="0">
 *         &lt;!-- Reference to inner class TicketingInfos -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ETicketCouponRS implements Serializable
{
    private ApplicationResults applicationResults;
    private TicketingInfos ticketingInfos;
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the 'TicketingInfos' element value.
     * 
     * @return value
     */
    public TicketingInfos getTicketingInfos() {
        return ticketingInfos;
    }

    /** 
     * Set the 'TicketingInfos' element value.
     * 
     * @param ticketingInfos
     */
    public void setTicketingInfos(TicketingInfos ticketingInfos) {
        this.ticketingInfos = ticketingInfos;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInfos" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TicketingInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class TicketingInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketingInfos implements Serializable
    {
        private TicketingInfo ticketingInfo;

        /** 
         * Get the 'TicketingInfo' element value.
         * 
         * @return value
         */
        public TicketingInfo getTicketingInfo() {
            return ticketingInfo;
        }

        /** 
         * Set the 'TicketingInfo' element value.
         * 
         * @param ticketingInfo
         */
        public void setTicketingInfo(TicketingInfo ticketingInfo) {
            this.ticketingInfo = ticketingInfo;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Ticketing" minOccurs="0">
         *         &lt;!-- Reference to inner class Ticketing -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketingInfo implements Serializable
        {
            private Ticketing ticketing;

            /** 
             * Get the 'Ticketing' element value.
             * 
             * @return value
             */
            public Ticketing getTicketing() {
                return ticketing;
            }

            /** 
             * Set the 'Ticketing' element value.
             * 
             * @param ticketing
             */
            public void setTicketing(Ticketing ticketing) {
                this.ticketing = ticketing;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CouponData" minOccurs="0">
             *         &lt;!-- Reference to inner class CouponData -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ExchangeData" minOccurs="0">
             *         &lt;!-- Reference to inner class ExchangeData -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="AgencyCity"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="AgentWorkArea"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="IATA_Number"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="IssuingAgent"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="PrimeHostID"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="TransactionDateTime"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Ticketing implements Serializable
            {
                private CouponData couponData;
                private ExchangeData exchangeData;
                private String agencyCity;
                private String agentWorkArea;
                private String IATANumber;
                private String issuingAgent;
                private String primeHostID;
                private String pseudoCityCode;
                private String transactionDateTime;

                /** 
                 * Get the 'CouponData' element value.
                 * 
                 * @return value
                 */
                public CouponData getCouponData() {
                    return couponData;
                }

                /** 
                 * Set the 'CouponData' element value.
                 * 
                 * @param couponData
                 */
                public void setCouponData(CouponData couponData) {
                    this.couponData = couponData;
                }

                /** 
                 * Get the 'ExchangeData' element value.
                 * 
                 * @return value
                 */
                public ExchangeData getExchangeData() {
                    return exchangeData;
                }

                /** 
                 * Set the 'ExchangeData' element value.
                 * 
                 * @param exchangeData
                 */
                public void setExchangeData(ExchangeData exchangeData) {
                    this.exchangeData = exchangeData;
                }

                /** 
                 * Get the 'AgencyCity' attribute value.
                 * 
                 * @return value
                 */
                public String getAgencyCity() {
                    return agencyCity;
                }

                /** 
                 * Set the 'AgencyCity' attribute value.
                 * 
                 * @param agencyCity
                 */
                public void setAgencyCity(String agencyCity) {
                    this.agencyCity = agencyCity;
                }

                /** 
                 * Get the 'AgentWorkArea' attribute value.
                 * 
                 * @return value
                 */
                public String getAgentWorkArea() {
                    return agentWorkArea;
                }

                /** 
                 * Set the 'AgentWorkArea' attribute value.
                 * 
                 * @param agentWorkArea
                 */
                public void setAgentWorkArea(String agentWorkArea) {
                    this.agentWorkArea = agentWorkArea;
                }

                /** 
                 * Get the 'IATA_Number' attribute value.
                 * 
                 * @return value
                 */
                public String getIATANumber() {
                    return IATANumber;
                }

                /** 
                 * Set the 'IATA_Number' attribute value.
                 * 
                 * @param IATANumber
                 */
                public void setIATANumber(String IATANumber) {
                    this.IATANumber = IATANumber;
                }

                /** 
                 * Get the 'IssuingAgent' attribute value.
                 * 
                 * @return value
                 */
                public String getIssuingAgent() {
                    return issuingAgent;
                }

                /** 
                 * Set the 'IssuingAgent' attribute value.
                 * 
                 * @param issuingAgent
                 */
                public void setIssuingAgent(String issuingAgent) {
                    this.issuingAgent = issuingAgent;
                }

                /** 
                 * Get the 'PrimeHostID' attribute value.
                 * 
                 * @return value
                 */
                public String getPrimeHostID() {
                    return primeHostID;
                }

                /** 
                 * Set the 'PrimeHostID' attribute value.
                 * 
                 * @param primeHostID
                 */
                public void setPrimeHostID(String primeHostID) {
                    this.primeHostID = primeHostID;
                }

                /** 
                 * Get the 'PseudoCityCode' attribute value.
                 * 
                 * @return value
                 */
                public String getPseudoCityCode() {
                    return pseudoCityCode;
                }

                /** 
                 * Set the 'PseudoCityCode' attribute value.
                 * 
                 * @param pseudoCityCode
                 */
                public void setPseudoCityCode(String pseudoCityCode) {
                    this.pseudoCityCode = pseudoCityCode;
                }

                /** 
                 * Get the 'TransactionDateTime' attribute value.
                 * 
                 * @return value
                 */
                public String getTransactionDateTime() {
                    return transactionDateTime;
                }

                /** 
                 * Set the 'TransactionDateTime' attribute value.
                 * 
                 * @param transactionDateTime
                 */
                public void setTransactionDateTime(String transactionDateTime) {
                    this.transactionDateTime = transactionDateTime;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponData" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="AirItineraryPricingInfo" minOccurs="0">
                 *         &lt;!-- Reference to inner class AirItineraryPricingInfo -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Coupons" minOccurs="0">
                 *         &lt;!-- Reference to inner class Coupons -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="CustomerInfo" minOccurs="0">
                 *         &lt;!-- Reference to inner class CustomerInfo -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="ItineraryRef" minOccurs="0">
                 *         &lt;!-- Reference to inner class ItineraryRef -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ConjunctiveTicketNumbers"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ExchangeInd"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="InformationSource"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="IssueDate"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="NumBooklets"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ProductID"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="TicketMedia"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="TicketMode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CouponData implements Serializable
                {
                    private AirItineraryPricingInfo airItineraryPricingInfo;
                    private Coupons coupons;
                    private CustomerInfo customerInfo;
                    private ItineraryRef itineraryRef;
                    private String conjunctiveTicketNumbers;
                    private String exchangeInd;
                    private String informationSource;
                    private String issueDate;
                    private String numBooklets;
                    private String productID;
                    private String ticketMedia;
                    private String ticketMode;

                    /** 
                     * Get the 'AirItineraryPricingInfo' element value.
                     * 
                     * @return value
                     */
                    public AirItineraryPricingInfo getAirItineraryPricingInfo() {
                        return airItineraryPricingInfo;
                    }

                    /** 
                     * Set the 'AirItineraryPricingInfo' element value.
                     * 
                     * @param airItineraryPricingInfo
                     */
                    public void setAirItineraryPricingInfo(
                            AirItineraryPricingInfo airItineraryPricingInfo) {
                        this.airItineraryPricingInfo = airItineraryPricingInfo;
                    }

                    /** 
                     * Get the 'Coupons' element value.
                     * 
                     * @return value
                     */
                    public Coupons getCoupons() {
                        return coupons;
                    }

                    /** 
                     * Set the 'Coupons' element value.
                     * 
                     * @param coupons
                     */
                    public void setCoupons(Coupons coupons) {
                        this.coupons = coupons;
                    }

                    /** 
                     * Get the 'CustomerInfo' element value.
                     * 
                     * @return value
                     */
                    public CustomerInfo getCustomerInfo() {
                        return customerInfo;
                    }

                    /** 
                     * Set the 'CustomerInfo' element value.
                     * 
                     * @param customerInfo
                     */
                    public void setCustomerInfo(CustomerInfo customerInfo) {
                        this.customerInfo = customerInfo;
                    }

                    /** 
                     * Get the 'ItineraryRef' element value.
                     * 
                     * @return value
                     */
                    public ItineraryRef getItineraryRef() {
                        return itineraryRef;
                    }

                    /** 
                     * Set the 'ItineraryRef' element value.
                     * 
                     * @param itineraryRef
                     */
                    public void setItineraryRef(ItineraryRef itineraryRef) {
                        this.itineraryRef = itineraryRef;
                    }

                    /** 
                     * Get the 'ConjunctiveTicketNumbers' attribute value.
                     * 
                     * @return value
                     */
                    public String getConjunctiveTicketNumbers() {
                        return conjunctiveTicketNumbers;
                    }

                    /** 
                     * Set the 'ConjunctiveTicketNumbers' attribute value.
                     * 
                     * @param conjunctiveTicketNumbers
                     */
                    public void setConjunctiveTicketNumbers(
                            String conjunctiveTicketNumbers) {
                        this.conjunctiveTicketNumbers = conjunctiveTicketNumbers;
                    }

                    /** 
                     * Get the 'ExchangeInd' attribute value.
                     * 
                     * @return value
                     */
                    public String getExchangeInd() {
                        return exchangeInd;
                    }

                    /** 
                     * Set the 'ExchangeInd' attribute value.
                     * 
                     * @param exchangeInd
                     */
                    public void setExchangeInd(String exchangeInd) {
                        this.exchangeInd = exchangeInd;
                    }

                    /** 
                     * Get the 'InformationSource' attribute value.
                     * 
                     * @return value
                     */
                    public String getInformationSource() {
                        return informationSource;
                    }

                    /** 
                     * Set the 'InformationSource' attribute value.
                     * 
                     * @param informationSource
                     */
                    public void setInformationSource(String informationSource) {
                        this.informationSource = informationSource;
                    }

                    /** 
                     * Get the 'IssueDate' attribute value.
                     * 
                     * @return value
                     */
                    public String getIssueDate() {
                        return issueDate;
                    }

                    /** 
                     * Set the 'IssueDate' attribute value.
                     * 
                     * @param issueDate
                     */
                    public void setIssueDate(String issueDate) {
                        this.issueDate = issueDate;
                    }

                    /** 
                     * Get the 'NumBooklets' attribute value.
                     * 
                     * @return value
                     */
                    public String getNumBooklets() {
                        return numBooklets;
                    }

                    /** 
                     * Set the 'NumBooklets' attribute value.
                     * 
                     * @param numBooklets
                     */
                    public void setNumBooklets(String numBooklets) {
                        this.numBooklets = numBooklets;
                    }

                    /** 
                     * Get the 'ProductID' attribute value.
                     * 
                     * @return value
                     */
                    public String getProductID() {
                        return productID;
                    }

                    /** 
                     * Set the 'ProductID' attribute value.
                     * 
                     * @param productID
                     */
                    public void setProductID(String productID) {
                        this.productID = productID;
                    }

                    /** 
                     * Get the 'TicketMedia' attribute value.
                     * 
                     * @return value
                     */
                    public String getTicketMedia() {
                        return ticketMedia;
                    }

                    /** 
                     * Set the 'TicketMedia' attribute value.
                     * 
                     * @param ticketMedia
                     */
                    public void setTicketMedia(String ticketMedia) {
                        this.ticketMedia = ticketMedia;
                    }

                    /** 
                     * Get the 'TicketMode' attribute value.
                     * 
                     * @return value
                     */
                    public String getTicketMode() {
                        return ticketMode;
                    }

                    /** 
                     * Set the 'TicketMode' attribute value.
                     * 
                     * @param ticketMode
                     */
                    public void setTicketMode(String ticketMode) {
                        this.ticketMode = ticketMode;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryPricingInfo" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Endorsements" minOccurs="0">
                     *         &lt;!-- Reference to inner class Endorsements -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FareCalculation" minOccurs="0">
                     *         &lt;!-- Reference to inner class FareCalculation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="ItinTotalFare" minOccurs="0">
                     *         &lt;!-- Reference to inner class ItinTotalFare -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="PassengerTypeQuantity" minOccurs="0">
                     *         &lt;!-- Reference to inner class PassengerTypeQuantity -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AirItineraryPricingInfo implements
                        Serializable
                    {
                        private Endorsements endorsements;
                        private FareCalculation fareCalculation;
                        private ItinTotalFare itinTotalFare;
                        private PassengerTypeQuantity passengerTypeQuantity;

                        /** 
                         * Get the 'Endorsements' element value.
                         * 
                         * @return value
                         */
                        public Endorsements getEndorsements() {
                            return endorsements;
                        }

                        /** 
                         * Set the 'Endorsements' element value.
                         * 
                         * @param endorsements
                         */
                        public void setEndorsements(Endorsements endorsements) {
                            this.endorsements = endorsements;
                        }

                        /** 
                         * Get the 'FareCalculation' element value.
                         * 
                         * @return value
                         */
                        public FareCalculation getFareCalculation() {
                            return fareCalculation;
                        }

                        /** 
                         * Set the 'FareCalculation' element value.
                         * 
                         * @param fareCalculation
                         */
                        public void setFareCalculation(
                                FareCalculation fareCalculation) {
                            this.fareCalculation = fareCalculation;
                        }

                        /** 
                         * Get the 'ItinTotalFare' element value.
                         * 
                         * @return value
                         */
                        public ItinTotalFare getItinTotalFare() {
                            return itinTotalFare;
                        }

                        /** 
                         * Set the 'ItinTotalFare' element value.
                         * 
                         * @param itinTotalFare
                         */
                        public void setItinTotalFare(ItinTotalFare itinTotalFare) {
                            this.itinTotalFare = itinTotalFare;
                        }

                        /** 
                         * Get the 'PassengerTypeQuantity' element value.
                         * 
                         * @return value
                         */
                        public PassengerTypeQuantity getPassengerTypeQuantity() {
                            return passengerTypeQuantity;
                        }

                        /** 
                         * Set the 'PassengerTypeQuantity' element value.
                         * 
                         * @param passengerTypeQuantity
                         */
                        public void setPassengerTypeQuantity(
                                PassengerTypeQuantity passengerTypeQuantity) {
                            this.passengerTypeQuantity = passengerTypeQuantity;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsements" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="5"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Endorsements implements
                            Serializable
                        {
                            private List<String> textList = new ArrayList<String>();

                            /** 
                             * Get the list of 'Text' element items.
                             * 
                             * @return list
                             */
                            public List<String> getTextList() {
                                return textList;
                            }

                            /** 
                             * Set the list of 'Text' element items.
                             * 
                             * @param list
                             */
                            public void setTextList(List<String> list) {
                                textList = list;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class FareCalculation implements
                            Serializable
                        {
                            private String text;

                            /** 
                             * Get the 'Text' element value.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinTotalFare" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="BaseFare" minOccurs="0">
                         *         &lt;!-- Reference to inner class BaseFare -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="EquivFare" minOccurs="0">
                         *         &lt;!-- Reference to inner class EquivFare -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="NetFare" minOccurs="0">
                         *         &lt;!-- Reference to inner class NetFare -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="Taxes" minOccurs="0">
                         *         &lt;!-- Reference to inner class Taxes -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="TotalFare" minOccurs="0">
                         *         &lt;!-- Reference to inner class TotalFare -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class ItinTotalFare implements
                            Serializable
                        {
                            private BaseFare baseFare;
                            private EquivFare equivFare;
                            private NetFare netFare;
                            private Taxes taxes;
                            private TotalFare totalFare;

                            /** 
                             * Get the 'BaseFare' element value.
                             * 
                             * @return value
                             */
                            public BaseFare getBaseFare() {
                                return baseFare;
                            }

                            /** 
                             * Set the 'BaseFare' element value.
                             * 
                             * @param baseFare
                             */
                            public void setBaseFare(BaseFare baseFare) {
                                this.baseFare = baseFare;
                            }

                            /** 
                             * Get the 'EquivFare' element value.
                             * 
                             * @return value
                             */
                            public EquivFare getEquivFare() {
                                return equivFare;
                            }

                            /** 
                             * Set the 'EquivFare' element value.
                             * 
                             * @param equivFare
                             */
                            public void setEquivFare(EquivFare equivFare) {
                                this.equivFare = equivFare;
                            }

                            /** 
                             * Get the 'NetFare' element value.
                             * 
                             * @return value
                             */
                            public NetFare getNetFare() {
                                return netFare;
                            }

                            /** 
                             * Set the 'NetFare' element value.
                             * 
                             * @param netFare
                             */
                            public void setNetFare(NetFare netFare) {
                                this.netFare = netFare;
                            }

                            /** 
                             * Get the 'Taxes' element value.
                             * 
                             * @return value
                             */
                            public Taxes getTaxes() {
                                return taxes;
                            }

                            /** 
                             * Set the 'Taxes' element value.
                             * 
                             * @param taxes
                             */
                            public void setTaxes(Taxes taxes) {
                                this.taxes = taxes;
                            }

                            /** 
                             * Get the 'TotalFare' element value.
                             * 
                             * @return value
                             */
                            public TotalFare getTotalFare() {
                                return totalFare;
                            }

                            /** 
                             * Set the 'TotalFare' element value.
                             * 
                             * @param totalFare
                             */
                            public void setTotalFare(TotalFare totalFare) {
                                this.totalFare = totalFare;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class BaseFare implements
                                Serializable
                            {
                                private String amount;
                                private String currencyCode;

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class EquivFare implements
                                Serializable
                            {
                                private String amount;
                                private String currencyCode;

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetFare" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="AmountType"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CreditCardAmount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="SellingAmount"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class NetFare implements Serializable
                            {
                                private String amount;
                                private String amountType;
                                private String creditCardAmount;
                                private String sellingAmount;

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'AmountType' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmountType() {
                                    return amountType;
                                }

                                /** 
                                 * Set the 'AmountType' attribute value.
                                 * 
                                 * @param amountType
                                 */
                                public void setAmountType(String amountType) {
                                    this.amountType = amountType;
                                }

                                /** 
                                 * Get the 'CreditCardAmount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCreditCardAmount() {
                                    return creditCardAmount;
                                }

                                /** 
                                 * Set the 'CreditCardAmount' attribute value.
                                 * 
                                 * @param creditCardAmount
                                 */
                                public void setCreditCardAmount(
                                        String creditCardAmount) {
                                    this.creditCardAmount = creditCardAmount;
                                }

                                /** 
                                 * Get the 'SellingAmount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getSellingAmount() {
                                    return sellingAmount;
                                }

                                /** 
                                 * Set the 'SellingAmount' attribute value.
                                 * 
                                 * @param sellingAmount
                                 */
                                public void setSellingAmount(
                                        String sellingAmount) {
                                    this.sellingAmount = sellingAmount;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
                             *         &lt;!-- Reference to inner class Tax -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Total"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Taxes implements Serializable
                            {
                                private List<Tax> taxList = new ArrayList<Tax>();
                                private String total;

                                /** 
                                 * Get the list of 'Tax' element items.
                                 * 
                                 * @return list
                                 */
                                public List<Tax> getTaxList() {
                                    return taxList;
                                }

                                /** 
                                 * Set the list of 'Tax' element items.
                                 * 
                                 * @param list
                                 */
                                public void setTaxList(List<Tax> list) {
                                    taxList = list;
                                }

                                /** 
                                 * Get the 'Total' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getTotal() {
                                    return total;
                                }

                                /** 
                                 * Set the 'Total' attribute value.
                                 * 
                                 * @param total
                                 */
                                public void setTotal(String total) {
                                    this.total = total;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Paid"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class Tax implements Serializable
                                {
                                    private String amount;
                                    private String paid;
                                    private String taxCode;

                                    /** 
                                     * Get the 'Amount' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getAmount() {
                                        return amount;
                                    }

                                    /** 
                                     * Set the 'Amount' attribute value.
                                     * 
                                     * @param amount
                                     */
                                    public void setAmount(String amount) {
                                        this.amount = amount;
                                    }

                                    /** 
                                     * Get the 'Paid' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getPaid() {
                                        return paid;
                                    }

                                    /** 
                                     * Set the 'Paid' attribute value.
                                     * 
                                     * @param paid
                                     */
                                    public void setPaid(String paid) {
                                        this.paid = paid;
                                    }

                                    /** 
                                     * Get the 'TaxCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getTaxCode() {
                                        return taxCode;
                                    }

                                    /** 
                                     * Set the 'TaxCode' attribute value.
                                     * 
                                     * @param taxCode
                                     */
                                    public void setTaxCode(String taxCode) {
                                        this.taxCode = taxCode;
                                    }
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class TotalFare implements
                                Serializable
                            {
                                private String amount;
                                private String currencyCode;

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeQuantity" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PassengerTypeQuantity implements
                            Serializable
                        {
                            private String code;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Coupons" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Coupon" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Coupon -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Coupons implements Serializable
                    {
                        private List<Coupon> couponList = new ArrayList<Coupon>();

                        /** 
                         * Get the list of 'Coupon' element items.
                         * 
                         * @return list
                         */
                        public List<Coupon> getCouponList() {
                            return couponList;
                        }

                        /** 
                         * Set the list of 'Coupon' element items.
                         * 
                         * @param list
                         */
                        public void setCouponList(List<Coupon> list) {
                            couponList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Coupon" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="FlightSegment" minOccurs="0">
                         *         &lt;!-- Reference to inner class FlightSegment -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CodedStatus"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="StatusCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Coupon implements Serializable
                        {
                            private FlightSegment flightSegment;
                            private String codedStatus;
                            private String number;
                            private String statusCode;

                            /** 
                             * Get the 'FlightSegment' element value.
                             * 
                             * @return value
                             */
                            public FlightSegment getFlightSegment() {
                                return flightSegment;
                            }

                            /** 
                             * Set the 'FlightSegment' element value.
                             * 
                             * @param flightSegment
                             */
                            public void setFlightSegment(
                                    FlightSegment flightSegment) {
                                this.flightSegment = flightSegment;
                            }

                            /** 
                             * Get the 'CodedStatus' attribute value.
                             * 
                             * @return value
                             */
                            public String getCodedStatus() {
                                return codedStatus;
                            }

                            /** 
                             * Set the 'CodedStatus' attribute value.
                             * 
                             * @param codedStatus
                             */
                            public void setCodedStatus(String codedStatus) {
                                this.codedStatus = codedStatus;
                            }

                            /** 
                             * Get the 'Number' attribute value.
                             * 
                             * @return value
                             */
                            public String getNumber() {
                                return number;
                            }

                            /** 
                             * Set the 'Number' attribute value.
                             * 
                             * @param number
                             */
                            public void setNumber(String number) {
                                this.number = number;
                            }

                            /** 
                             * Get the 'StatusCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getStatusCode() {
                                return statusCode;
                            }

                            /** 
                             * Set the 'StatusCode' attribute value.
                             * 
                             * @param statusCode
                             */
                            public void setStatusCode(String statusCode) {
                                this.statusCode = statusCode;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                             *         &lt;!-- Reference to inner class DestinationLocation -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="FareBasis" minOccurs="0">
                             *         &lt;!-- Reference to inner class FareBasis -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="MarketingAirline" minOccurs="0">
                             *         &lt;!-- Reference to inner class MarketingAirline -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="OperatingAirline" minOccurs="0">
                             *         &lt;!-- Reference to inner class OperatingAirline -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element name="OriginLocation" minOccurs="0">
                             *         &lt;!-- Reference to inner class OriginLocation -->
                             *       &lt;/xs:element>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="ConnectionInd"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class FlightSegment implements
                                Serializable
                            {
                                private DestinationLocation destinationLocation;
                                private FareBasis fareBasis;
                                private MarketingAirline marketingAirline;
                                private OperatingAirline operatingAirline;
                                private OriginLocation originLocation;
                                private String connectionInd;
                                private String departureDateTime;
                                private String flightNumber;
                                private String resBookDesigCode;
                                private String RPH;

                                /** 
                                 * Get the 'DestinationLocation' element value.
                                 * 
                                 * @return value
                                 */
                                public DestinationLocation getDestinationLocation() {
                                    return destinationLocation;
                                }

                                /** 
                                 * Set the 'DestinationLocation' element value.
                                 * 
                                 * @param destinationLocation
                                 */
                                public void setDestinationLocation(
                                        DestinationLocation destinationLocation) {
                                    this.destinationLocation = destinationLocation;
                                }

                                /** 
                                 * Get the 'FareBasis' element value.
                                 * 
                                 * @return value
                                 */
                                public FareBasis getFareBasis() {
                                    return fareBasis;
                                }

                                /** 
                                 * Set the 'FareBasis' element value.
                                 * 
                                 * @param fareBasis
                                 */
                                public void setFareBasis(FareBasis fareBasis) {
                                    this.fareBasis = fareBasis;
                                }

                                /** 
                                 * Get the 'MarketingAirline' element value.
                                 * 
                                 * @return value
                                 */
                                public MarketingAirline getMarketingAirline() {
                                    return marketingAirline;
                                }

                                /** 
                                 * Set the 'MarketingAirline' element value.
                                 * 
                                 * @param marketingAirline
                                 */
                                public void setMarketingAirline(
                                        MarketingAirline marketingAirline) {
                                    this.marketingAirline = marketingAirline;
                                }

                                /** 
                                 * Get the 'OperatingAirline' element value.
                                 * 
                                 * @return value
                                 */
                                public OperatingAirline getOperatingAirline() {
                                    return operatingAirline;
                                }

                                /** 
                                 * Set the 'OperatingAirline' element value.
                                 * 
                                 * @param operatingAirline
                                 */
                                public void setOperatingAirline(
                                        OperatingAirline operatingAirline) {
                                    this.operatingAirline = operatingAirline;
                                }

                                /** 
                                 * Get the 'OriginLocation' element value.
                                 * 
                                 * @return value
                                 */
                                public OriginLocation getOriginLocation() {
                                    return originLocation;
                                }

                                /** 
                                 * Set the 'OriginLocation' element value.
                                 * 
                                 * @param originLocation
                                 */
                                public void setOriginLocation(
                                        OriginLocation originLocation) {
                                    this.originLocation = originLocation;
                                }

                                /** 
                                 * Get the 'ConnectionInd' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getConnectionInd() {
                                    return connectionInd;
                                }

                                /** 
                                 * Set the 'ConnectionInd' attribute value.
                                 * 
                                 * @param connectionInd
                                 */
                                public void setConnectionInd(
                                        String connectionInd) {
                                    this.connectionInd = connectionInd;
                                }

                                /** 
                                 * Get the 'DepartureDateTime' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getDepartureDateTime() {
                                    return departureDateTime;
                                }

                                /** 
                                 * Set the 'DepartureDateTime' attribute value.
                                 * 
                                 * @param departureDateTime
                                 */
                                public void setDepartureDateTime(
                                        String departureDateTime) {
                                    this.departureDateTime = departureDateTime;
                                }

                                /** 
                                 * Get the 'FlightNumber' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getFlightNumber() {
                                    return flightNumber;
                                }

                                /** 
                                 * Set the 'FlightNumber' attribute value.
                                 * 
                                 * @param flightNumber
                                 */
                                public void setFlightNumber(String flightNumber) {
                                    this.flightNumber = flightNumber;
                                }

                                /** 
                                 * Get the 'ResBookDesigCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getResBookDesigCode() {
                                    return resBookDesigCode;
                                }

                                /** 
                                 * Set the 'ResBookDesigCode' attribute value.
                                 * 
                                 * @param resBookDesigCode
                                 */
                                public void setResBookDesigCode(
                                        String resBookDesigCode) {
                                    this.resBookDesigCode = resBookDesigCode;
                                }

                                /** 
                                 * Get the 'RPH' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getRPH() {
                                    return RPH;
                                }

                                /** 
                                 * Set the 'RPH' attribute value.
                                 * 
                                 * @param RPH
                                 */
                                public void setRPH(String RPH) {
                                    this.RPH = RPH;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class DestinationLocation
                                    implements Serializable
                                {
                                    private String locationCode;

                                    /** 
                                     * Get the 'LocationCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getLocationCode() {
                                        return locationCode;
                                    }

                                    /** 
                                     * Set the 'LocationCode' attribute value.
                                     * 
                                     * @param locationCode
                                     */
                                    public void setLocationCode(
                                            String locationCode) {
                                        this.locationCode = locationCode;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class FareBasis implements
                                    Serializable
                                {
                                    private String code;

                                    /** 
                                     * Get the 'Code' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCode() {
                                        return code;
                                    }

                                    /** 
                                     * Set the 'Code' attribute value.
                                     * 
                                     * @param code
                                     */
                                    public void setCode(String code) {
                                        this.code = code;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class MarketingAirline implements
                                    Serializable
                                {
                                    private String code;
                                    private String flightNumber;

                                    /** 
                                     * Get the 'Code' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCode() {
                                        return code;
                                    }

                                    /** 
                                     * Set the 'Code' attribute value.
                                     * 
                                     * @param code
                                     */
                                    public void setCode(String code) {
                                        this.code = code;
                                    }

                                    /** 
                                     * Get the 'FlightNumber' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getFlightNumber() {
                                        return flightNumber;
                                    }

                                    /** 
                                     * Set the 'FlightNumber' attribute value.
                                     * 
                                     * @param flightNumber
                                     */
                                    public void setFlightNumber(
                                            String flightNumber) {
                                        this.flightNumber = flightNumber;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingAirline" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class OperatingAirline implements
                                    Serializable
                                {
                                    private String code;

                                    /** 
                                     * Get the 'Code' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getCode() {
                                        return code;
                                    }

                                    /** 
                                     * Set the 'Code' attribute value.
                                     * 
                                     * @param code
                                     */
                                    public void setCode(String code) {
                                        this.code = code;
                                    }
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class OriginLocation implements
                                    Serializable
                                {
                                    private String locationCode;

                                    /** 
                                     * Get the 'LocationCode' attribute value.
                                     * 
                                     * @return value
                                     */
                                    public String getLocationCode() {
                                        return locationCode;
                                    }

                                    /** 
                                     * Set the 'LocationCode' attribute value.
                                     * 
                                     * @param locationCode
                                     */
                                    public void setLocationCode(
                                            String locationCode) {
                                        this.locationCode = locationCode;
                                    }
                                }
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerInfo" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Customer" minOccurs="0">
                     *         &lt;!-- Reference to inner class Customer -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CustomerInfo implements Serializable
                    {
                        private Customer customer;

                        /** 
                         * Get the 'Customer' element value.
                         * 
                         * @return value
                         */
                        public Customer getCustomer() {
                            return customer;
                        }

                        /** 
                         * Set the 'Customer' element value.
                         * 
                         * @param customer
                         */
                        public void setCustomer(Customer customer) {
                            this.customer = customer;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Customer" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Invoice" minOccurs="0">
                         *         &lt;!-- Reference to inner class Invoice -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="Payment" minOccurs="0" maxOccurs="2">
                         *         &lt;!-- Reference to inner class Payment -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="PersonName" minOccurs="0">
                         *         &lt;!-- Reference to inner class PersonName -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Customer implements Serializable
                        {
                            private Invoice invoice;
                            private List<Payment> paymentList = new ArrayList<Payment>();
                            private PersonName personName;

                            /** 
                             * Get the 'Invoice' element value.
                             * 
                             * @return value
                             */
                            public Invoice getInvoice() {
                                return invoice;
                            }

                            /** 
                             * Set the 'Invoice' element value.
                             * 
                             * @param invoice
                             */
                            public void setInvoice(Invoice invoice) {
                                this.invoice = invoice;
                            }

                            /** 
                             * Get the list of 'Payment' element items.
                             * 
                             * @return list
                             */
                            public List<Payment> getPaymentList() {
                                return paymentList;
                            }

                            /** 
                             * Set the list of 'Payment' element items.
                             * 
                             * @param list
                             */
                            public void setPaymentList(List<Payment> list) {
                                paymentList = list;
                            }

                            /** 
                             * Get the 'PersonName' element value.
                             * 
                             * @return value
                             */
                            public PersonName getPersonName() {
                                return personName;
                            }

                            /** 
                             * Set the 'PersonName' element value.
                             * 
                             * @param personName
                             */
                            public void setPersonName(PersonName personName) {
                                this.personName = personName;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Invoice" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Invoice implements Serializable
                            {
                                private String number;

                                /** 
                                 * Get the 'Number' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getNumber() {
                                    return number;
                                }

                                /** 
                                 * Set the 'Number' attribute value.
                                 * 
                                 * @param number
                                 */
                                public void setNumber(String number) {
                                    this.number = number;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0" maxOccurs="2">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element name="CC_Info" minOccurs="0">
                             *         &lt;!-- Reference to inner class CCInfo -->
                             *       &lt;/xs:element>
                             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="ApprovalID"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Conditions"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="ReferenceNumber"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Payment implements Serializable
                            {
                                private CCInfo CCInfo1;
                                private String text;
                                private String approvalID;
                                private String conditions;
                                private String referenceNumber;
                                private String RPH;
                                private String type;

                                /** 
                                 * Get the 'CC_Info' element value.
                                 * 
                                 * @return value
                                 */
                                public CCInfo getCCInfo1() {
                                    return CCInfo1;
                                }

                                /** 
                                 * Set the 'CC_Info' element value.
                                 * 
                                 * @param CCInfo1
                                 */
                                public void setCCInfo1(CCInfo CCInfo1) {
                                    this.CCInfo1 = CCInfo1;
                                }

                                /** 
                                 * Get the 'Text' element value.
                                 * 
                                 * @return value
                                 */
                                public String getText() {
                                    return text;
                                }

                                /** 
                                 * Set the 'Text' element value.
                                 * 
                                 * @param text
                                 */
                                public void setText(String text) {
                                    this.text = text;
                                }

                                /** 
                                 * Get the 'ApprovalID' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getApprovalID() {
                                    return approvalID;
                                }

                                /** 
                                 * Set the 'ApprovalID' attribute value.
                                 * 
                                 * @param approvalID
                                 */
                                public void setApprovalID(String approvalID) {
                                    this.approvalID = approvalID;
                                }

                                /** 
                                 * Get the 'Conditions' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getConditions() {
                                    return conditions;
                                }

                                /** 
                                 * Set the 'Conditions' attribute value.
                                 * 
                                 * @param conditions
                                 */
                                public void setConditions(String conditions) {
                                    this.conditions = conditions;
                                }

                                /** 
                                 * Get the 'ReferenceNumber' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getReferenceNumber() {
                                    return referenceNumber;
                                }

                                /** 
                                 * Set the 'ReferenceNumber' attribute value.
                                 * 
                                 * @param referenceNumber
                                 */
                                public void setReferenceNumber(
                                        String referenceNumber) {
                                    this.referenceNumber = referenceNumber;
                                }

                                /** 
                                 * Get the 'RPH' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getRPH() {
                                    return RPH;
                                }

                                /** 
                                 * Set the 'RPH' attribute value.
                                 * 
                                 * @param RPH
                                 */
                                public void setRPH(String RPH) {
                                    this.RPH = RPH;
                                }

                                /** 
                                 * Get the 'Type' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getType() {
                                    return type;
                                }

                                /** 
                                 * Set the 'Type' attribute value.
                                 * 
                                 * @param type
                                 */
                                public void setType(String type) {
                                    this.type = type;
                                }
                                /** 
                                 * Schema fragment(s) for this class:
                                 * <pre>
                                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CC_Info" minOccurs="0">
                                 *   &lt;xs:complexType>
                                 *     &lt;xs:sequence>
                                 *       &lt;xs:element name="PaymentCard" minOccurs="0">
                                 *         &lt;!-- Reference to inner class PaymentCard -->
                                 *       &lt;/xs:element>
                                 *     &lt;/xs:sequence>
                                 *   &lt;/xs:complexType>
                                 * &lt;/xs:element>
                                 * </pre>
                                 */
                                public static class CCInfo implements
                                    Serializable
                                {
                                    private PaymentCard paymentCard;

                                    /** 
                                     * Get the 'PaymentCard' element value.
                                     * 
                                     * @return value
                                     */
                                    public PaymentCard getPaymentCard() {
                                        return paymentCard;
                                    }

                                    /** 
                                     * Set the 'PaymentCard' element value.
                                     * 
                                     * @param paymentCard
                                     */
                                    public void setPaymentCard(
                                            PaymentCard paymentCard) {
                                        this.paymentCard = paymentCard;
                                    }
                                    /** 
                                     * Schema fragment(s) for this class:
                                     * <pre>
                                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCard" minOccurs="0">
                                     *   &lt;xs:complexType>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                                     *     &lt;xs:attribute type="xs:string" use="optional" name="ExpirationDate"/>
                                     *   &lt;/xs:complexType>
                                     * &lt;/xs:element>
                                     * </pre>
                                     */
                                    public static class PaymentCard implements
                                        Serializable
                                    {
                                        private String amount;
                                        private String code;
                                        private String expirationDate;

                                        /** 
                                         * Get the 'Amount' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getAmount() {
                                            return amount;
                                        }

                                        /** 
                                         * Set the 'Amount' attribute value.
                                         * 
                                         * @param amount
                                         */
                                        public void setAmount(String amount) {
                                            this.amount = amount;
                                        }

                                        /** 
                                         * Get the 'Code' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getCode() {
                                            return code;
                                        }

                                        /** 
                                         * Set the 'Code' attribute value.
                                         * 
                                         * @param code
                                         */
                                        public void setCode(String code) {
                                            this.code = code;
                                        }

                                        /** 
                                         * Get the 'ExpirationDate' attribute value.
                                         * 
                                         * @return value
                                         */
                                        public String getExpirationDate() {
                                            return expirationDate;
                                        }

                                        /** 
                                         * Set the 'ExpirationDate' attribute value.
                                         * 
                                         * @param expirationDate
                                         */
                                        public void setExpirationDate(
                                                String expirationDate) {
                                            this.expirationDate = expirationDate;
                                        }
                                    }
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:sequence>
                             *       &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
                             *       &lt;xs:element type="xs:string" name="Surname" minOccurs="0"/>
                             *     &lt;/xs:sequence>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="NameReference"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="PassengerType"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class PersonName implements
                                Serializable
                            {
                                private String givenName;
                                private String surname;
                                private String nameReference;
                                private String passengerType;

                                /** 
                                 * Get the 'GivenName' element value.
                                 * 
                                 * @return value
                                 */
                                public String getGivenName() {
                                    return givenName;
                                }

                                /** 
                                 * Set the 'GivenName' element value.
                                 * 
                                 * @param givenName
                                 */
                                public void setGivenName(String givenName) {
                                    this.givenName = givenName;
                                }

                                /** 
                                 * Get the 'Surname' element value.
                                 * 
                                 * @return value
                                 */
                                public String getSurname() {
                                    return surname;
                                }

                                /** 
                                 * Set the 'Surname' element value.
                                 * 
                                 * @param surname
                                 */
                                public void setSurname(String surname) {
                                    this.surname = surname;
                                }

                                /** 
                                 * Get the 'NameReference' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getNameReference() {
                                    return nameReference;
                                }

                                /** 
                                 * Set the 'NameReference' attribute value.
                                 * 
                                 * @param nameReference
                                 */
                                public void setNameReference(
                                        String nameReference) {
                                    this.nameReference = nameReference;
                                }

                                /** 
                                 * Get the 'PassengerType' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getPassengerType() {
                                    return passengerType;
                                }

                                /** 
                                 * Set the 'PassengerType' attribute value.
                                 * 
                                 * @param passengerType
                                 */
                                public void setPassengerType(
                                        String passengerType) {
                                    this.passengerType = passengerType;
                                }
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryRef" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CustomerIdentifier"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ID"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ItineraryRef implements Serializable
                    {
                        private String customerIdentifier;
                        private String ID;

                        /** 
                         * Get the 'CustomerIdentifier' attribute value.
                         * 
                         * @return value
                         */
                        public String getCustomerIdentifier() {
                            return customerIdentifier;
                        }

                        /** 
                         * Set the 'CustomerIdentifier' attribute value.
                         * 
                         * @param customerIdentifier
                         */
                        public void setCustomerIdentifier(
                                String customerIdentifier) {
                            this.customerIdentifier = customerIdentifier;
                        }

                        /** 
                         * Get the 'ID' attribute value.
                         * 
                         * @return value
                         */
                        public String getID() {
                            return ID;
                        }

                        /** 
                         * Set the 'ID' attribute value.
                         * 
                         * @param ID
                         */
                        public void setID(String ID) {
                            this.ID = ID;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeData" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="CouponData" minOccurs="0">
                 *         &lt;!-- Reference to inner class CouponData -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ExchangeData implements Serializable
                {
                    private CouponData couponData;

                    /** 
                     * Get the 'CouponData' element value.
                     * 
                     * @return value
                     */
                    public CouponData getCouponData() {
                        return couponData;
                    }

                    /** 
                     * Set the 'CouponData' element value.
                     * 
                     * @param couponData
                     */
                    public void setCouponData(CouponData couponData) {
                        this.couponData = couponData;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponData" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Payment" minOccurs="0">
                     *         &lt;!-- Reference to inner class Payment -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="BoardPoint"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CouponNumbers"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="IATA_Code"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="IssueDate"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="OriginalTicketNumber"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class CouponData implements Serializable
                    {
                        private Payment payment;
                        private String boardPoint;
                        private String couponNumbers;
                        private String IATACode;
                        private String issueDate;
                        private String originalTicketNumber;

                        /** 
                         * Get the 'Payment' element value.
                         * 
                         * @return value
                         */
                        public Payment getPayment() {
                            return payment;
                        }

                        /** 
                         * Set the 'Payment' element value.
                         * 
                         * @param payment
                         */
                        public void setPayment(Payment payment) {
                            this.payment = payment;
                        }

                        /** 
                         * Get the 'BoardPoint' attribute value.
                         * 
                         * @return value
                         */
                        public String getBoardPoint() {
                            return boardPoint;
                        }

                        /** 
                         * Set the 'BoardPoint' attribute value.
                         * 
                         * @param boardPoint
                         */
                        public void setBoardPoint(String boardPoint) {
                            this.boardPoint = boardPoint;
                        }

                        /** 
                         * Get the 'CouponNumbers' attribute value.
                         * 
                         * @return value
                         */
                        public String getCouponNumbers() {
                            return couponNumbers;
                        }

                        /** 
                         * Set the 'CouponNumbers' attribute value.
                         * 
                         * @param couponNumbers
                         */
                        public void setCouponNumbers(String couponNumbers) {
                            this.couponNumbers = couponNumbers;
                        }

                        /** 
                         * Get the 'IATA_Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getIATACode() {
                            return IATACode;
                        }

                        /** 
                         * Set the 'IATA_Code' attribute value.
                         * 
                         * @param IATACode
                         */
                        public void setIATACode(String IATACode) {
                            this.IATACode = IATACode;
                        }

                        /** 
                         * Get the 'IssueDate' attribute value.
                         * 
                         * @return value
                         */
                        public String getIssueDate() {
                            return issueDate;
                        }

                        /** 
                         * Set the 'IssueDate' attribute value.
                         * 
                         * @param issueDate
                         */
                        public void setIssueDate(String issueDate) {
                            this.issueDate = issueDate;
                        }

                        /** 
                         * Get the 'OriginalTicketNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getOriginalTicketNumber() {
                            return originalTicketNumber;
                        }

                        /** 
                         * Set the 'OriginalTicketNumber' attribute value.
                         * 
                         * @param originalTicketNumber
                         */
                        public void setOriginalTicketNumber(
                                String originalTicketNumber) {
                            this.originalTicketNumber = originalTicketNumber;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ReferenceNumber"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Payment implements Serializable
                        {
                            private String code;
                            private String referenceNumber;
                            private String type;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'ReferenceNumber' attribute value.
                             * 
                             * @return value
                             */
                            public String getReferenceNumber() {
                                return referenceNumber;
                            }

                            /** 
                             * Set the 'ReferenceNumber' attribute value.
                             * 
                             * @param referenceNumber
                             */
                            public void setReferenceNumber(
                                    String referenceNumber) {
                                this.referenceNumber = referenceNumber;
                            }

                            /** 
                             * Get the 'Type' attribute value.
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'Type' attribute value.
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }
                        }
                    }
                }
            }
        }
    }
}
