
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirAvailRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="OriginDestinationOptions" minOccurs="0">
 *         &lt;!-- Reference to inner class OriginDestinationOptions -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirAvailRS implements Serializable
{
    private ApplicationResults applicationResults;
    private OriginDestinationOptions originDestinationOptions;
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the 'OriginDestinationOptions' element value.
     * 
     * @return value
     */
    public OriginDestinationOptions getOriginDestinationOptions() {
        return originDestinationOptions;
    }

    /** 
     * Set the 'OriginDestinationOptions' element value.
     * 
     * @param originDestinationOptions
     */
    public void setOriginDestinationOptions(
            OriginDestinationOptions originDestinationOptions) {
        this.originDestinationOptions = originDestinationOptions;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOptions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OriginDestinationOption" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OriginDestinationOption -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="DestinationTimeZone"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="OriginTimeZone"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="TimeZoneDifference"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationOptions implements Serializable
    {
        private List<OriginDestinationOption> originDestinationOptionList = new ArrayList<OriginDestinationOption>();
        private String destinationTimeZone;
        private String originTimeZone;
        private String timeZoneDifference;

        /** 
         * Get the list of 'OriginDestinationOption' element items.
         * 
         * @return list
         */
        public List<OriginDestinationOption> getOriginDestinationOptionList() {
            return originDestinationOptionList;
        }

        /** 
         * Set the list of 'OriginDestinationOption' element items.
         * 
         * @param list
         */
        public void setOriginDestinationOptionList(
                List<OriginDestinationOption> list) {
            originDestinationOptionList = list;
        }

        /** 
         * Get the 'DestinationTimeZone' attribute value.
         * 
         * @return value
         */
        public String getDestinationTimeZone() {
            return destinationTimeZone;
        }

        /** 
         * Set the 'DestinationTimeZone' attribute value.
         * 
         * @param destinationTimeZone
         */
        public void setDestinationTimeZone(String destinationTimeZone) {
            this.destinationTimeZone = destinationTimeZone;
        }

        /** 
         * Get the 'OriginTimeZone' attribute value.
         * 
         * @return value
         */
        public String getOriginTimeZone() {
            return originTimeZone;
        }

        /** 
         * Set the 'OriginTimeZone' attribute value.
         * 
         * @param originTimeZone
         */
        public void setOriginTimeZone(String originTimeZone) {
            this.originTimeZone = originTimeZone;
        }

        /** 
         * Get the 'TimeZoneDifference' attribute value.
         * 
         * @return value
         */
        public String getTimeZoneDifference() {
            return timeZoneDifference;
        }

        /** 
         * Set the 'TimeZoneDifference' attribute value.
         * 
         * @param timeZoneDifference
         */
        public void setTimeZoneDifference(String timeZoneDifference) {
            this.timeZoneDifference = timeZoneDifference;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOption" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class FlightSegment -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginDestinationOption implements Serializable
        {
            private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
            private String RPH;

            /** 
             * Get the list of 'FlightSegment' element items.
             * 
             * @return list
             */
            public List<FlightSegment> getFlightSegmentList() {
                return flightSegmentList;
            }

            /** 
             * Set the list of 'FlightSegment' element items.
             * 
             * @param list
             */
            public void setFlightSegmentList(List<FlightSegment> list) {
                flightSegmentList = list;
            }

            /** 
             * Get the 'RPH' attribute value.
             * 
             * @return value
             */
            public String getRPH() {
                return RPH;
            }

            /** 
             * Set the 'RPH' attribute value.
             * 
             * @param RPH
             */
            public void setRPH(String RPH) {
                this.RPH = RPH;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BookingClassAvail" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class BookingClassAvail -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="DaysOfOperation" minOccurs="0">
             *         &lt;!-- Reference to inner class DaysOfOperation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="DestinationLocation" minOccurs="0">
             *         &lt;!-- Reference to inner class DestinationLocation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="DisclosureAirline" minOccurs="0">
             *         &lt;!-- Reference to inner class DisclosureAirline -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Equipment" minOccurs="0">
             *         &lt;!-- Reference to inner class Equipment -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FlightDetails" minOccurs="0">
             *         &lt;!-- Reference to inner class FlightDetails -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MarketingAirline" minOccurs="0">
             *         &lt;!-- Reference to inner class MarketingAirline -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Meal" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Meal -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="OperatingAirline" minOccurs="0">
             *         &lt;!-- Reference to inner class OperatingAirline -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="OriginLocation" minOccurs="0">
             *         &lt;!-- Reference to inner class OriginLocation -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ConnectionInd"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="DOT_Ind"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="eTicket"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="OnTimeInd"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="SmokingAllowed"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="StopQuantity"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FlightSegment implements Serializable
            {
                private List<BookingClassAvail> bookingClassAvailList = new ArrayList<BookingClassAvail>();
                private DaysOfOperation daysOfOperation;
                private DestinationLocation destinationLocation;
                private DisclosureAirline disclosureAirline;
                private Equipment equipment;
                private FlightDetails flightDetails;
                private MarketingAirline marketingAirline;
                private List<Meal> mealList = new ArrayList<Meal>();
                private OperatingAirline operatingAirline;
                private OriginLocation originLocation;
                private String arrivalDateTime;
                private String connectionInd;
                private String departureDateTime;
                private String DOTInd;
                private Boolean ETicket;
                private String flightNumber;
                private String onTimeInd;
                private String RPH;
                private Boolean smokingAllowed;
                private String stopQuantity;

                /** 
                 * Get the list of 'BookingClassAvail' element items.
                 * 
                 * @return list
                 */
                public List<BookingClassAvail> getBookingClassAvailList() {
                    return bookingClassAvailList;
                }

                /** 
                 * Set the list of 'BookingClassAvail' element items.
                 * 
                 * @param list
                 */
                public void setBookingClassAvailList(
                        List<BookingClassAvail> list) {
                    bookingClassAvailList = list;
                }

                /** 
                 * Get the 'DaysOfOperation' element value.
                 * 
                 * @return value
                 */
                public DaysOfOperation getDaysOfOperation() {
                    return daysOfOperation;
                }

                /** 
                 * Set the 'DaysOfOperation' element value.
                 * 
                 * @param daysOfOperation
                 */
                public void setDaysOfOperation(DaysOfOperation daysOfOperation) {
                    this.daysOfOperation = daysOfOperation;
                }

                /** 
                 * Get the 'DestinationLocation' element value.
                 * 
                 * @return value
                 */
                public DestinationLocation getDestinationLocation() {
                    return destinationLocation;
                }

                /** 
                 * Set the 'DestinationLocation' element value.
                 * 
                 * @param destinationLocation
                 */
                public void setDestinationLocation(
                        DestinationLocation destinationLocation) {
                    this.destinationLocation = destinationLocation;
                }

                /** 
                 * Get the 'DisclosureAirline' element value.
                 * 
                 * @return value
                 */
                public DisclosureAirline getDisclosureAirline() {
                    return disclosureAirline;
                }

                /** 
                 * Set the 'DisclosureAirline' element value.
                 * 
                 * @param disclosureAirline
                 */
                public void setDisclosureAirline(
                        DisclosureAirline disclosureAirline) {
                    this.disclosureAirline = disclosureAirline;
                }

                /** 
                 * Get the 'Equipment' element value.
                 * 
                 * @return value
                 */
                public Equipment getEquipment() {
                    return equipment;
                }

                /** 
                 * Set the 'Equipment' element value.
                 * 
                 * @param equipment
                 */
                public void setEquipment(Equipment equipment) {
                    this.equipment = equipment;
                }

                /** 
                 * Get the 'FlightDetails' element value.
                 * 
                 * @return value
                 */
                public FlightDetails getFlightDetails() {
                    return flightDetails;
                }

                /** 
                 * Set the 'FlightDetails' element value.
                 * 
                 * @param flightDetails
                 */
                public void setFlightDetails(FlightDetails flightDetails) {
                    this.flightDetails = flightDetails;
                }

                /** 
                 * Get the 'MarketingAirline' element value.
                 * 
                 * @return value
                 */
                public MarketingAirline getMarketingAirline() {
                    return marketingAirline;
                }

                /** 
                 * Set the 'MarketingAirline' element value.
                 * 
                 * @param marketingAirline
                 */
                public void setMarketingAirline(
                        MarketingAirline marketingAirline) {
                    this.marketingAirline = marketingAirline;
                }

                /** 
                 * Get the list of 'Meal' element items.
                 * 
                 * @return list
                 */
                public List<Meal> getMealList() {
                    return mealList;
                }

                /** 
                 * Set the list of 'Meal' element items.
                 * 
                 * @param list
                 */
                public void setMealList(List<Meal> list) {
                    mealList = list;
                }

                /** 
                 * Get the 'OperatingAirline' element value.
                 * 
                 * @return value
                 */
                public OperatingAirline getOperatingAirline() {
                    return operatingAirline;
                }

                /** 
                 * Set the 'OperatingAirline' element value.
                 * 
                 * @param operatingAirline
                 */
                public void setOperatingAirline(
                        OperatingAirline operatingAirline) {
                    this.operatingAirline = operatingAirline;
                }

                /** 
                 * Get the 'OriginLocation' element value.
                 * 
                 * @return value
                 */
                public OriginLocation getOriginLocation() {
                    return originLocation;
                }

                /** 
                 * Set the 'OriginLocation' element value.
                 * 
                 * @param originLocation
                 */
                public void setOriginLocation(OriginLocation originLocation) {
                    this.originLocation = originLocation;
                }

                /** 
                 * Get the 'ArrivalDateTime' attribute value.
                 * 
                 * @return value
                 */
                public String getArrivalDateTime() {
                    return arrivalDateTime;
                }

                /** 
                 * Set the 'ArrivalDateTime' attribute value.
                 * 
                 * @param arrivalDateTime
                 */
                public void setArrivalDateTime(String arrivalDateTime) {
                    this.arrivalDateTime = arrivalDateTime;
                }

                /** 
                 * Get the 'ConnectionInd' attribute value.
                 * 
                 * @return value
                 */
                public String getConnectionInd() {
                    return connectionInd;
                }

                /** 
                 * Set the 'ConnectionInd' attribute value.
                 * 
                 * @param connectionInd
                 */
                public void setConnectionInd(String connectionInd) {
                    this.connectionInd = connectionInd;
                }

                /** 
                 * Get the 'DepartureDateTime' attribute value.
                 * 
                 * @return value
                 */
                public String getDepartureDateTime() {
                    return departureDateTime;
                }

                /** 
                 * Set the 'DepartureDateTime' attribute value.
                 * 
                 * @param departureDateTime
                 */
                public void setDepartureDateTime(String departureDateTime) {
                    this.departureDateTime = departureDateTime;
                }

                /** 
                 * Get the 'DOT_Ind' attribute value.
                 * 
                 * @return value
                 */
                public String getDOTInd() {
                    return DOTInd;
                }

                /** 
                 * Set the 'DOT_Ind' attribute value.
                 * 
                 * @param DOTInd
                 */
                public void setDOTInd(String DOTInd) {
                    this.DOTInd = DOTInd;
                }

                /** 
                 * Get the 'eTicket' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getETicket() {
                    return ETicket;
                }

                /** 
                 * Set the 'eTicket' attribute value.
                 * 
                 * @param eTicket
                 */
                public void setETicket(Boolean eTicket) {
                    ETicket = eTicket;
                }

                /** 
                 * Get the 'FlightNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getFlightNumber() {
                    return flightNumber;
                }

                /** 
                 * Set the 'FlightNumber' attribute value.
                 * 
                 * @param flightNumber
                 */
                public void setFlightNumber(String flightNumber) {
                    this.flightNumber = flightNumber;
                }

                /** 
                 * Get the 'OnTimeInd' attribute value.
                 * 
                 * @return value
                 */
                public String getOnTimeInd() {
                    return onTimeInd;
                }

                /** 
                 * Set the 'OnTimeInd' attribute value.
                 * 
                 * @param onTimeInd
                 */
                public void setOnTimeInd(String onTimeInd) {
                    this.onTimeInd = onTimeInd;
                }

                /** 
                 * Get the 'RPH' attribute value.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }

                /** 
                 * Get the 'SmokingAllowed' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getSmokingAllowed() {
                    return smokingAllowed;
                }

                /** 
                 * Set the 'SmokingAllowed' attribute value.
                 * 
                 * @param smokingAllowed
                 */
                public void setSmokingAllowed(Boolean smokingAllowed) {
                    this.smokingAllowed = smokingAllowed;
                }

                /** 
                 * Get the 'StopQuantity' attribute value.
                 * 
                 * @return value
                 */
                public String getStopQuantity() {
                    return stopQuantity;
                }

                /** 
                 * Set the 'StopQuantity' attribute value.
                 * 
                 * @param stopQuantity
                 */
                public void setStopQuantity(String stopQuantity) {
                    this.stopQuantity = stopQuantity;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingClassAvail" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Availability"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="BrandID"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="AggregatedContent"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BookingClassAvail implements Serializable
                {
                    private String availability;
                    private String brandID;
                    private String resBookDesigCode;
                    private String RPH;
                    private Boolean aggregatedContent;

                    /** 
                     * Get the 'Availability' attribute value.
                     * 
                     * @return value
                     */
                    public String getAvailability() {
                        return availability;
                    }

                    /** 
                     * Set the 'Availability' attribute value.
                     * 
                     * @param availability
                     */
                    public void setAvailability(String availability) {
                        this.availability = availability;
                    }

                    /** 
                     * Get the 'BrandID' attribute value.
                     * 
                     * @return value
                     */
                    public String getBrandID() {
                        return brandID;
                    }

                    /** 
                     * Set the 'BrandID' attribute value.
                     * 
                     * @param brandID
                     */
                    public void setBrandID(String brandID) {
                        this.brandID = brandID;
                    }

                    /** 
                     * Get the 'ResBookDesigCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getResBookDesigCode() {
                        return resBookDesigCode;
                    }

                    /** 
                     * Set the 'ResBookDesigCode' attribute value.
                     * 
                     * @param resBookDesigCode
                     */
                    public void setResBookDesigCode(String resBookDesigCode) {
                        this.resBookDesigCode = resBookDesigCode;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }

                    /** 
                     * Get the 'AggregatedContent' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getAggregatedContent() {
                        return aggregatedContent;
                    }

                    /** 
                     * Set the 'AggregatedContent' attribute value.
                     * 
                     * @param aggregatedContent
                     */
                    public void setAggregatedContent(Boolean aggregatedContent) {
                        this.aggregatedContent = aggregatedContent;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DaysOfOperation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="OperationSchedule" minOccurs="0">
                 *         &lt;!-- Reference to inner class OperationSchedule -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class DaysOfOperation implements Serializable
                {
                    private OperationSchedule operationSchedule;

                    /** 
                     * Get the 'OperationSchedule' element value.
                     * 
                     * @return value
                     */
                    public OperationSchedule getOperationSchedule() {
                        return operationSchedule;
                    }

                    /** 
                     * Set the 'OperationSchedule' element value.
                     * 
                     * @param operationSchedule
                     */
                    public void setOperationSchedule(
                            OperationSchedule operationSchedule) {
                        this.operationSchedule = operationSchedule;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperationSchedule" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="OperationTimes" minOccurs="0">
                     *         &lt;!-- Reference to inner class OperationTimes -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OperationSchedule implements
                        Serializable
                    {
                        private OperationTimes operationTimes;

                        /** 
                         * Get the 'OperationTimes' element value.
                         * 
                         * @return value
                         */
                        public OperationTimes getOperationTimes() {
                            return operationTimes;
                        }

                        /** 
                         * Set the 'OperationTimes' element value.
                         * 
                         * @param operationTimes
                         */
                        public void setOperationTimes(
                                OperationTimes operationTimes) {
                            this.operationTimes = operationTimes;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperationTimes" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="OperationTime" minOccurs="0">
                         *         &lt;!-- Reference to inner class OperationTime -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OperationTimes implements
                            Serializable
                        {
                            private OperationTime operationTime;

                            /** 
                             * Get the 'OperationTime' element value.
                             * 
                             * @return value
                             */
                            public OperationTime getOperationTime() {
                                return operationTime;
                            }

                            /** 
                             * Set the 'OperationTime' element value.
                             * 
                             * @param operationTime
                             */
                            public void setOperationTime(
                                    OperationTime operationTime) {
                                this.operationTime = operationTime;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperationTime" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Fri"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Mon"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Sat"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Sun"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Thur"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Tue"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Weds"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class OperationTime implements
                                Serializable
                            {
                                private Boolean fri;
                                private Boolean mon;
                                private Boolean sat;
                                private Boolean sun;
                                private Boolean thur;
                                private Boolean tue;
                                private Boolean weds;

                                /** 
                                 * Get the 'Fri' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getFri() {
                                    return fri;
                                }

                                /** 
                                 * Set the 'Fri' attribute value.
                                 * 
                                 * @param fri
                                 */
                                public void setFri(Boolean fri) {
                                    this.fri = fri;
                                }

                                /** 
                                 * Get the 'Mon' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getMon() {
                                    return mon;
                                }

                                /** 
                                 * Set the 'Mon' attribute value.
                                 * 
                                 * @param mon
                                 */
                                public void setMon(Boolean mon) {
                                    this.mon = mon;
                                }

                                /** 
                                 * Get the 'Sat' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getSat() {
                                    return sat;
                                }

                                /** 
                                 * Set the 'Sat' attribute value.
                                 * 
                                 * @param sat
                                 */
                                public void setSat(Boolean sat) {
                                    this.sat = sat;
                                }

                                /** 
                                 * Get the 'Sun' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getSun() {
                                    return sun;
                                }

                                /** 
                                 * Set the 'Sun' attribute value.
                                 * 
                                 * @param sun
                                 */
                                public void setSun(Boolean sun) {
                                    this.sun = sun;
                                }

                                /** 
                                 * Get the 'Thur' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getThur() {
                                    return thur;
                                }

                                /** 
                                 * Set the 'Thur' attribute value.
                                 * 
                                 * @param thur
                                 */
                                public void setThur(Boolean thur) {
                                    this.thur = thur;
                                }

                                /** 
                                 * Get the 'Tue' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getTue() {
                                    return tue;
                                }

                                /** 
                                 * Set the 'Tue' attribute value.
                                 * 
                                 * @param tue
                                 */
                                public void setTue(Boolean tue) {
                                    this.tue = tue;
                                }

                                /** 
                                 * Get the 'Weds' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getWeds() {
                                    return weds;
                                }

                                /** 
                                 * Set the 'Weds' attribute value.
                                 * 
                                 * @param weds
                                 */
                                public void setWeds(Boolean weds) {
                                    this.weds = weds;
                                }
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class DestinationLocation implements Serializable
                {
                    private String locationCode;

                    /** 
                     * Get the 'LocationCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getLocationCode() {
                        return locationCode;
                    }

                    /** 
                     * Set the 'LocationCode' attribute value.
                     * 
                     * @param locationCode
                     */
                    public void setLocationCode(String locationCode) {
                        this.locationCode = locationCode;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DisclosureAirline" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CompanyShortName"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class DisclosureAirline implements Serializable
                {
                    private List<String> textList = new ArrayList<String>();
                    private String code;
                    private String companyShortName;

                    /** 
                     * Get the list of 'Text' element items.
                     * 
                     * @return list
                     */
                    public List<String> getTextList() {
                        return textList;
                    }

                    /** 
                     * Set the list of 'Text' element items.
                     * 
                     * @param list
                     */
                    public void setTextList(List<String> list) {
                        textList = list;
                    }

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'CompanyShortName' attribute value.
                     * 
                     * @return value
                     */
                    public String getCompanyShortName() {
                        return companyShortName;
                    }

                    /** 
                     * Set the 'CompanyShortName' attribute value.
                     * 
                     * @param companyShortName
                     */
                    public void setCompanyShortName(String companyShortName) {
                        this.companyShortName = companyShortName;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equipment" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="AirEquipType"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Equipment implements Serializable
                {
                    private String airEquipType;

                    /** 
                     * Get the 'AirEquipType' attribute value.
                     * 
                     * @return value
                     */
                    public String getAirEquipType() {
                        return airEquipType;
                    }

                    /** 
                     * Set the 'AirEquipType' attribute value.
                     * 
                     * @param airEquipType
                     */
                    public void setAirEquipType(String airEquipType) {
                        this.airEquipType = airEquipType;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDetails" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Canceled"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="Charter"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CodeshareBlockDisplay"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="DiscontinueDate"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="EffectiveDate"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="GroundTime"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="TotalTravelTime"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="TrafficRestrictionCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FlightDetails implements Serializable
                {
                    private List<String> textList = new ArrayList<String>();
                    private Boolean canceled;
                    private Boolean charter;
                    private String codeshareBlockDisplay;
                    private String discontinueDate;
                    private String effectiveDate;
                    private String groundTime;
                    private String totalTravelTime;
                    private String trafficRestrictionCode;

                    /** 
                     * Get the list of 'Text' element items.
                     * 
                     * @return list
                     */
                    public List<String> getTextList() {
                        return textList;
                    }

                    /** 
                     * Set the list of 'Text' element items.
                     * 
                     * @param list
                     */
                    public void setTextList(List<String> list) {
                        textList = list;
                    }

                    /** 
                     * Get the 'Canceled' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getCanceled() {
                        return canceled;
                    }

                    /** 
                     * Set the 'Canceled' attribute value.
                     * 
                     * @param canceled
                     */
                    public void setCanceled(Boolean canceled) {
                        this.canceled = canceled;
                    }

                    /** 
                     * Get the 'Charter' attribute value.
                     * 
                     * @return value
                     */
                    public Boolean getCharter() {
                        return charter;
                    }

                    /** 
                     * Set the 'Charter' attribute value.
                     * 
                     * @param charter
                     */
                    public void setCharter(Boolean charter) {
                        this.charter = charter;
                    }

                    /** 
                     * Get the 'CodeshareBlockDisplay' attribute value.
                     * 
                     * @return value
                     */
                    public String getCodeshareBlockDisplay() {
                        return codeshareBlockDisplay;
                    }

                    /** 
                     * Set the 'CodeshareBlockDisplay' attribute value.
                     * 
                     * @param codeshareBlockDisplay
                     */
                    public void setCodeshareBlockDisplay(
                            String codeshareBlockDisplay) {
                        this.codeshareBlockDisplay = codeshareBlockDisplay;
                    }

                    /** 
                     * Get the 'DiscontinueDate' attribute value.
                     * 
                     * @return value
                     */
                    public String getDiscontinueDate() {
                        return discontinueDate;
                    }

                    /** 
                     * Set the 'DiscontinueDate' attribute value.
                     * 
                     * @param discontinueDate
                     */
                    public void setDiscontinueDate(String discontinueDate) {
                        this.discontinueDate = discontinueDate;
                    }

                    /** 
                     * Get the 'EffectiveDate' attribute value.
                     * 
                     * @return value
                     */
                    public String getEffectiveDate() {
                        return effectiveDate;
                    }

                    /** 
                     * Set the 'EffectiveDate' attribute value.
                     * 
                     * @param effectiveDate
                     */
                    public void setEffectiveDate(String effectiveDate) {
                        this.effectiveDate = effectiveDate;
                    }

                    /** 
                     * Get the 'GroundTime' attribute value.
                     * 
                     * @return value
                     */
                    public String getGroundTime() {
                        return groundTime;
                    }

                    /** 
                     * Set the 'GroundTime' attribute value.
                     * 
                     * @param groundTime
                     */
                    public void setGroundTime(String groundTime) {
                        this.groundTime = groundTime;
                    }

                    /** 
                     * Get the 'TotalTravelTime' attribute value.
                     * 
                     * @return value
                     */
                    public String getTotalTravelTime() {
                        return totalTravelTime;
                    }

                    /** 
                     * Set the 'TotalTravelTime' attribute value.
                     * 
                     * @param totalTravelTime
                     */
                    public void setTotalTravelTime(String totalTravelTime) {
                        this.totalTravelTime = totalTravelTime;
                    }

                    /** 
                     * Get the 'TrafficRestrictionCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getTrafficRestrictionCode() {
                        return trafficRestrictionCode;
                    }

                    /** 
                     * Set the 'TrafficRestrictionCode' attribute value.
                     * 
                     * @param trafficRestrictionCode
                     */
                    public void setTrafficRestrictionCode(
                            String trafficRestrictionCode) {
                        this.trafficRestrictionCode = trafficRestrictionCode;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ParticipationLevel"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MarketingAirline implements Serializable
                {
                    private String code;
                    private String flightNumber;
                    private String participationLevel;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'FlightNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getFlightNumber() {
                        return flightNumber;
                    }

                    /** 
                     * Set the 'FlightNumber' attribute value.
                     * 
                     * @param flightNumber
                     */
                    public void setFlightNumber(String flightNumber) {
                        this.flightNumber = flightNumber;
                    }

                    /** 
                     * Get the 'ParticipationLevel' attribute value.
                     * 
                     * @return value
                     */
                    public String getParticipationLevel() {
                        return participationLevel;
                    }

                    /** 
                     * Set the 'ParticipationLevel' attribute value.
                     * 
                     * @param participationLevel
                     */
                    public void setParticipationLevel(String participationLevel) {
                        this.participationLevel = participationLevel;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Meal" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MealCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Meal implements Serializable
                {
                    private String mealCode;

                    /** 
                     * Get the 'MealCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getMealCode() {
                        return mealCode;
                    }

                    /** 
                     * Set the 'MealCode' attribute value.
                     * 
                     * @param mealCode
                     */
                    public void setMealCode(String mealCode) {
                        this.mealCode = mealCode;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingAirline" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OperatingAirline implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OriginLocation implements Serializable
                {
                    private String locationCode;

                    /** 
                     * Get the 'LocationCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getLocationCode() {
                        return locationCode;
                    }

                    /** 
                     * Set the 'LocationCode' attribute value.
                     * 
                     * @param locationCode
                     */
                    public void setLocationCode(String locationCode) {
                        this.locationCode = locationCode;
                    }
                }
            }
        }
    }
}
