
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirBookRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="OriginDestinationInformation">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="FlightSegment" maxOccurs="16">
 *               &lt;!-- Reference to inner class FlightSegment -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.2.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirBookRQ implements Serializable
{
    private List<FlightSegment> originDestinationInformationList = new ArrayList<FlightSegment>();
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the list of 'FlightSegment' element items.
     * 
     * @return list
     */
    public List<FlightSegment> getOriginDestinationInformationList() {
        return originDestinationInformationList;
    }

    /** 
     * Set the list of 'FlightSegment' element items.
     * 
     * @param list
     */
    public void setOriginDestinationInformationList(List<FlightSegment> list) {
        originDestinationInformationList = list;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" maxOccurs="16">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="DestinationLocation">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Equipment" minOccurs="0">
     *         &lt;!-- Reference to inner class Equipment -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MarketingAirline">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="required" name="Code"/>
     *           &lt;xs:attribute type="xs:string" use="required" name="FlightNumber"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="MarriageGrp" minOccurs="0">
     *         &lt;!-- Reference to inner class MarriageGrp -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OperatingAirline" minOccurs="0">
     *         &lt;!-- Reference to inner class OperatingAirline -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OriginLocation">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="BrandID"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="FlightNumber"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="NumberInParty"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="RedemptionSell"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="ResBookDesigCode"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="Status"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightSegment implements Serializable
    {
        private String destinationLocation;
        private Equipment equipment;
        private String marketingAirlineCode;
        private String marketingAirlineFlightNumber;
        private MarriageGrp marriageGrp;
        private OperatingAirline operatingAirline;
        private String originLocation;
        private String arrivalDateTime;
        private String brandID;
        private String departureDateTime;
        private String flightNumber;
        private String numberInParty;
        private Boolean redemptionSell;
        private String resBookDesigCode;
        private String status;

        /** 
         * Get the 'LocationCode' attribute value.
         * 
         * @return value
         */
        public String getDestinationLocation() {
            return destinationLocation;
        }

        /** 
         * Set the 'LocationCode' attribute value.
         * 
         * @param destinationLocation
         */
        public void setDestinationLocation(String destinationLocation) {
            this.destinationLocation = destinationLocation;
        }

        /** 
         * Get the 'Equipment' element value.
         * 
         * @return value
         */
        public Equipment getEquipment() {
            return equipment;
        }

        /** 
         * Set the 'Equipment' element value.
         * 
         * @param equipment
         */
        public void setEquipment(Equipment equipment) {
            this.equipment = equipment;
        }

        /** 
         * Get the 'Code' attribute value.
         * 
         * @return value
         */
        public String getMarketingAirlineCode() {
            return marketingAirlineCode;
        }

        /** 
         * Set the 'Code' attribute value.
         * 
         * @param marketingAirlineCode
         */
        public void setMarketingAirlineCode(String marketingAirlineCode) {
            this.marketingAirlineCode = marketingAirlineCode;
        }

        /** 
         * Get the 'FlightNumber' attribute value.
         * 
         * @return value
         */
        public String getMarketingAirlineFlightNumber() {
            return marketingAirlineFlightNumber;
        }

        /** 
         * Set the 'FlightNumber' attribute value.
         * 
         * @param marketingAirlineFlightNumber
         */
        public void setMarketingAirlineFlightNumber(
                String marketingAirlineFlightNumber) {
            this.marketingAirlineFlightNumber = marketingAirlineFlightNumber;
        }

        /** 
         * Get the 'MarriageGrp' element value.
         * 
         * @return value
         */
        public MarriageGrp getMarriageGrp() {
            return marriageGrp;
        }

        /** 
         * Set the 'MarriageGrp' element value.
         * 
         * @param marriageGrp
         */
        public void setMarriageGrp(MarriageGrp marriageGrp) {
            this.marriageGrp = marriageGrp;
        }

        /** 
         * Get the 'OperatingAirline' element value.
         * 
         * @return value
         */
        public OperatingAirline getOperatingAirline() {
            return operatingAirline;
        }

        /** 
         * Set the 'OperatingAirline' element value.
         * 
         * @param operatingAirline
         */
        public void setOperatingAirline(OperatingAirline operatingAirline) {
            this.operatingAirline = operatingAirline;
        }

        /** 
         * Get the 'LocationCode' attribute value.
         * 
         * @return value
         */
        public String getOriginLocation() {
            return originLocation;
        }

        /** 
         * Set the 'LocationCode' attribute value.
         * 
         * @param originLocation
         */
        public void setOriginLocation(String originLocation) {
            this.originLocation = originLocation;
        }

        /** 
         * Get the 'ArrivalDateTime' attribute value.
         * 
         * @return value
         */
        public String getArrivalDateTime() {
            return arrivalDateTime;
        }

        /** 
         * Set the 'ArrivalDateTime' attribute value.
         * 
         * @param arrivalDateTime
         */
        public void setArrivalDateTime(String arrivalDateTime) {
            this.arrivalDateTime = arrivalDateTime;
        }

        /** 
         * Get the 'BrandID' attribute value.
         * 
         * @return value
         */
        public String getBrandID() {
            return brandID;
        }

        /** 
         * Set the 'BrandID' attribute value.
         * 
         * @param brandID
         */
        public void setBrandID(String brandID) {
            this.brandID = brandID;
        }

        /** 
         * Get the 'DepartureDateTime' attribute value.
         * 
         * @return value
         */
        public String getDepartureDateTime() {
            return departureDateTime;
        }

        /** 
         * Set the 'DepartureDateTime' attribute value.
         * 
         * @param departureDateTime
         */
        public void setDepartureDateTime(String departureDateTime) {
            this.departureDateTime = departureDateTime;
        }

        /** 
         * Get the 'FlightNumber' attribute value.
         * 
         * @return value
         */
        public String getFlightNumber() {
            return flightNumber;
        }

        /** 
         * Set the 'FlightNumber' attribute value.
         * 
         * @param flightNumber
         */
        public void setFlightNumber(String flightNumber) {
            this.flightNumber = flightNumber;
        }

        /** 
         * Get the 'NumberInParty' attribute value.
         * 
         * @return value
         */
        public String getNumberInParty() {
            return numberInParty;
        }

        /** 
         * Set the 'NumberInParty' attribute value.
         * 
         * @param numberInParty
         */
        public void setNumberInParty(String numberInParty) {
            this.numberInParty = numberInParty;
        }

        /** 
         * Get the 'RedemptionSell' attribute value.
         * 
         * @return value
         */
        public Boolean getRedemptionSell() {
            return redemptionSell;
        }

        /** 
         * Set the 'RedemptionSell' attribute value.
         * 
         * @param redemptionSell
         */
        public void setRedemptionSell(Boolean redemptionSell) {
            this.redemptionSell = redemptionSell;
        }

        /** 
         * Get the 'ResBookDesigCode' attribute value.
         * 
         * @return value
         */
        public String getResBookDesigCode() {
            return resBookDesigCode;
        }

        /** 
         * Set the 'ResBookDesigCode' attribute value.
         * 
         * @param resBookDesigCode
         */
        public void setResBookDesigCode(String resBookDesigCode) {
            this.resBookDesigCode = resBookDesigCode;
        }

        /** 
         * Get the 'Status' attribute value.
         * 
         * @return value
         */
        public String getStatus() {
            return status;
        }

        /** 
         * Set the 'Status' attribute value.
         * 
         * @param status
         */
        public void setStatus(String status) {
            this.status = status;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equipment" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="AirEquipType"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Equipment implements Serializable
        {
            private String airEquipType;

            /** 
             * Get the 'AirEquipType' attribute value.
             * 
             * @return value
             */
            public String getAirEquipType() {
                return airEquipType;
            }

            /** 
             * Set the 'AirEquipType' attribute value.
             * 
             * @param airEquipType
             */
            public void setAirEquipType(String airEquipType) {
                this.airEquipType = airEquipType;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarriageGrp" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MarriageGrp implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingAirline" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OperatingAirline implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
    }
}
