
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirBookRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="OriginDestinationOption" minOccurs="0">
 *         &lt;!-- Reference to inner class OriginDestinationOption -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirBookRS implements Serializable
{
    private ApplicationResults applicationResults;
    private OriginDestinationOption originDestinationOption;
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the 'OriginDestinationOption' element value.
     * 
     * @return value
     */
    public OriginDestinationOption getOriginDestinationOption() {
        return originDestinationOption;
    }

    /** 
     * Set the 'OriginDestinationOption' element value.
     * 
     * @param originDestinationOption
     */
    public void setOriginDestinationOption(
            OriginDestinationOption originDestinationOption) {
        this.originDestinationOption = originDestinationOption;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOption" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="16">
     *         &lt;!-- Reference to inner class FlightSegment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationOption implements Serializable
    {
        private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();

        /** 
         * Get the list of 'FlightSegment' element items.
         * 
         * @return list
         */
        public List<FlightSegment> getFlightSegmentList() {
            return flightSegmentList;
        }

        /** 
         * Set the list of 'FlightSegment' element items.
         * 
         * @param list
         */
        public void setFlightSegmentList(List<FlightSegment> list) {
            flightSegmentList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="16">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="DestinationLocation" minOccurs="0">
         *         &lt;!-- Reference to inner class DestinationLocation -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MarketingAirline" minOccurs="0">
         *         &lt;!-- Reference to inner class MarketingAirline -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MarriageGrp" minOccurs="0">
         *         &lt;!-- Reference to inner class MarriageGrp -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OriginLocation" minOccurs="0">
         *         &lt;!-- Reference to inner class OriginLocation -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="eTicket"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="NumberInParty"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegment implements Serializable
        {
            private DestinationLocation destinationLocation;
            private MarketingAirline marketingAirline;
            private MarriageGrp marriageGrp;
            private OriginLocation originLocation;
            private String arrivalDateTime;
            private String departureDateTime;
            private Boolean ETicket;
            private String flightNumber;
            private String numberInParty;
            private String resBookDesigCode;
            private String status;

            /** 
             * Get the 'DestinationLocation' element value.
             * 
             * @return value
             */
            public DestinationLocation getDestinationLocation() {
                return destinationLocation;
            }

            /** 
             * Set the 'DestinationLocation' element value.
             * 
             * @param destinationLocation
             */
            public void setDestinationLocation(
                    DestinationLocation destinationLocation) {
                this.destinationLocation = destinationLocation;
            }

            /** 
             * Get the 'MarketingAirline' element value.
             * 
             * @return value
             */
            public MarketingAirline getMarketingAirline() {
                return marketingAirline;
            }

            /** 
             * Set the 'MarketingAirline' element value.
             * 
             * @param marketingAirline
             */
            public void setMarketingAirline(MarketingAirline marketingAirline) {
                this.marketingAirline = marketingAirline;
            }

            /** 
             * Get the 'MarriageGrp' element value.
             * 
             * @return value
             */
            public MarriageGrp getMarriageGrp() {
                return marriageGrp;
            }

            /** 
             * Set the 'MarriageGrp' element value.
             * 
             * @param marriageGrp
             */
            public void setMarriageGrp(MarriageGrp marriageGrp) {
                this.marriageGrp = marriageGrp;
            }

            /** 
             * Get the 'OriginLocation' element value.
             * 
             * @return value
             */
            public OriginLocation getOriginLocation() {
                return originLocation;
            }

            /** 
             * Set the 'OriginLocation' element value.
             * 
             * @param originLocation
             */
            public void setOriginLocation(OriginLocation originLocation) {
                this.originLocation = originLocation;
            }

            /** 
             * Get the 'ArrivalDateTime' attribute value.
             * 
             * @return value
             */
            public String getArrivalDateTime() {
                return arrivalDateTime;
            }

            /** 
             * Set the 'ArrivalDateTime' attribute value.
             * 
             * @param arrivalDateTime
             */
            public void setArrivalDateTime(String arrivalDateTime) {
                this.arrivalDateTime = arrivalDateTime;
            }

            /** 
             * Get the 'DepartureDateTime' attribute value.
             * 
             * @return value
             */
            public String getDepartureDateTime() {
                return departureDateTime;
            }

            /** 
             * Set the 'DepartureDateTime' attribute value.
             * 
             * @param departureDateTime
             */
            public void setDepartureDateTime(String departureDateTime) {
                this.departureDateTime = departureDateTime;
            }

            /** 
             * Get the 'eTicket' attribute value.
             * 
             * @return value
             */
            public Boolean getETicket() {
                return ETicket;
            }

            /** 
             * Set the 'eTicket' attribute value.
             * 
             * @param eTicket
             */
            public void setETicket(Boolean eTicket) {
                ETicket = eTicket;
            }

            /** 
             * Get the 'FlightNumber' attribute value.
             * 
             * @return value
             */
            public String getFlightNumber() {
                return flightNumber;
            }

            /** 
             * Set the 'FlightNumber' attribute value.
             * 
             * @param flightNumber
             */
            public void setFlightNumber(String flightNumber) {
                this.flightNumber = flightNumber;
            }

            /** 
             * Get the 'NumberInParty' attribute value.
             * 
             * @return value
             */
            public String getNumberInParty() {
                return numberInParty;
            }

            /** 
             * Set the 'NumberInParty' attribute value.
             * 
             * @param numberInParty
             */
            public void setNumberInParty(String numberInParty) {
                this.numberInParty = numberInParty;
            }

            /** 
             * Get the 'ResBookDesigCode' attribute value.
             * 
             * @return value
             */
            public String getResBookDesigCode() {
                return resBookDesigCode;
            }

            /** 
             * Set the 'ResBookDesigCode' attribute value.
             * 
             * @param resBookDesigCode
             */
            public void setResBookDesigCode(String resBookDesigCode) {
                this.resBookDesigCode = resBookDesigCode;
            }

            /** 
             * Get the 'Status' attribute value.
             * 
             * @return value
             */
            public String getStatus() {
                return status;
            }

            /** 
             * Set the 'Status' attribute value.
             * 
             * @param status
             */
            public void setStatus(String status) {
                this.status = status;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DestinationLocation implements Serializable
            {
                private String locationCode;

                /** 
                 * Get the 'LocationCode' attribute value.
                 * 
                 * @return value
                 */
                public String getLocationCode() {
                    return locationCode;
                }

                /** 
                 * Set the 'LocationCode' attribute value.
                 * 
                 * @param locationCode
                 */
                public void setLocationCode(String locationCode) {
                    this.locationCode = locationCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MarketingAirline implements Serializable
            {
                private String code;
                private String flightNumber;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'FlightNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getFlightNumber() {
                    return flightNumber;
                }

                /** 
                 * Set the 'FlightNumber' attribute value.
                 * 
                 * @param flightNumber
                 */
                public void setFlightNumber(String flightNumber) {
                    this.flightNumber = flightNumber;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarriageGrp" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MarriageGrp implements Serializable
            {
                private String ind;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public String getInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(String ind) {
                    this.ind = ind;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OriginLocation implements Serializable
            {
                private String locationCode;

                /** 
                 * Get the 'LocationCode' attribute value.
                 * 
                 * @return value
                 */
                public String getLocationCode() {
                    return locationCode;
                }

                /** 
                 * Set the 'LocationCode' attribute value.
                 * 
                 * @param locationCode
                 */
                public void setLocationCode(String locationCode) {
                    this.locationCode = locationCode;
                }
            }
        }
    }
}
