
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_AirPriceRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="PriceQuote" minOccurs="0">
 *         &lt;!-- Reference to inner class PriceQuote -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTAAirPriceRS implements Serializable
{
    private ApplicationResults applicationResults;
    private PriceQuote priceQuote;
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the 'PriceQuote' element value.
     * 
     * @return value
     */
    public PriceQuote getPriceQuote() {
        return priceQuote;
    }

    /** 
     * Set the 'PriceQuote' element value.
     * 
     * @param priceQuote
     */
    public void setPriceQuote(PriceQuote priceQuote) {
        this.priceQuote = priceQuote;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="MiscInformation" minOccurs="0">
     *         &lt;!-- Reference to inner class MiscInformation -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PricedItinerary" minOccurs="0">
     *         &lt;!-- Reference to inner class PricedItinerary -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PriceQuote implements Serializable
    {
        private MiscInformation miscInformation;
        private PricedItinerary pricedItinerary;

        /** 
         * Get the 'MiscInformation' element value.
         * 
         * @return value
         */
        public MiscInformation getMiscInformation() {
            return miscInformation;
        }

        /** 
         * Set the 'MiscInformation' element value.
         * 
         * @param miscInformation
         */
        public void setMiscInformation(MiscInformation miscInformation) {
            this.miscInformation = miscInformation;
        }

        /** 
         * Get the 'PricedItinerary' element value.
         * 
         * @return value
         */
        public PricedItinerary getPricedItinerary() {
            return pricedItinerary;
        }

        /** 
         * Set the 'PricedItinerary' element value.
         * 
         * @param pricedItinerary
         */
        public void setPricedItinerary(PricedItinerary pricedItinerary) {
            this.pricedItinerary = pricedItinerary;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MiscInformation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="BaggageInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class BaggageInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="HeaderInformation" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class HeaderInformation -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="SolutionInformation" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SolutionInformation -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OptionalCharges" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class OptionalCharges -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ValidatingCarrier" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class ValidatingCarrier -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MiscInformation implements Serializable
        {
            private BaggageInfo baggageInfo;
            private List<HeaderInformation> headerInformationList = new ArrayList<HeaderInformation>();
            private List<SolutionInformation> solutionInformationList = new ArrayList<SolutionInformation>();
            private List<OptionalCharges> optionalChargeList = new ArrayList<OptionalCharges>();
            private List<ValidatingCarrier> validatingCarrierList = new ArrayList<ValidatingCarrier>();

            /** 
             * Get the 'BaggageInfo' element value.
             * 
             * @return value
             */
            public BaggageInfo getBaggageInfo() {
                return baggageInfo;
            }

            /** 
             * Set the 'BaggageInfo' element value.
             * 
             * @param baggageInfo
             */
            public void setBaggageInfo(BaggageInfo baggageInfo) {
                this.baggageInfo = baggageInfo;
            }

            /** 
             * Get the list of 'HeaderInformation' element items.
             * 
             * @return list
             */
            public List<HeaderInformation> getHeaderInformationList() {
                return headerInformationList;
            }

            /** 
             * Set the list of 'HeaderInformation' element items.
             * 
             * @param list
             */
            public void setHeaderInformationList(List<HeaderInformation> list) {
                headerInformationList = list;
            }

            /** 
             * Get the list of 'SolutionInformation' element items.
             * 
             * @return list
             */
            public List<SolutionInformation> getSolutionInformationList() {
                return solutionInformationList;
            }

            /** 
             * Set the list of 'SolutionInformation' element items.
             * 
             * @param list
             */
            public void setSolutionInformationList(
                    List<SolutionInformation> list) {
                solutionInformationList = list;
            }

            /** 
             * Get the list of 'OptionalCharges' element items.
             * 
             * @return list
             */
            public List<OptionalCharges> getOptionalChargeList() {
                return optionalChargeList;
            }

            /** 
             * Set the list of 'OptionalCharges' element items.
             * 
             * @param list
             */
            public void setOptionalChargeList(List<OptionalCharges> list) {
                optionalChargeList = list;
            }

            /** 
             * Get the list of 'ValidatingCarrier' element items.
             * 
             * @return list
             */
            public List<ValidatingCarrier> getValidatingCarrierList() {
                return validatingCarrierList;
            }

            /** 
             * Set the list of 'ValidatingCarrier' element items.
             * 
             * @param list
             */
            public void setValidatingCarrierList(List<ValidatingCarrier> list) {
                validatingCarrierList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="SubCodeProperties" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class SubCodeProperties -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class BaggageInfo implements Serializable
            {
                private List<SubCodeProperties> subCodePropertyList = new ArrayList<SubCodeProperties>();

                /** 
                 * Get the list of 'SubCodeProperties' element items.
                 * 
                 * @return list
                 */
                public List<SubCodeProperties> getSubCodePropertyList() {
                    return subCodePropertyList;
                }

                /** 
                 * Set the list of 'SubCodeProperties' element items.
                 * 
                 * @param list
                 */
                public void setSubCodePropertyList(List<SubCodeProperties> list) {
                    subCodePropertyList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubCodeProperties" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="AncillaryFeeGroupCode" minOccurs="0"/>
                 *       &lt;xs:element name="AncillaryService" minOccurs="0">
                 *         &lt;!-- Reference to inner class AncillaryService -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="BookingMethod" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="CommercialNameofBaggageItemType" minOccurs="0"/>
                 *       &lt;xs:element name="DescriptionOne" minOccurs="0">
                 *         &lt;!-- Reference to inner class DescriptionOne -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="DescriptionTwo" minOccurs="0">
                 *         &lt;!-- Reference to inner class DescriptionTwo -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="EMD_Type" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="ExtendedSubCodeKey" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="RFIC" minOccurs="0"/>
                 *       &lt;xs:element name="SizeWeightInfo" minOccurs="0">
                 *         &lt;!-- Reference to inner class SizeWeightInfo -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="SSR_Code" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="SolutionSequenceNmbr"/>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SubCodeProperties implements Serializable
                {
                    private String ancillaryFeeGroupCode;
                    private AncillaryService ancillaryService;
                    private String bookingMethod;
                    private String commercialNameofBaggageItemType;
                    private DescriptionOne descriptionOne;
                    private DescriptionTwo descriptionTwo;
                    private String EMDType;
                    private String extendedSubCodeKey;
                    private String RFIC;
                    private SizeWeightInfo sizeWeightInfo;
                    private String SSRCode;
                    private BigInteger solutionSequenceNmbr;
                    private BigInteger RPH;

                    /** 
                     * Get the 'AncillaryFeeGroupCode' element value.
                     * 
                     * @return value
                     */
                    public String getAncillaryFeeGroupCode() {
                        return ancillaryFeeGroupCode;
                    }

                    /** 
                     * Set the 'AncillaryFeeGroupCode' element value.
                     * 
                     * @param ancillaryFeeGroupCode
                     */
                    public void setAncillaryFeeGroupCode(
                            String ancillaryFeeGroupCode) {
                        this.ancillaryFeeGroupCode = ancillaryFeeGroupCode;
                    }

                    /** 
                     * Get the 'AncillaryService' element value.
                     * 
                     * @return value
                     */
                    public AncillaryService getAncillaryService() {
                        return ancillaryService;
                    }

                    /** 
                     * Set the 'AncillaryService' element value.
                     * 
                     * @param ancillaryService
                     */
                    public void setAncillaryService(
                            AncillaryService ancillaryService) {
                        this.ancillaryService = ancillaryService;
                    }

                    /** 
                     * Get the 'BookingMethod' element value.
                     * 
                     * @return value
                     */
                    public String getBookingMethod() {
                        return bookingMethod;
                    }

                    /** 
                     * Set the 'BookingMethod' element value.
                     * 
                     * @param bookingMethod
                     */
                    public void setBookingMethod(String bookingMethod) {
                        this.bookingMethod = bookingMethod;
                    }

                    /** 
                     * Get the 'CommercialNameofBaggageItemType' element value.
                     * 
                     * @return value
                     */
                    public String getCommercialNameofBaggageItemType() {
                        return commercialNameofBaggageItemType;
                    }

                    /** 
                     * Set the 'CommercialNameofBaggageItemType' element value.
                     * 
                     * @param commercialNameofBaggageItemType
                     */
                    public void setCommercialNameofBaggageItemType(
                            String commercialNameofBaggageItemType) {
                        this.commercialNameofBaggageItemType = commercialNameofBaggageItemType;
                    }

                    /** 
                     * Get the 'DescriptionOne' element value.
                     * 
                     * @return value
                     */
                    public DescriptionOne getDescriptionOne() {
                        return descriptionOne;
                    }

                    /** 
                     * Set the 'DescriptionOne' element value.
                     * 
                     * @param descriptionOne
                     */
                    public void setDescriptionOne(DescriptionOne descriptionOne) {
                        this.descriptionOne = descriptionOne;
                    }

                    /** 
                     * Get the 'DescriptionTwo' element value.
                     * 
                     * @return value
                     */
                    public DescriptionTwo getDescriptionTwo() {
                        return descriptionTwo;
                    }

                    /** 
                     * Set the 'DescriptionTwo' element value.
                     * 
                     * @param descriptionTwo
                     */
                    public void setDescriptionTwo(DescriptionTwo descriptionTwo) {
                        this.descriptionTwo = descriptionTwo;
                    }

                    /** 
                     * Get the 'EMD_Type' element value.
                     * 
                     * @return value
                     */
                    public String getEMDType() {
                        return EMDType;
                    }

                    /** 
                     * Set the 'EMD_Type' element value.
                     * 
                     * @param EMDType
                     */
                    public void setEMDType(String EMDType) {
                        this.EMDType = EMDType;
                    }

                    /** 
                     * Get the 'ExtendedSubCodeKey' element value.
                     * 
                     * @return value
                     */
                    public String getExtendedSubCodeKey() {
                        return extendedSubCodeKey;
                    }

                    /** 
                     * Set the 'ExtendedSubCodeKey' element value.
                     * 
                     * @param extendedSubCodeKey
                     */
                    public void setExtendedSubCodeKey(String extendedSubCodeKey) {
                        this.extendedSubCodeKey = extendedSubCodeKey;
                    }

                    /** 
                     * Get the 'RFIC' element value.
                     * 
                     * @return value
                     */
                    public String getRFIC() {
                        return RFIC;
                    }

                    /** 
                     * Set the 'RFIC' element value.
                     * 
                     * @param RFIC
                     */
                    public void setRFIC(String RFIC) {
                        this.RFIC = RFIC;
                    }

                    /** 
                     * Get the 'SizeWeightInfo' element value.
                     * 
                     * @return value
                     */
                    public SizeWeightInfo getSizeWeightInfo() {
                        return sizeWeightInfo;
                    }

                    /** 
                     * Set the 'SizeWeightInfo' element value.
                     * 
                     * @param sizeWeightInfo
                     */
                    public void setSizeWeightInfo(SizeWeightInfo sizeWeightInfo) {
                        this.sizeWeightInfo = sizeWeightInfo;
                    }

                    /** 
                     * Get the 'SSR_Code' element value.
                     * 
                     * @return value
                     */
                    public String getSSRCode() {
                        return SSRCode;
                    }

                    /** 
                     * Set the 'SSR_Code' element value.
                     * 
                     * @param SSRCode
                     */
                    public void setSSRCode(String SSRCode) {
                        this.SSRCode = SSRCode;
                    }

                    /** 
                     * Get the 'SolutionSequenceNmbr' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getSolutionSequenceNmbr() {
                        return solutionSequenceNmbr;
                    }

                    /** 
                     * Set the 'SolutionSequenceNmbr' attribute value.
                     * 
                     * @param solutionSequenceNmbr
                     */
                    public void setSolutionSequenceNmbr(
                            BigInteger solutionSequenceNmbr) {
                        this.solutionSequenceNmbr = solutionSequenceNmbr;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(BigInteger RPH) {
                        this.RPH = RPH;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryService" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SubGroupCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AncillaryService implements
                        Serializable
                    {
                        private String text;
                        private String subGroupCode;

                        /** 
                         * Get the 'Text' element value.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }

                        /** 
                         * Get the 'SubGroupCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getSubGroupCode() {
                            return subGroupCode;
                        }

                        /** 
                         * Set the 'SubGroupCode' attribute value.
                         * 
                         * @param subGroupCode
                         */
                        public void setSubGroupCode(String subGroupCode) {
                            this.subGroupCode = subGroupCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DescriptionOne" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class DescriptionOne implements Serializable
                    {
                        private String text;
                        private String code;

                        /** 
                         * Get the 'Text' element value.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DescriptionTwo" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class DescriptionTwo implements Serializable
                    {
                        private String text;
                        private String code;

                        /** 
                         * Get the 'Text' element value.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SizeWeightInfo" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="MaximumSizeInAlternate" minOccurs="0">
                     *         &lt;!-- Reference to inner class MaximumSizeInAlternate -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MaximumSize" minOccurs="0">
                     *         &lt;!-- Reference to inner class MaximumSize -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MaximumWeightInAlternate" minOccurs="0">
                     *         &lt;!-- Reference to inner class MaximumWeightInAlternate -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MaximumWeight" minOccurs="0">
                     *         &lt;!-- Reference to inner class MaximumWeight -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MinimumSizeInAlternate" minOccurs="0">
                     *         &lt;!-- Reference to inner class MinimumSizeInAlternate -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MinimumSize" minOccurs="0">
                     *         &lt;!-- Reference to inner class MinimumSize -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MinimumWeightInAlternate" minOccurs="0">
                     *         &lt;!-- Reference to inner class MinimumWeightInAlternate -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MinimumWeight" minOccurs="0">
                     *         &lt;!-- Reference to inner class MinimumWeight -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SizeWeightInfo implements Serializable
                    {
                        private MaximumSizeInAlternate maximumSizeInAlternate;
                        private MaximumSize maximumSize;
                        private MaximumWeightInAlternate maximumWeightInAlternate;
                        private MaximumWeight maximumWeight;
                        private MinimumSizeInAlternate minimumSizeInAlternate;
                        private MinimumSize minimumSize;
                        private MinimumWeightInAlternate minimumWeightInAlternate;
                        private MinimumWeight minimumWeight;

                        /** 
                         * Get the 'MaximumSizeInAlternate' element value.
                         * 
                         * @return value
                         */
                        public MaximumSizeInAlternate getMaximumSizeInAlternate() {
                            return maximumSizeInAlternate;
                        }

                        /** 
                         * Set the 'MaximumSizeInAlternate' element value.
                         * 
                         * @param maximumSizeInAlternate
                         */
                        public void setMaximumSizeInAlternate(
                                MaximumSizeInAlternate maximumSizeInAlternate) {
                            this.maximumSizeInAlternate = maximumSizeInAlternate;
                        }

                        /** 
                         * Get the 'MaximumSize' element value.
                         * 
                         * @return value
                         */
                        public MaximumSize getMaximumSize() {
                            return maximumSize;
                        }

                        /** 
                         * Set the 'MaximumSize' element value.
                         * 
                         * @param maximumSize
                         */
                        public void setMaximumSize(MaximumSize maximumSize) {
                            this.maximumSize = maximumSize;
                        }

                        /** 
                         * Get the 'MaximumWeightInAlternate' element value.
                         * 
                         * @return value
                         */
                        public MaximumWeightInAlternate getMaximumWeightInAlternate() {
                            return maximumWeightInAlternate;
                        }

                        /** 
                         * Set the 'MaximumWeightInAlternate' element value.
                         * 
                         * @param maximumWeightInAlternate
                         */
                        public void setMaximumWeightInAlternate(
                                MaximumWeightInAlternate maximumWeightInAlternate) {
                            this.maximumWeightInAlternate = maximumWeightInAlternate;
                        }

                        /** 
                         * Get the 'MaximumWeight' element value.
                         * 
                         * @return value
                         */
                        public MaximumWeight getMaximumWeight() {
                            return maximumWeight;
                        }

                        /** 
                         * Set the 'MaximumWeight' element value.
                         * 
                         * @param maximumWeight
                         */
                        public void setMaximumWeight(MaximumWeight maximumWeight) {
                            this.maximumWeight = maximumWeight;
                        }

                        /** 
                         * Get the 'MinimumSizeInAlternate' element value.
                         * 
                         * @return value
                         */
                        public MinimumSizeInAlternate getMinimumSizeInAlternate() {
                            return minimumSizeInAlternate;
                        }

                        /** 
                         * Set the 'MinimumSizeInAlternate' element value.
                         * 
                         * @param minimumSizeInAlternate
                         */
                        public void setMinimumSizeInAlternate(
                                MinimumSizeInAlternate minimumSizeInAlternate) {
                            this.minimumSizeInAlternate = minimumSizeInAlternate;
                        }

                        /** 
                         * Get the 'MinimumSize' element value.
                         * 
                         * @return value
                         */
                        public MinimumSize getMinimumSize() {
                            return minimumSize;
                        }

                        /** 
                         * Set the 'MinimumSize' element value.
                         * 
                         * @param minimumSize
                         */
                        public void setMinimumSize(MinimumSize minimumSize) {
                            this.minimumSize = minimumSize;
                        }

                        /** 
                         * Get the 'MinimumWeightInAlternate' element value.
                         * 
                         * @return value
                         */
                        public MinimumWeightInAlternate getMinimumWeightInAlternate() {
                            return minimumWeightInAlternate;
                        }

                        /** 
                         * Set the 'MinimumWeightInAlternate' element value.
                         * 
                         * @param minimumWeightInAlternate
                         */
                        public void setMinimumWeightInAlternate(
                                MinimumWeightInAlternate minimumWeightInAlternate) {
                            this.minimumWeightInAlternate = minimumWeightInAlternate;
                        }

                        /** 
                         * Get the 'MinimumWeight' element value.
                         * 
                         * @return value
                         */
                        public MinimumWeight getMinimumWeight() {
                            return minimumWeight;
                        }

                        /** 
                         * Set the 'MinimumWeight' element value.
                         * 
                         * @param minimumWeight
                         */
                        public void setMinimumWeight(MinimumWeight minimumWeight) {
                            this.minimumWeight = minimumWeight;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaximumSizeInAlternate" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:string" use="optional" name="Units"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MaximumSizeInAlternate implements
                            Serializable
                        {
                            private String string;
                            private String units;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'Units' attribute value.
                             * 
                             * @return value
                             */
                            public String getUnits() {
                                return units;
                            }

                            /** 
                             * Set the 'Units' attribute value.
                             * 
                             * @param units
                             */
                            public void setUnits(String units) {
                                this.units = units;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaximumSize" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:string" use="optional" name="Units"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MaximumSize implements Serializable
                        {
                            private String string;
                            private String units;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'Units' attribute value.
                             * 
                             * @return value
                             */
                            public String getUnits() {
                                return units;
                            }

                            /** 
                             * Set the 'Units' attribute value.
                             * 
                             * @param units
                             */
                            public void setUnits(String units) {
                                this.units = units;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaximumWeightInAlternate" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:string" use="optional" name="Units"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MaximumWeightInAlternate implements
                            Serializable
                        {
                            private String string;
                            private String units;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'Units' attribute value.
                             * 
                             * @return value
                             */
                            public String getUnits() {
                                return units;
                            }

                            /** 
                             * Set the 'Units' attribute value.
                             * 
                             * @param units
                             */
                            public void setUnits(String units) {
                                this.units = units;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaximumWeight" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:string" use="optional" name="Units"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MaximumWeight implements
                            Serializable
                        {
                            private String string;
                            private String units;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'Units' attribute value.
                             * 
                             * @return value
                             */
                            public String getUnits() {
                                return units;
                            }

                            /** 
                             * Set the 'Units' attribute value.
                             * 
                             * @param units
                             */
                            public void setUnits(String units) {
                                this.units = units;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MinimumSizeInAlternate" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:string" use="optional" name="Units"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MinimumSizeInAlternate implements
                            Serializable
                        {
                            private String string;
                            private String units;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'Units' attribute value.
                             * 
                             * @return value
                             */
                            public String getUnits() {
                                return units;
                            }

                            /** 
                             * Set the 'Units' attribute value.
                             * 
                             * @param units
                             */
                            public void setUnits(String units) {
                                this.units = units;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MinimumSize" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:string" use="optional" name="Units"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MinimumSize implements Serializable
                        {
                            private String string;
                            private String units;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'Units' attribute value.
                             * 
                             * @return value
                             */
                            public String getUnits() {
                                return units;
                            }

                            /** 
                             * Set the 'Units' attribute value.
                             * 
                             * @param units
                             */
                            public void setUnits(String units) {
                                this.units = units;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MinimumWeightInAlternate" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:string" use="optional" name="Units"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MinimumWeightInAlternate implements
                            Serializable
                        {
                            private String string;
                            private String units;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'Units' attribute value.
                             * 
                             * @return value
                             */
                            public String getUnits() {
                                return units;
                            }

                            /** 
                             * Set the 'Units' attribute value.
                             * 
                             * @param units
                             */
                            public void setUnits(String units) {
                                this.units = units;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MinimumWeight" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:string" use="optional" name="Units"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MinimumWeight implements
                            Serializable
                        {
                            private String string;
                            private String units;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'Units' attribute value.
                             * 
                             * @return value
                             */
                            public String getUnits() {
                                return units;
                            }

                            /** 
                             * Set the 'Units' attribute value.
                             * 
                             * @param units
                             */
                            public void setUnits(String units) {
                                this.units = units;
                            }
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HeaderInformation" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BargainFinder" minOccurs="0">
             *         &lt;!-- Reference to inner class BargainFinder -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:date" name="DepartureDate" minOccurs="0"/>
             *       &lt;xs:element name="DivideParty" minOccurs="0" maxOccurs="24">
             *         &lt;!-- Reference to inner class DivideParty -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="xs:string" name="LastTicketingDate" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element name="ValidatingCarrier" minOccurs="0">
             *         &lt;!-- Reference to inner class ValidatingCarrier -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SolutionSequenceNmbr"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class HeaderInformation implements Serializable
            {
                private BargainFinder bargainFinder;
                private Date departureDate;
                private List<DivideParty> dividePartyList = new ArrayList<DivideParty>();
                private String lastTicketingDate;
                private List<String> textList = new ArrayList<String>();
                private ValidatingCarrier validatingCarrier;
                private String solutionSequenceNmbr;

                /** 
                 * Get the 'BargainFinder' element value.
                 * 
                 * @return value
                 */
                public BargainFinder getBargainFinder() {
                    return bargainFinder;
                }

                /** 
                 * Set the 'BargainFinder' element value.
                 * 
                 * @param bargainFinder
                 */
                public void setBargainFinder(BargainFinder bargainFinder) {
                    this.bargainFinder = bargainFinder;
                }

                /** 
                 * Get the 'DepartureDate' element value.
                 * 
                 * @return value
                 */
                public Date getDepartureDate() {
                    return departureDate;
                }

                /** 
                 * Set the 'DepartureDate' element value.
                 * 
                 * @param departureDate
                 */
                public void setDepartureDate(Date departureDate) {
                    this.departureDate = departureDate;
                }

                /** 
                 * Get the list of 'DivideParty' element items.
                 * 
                 * @return list
                 */
                public List<DivideParty> getDividePartyList() {
                    return dividePartyList;
                }

                /** 
                 * Set the list of 'DivideParty' element items.
                 * 
                 * @param list
                 */
                public void setDividePartyList(List<DivideParty> list) {
                    dividePartyList = list;
                }

                /** 
                 * Get the 'LastTicketingDate' element value.
                 * 
                 * @return value
                 */
                public String getLastTicketingDate() {
                    return lastTicketingDate;
                }

                /** 
                 * Set the 'LastTicketingDate' element value.
                 * 
                 * @param lastTicketingDate
                 */
                public void setLastTicketingDate(String lastTicketingDate) {
                    this.lastTicketingDate = lastTicketingDate;
                }

                /** 
                 * Get the list of 'Text' element items.
                 * 
                 * @return list
                 */
                public List<String> getTextList() {
                    return textList;
                }

                /** 
                 * Set the list of 'Text' element items.
                 * 
                 * @param list
                 */
                public void setTextList(List<String> list) {
                    textList = list;
                }

                /** 
                 * Get the 'ValidatingCarrier' element value.
                 * 
                 * @return value
                 */
                public ValidatingCarrier getValidatingCarrier() {
                    return validatingCarrier;
                }

                /** 
                 * Set the 'ValidatingCarrier' element value.
                 * 
                 * @param validatingCarrier
                 */
                public void setValidatingCarrier(
                        ValidatingCarrier validatingCarrier) {
                    this.validatingCarrier = validatingCarrier;
                }

                /** 
                 * Get the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @return value
                 */
                public String getSolutionSequenceNmbr() {
                    return solutionSequenceNmbr;
                }

                /** 
                 * Set the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @param solutionSequenceNmbr
                 */
                public void setSolutionSequenceNmbr(String solutionSequenceNmbr) {
                    this.solutionSequenceNmbr = solutionSequenceNmbr;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BargainFinder" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="AlternateBooking" minOccurs="0" maxOccurs="24">
                 *         &lt;!-- Reference to inner class AlternateBooking -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BargainFinder implements Serializable
                {
                    private List<AlternateBooking> alternateBookingList = new ArrayList<AlternateBooking>();

                    /** 
                     * Get the list of 'AlternateBooking' element items.
                     * 
                     * @return list
                     */
                    public List<AlternateBooking> getAlternateBookingList() {
                        return alternateBookingList;
                    }

                    /** 
                     * Set the list of 'AlternateBooking' element items.
                     * 
                     * @param list
                     */
                    public void setAlternateBookingList(
                            List<AlternateBooking> list) {
                        alternateBookingList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateBooking" minOccurs="0" maxOccurs="24">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AlternateBooking implements
                        Serializable
                    {
                        private String resBookDesigCode;

                        /** 
                         * Get the 'ResBookDesigCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getResBookDesigCode() {
                            return resBookDesigCode;
                        }

                        /** 
                         * Set the 'ResBookDesigCode' attribute value.
                         * 
                         * @param resBookDesigCode
                         */
                        public void setResBookDesigCode(String resBookDesigCode) {
                            this.resBookDesigCode = resBookDesigCode;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DivideParty" minOccurs="0" maxOccurs="24">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class DivideParty implements Serializable
                {
                    private String resBookDesigCode;

                    /** 
                     * Get the 'ResBookDesigCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getResBookDesigCode() {
                        return resBookDesigCode;
                    }

                    /** 
                     * Set the 'ResBookDesigCode' attribute value.
                     * 
                     * @param resBookDesigCode
                     */
                    public void setResBookDesigCode(String resBookDesigCode) {
                        this.resBookDesigCode = resBookDesigCode;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrier" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ValidatingCarrier implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SolutionInformation" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="BaseFareCurrencyCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="GrandTotalBaseFareAmount" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="GrandTotalEquivFareAmount" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="GrandTotalTaxes" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="RequiresRebook" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="SegmentNumber" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="ServiceFeeCurrency" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="xs:string" name="TicketNumber" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TotalAmount" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TotalServiceFeeAmount" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TotalServiceTax" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SolutionSequenceNmbr"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SolutionInformation implements Serializable
            {
                private String baseFareCurrencyCode;
                private String currencyCode;
                private String grandTotalBaseFareAmount;
                private String grandTotalEquivFareAmount;
                private String grandTotalTaxes;
                private String requiresRebook;
                private List<String> segmentNumberList = new ArrayList<String>();
                private String serviceFeeCurrency;
                private List<String> textList = new ArrayList<String>();
                private String ticketNumber;
                private String totalAmount;
                private String totalServiceFeeAmount;
                private String totalServiceTax;
                private String solutionSequenceNmbr;

                /** 
                 * Get the 'BaseFareCurrencyCode' element value.
                 * 
                 * @return value
                 */
                public String getBaseFareCurrencyCode() {
                    return baseFareCurrencyCode;
                }

                /** 
                 * Set the 'BaseFareCurrencyCode' element value.
                 * 
                 * @param baseFareCurrencyCode
                 */
                public void setBaseFareCurrencyCode(String baseFareCurrencyCode) {
                    this.baseFareCurrencyCode = baseFareCurrencyCode;
                }

                /** 
                 * Get the 'CurrencyCode' element value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' element value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'GrandTotalBaseFareAmount' element value.
                 * 
                 * @return value
                 */
                public String getGrandTotalBaseFareAmount() {
                    return grandTotalBaseFareAmount;
                }

                /** 
                 * Set the 'GrandTotalBaseFareAmount' element value.
                 * 
                 * @param grandTotalBaseFareAmount
                 */
                public void setGrandTotalBaseFareAmount(
                        String grandTotalBaseFareAmount) {
                    this.grandTotalBaseFareAmount = grandTotalBaseFareAmount;
                }

                /** 
                 * Get the 'GrandTotalEquivFareAmount' element value.
                 * 
                 * @return value
                 */
                public String getGrandTotalEquivFareAmount() {
                    return grandTotalEquivFareAmount;
                }

                /** 
                 * Set the 'GrandTotalEquivFareAmount' element value.
                 * 
                 * @param grandTotalEquivFareAmount
                 */
                public void setGrandTotalEquivFareAmount(
                        String grandTotalEquivFareAmount) {
                    this.grandTotalEquivFareAmount = grandTotalEquivFareAmount;
                }

                /** 
                 * Get the 'GrandTotalTaxes' element value.
                 * 
                 * @return value
                 */
                public String getGrandTotalTaxes() {
                    return grandTotalTaxes;
                }

                /** 
                 * Set the 'GrandTotalTaxes' element value.
                 * 
                 * @param grandTotalTaxes
                 */
                public void setGrandTotalTaxes(String grandTotalTaxes) {
                    this.grandTotalTaxes = grandTotalTaxes;
                }

                /** 
                 * Get the 'RequiresRebook' element value.
                 * 
                 * @return value
                 */
                public String getRequiresRebook() {
                    return requiresRebook;
                }

                /** 
                 * Set the 'RequiresRebook' element value.
                 * 
                 * @param requiresRebook
                 */
                public void setRequiresRebook(String requiresRebook) {
                    this.requiresRebook = requiresRebook;
                }

                /** 
                 * Get the list of 'SegmentNumber' element items.
                 * 
                 * @return list
                 */
                public List<String> getSegmentNumberList() {
                    return segmentNumberList;
                }

                /** 
                 * Set the list of 'SegmentNumber' element items.
                 * 
                 * @param list
                 */
                public void setSegmentNumberList(List<String> list) {
                    segmentNumberList = list;
                }

                /** 
                 * Get the 'ServiceFeeCurrency' element value.
                 * 
                 * @return value
                 */
                public String getServiceFeeCurrency() {
                    return serviceFeeCurrency;
                }

                /** 
                 * Set the 'ServiceFeeCurrency' element value.
                 * 
                 * @param serviceFeeCurrency
                 */
                public void setServiceFeeCurrency(String serviceFeeCurrency) {
                    this.serviceFeeCurrency = serviceFeeCurrency;
                }

                /** 
                 * Get the list of 'Text' element items.
                 * 
                 * @return list
                 */
                public List<String> getTextList() {
                    return textList;
                }

                /** 
                 * Set the list of 'Text' element items.
                 * 
                 * @param list
                 */
                public void setTextList(List<String> list) {
                    textList = list;
                }

                /** 
                 * Get the 'TicketNumber' element value.
                 * 
                 * @return value
                 */
                public String getTicketNumber() {
                    return ticketNumber;
                }

                /** 
                 * Set the 'TicketNumber' element value.
                 * 
                 * @param ticketNumber
                 */
                public void setTicketNumber(String ticketNumber) {
                    this.ticketNumber = ticketNumber;
                }

                /** 
                 * Get the 'TotalAmount' element value.
                 * 
                 * @return value
                 */
                public String getTotalAmount() {
                    return totalAmount;
                }

                /** 
                 * Set the 'TotalAmount' element value.
                 * 
                 * @param totalAmount
                 */
                public void setTotalAmount(String totalAmount) {
                    this.totalAmount = totalAmount;
                }

                /** 
                 * Get the 'TotalServiceFeeAmount' element value.
                 * 
                 * @return value
                 */
                public String getTotalServiceFeeAmount() {
                    return totalServiceFeeAmount;
                }

                /** 
                 * Set the 'TotalServiceFeeAmount' element value.
                 * 
                 * @param totalServiceFeeAmount
                 */
                public void setTotalServiceFeeAmount(
                        String totalServiceFeeAmount) {
                    this.totalServiceFeeAmount = totalServiceFeeAmount;
                }

                /** 
                 * Get the 'TotalServiceTax' element value.
                 * 
                 * @return value
                 */
                public String getTotalServiceTax() {
                    return totalServiceTax;
                }

                /** 
                 * Set the 'TotalServiceTax' element value.
                 * 
                 * @param totalServiceTax
                 */
                public void setTotalServiceTax(String totalServiceTax) {
                    this.totalServiceTax = totalServiceTax;
                }

                /** 
                 * Get the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @return value
                 */
                public String getSolutionSequenceNmbr() {
                    return solutionSequenceNmbr;
                }

                /** 
                 * Set the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @param solutionSequenceNmbr
                 */
                public void setSolutionSequenceNmbr(String solutionSequenceNmbr) {
                    this.solutionSequenceNmbr = solutionSequenceNmbr;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionalCharges" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ChargeDetails" minOccurs="0">
             *         &lt;!-- Reference to inner class ChargeDetails -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ItineraryInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class ItineraryInfo -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TicketingInfo" minOccurs="0">
             *         &lt;!-- Reference to inner class TicketingInfo -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SolutionSequenceNmbr"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OptionalCharges implements Serializable
            {
                private ChargeDetails chargeDetails;
                private ItineraryInfo itineraryInfo;
                private TicketingInfo ticketingInfo;
                private String solutionSequenceNmbr;

                /** 
                 * Get the 'ChargeDetails' element value.
                 * 
                 * @return value
                 */
                public ChargeDetails getChargeDetails() {
                    return chargeDetails;
                }

                /** 
                 * Set the 'ChargeDetails' element value.
                 * 
                 * @param chargeDetails
                 */
                public void setChargeDetails(ChargeDetails chargeDetails) {
                    this.chargeDetails = chargeDetails;
                }

                /** 
                 * Get the 'ItineraryInfo' element value.
                 * 
                 * @return value
                 */
                public ItineraryInfo getItineraryInfo() {
                    return itineraryInfo;
                }

                /** 
                 * Set the 'ItineraryInfo' element value.
                 * 
                 * @param itineraryInfo
                 */
                public void setItineraryInfo(ItineraryInfo itineraryInfo) {
                    this.itineraryInfo = itineraryInfo;
                }

                /** 
                 * Get the 'TicketingInfo' element value.
                 * 
                 * @return value
                 */
                public TicketingInfo getTicketingInfo() {
                    return ticketingInfo;
                }

                /** 
                 * Set the 'TicketingInfo' element value.
                 * 
                 * @param ticketingInfo
                 */
                public void setTicketingInfo(TicketingInfo ticketingInfo) {
                    this.ticketingInfo = ticketingInfo;
                }

                /** 
                 * Get the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @return value
                 */
                public String getSolutionSequenceNmbr() {
                    return solutionSequenceNmbr;
                }

                /** 
                 * Set the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @param solutionSequenceNmbr
                 */
                public void setSolutionSequenceNmbr(String solutionSequenceNmbr) {
                    this.solutionSequenceNmbr = solutionSequenceNmbr;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChargeDetails" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="ChargeBreakdown" minOccurs="0">
                 *         &lt;!-- Reference to inner class ChargeBreakdown -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="DiscontinueDate" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="EffectiveDate" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="PurchaseBy" minOccurs="0"/>
                 *       &lt;xs:element name="ReasonForIssuance" minOccurs="0">
                 *         &lt;!-- Reference to inner class ReasonForIssuance -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="SSIM" minOccurs="0">
                 *         &lt;!-- Reference to inner class SSIM -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="SSR" minOccurs="0">
                 *         &lt;!-- Reference to inner class SSR -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Ticket" minOccurs="0">
                 *         &lt;!-- Reference to inner class Ticket -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TourCode" minOccurs="0">
                 *         &lt;!-- Reference to inner class TourCode -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="VendorPrefs" minOccurs="0">
                 *         &lt;!-- Reference to inner class VendorPrefs -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CommericalName"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="DisplayOnly"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="EMD_Type"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="FeeApplication"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="FQTV_Tier"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="GuaranteeInd"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="IATA_Application"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Owner"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RefundForm"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentJourneyCouponInd"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ChargeDetails implements Serializable
                {
                    private ChargeBreakdown chargeBreakdown;
                    private String discontinueDate;
                    private String effectiveDate;
                    private String purchaseBy;
                    private ReasonForIssuance reasonForIssuance;
                    private SSIM SSIM1;
                    private SSR SSR1;
                    private Ticket ticket;
                    private TourCode tourCode;
                    private VendorPrefs vendorPrefs;
                    private String commericalName;
                    private String displayOnly;
                    private String EMDType;
                    private String feeApplication;
                    private String FQTVTier;
                    private String guaranteeInd;
                    private String IATAApplication;
                    private String nameNumber;
                    private String owner;
                    private String refundForm;
                    private String RPH;
                    private String segmentJourneyCouponInd;

                    /** 
                     * Get the 'ChargeBreakdown' element value.
                     * 
                     * @return value
                     */
                    public ChargeBreakdown getChargeBreakdown() {
                        return chargeBreakdown;
                    }

                    /** 
                     * Set the 'ChargeBreakdown' element value.
                     * 
                     * @param chargeBreakdown
                     */
                    public void setChargeBreakdown(
                            ChargeBreakdown chargeBreakdown) {
                        this.chargeBreakdown = chargeBreakdown;
                    }

                    /** 
                     * Get the 'DiscontinueDate' element value.
                     * 
                     * @return value
                     */
                    public String getDiscontinueDate() {
                        return discontinueDate;
                    }

                    /** 
                     * Set the 'DiscontinueDate' element value.
                     * 
                     * @param discontinueDate
                     */
                    public void setDiscontinueDate(String discontinueDate) {
                        this.discontinueDate = discontinueDate;
                    }

                    /** 
                     * Get the 'EffectiveDate' element value.
                     * 
                     * @return value
                     */
                    public String getEffectiveDate() {
                        return effectiveDate;
                    }

                    /** 
                     * Set the 'EffectiveDate' element value.
                     * 
                     * @param effectiveDate
                     */
                    public void setEffectiveDate(String effectiveDate) {
                        this.effectiveDate = effectiveDate;
                    }

                    /** 
                     * Get the 'PurchaseBy' element value.
                     * 
                     * @return value
                     */
                    public String getPurchaseBy() {
                        return purchaseBy;
                    }

                    /** 
                     * Set the 'PurchaseBy' element value.
                     * 
                     * @param purchaseBy
                     */
                    public void setPurchaseBy(String purchaseBy) {
                        this.purchaseBy = purchaseBy;
                    }

                    /** 
                     * Get the 'ReasonForIssuance' element value.
                     * 
                     * @return value
                     */
                    public ReasonForIssuance getReasonForIssuance() {
                        return reasonForIssuance;
                    }

                    /** 
                     * Set the 'ReasonForIssuance' element value.
                     * 
                     * @param reasonForIssuance
                     */
                    public void setReasonForIssuance(
                            ReasonForIssuance reasonForIssuance) {
                        this.reasonForIssuance = reasonForIssuance;
                    }

                    /** 
                     * Get the 'SSIM' element value.
                     * 
                     * @return value
                     */
                    public SSIM getSSIM1() {
                        return SSIM1;
                    }

                    /** 
                     * Set the 'SSIM' element value.
                     * 
                     * @param SSIM1
                     */
                    public void setSSIM1(SSIM SSIM1) {
                        this.SSIM1 = SSIM1;
                    }

                    /** 
                     * Get the 'SSR' element value.
                     * 
                     * @return value
                     */
                    public SSR getSSR1() {
                        return SSR1;
                    }

                    /** 
                     * Set the 'SSR' element value.
                     * 
                     * @param SSR1
                     */
                    public void setSSR1(SSR SSR1) {
                        this.SSR1 = SSR1;
                    }

                    /** 
                     * Get the 'Ticket' element value.
                     * 
                     * @return value
                     */
                    public Ticket getTicket() {
                        return ticket;
                    }

                    /** 
                     * Set the 'Ticket' element value.
                     * 
                     * @param ticket
                     */
                    public void setTicket(Ticket ticket) {
                        this.ticket = ticket;
                    }

                    /** 
                     * Get the 'TourCode' element value.
                     * 
                     * @return value
                     */
                    public TourCode getTourCode() {
                        return tourCode;
                    }

                    /** 
                     * Set the 'TourCode' element value.
                     * 
                     * @param tourCode
                     */
                    public void setTourCode(TourCode tourCode) {
                        this.tourCode = tourCode;
                    }

                    /** 
                     * Get the 'VendorPrefs' element value.
                     * 
                     * @return value
                     */
                    public VendorPrefs getVendorPrefs() {
                        return vendorPrefs;
                    }

                    /** 
                     * Set the 'VendorPrefs' element value.
                     * 
                     * @param vendorPrefs
                     */
                    public void setVendorPrefs(VendorPrefs vendorPrefs) {
                        this.vendorPrefs = vendorPrefs;
                    }

                    /** 
                     * Get the 'CommericalName' attribute value.
                     * 
                     * @return value
                     */
                    public String getCommericalName() {
                        return commericalName;
                    }

                    /** 
                     * Set the 'CommericalName' attribute value.
                     * 
                     * @param commericalName
                     */
                    public void setCommericalName(String commericalName) {
                        this.commericalName = commericalName;
                    }

                    /** 
                     * Get the 'DisplayOnly' attribute value.
                     * 
                     * @return value
                     */
                    public String getDisplayOnly() {
                        return displayOnly;
                    }

                    /** 
                     * Set the 'DisplayOnly' attribute value.
                     * 
                     * @param displayOnly
                     */
                    public void setDisplayOnly(String displayOnly) {
                        this.displayOnly = displayOnly;
                    }

                    /** 
                     * Get the 'EMD_Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getEMDType() {
                        return EMDType;
                    }

                    /** 
                     * Set the 'EMD_Type' attribute value.
                     * 
                     * @param EMDType
                     */
                    public void setEMDType(String EMDType) {
                        this.EMDType = EMDType;
                    }

                    /** 
                     * Get the 'FeeApplication' attribute value.
                     * 
                     * @return value
                     */
                    public String getFeeApplication() {
                        return feeApplication;
                    }

                    /** 
                     * Set the 'FeeApplication' attribute value.
                     * 
                     * @param feeApplication
                     */
                    public void setFeeApplication(String feeApplication) {
                        this.feeApplication = feeApplication;
                    }

                    /** 
                     * Get the 'FQTV_Tier' attribute value.
                     * 
                     * @return value
                     */
                    public String getFQTVTier() {
                        return FQTVTier;
                    }

                    /** 
                     * Set the 'FQTV_Tier' attribute value.
                     * 
                     * @param FQTVTier
                     */
                    public void setFQTVTier(String FQTVTier) {
                        this.FQTVTier = FQTVTier;
                    }

                    /** 
                     * Get the 'GuaranteeInd' attribute value.
                     * 
                     * @return value
                     */
                    public String getGuaranteeInd() {
                        return guaranteeInd;
                    }

                    /** 
                     * Set the 'GuaranteeInd' attribute value.
                     * 
                     * @param guaranteeInd
                     */
                    public void setGuaranteeInd(String guaranteeInd) {
                        this.guaranteeInd = guaranteeInd;
                    }

                    /** 
                     * Get the 'IATA_Application' attribute value.
                     * 
                     * @return value
                     */
                    public String getIATAApplication() {
                        return IATAApplication;
                    }

                    /** 
                     * Set the 'IATA_Application' attribute value.
                     * 
                     * @param IATAApplication
                     */
                    public void setIATAApplication(String IATAApplication) {
                        this.IATAApplication = IATAApplication;
                    }

                    /** 
                     * Get the 'NameNumber' attribute value.
                     * 
                     * @return value
                     */
                    public String getNameNumber() {
                        return nameNumber;
                    }

                    /** 
                     * Set the 'NameNumber' attribute value.
                     * 
                     * @param nameNumber
                     */
                    public void setNameNumber(String nameNumber) {
                        this.nameNumber = nameNumber;
                    }

                    /** 
                     * Get the 'Owner' attribute value.
                     * 
                     * @return value
                     */
                    public String getOwner() {
                        return owner;
                    }

                    /** 
                     * Set the 'Owner' attribute value.
                     * 
                     * @param owner
                     */
                    public void setOwner(String owner) {
                        this.owner = owner;
                    }

                    /** 
                     * Get the 'RefundForm' attribute value.
                     * 
                     * @return value
                     */
                    public String getRefundForm() {
                        return refundForm;
                    }

                    /** 
                     * Set the 'RefundForm' attribute value.
                     * 
                     * @param refundForm
                     */
                    public void setRefundForm(String refundForm) {
                        this.refundForm = refundForm;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }

                    /** 
                     * Get the 'SegmentJourneyCouponInd' attribute value.
                     * 
                     * @return value
                     */
                    public String getSegmentJourneyCouponInd() {
                        return segmentJourneyCouponInd;
                    }

                    /** 
                     * Set the 'SegmentJourneyCouponInd' attribute value.
                     * 
                     * @param segmentJourneyCouponInd
                     */
                    public void setSegmentJourneyCouponInd(
                            String segmentJourneyCouponInd) {
                        this.segmentJourneyCouponInd = segmentJourneyCouponInd;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChargeBreakdown" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Base" minOccurs="0">
                     *         &lt;!-- Reference to inner class Base -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Equiv" minOccurs="0">
                     *         &lt;!-- Reference to inner class Equiv -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="PassengerTypeQuantity" minOccurs="0">
                     *         &lt;!-- Reference to inner class PassengerTypeQuantity -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Taxes" minOccurs="0">
                     *         &lt;!-- Reference to inner class Taxes -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Total" minOccurs="0">
                     *         &lt;!-- Reference to inner class Total -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NoChargeInd"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ChargeBreakdown implements Serializable
                    {
                        private Base base;
                        private Equiv equiv;
                        private PassengerTypeQuantity passengerTypeQuantity;
                        private Taxes taxes;
                        private Total total;
                        private String noChargeInd;

                        /** 
                         * Get the 'Base' element value.
                         * 
                         * @return value
                         */
                        public Base getBase() {
                            return base;
                        }

                        /** 
                         * Set the 'Base' element value.
                         * 
                         * @param base
                         */
                        public void setBase(Base base) {
                            this.base = base;
                        }

                        /** 
                         * Get the 'Equiv' element value.
                         * 
                         * @return value
                         */
                        public Equiv getEquiv() {
                            return equiv;
                        }

                        /** 
                         * Set the 'Equiv' element value.
                         * 
                         * @param equiv
                         */
                        public void setEquiv(Equiv equiv) {
                            this.equiv = equiv;
                        }

                        /** 
                         * Get the 'PassengerTypeQuantity' element value.
                         * 
                         * @return value
                         */
                        public PassengerTypeQuantity getPassengerTypeQuantity() {
                            return passengerTypeQuantity;
                        }

                        /** 
                         * Set the 'PassengerTypeQuantity' element value.
                         * 
                         * @param passengerTypeQuantity
                         */
                        public void setPassengerTypeQuantity(
                                PassengerTypeQuantity passengerTypeQuantity) {
                            this.passengerTypeQuantity = passengerTypeQuantity;
                        }

                        /** 
                         * Get the 'Taxes' element value.
                         * 
                         * @return value
                         */
                        public Taxes getTaxes() {
                            return taxes;
                        }

                        /** 
                         * Set the 'Taxes' element value.
                         * 
                         * @param taxes
                         */
                        public void setTaxes(Taxes taxes) {
                            this.taxes = taxes;
                        }

                        /** 
                         * Get the 'Total' element value.
                         * 
                         * @return value
                         */
                        public Total getTotal() {
                            return total;
                        }

                        /** 
                         * Set the 'Total' element value.
                         * 
                         * @param total
                         */
                        public void setTotal(Total total) {
                            this.total = total;
                        }

                        /** 
                         * Get the 'NoChargeInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getNoChargeInd() {
                            return noChargeInd;
                        }

                        /** 
                         * Set the 'NoChargeInd' attribute value.
                         * 
                         * @param noChargeInd
                         */
                        public void setNoChargeInd(String noChargeInd) {
                            this.noChargeInd = noChargeInd;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Base" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Base implements Serializable
                        {
                            private String amount;
                            private String currencyCode;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'CurrencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equiv" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Equiv implements Serializable
                        {
                            private String amount;
                            private String currencyCode;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'CurrencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeQuantity" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Group"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PassengerTypeQuantity implements
                            Serializable
                        {
                            private String code;
                            private String group;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'Group' attribute value.
                             * 
                             * @return value
                             */
                            public String getGroup() {
                                return group;
                            }

                            /** 
                             * Set the 'Group' attribute value.
                             * 
                             * @param group
                             */
                            public void setGroup(String group) {
                                this.group = group;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
                         *         &lt;!-- Reference to inner class Tax -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Taxes implements Serializable
                        {
                            private List<Tax> taxList = new ArrayList<Tax>();
                            private String ind;

                            /** 
                             * Get the list of 'Tax' element items.
                             * 
                             * @return list
                             */
                            public List<Tax> getTaxList() {
                                return taxList;
                            }

                            /** 
                             * Set the list of 'Tax' element items.
                             * 
                             * @param list
                             */
                            public void setTaxList(List<Tax> list) {
                                taxList = list;
                            }

                            /** 
                             * Get the 'Ind' attribute value.
                             * 
                             * @return value
                             */
                            public String getInd() {
                                return ind;
                            }

                            /** 
                             * Set the 'Ind' attribute value.
                             * 
                             * @param ind
                             */
                            public void setInd(String ind) {
                                this.ind = ind;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Tax implements Serializable
                            {
                                private String amount;
                                private String taxCode;

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'TaxCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getTaxCode() {
                                    return taxCode;
                                }

                                /** 
                                 * Set the 'TaxCode' attribute value.
                                 * 
                                 * @param taxCode
                                 */
                                public void setTaxCode(String taxCode) {
                                    this.taxCode = taxCode;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Total" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Total implements Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReasonForIssuance" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class ReasonForIssuance implements
                        Serializable
                    {
                        private String string;
                        private String code;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SSIM" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SSIM implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' element value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' element value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SSR" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SSR implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' element value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' element value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticket" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Simultaneous"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Ticket implements Serializable
                    {
                        private String number;
                        private String simultaneous;

                        /** 
                         * Get the 'Number' attribute value.
                         * 
                         * @return value
                         */
                        public String getNumber() {
                            return number;
                        }

                        /** 
                         * Set the 'Number' attribute value.
                         * 
                         * @param number
                         */
                        public void setNumber(String number) {
                            this.number = number;
                        }

                        /** 
                         * Get the 'Simultaneous' attribute value.
                         * 
                         * @return value
                         */
                        public String getSimultaneous() {
                            return simultaneous;
                        }

                        /** 
                         * Set the 'Simultaneous' attribute value.
                         * 
                         * @param simultaneous
                         */
                        public void setSimultaneous(String simultaneous) {
                            this.simultaneous = simultaneous;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TourCode implements Serializable
                    {
                        private String text;

                        /** 
                         * Get the 'Text' element value.
                         * 
                         * @return value
                         */
                        public String getText() {
                            return text;
                        }

                        /** 
                         * Set the 'Text' element value.
                         * 
                         * @param text
                         */
                        public void setText(String text) {
                            this.text = text;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefs" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Airline" minOccurs="0">
                     *         &lt;!-- Reference to inner class Airline -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class VendorPrefs implements Serializable
                    {
                        private Airline airline;

                        /** 
                         * Get the 'Airline' element value.
                         * 
                         * @return value
                         */
                        public Airline getAirline() {
                            return airline;
                        }

                        /** 
                         * Set the 'Airline' element value.
                         * 
                         * @param airline
                         */
                        public void setAirline(Airline airline) {
                            this.airline = airline;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Airline implements Serializable
                        {
                            private String code;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class FlightSegment -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="BookingMethodReq"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentCount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ItineraryInfo implements Serializable
                {
                    private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
                    private String bookingMethodReq;
                    private String segmentCount;

                    /** 
                     * Get the list of 'FlightSegment' element items.
                     * 
                     * @return list
                     */
                    public List<FlightSegment> getFlightSegmentList() {
                        return flightSegmentList;
                    }

                    /** 
                     * Set the list of 'FlightSegment' element items.
                     * 
                     * @param list
                     */
                    public void setFlightSegmentList(List<FlightSegment> list) {
                        flightSegmentList = list;
                    }

                    /** 
                     * Get the 'BookingMethodReq' attribute value.
                     * 
                     * @return value
                     */
                    public String getBookingMethodReq() {
                        return bookingMethodReq;
                    }

                    /** 
                     * Set the 'BookingMethodReq' attribute value.
                     * 
                     * @param bookingMethodReq
                     */
                    public void setBookingMethodReq(String bookingMethodReq) {
                        this.bookingMethodReq = bookingMethodReq;
                    }

                    /** 
                     * Get the 'SegmentCount' attribute value.
                     * 
                     * @return value
                     */
                    public String getSegmentCount() {
                        return segmentCount;
                    }

                    /** 
                     * Set the 'SegmentCount' attribute value.
                     * 
                     * @param segmentCount
                     */
                    public void setSegmentCount(String segmentCount) {
                        this.segmentCount = segmentCount;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class DestinationLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="MarketingAirline" minOccurs="0">
                     *         &lt;!-- Reference to inner class MarketingAirline -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OriginLocation" minOccurs="0">
                     *         &lt;!-- Reference to inner class OriginLocation -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FlightSegment implements Serializable
                    {
                        private DestinationLocation destinationLocation;
                        private MarketingAirline marketingAirline;
                        private OriginLocation originLocation;
                        private String departureDateTime;
                        private String flightNumber;
                        private String resBookDesigCode;
                        private String segmentNumber;
                        private String status;

                        /** 
                         * Get the 'DestinationLocation' element value.
                         * 
                         * @return value
                         */
                        public DestinationLocation getDestinationLocation() {
                            return destinationLocation;
                        }

                        /** 
                         * Set the 'DestinationLocation' element value.
                         * 
                         * @param destinationLocation
                         */
                        public void setDestinationLocation(
                                DestinationLocation destinationLocation) {
                            this.destinationLocation = destinationLocation;
                        }

                        /** 
                         * Get the 'MarketingAirline' element value.
                         * 
                         * @return value
                         */
                        public MarketingAirline getMarketingAirline() {
                            return marketingAirline;
                        }

                        /** 
                         * Set the 'MarketingAirline' element value.
                         * 
                         * @param marketingAirline
                         */
                        public void setMarketingAirline(
                                MarketingAirline marketingAirline) {
                            this.marketingAirline = marketingAirline;
                        }

                        /** 
                         * Get the 'OriginLocation' element value.
                         * 
                         * @return value
                         */
                        public OriginLocation getOriginLocation() {
                            return originLocation;
                        }

                        /** 
                         * Set the 'OriginLocation' element value.
                         * 
                         * @param originLocation
                         */
                        public void setOriginLocation(
                                OriginLocation originLocation) {
                            this.originLocation = originLocation;
                        }

                        /** 
                         * Get the 'DepartureDateTime' attribute value.
                         * 
                         * @return value
                         */
                        public String getDepartureDateTime() {
                            return departureDateTime;
                        }

                        /** 
                         * Set the 'DepartureDateTime' attribute value.
                         * 
                         * @param departureDateTime
                         */
                        public void setDepartureDateTime(
                                String departureDateTime) {
                            this.departureDateTime = departureDateTime;
                        }

                        /** 
                         * Get the 'FlightNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getFlightNumber() {
                            return flightNumber;
                        }

                        /** 
                         * Set the 'FlightNumber' attribute value.
                         * 
                         * @param flightNumber
                         */
                        public void setFlightNumber(String flightNumber) {
                            this.flightNumber = flightNumber;
                        }

                        /** 
                         * Get the 'ResBookDesigCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getResBookDesigCode() {
                            return resBookDesigCode;
                        }

                        /** 
                         * Set the 'ResBookDesigCode' attribute value.
                         * 
                         * @param resBookDesigCode
                         */
                        public void setResBookDesigCode(String resBookDesigCode) {
                            this.resBookDesigCode = resBookDesigCode;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }

                        /** 
                         * Get the 'Status' attribute value.
                         * 
                         * @return value
                         */
                        public String getStatus() {
                            return status;
                        }

                        /** 
                         * Set the 'Status' attribute value.
                         * 
                         * @param status
                         */
                        public void setStatus(String status) {
                            this.status = status;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class DestinationLocation implements
                            Serializable
                        {
                            private String locationCode;

                            /** 
                             * Get the 'LocationCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class MarketingAirline implements
                            Serializable
                        {
                            private String code;
                            private String flightNumber;

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }

                            /** 
                             * Get the 'FlightNumber' attribute value.
                             * 
                             * @return value
                             */
                            public String getFlightNumber() {
                                return flightNumber;
                            }

                            /** 
                             * Set the 'FlightNumber' attribute value.
                             * 
                             * @param flightNumber
                             */
                            public void setFlightNumber(String flightNumber) {
                                this.flightNumber = flightNumber;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OriginLocation implements
                            Serializable
                        {
                            private String locationCode;

                            /** 
                             * Get the 'LocationCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInfo" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Ticketing" minOccurs="0" maxOccurs="9">
                 *         &lt;!-- Reference to inner class Ticketing -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TicketingInfo implements Serializable
                {
                    private List<Ticketing> ticketingList = new ArrayList<Ticketing>();

                    /** 
                     * Get the list of 'Ticketing' element items.
                     * 
                     * @return list
                     */
                    public List<Ticketing> getTicketingList() {
                        return ticketingList;
                    }

                    /** 
                     * Set the list of 'Ticketing' element items.
                     * 
                     * @param list
                     */
                    public void setTicketingList(List<Ticketing> list) {
                        ticketingList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticketing" minOccurs="0" maxOccurs="9">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Coupon" minOccurs="0" maxOccurs="16">
                     *         &lt;!-- Reference to inner class Coupon -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="PersonName" minOccurs="0">
                     *         &lt;!-- Reference to inner class PersonName -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="eTicketNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ReferenceNumber"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Ticketing implements Serializable
                    {
                        private List<Coupon> couponList = new ArrayList<Coupon>();
                        private PersonName personName;
                        private String ETicketNumber;
                        private String referenceNumber;

                        /** 
                         * Get the list of 'Coupon' element items.
                         * 
                         * @return list
                         */
                        public List<Coupon> getCouponList() {
                            return couponList;
                        }

                        /** 
                         * Set the list of 'Coupon' element items.
                         * 
                         * @param list
                         */
                        public void setCouponList(List<Coupon> list) {
                            couponList = list;
                        }

                        /** 
                         * Get the 'PersonName' element value.
                         * 
                         * @return value
                         */
                        public PersonName getPersonName() {
                            return personName;
                        }

                        /** 
                         * Set the 'PersonName' element value.
                         * 
                         * @param personName
                         */
                        public void setPersonName(PersonName personName) {
                            this.personName = personName;
                        }

                        /** 
                         * Get the 'eTicketNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getETicketNumber() {
                            return ETicketNumber;
                        }

                        /** 
                         * Set the 'eTicketNumber' attribute value.
                         * 
                         * @param eTicketNumber
                         */
                        public void setETicketNumber(String eTicketNumber) {
                            ETicketNumber = eTicketNumber;
                        }

                        /** 
                         * Get the 'ReferenceNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getReferenceNumber() {
                            return referenceNumber;
                        }

                        /** 
                         * Set the 'ReferenceNumber' attribute value.
                         * 
                         * @param referenceNumber
                         */
                        public void setReferenceNumber(String referenceNumber) {
                            this.referenceNumber = referenceNumber;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Coupon" minOccurs="0" maxOccurs="16">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Coupon implements Serializable
                        {
                            private String number;

                            /** 
                             * Get the 'Number' attribute value.
                             * 
                             * @return value
                             */
                            public String getNumber() {
                                return number;
                            }

                            /** 
                             * Set the 'Number' attribute value.
                             * 
                             * @param number
                             */
                            public void setNumber(String number) {
                                this.number = number;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="GivenName" minOccurs="0">
                         *         &lt;!-- Reference to inner class GivenName -->
                         *       &lt;/xs:element>
                         *       &lt;xs:element name="Surname" minOccurs="0">
                         *         &lt;!-- Reference to inner class Surname -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PersonName implements Serializable
                        {
                            private GivenName givenName;
                            private Surname surname;

                            /** 
                             * Get the 'GivenName' element value.
                             * 
                             * @return value
                             */
                            public GivenName getGivenName() {
                                return givenName;
                            }

                            /** 
                             * Set the 'GivenName' element value.
                             * 
                             * @param givenName
                             */
                            public void setGivenName(GivenName givenName) {
                                this.givenName = givenName;
                            }

                            /** 
                             * Get the 'Surname' element value.
                             * 
                             * @return value
                             */
                            public Surname getSurname() {
                                return surname;
                            }

                            /** 
                             * Set the 'Surname' element value.
                             * 
                             * @param surname
                             */
                            public void setSurname(Surname surname) {
                                this.surname = surname;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GivenName" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class GivenName implements
                                Serializable
                            {
                                private String number;

                                /** 
                                 * Get the 'Number' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getNumber() {
                                    return number;
                                }

                                /** 
                                 * Set the 'Number' attribute value.
                                 * 
                                 * @param number
                                 */
                                public void setNumber(String number) {
                                    this.number = number;
                                }
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surname" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Surname implements Serializable
                            {
                                private String number;

                                /** 
                                 * Get the 'Number' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getNumber() {
                                    return number;
                                }

                                /** 
                                 * Set the 'Number' attribute value.
                                 * 
                                 * @param number
                                 */
                                public void setNumber(String number) {
                                    this.number = number;
                                }
                            }
                        }
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrier" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="SettlementMethod" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="IETCheckedValidatingCarrier" minOccurs="0" maxOccurs="24"/>
             *       &lt;xs:element name="Ticket" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Ticket -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="NewValidatingProcess"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SolutionSequenceNmbr"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ValidatingCarrier implements Serializable
            {
                private String settlementMethod;
                private List<String> IETCheckedValidatingCarrierList = new ArrayList<String>();
                private List<Ticket> ticketList = new ArrayList<Ticket>();
                private Boolean newValidatingProcess;
                private String solutionSequenceNmbr;

                /** 
                 * Get the 'SettlementMethod' element value.
                 * 
                 * @return value
                 */
                public String getSettlementMethod() {
                    return settlementMethod;
                }

                /** 
                 * Set the 'SettlementMethod' element value.
                 * 
                 * @param settlementMethod
                 */
                public void setSettlementMethod(String settlementMethod) {
                    this.settlementMethod = settlementMethod;
                }

                /** 
                 * Get the list of 'IETCheckedValidatingCarrier' element items.
                 * 
                 * @return list
                 */
                public List<String> getIETCheckedValidatingCarrierList() {
                    return IETCheckedValidatingCarrierList;
                }

                /** 
                 * Set the list of 'IETCheckedValidatingCarrier' element items.
                 * 
                 * @param list
                 */
                public void setIETCheckedValidatingCarrierList(List<String> list) {
                    IETCheckedValidatingCarrierList = list;
                }

                /** 
                 * Get the list of 'Ticket' element items.
                 * 
                 * @return list
                 */
                public List<Ticket> getTicketList() {
                    return ticketList;
                }

                /** 
                 * Set the list of 'Ticket' element items.
                 * 
                 * @param list
                 */
                public void setTicketList(List<Ticket> list) {
                    ticketList = list;
                }

                /** 
                 * Get the 'NewValidatingProcess' attribute value.
                 * 
                 * @return value
                 */
                public Boolean getNewValidatingProcess() {
                    return newValidatingProcess;
                }

                /** 
                 * Set the 'NewValidatingProcess' attribute value.
                 * 
                 * @param newValidatingProcess
                 */
                public void setNewValidatingProcess(Boolean newValidatingProcess) {
                    this.newValidatingProcess = newValidatingProcess;
                }

                /** 
                 * Get the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @return value
                 */
                public String getSolutionSequenceNmbr() {
                    return solutionSequenceNmbr;
                }

                /** 
                 * Set the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @param solutionSequenceNmbr
                 */
                public void setSolutionSequenceNmbr(String solutionSequenceNmbr) {
                    this.solutionSequenceNmbr = solutionSequenceNmbr;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ticket" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="InterlineAgreement" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class InterlineAgreement -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="CarrierCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ValidatingCarrierType"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Ticket implements Serializable
                {
                    private List<InterlineAgreement> interlineAgreementList = new ArrayList<InterlineAgreement>();
                    private String type;
                    private String carrierCode;
                    private String validatingCarrierType;

                    /** 
                     * Get the list of 'InterlineAgreement' element items.
                     * 
                     * @return list
                     */
                    public List<InterlineAgreement> getInterlineAgreementList() {
                        return interlineAgreementList;
                    }

                    /** 
                     * Set the list of 'InterlineAgreement' element items.
                     * 
                     * @param list
                     */
                    public void setInterlineAgreementList(
                            List<InterlineAgreement> list) {
                        interlineAgreementList = list;
                    }

                    /** 
                     * Get the 'Type' attribute value.
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value.
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'CarrierCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getCarrierCode() {
                        return carrierCode;
                    }

                    /** 
                     * Set the 'CarrierCode' attribute value.
                     * 
                     * @param carrierCode
                     */
                    public void setCarrierCode(String carrierCode) {
                        this.carrierCode = carrierCode;
                    }

                    /** 
                     * Get the 'ValidatingCarrierType' attribute value.
                     * 
                     * @return value
                     */
                    public String getValidatingCarrierType() {
                        return validatingCarrierType;
                    }

                    /** 
                     * Set the 'ValidatingCarrierType' attribute value.
                     * 
                     * @param validatingCarrierType
                     */
                    public void setValidatingCarrierType(
                            String validatingCarrierType) {
                        this.validatingCarrierType = validatingCarrierType;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InterlineAgreement" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CarrierCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class InterlineAgreement implements
                        Serializable
                    {
                        private String type;
                        private String carrierCode;

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }

                        /** 
                         * Get the 'CarrierCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCarrierCode() {
                            return carrierCode;
                        }

                        /** 
                         * Set the 'CarrierCode' attribute value.
                         * 
                         * @param carrierCode
                         */
                        public void setCarrierCode(String carrierCode) {
                            this.carrierCode = carrierCode;
                        }
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedItinerary" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AirItineraryPricingInfo" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class AirItineraryPricingInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="AlternativePricing"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="MultiTicket"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="MultiTicketShortText"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceFeeAmount"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceFeeCurrencyCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceFeeTax"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="TotalAmount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PricedItinerary implements Serializable
        {
            private List<AirItineraryPricingInfo> airItineraryPricingInfoList = new ArrayList<AirItineraryPricingInfo>();
            private String alternativePricing;
            private String currencyCode;
            private Boolean multiTicket;
            private String multiTicketShortText;
            private String serviceFeeAmount;
            private String serviceFeeCurrencyCode;
            private String serviceFeeTax;
            private String totalAmount;

            /** 
             * Get the list of 'AirItineraryPricingInfo' element items.
             * 
             * @return list
             */
            public List<AirItineraryPricingInfo> getAirItineraryPricingInfoList() {
                return airItineraryPricingInfoList;
            }

            /** 
             * Set the list of 'AirItineraryPricingInfo' element items.
             * 
             * @param list
             */
            public void setAirItineraryPricingInfoList(
                    List<AirItineraryPricingInfo> list) {
                airItineraryPricingInfoList = list;
            }

            /** 
             * Get the 'AlternativePricing' attribute value.
             * 
             * @return value
             */
            public String getAlternativePricing() {
                return alternativePricing;
            }

            /** 
             * Set the 'AlternativePricing' attribute value.
             * 
             * @param alternativePricing
             */
            public void setAlternativePricing(String alternativePricing) {
                this.alternativePricing = alternativePricing;
            }

            /** 
             * Get the 'CurrencyCode' attribute value.
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'CurrencyCode' attribute value.
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }

            /** 
             * Get the 'MultiTicket' attribute value.
             * 
             * @return value
             */
            public Boolean getMultiTicket() {
                return multiTicket;
            }

            /** 
             * Set the 'MultiTicket' attribute value.
             * 
             * @param multiTicket
             */
            public void setMultiTicket(Boolean multiTicket) {
                this.multiTicket = multiTicket;
            }

            /** 
             * Get the 'MultiTicketShortText' attribute value.
             * 
             * @return value
             */
            public String getMultiTicketShortText() {
                return multiTicketShortText;
            }

            /** 
             * Set the 'MultiTicketShortText' attribute value.
             * 
             * @param multiTicketShortText
             */
            public void setMultiTicketShortText(String multiTicketShortText) {
                this.multiTicketShortText = multiTicketShortText;
            }

            /** 
             * Get the 'ServiceFeeAmount' attribute value.
             * 
             * @return value
             */
            public String getServiceFeeAmount() {
                return serviceFeeAmount;
            }

            /** 
             * Set the 'ServiceFeeAmount' attribute value.
             * 
             * @param serviceFeeAmount
             */
            public void setServiceFeeAmount(String serviceFeeAmount) {
                this.serviceFeeAmount = serviceFeeAmount;
            }

            /** 
             * Get the 'ServiceFeeCurrencyCode' attribute value.
             * 
             * @return value
             */
            public String getServiceFeeCurrencyCode() {
                return serviceFeeCurrencyCode;
            }

            /** 
             * Set the 'ServiceFeeCurrencyCode' attribute value.
             * 
             * @param serviceFeeCurrencyCode
             */
            public void setServiceFeeCurrencyCode(String serviceFeeCurrencyCode) {
                this.serviceFeeCurrencyCode = serviceFeeCurrencyCode;
            }

            /** 
             * Get the 'ServiceFeeTax' attribute value.
             * 
             * @return value
             */
            public String getServiceFeeTax() {
                return serviceFeeTax;
            }

            /** 
             * Set the 'ServiceFeeTax' attribute value.
             * 
             * @param serviceFeeTax
             */
            public void setServiceFeeTax(String serviceFeeTax) {
                this.serviceFeeTax = serviceFeeTax;
            }

            /** 
             * Get the 'TotalAmount' attribute value.
             * 
             * @return value
             */
            public String getTotalAmount() {
                return totalAmount;
            }

            /** 
             * Set the 'TotalAmount' attribute value.
             * 
             * @param totalAmount
             */
            public void setTotalAmount(String totalAmount) {
                this.totalAmount = totalAmount;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryPricingInfo" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="AgencyCommission" minOccurs="0" maxOccurs="23">
             *         &lt;!-- Reference to inner class AgencyCommission -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="AncillaryFees" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class AncillaryFees -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="BaggageProvisions" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class BaggageProvisions -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareCalculation" minOccurs="0">
             *         &lt;!-- Reference to inner class FareCalculation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareCalculationBreakdown" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class FareCalculationBreakdown -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="ItinTotalFare" minOccurs="0">
             *         &lt;!-- Reference to inner class ItinTotalFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PassengerTypeQuantity" minOccurs="0">
             *         &lt;!-- Reference to inner class PassengerTypeQuantity -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PTC_FareBreakdown" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class PTCFareBreakdown -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="RetailerRules" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class RetailerRules -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SpecificPenalty" minOccurs="0" maxOccurs="4">
             *         &lt;!-- Reference to inner class SpecificPenalty -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TicketingFees" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class TicketingFees -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="SolutionSequenceNmbr"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AirItineraryPricingInfo implements Serializable
            {
                private List<AgencyCommission> agencyCommissionList = new ArrayList<AgencyCommission>();
                private List<AncillaryFees> ancillaryFeeList = new ArrayList<AncillaryFees>();
                private List<BaggageProvisions> baggageProvisionList = new ArrayList<BaggageProvisions>();
                private FareCalculation fareCalculation;
                private List<FareCalculationBreakdown> fareCalculationBreakdownList = new ArrayList<FareCalculationBreakdown>();
                private ItinTotalFare itinTotalFare;
                private PassengerTypeQuantity passengerTypeQuantity;
                private List<PTCFareBreakdown> PTCFareBreakdownList = new ArrayList<PTCFareBreakdown>();
                private List<RetailerRules> retailerRuleList = new ArrayList<RetailerRules>();
                private List<SpecificPenalty> specificPenaltyList = new ArrayList<SpecificPenalty>();
                private List<TicketingFees> ticketingFeeList = new ArrayList<TicketingFees>();
                private String solutionSequenceNmbr;

                /** 
                 * Get the list of 'AgencyCommission' element items.
                 * 
                 * @return list
                 */
                public List<AgencyCommission> getAgencyCommissionList() {
                    return agencyCommissionList;
                }

                /** 
                 * Set the list of 'AgencyCommission' element items.
                 * 
                 * @param list
                 */
                public void setAgencyCommissionList(List<AgencyCommission> list) {
                    agencyCommissionList = list;
                }

                /** 
                 * Get the list of 'AncillaryFees' element items.
                 * 
                 * @return list
                 */
                public List<AncillaryFees> getAncillaryFeeList() {
                    return ancillaryFeeList;
                }

                /** 
                 * Set the list of 'AncillaryFees' element items.
                 * 
                 * @param list
                 */
                public void setAncillaryFeeList(List<AncillaryFees> list) {
                    ancillaryFeeList = list;
                }

                /** 
                 * Get the list of 'BaggageProvisions' element items.
                 * 
                 * @return list
                 */
                public List<BaggageProvisions> getBaggageProvisionList() {
                    return baggageProvisionList;
                }

                /** 
                 * Set the list of 'BaggageProvisions' element items.
                 * 
                 * @param list
                 */
                public void setBaggageProvisionList(List<BaggageProvisions> list) {
                    baggageProvisionList = list;
                }

                /** 
                 * Get the 'FareCalculation' element value.
                 * 
                 * @return value
                 */
                public FareCalculation getFareCalculation() {
                    return fareCalculation;
                }

                /** 
                 * Set the 'FareCalculation' element value.
                 * 
                 * @param fareCalculation
                 */
                public void setFareCalculation(FareCalculation fareCalculation) {
                    this.fareCalculation = fareCalculation;
                }

                /** 
                 * Get the list of 'FareCalculationBreakdown' element items.
                 * 
                 * @return list
                 */
                public List<FareCalculationBreakdown> getFareCalculationBreakdownList() {
                    return fareCalculationBreakdownList;
                }

                /** 
                 * Set the list of 'FareCalculationBreakdown' element items.
                 * 
                 * @param list
                 */
                public void setFareCalculationBreakdownList(
                        List<FareCalculationBreakdown> list) {
                    fareCalculationBreakdownList = list;
                }

                /** 
                 * Get the 'ItinTotalFare' element value.
                 * 
                 * @return value
                 */
                public ItinTotalFare getItinTotalFare() {
                    return itinTotalFare;
                }

                /** 
                 * Set the 'ItinTotalFare' element value.
                 * 
                 * @param itinTotalFare
                 */
                public void setItinTotalFare(ItinTotalFare itinTotalFare) {
                    this.itinTotalFare = itinTotalFare;
                }

                /** 
                 * Get the 'PassengerTypeQuantity' element value.
                 * 
                 * @return value
                 */
                public PassengerTypeQuantity getPassengerTypeQuantity() {
                    return passengerTypeQuantity;
                }

                /** 
                 * Set the 'PassengerTypeQuantity' element value.
                 * 
                 * @param passengerTypeQuantity
                 */
                public void setPassengerTypeQuantity(
                        PassengerTypeQuantity passengerTypeQuantity) {
                    this.passengerTypeQuantity = passengerTypeQuantity;
                }

                /** 
                 * Get the list of 'PTC_FareBreakdown' element items.
                 * 
                 * @return list
                 */
                public List<PTCFareBreakdown> getPTCFareBreakdownList() {
                    return PTCFareBreakdownList;
                }

                /** 
                 * Set the list of 'PTC_FareBreakdown' element items.
                 * 
                 * @param list
                 */
                public void setPTCFareBreakdownList(List<PTCFareBreakdown> list) {
                    PTCFareBreakdownList = list;
                }

                /** 
                 * Get the list of 'RetailerRules' element items.
                 * 
                 * @return list
                 */
                public List<RetailerRules> getRetailerRuleList() {
                    return retailerRuleList;
                }

                /** 
                 * Set the list of 'RetailerRules' element items.
                 * 
                 * @param list
                 */
                public void setRetailerRuleList(List<RetailerRules> list) {
                    retailerRuleList = list;
                }

                /** 
                 * Get the list of 'SpecificPenalty' element items.
                 * 
                 * @return list
                 */
                public List<SpecificPenalty> getSpecificPenaltyList() {
                    return specificPenaltyList;
                }

                /** 
                 * Set the list of 'SpecificPenalty' element items.
                 * 
                 * @param list
                 */
                public void setSpecificPenaltyList(List<SpecificPenalty> list) {
                    specificPenaltyList = list;
                }

                /** 
                 * Get the list of 'TicketingFees' element items.
                 * 
                 * @return list
                 */
                public List<TicketingFees> getTicketingFeeList() {
                    return ticketingFeeList;
                }

                /** 
                 * Set the list of 'TicketingFees' element items.
                 * 
                 * @param list
                 */
                public void setTicketingFeeList(List<TicketingFees> list) {
                    ticketingFeeList = list;
                }

                /** 
                 * Get the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @return value
                 */
                public String getSolutionSequenceNmbr() {
                    return solutionSequenceNmbr;
                }

                /** 
                 * Set the 'SolutionSequenceNmbr' attribute value.
                 * 
                 * @param solutionSequenceNmbr
                 */
                public void setSolutionSequenceNmbr(String solutionSequenceNmbr) {
                    this.solutionSequenceNmbr = solutionSequenceNmbr;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyCommission" minOccurs="0" maxOccurs="23">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="CommissionContract" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="TotalPricedCommission" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AgencyCommission implements Serializable
                {
                    private String commissionContract;
                    private String totalPricedCommission;
                    private String validatingCarrier;

                    /** 
                     * Get the 'CommissionContract' element value.
                     * 
                     * @return value
                     */
                    public String getCommissionContract() {
                        return commissionContract;
                    }

                    /** 
                     * Set the 'CommissionContract' element value.
                     * 
                     * @param commissionContract
                     */
                    public void setCommissionContract(String commissionContract) {
                        this.commissionContract = commissionContract;
                    }

                    /** 
                     * Get the 'TotalPricedCommission' element value.
                     * 
                     * @return value
                     */
                    public String getTotalPricedCommission() {
                        return totalPricedCommission;
                    }

                    /** 
                     * Set the 'TotalPricedCommission' element value.
                     * 
                     * @param totalPricedCommission
                     */
                    public void setTotalPricedCommission(
                            String totalPricedCommission) {
                        this.totalPricedCommission = totalPricedCommission;
                    }

                    /** 
                     * Get the 'ValidatingCarrier' element value.
                     * 
                     * @return value
                     */
                    public String getValidatingCarrier() {
                        return validatingCarrier;
                    }

                    /** 
                     * Set the 'ValidatingCarrier' element value.
                     * 
                     * @param validatingCarrier
                     */
                    public void setValidatingCarrier(String validatingCarrier) {
                        this.validatingCarrier = validatingCarrier;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryFees" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="FeeInformation" minOccurs="0">
                 *         &lt;!-- Reference to inner class FeeInformation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AncillaryFees implements Serializable
                {
                    private FeeInformation feeInformation;

                    /** 
                     * Get the 'FeeInformation' element value.
                     * 
                     * @return value
                     */
                    public FeeInformation getFeeInformation() {
                        return feeInformation;
                    }

                    /** 
                     * Set the 'FeeInformation' element value.
                     * 
                     * @param feeInformation
                     */
                    public void setFeeInformation(FeeInformation feeInformation) {
                        this.feeInformation = feeInformation;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeInformation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="CreditCardFOP_MatchingBin" minOccurs="0"/>
                     *       &lt;xs:element type="xs:decimal" name="CreditCard_ResidualAmount" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="MaximumServiceFeeAmount" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="OB_FeeTicketTotalFareAmount" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="ServiceFeePercentage" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="TaxAmount" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="TaxID" minOccurs="0" maxOccurs="unbounded"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NumFees"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="NameNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SegmentNumber"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FeeInformation implements Serializable
                    {
                        private String creditCardFOPMatchingBin;
                        private BigDecimal creditCardResidualAmount;
                        private String maximumServiceFeeAmount;
                        private String OBFeeTicketTotalFareAmount;
                        private String serviceFeePercentage;
                        private List<String> taxAmountList = new ArrayList<String>();
                        private List<String> taxIDList = new ArrayList<String>();
                        private String amount;
                        private String code;
                        private String numFees;
                        private String nameNumber;
                        private String segmentNumber;

                        /** 
                         * Get the 'CreditCardFOP_MatchingBin' element value.
                         * 
                         * @return value
                         */
                        public String getCreditCardFOPMatchingBin() {
                            return creditCardFOPMatchingBin;
                        }

                        /** 
                         * Set the 'CreditCardFOP_MatchingBin' element value.
                         * 
                         * @param creditCardFOPMatchingBin
                         */
                        public void setCreditCardFOPMatchingBin(
                                String creditCardFOPMatchingBin) {
                            this.creditCardFOPMatchingBin = creditCardFOPMatchingBin;
                        }

                        /** 
                         * Get the 'CreditCard_ResidualAmount' element value.
                         * 
                         * @return value
                         */
                        public BigDecimal getCreditCardResidualAmount() {
                            return creditCardResidualAmount;
                        }

                        /** 
                         * Set the 'CreditCard_ResidualAmount' element value.
                         * 
                         * @param creditCardResidualAmount
                         */
                        public void setCreditCardResidualAmount(
                                BigDecimal creditCardResidualAmount) {
                            this.creditCardResidualAmount = creditCardResidualAmount;
                        }

                        /** 
                         * Get the 'MaximumServiceFeeAmount' element value.
                         * 
                         * @return value
                         */
                        public String getMaximumServiceFeeAmount() {
                            return maximumServiceFeeAmount;
                        }

                        /** 
                         * Set the 'MaximumServiceFeeAmount' element value.
                         * 
                         * @param maximumServiceFeeAmount
                         */
                        public void setMaximumServiceFeeAmount(
                                String maximumServiceFeeAmount) {
                            this.maximumServiceFeeAmount = maximumServiceFeeAmount;
                        }

                        /** 
                         * Get the 'OB_FeeTicketTotalFareAmount' element value.
                         * 
                         * @return value
                         */
                        public String getOBFeeTicketTotalFareAmount() {
                            return OBFeeTicketTotalFareAmount;
                        }

                        /** 
                         * Set the 'OB_FeeTicketTotalFareAmount' element value.
                         * 
                         * @param OBFeeTicketTotalFareAmount
                         */
                        public void setOBFeeTicketTotalFareAmount(
                                String OBFeeTicketTotalFareAmount) {
                            this.OBFeeTicketTotalFareAmount = OBFeeTicketTotalFareAmount;
                        }

                        /** 
                         * Get the 'ServiceFeePercentage' element value.
                         * 
                         * @return value
                         */
                        public String getServiceFeePercentage() {
                            return serviceFeePercentage;
                        }

                        /** 
                         * Set the 'ServiceFeePercentage' element value.
                         * 
                         * @param serviceFeePercentage
                         */
                        public void setServiceFeePercentage(
                                String serviceFeePercentage) {
                            this.serviceFeePercentage = serviceFeePercentage;
                        }

                        /** 
                         * Get the list of 'TaxAmount' element items.
                         * 
                         * @return list
                         */
                        public List<String> getTaxAmountList() {
                            return taxAmountList;
                        }

                        /** 
                         * Set the list of 'TaxAmount' element items.
                         * 
                         * @param list
                         */
                        public void setTaxAmountList(List<String> list) {
                            taxAmountList = list;
                        }

                        /** 
                         * Get the list of 'TaxID' element items.
                         * 
                         * @return list
                         */
                        public List<String> getTaxIDList() {
                            return taxIDList;
                        }

                        /** 
                         * Set the list of 'TaxID' element items.
                         * 
                         * @param list
                         */
                        public void setTaxIDList(List<String> list) {
                            taxIDList = list;
                        }

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'NumFees' attribute value.
                         * 
                         * @return value
                         */
                        public String getNumFees() {
                            return numFees;
                        }

                        /** 
                         * Set the 'NumFees' attribute value.
                         * 
                         * @param numFees
                         */
                        public void setNumFees(String numFees) {
                            this.numFees = numFees;
                        }

                        /** 
                         * Get the 'NameNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getNameNumber() {
                            return nameNumber;
                        }

                        /** 
                         * Set the 'NameNumber' attribute value.
                         * 
                         * @param nameNumber
                         */
                        public void setNameNumber(String nameNumber) {
                            this.nameNumber = nameNumber;
                        }

                        /** 
                         * Get the 'SegmentNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getSegmentNumber() {
                            return segmentNumber;
                        }

                        /** 
                         * Set the 'SegmentNumber' attribute value.
                         * 
                         * @param segmentNumber
                         */
                        public void setSegmentNumber(String segmentNumber) {
                            this.segmentNumber = segmentNumber;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageProvisions" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Associations" minOccurs="0">
                 *         &lt;!-- Reference to inner class Associations -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="CarrierWhoseBaggageProvisionsApply" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Commissionable" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="FeeApplicationIndicator" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="FeeNotGuaranteedIndicator" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="FirstOccurrence" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="FQTV_CarrierFiledTierLevel" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Interlineable" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="LastOccurrence" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="NoChargeNotAvailableIndicator" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="NumPiecesBDI" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="NumPiecesITR" minOccurs="0" maxOccurs="unbounded"/>
                 *       &lt;xs:element name="PassengerType" minOccurs="0">
                 *         &lt;!-- Reference to inner class PassengerType -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="PriceInformation" minOccurs="0">
                 *         &lt;!-- Reference to inner class PriceInformation -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="ProvisionType" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="RefundForm" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="RefundReissue" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="SimultaneousTicketIndicator" minOccurs="0"/>
                 *       &lt;xs:element name="SubCodeInfo" minOccurs="0">
                 *         &lt;!-- Reference to inner class SubCodeInfo -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="WeightLimit" minOccurs="0">
                 *         &lt;!-- Reference to inner class WeightLimit -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BaggageProvisions implements Serializable
                {
                    private Associations associations;
                    private String carrierWhoseBaggageProvisionsApply;
                    private String commissionable;
                    private String feeApplicationIndicator;
                    private String feeNotGuaranteedIndicator;
                    private String firstOccurrence;
                    private String FQTVCarrierFiledTierLevel;
                    private String interlineable;
                    private String lastOccurrence;
                    private String noChargeNotAvailableIndicator;
                    private String numPiecesBDI;
                    private List<String> numPiecesITRList = new ArrayList<String>();
                    private PassengerType passengerType;
                    private PriceInformation priceInformation;
                    private String provisionType;
                    private String refundForm;
                    private String refundReissue;
                    private String simultaneousTicketIndicator;
                    private SubCodeInfo subCodeInfo;
                    private WeightLimit weightLimit;
                    private String RPH;

                    /** 
                     * Get the 'Associations' element value.
                     * 
                     * @return value
                     */
                    public Associations getAssociations() {
                        return associations;
                    }

                    /** 
                     * Set the 'Associations' element value.
                     * 
                     * @param associations
                     */
                    public void setAssociations(Associations associations) {
                        this.associations = associations;
                    }

                    /** 
                     * Get the 'CarrierWhoseBaggageProvisionsApply' element value.
                     * 
                     * @return value
                     */
                    public String getCarrierWhoseBaggageProvisionsApply() {
                        return carrierWhoseBaggageProvisionsApply;
                    }

                    /** 
                     * Set the 'CarrierWhoseBaggageProvisionsApply' element value.
                     * 
                     * @param carrierWhoseBaggageProvisionsApply
                     */
                    public void setCarrierWhoseBaggageProvisionsApply(
                            String carrierWhoseBaggageProvisionsApply) {
                        this.carrierWhoseBaggageProvisionsApply = carrierWhoseBaggageProvisionsApply;
                    }

                    /** 
                     * Get the 'Commissionable' element value.
                     * 
                     * @return value
                     */
                    public String getCommissionable() {
                        return commissionable;
                    }

                    /** 
                     * Set the 'Commissionable' element value.
                     * 
                     * @param commissionable
                     */
                    public void setCommissionable(String commissionable) {
                        this.commissionable = commissionable;
                    }

                    /** 
                     * Get the 'FeeApplicationIndicator' element value.
                     * 
                     * @return value
                     */
                    public String getFeeApplicationIndicator() {
                        return feeApplicationIndicator;
                    }

                    /** 
                     * Set the 'FeeApplicationIndicator' element value.
                     * 
                     * @param feeApplicationIndicator
                     */
                    public void setFeeApplicationIndicator(
                            String feeApplicationIndicator) {
                        this.feeApplicationIndicator = feeApplicationIndicator;
                    }

                    /** 
                     * Get the 'FeeNotGuaranteedIndicator' element value.
                     * 
                     * @return value
                     */
                    public String getFeeNotGuaranteedIndicator() {
                        return feeNotGuaranteedIndicator;
                    }

                    /** 
                     * Set the 'FeeNotGuaranteedIndicator' element value.
                     * 
                     * @param feeNotGuaranteedIndicator
                     */
                    public void setFeeNotGuaranteedIndicator(
                            String feeNotGuaranteedIndicator) {
                        this.feeNotGuaranteedIndicator = feeNotGuaranteedIndicator;
                    }

                    /** 
                     * Get the 'FirstOccurrence' element value.
                     * 
                     * @return value
                     */
                    public String getFirstOccurrence() {
                        return firstOccurrence;
                    }

                    /** 
                     * Set the 'FirstOccurrence' element value.
                     * 
                     * @param firstOccurrence
                     */
                    public void setFirstOccurrence(String firstOccurrence) {
                        this.firstOccurrence = firstOccurrence;
                    }

                    /** 
                     * Get the 'FQTV_CarrierFiledTierLevel' element value.
                     * 
                     * @return value
                     */
                    public String getFQTVCarrierFiledTierLevel() {
                        return FQTVCarrierFiledTierLevel;
                    }

                    /** 
                     * Set the 'FQTV_CarrierFiledTierLevel' element value.
                     * 
                     * @param FQTVCarrierFiledTierLevel
                     */
                    public void setFQTVCarrierFiledTierLevel(
                            String FQTVCarrierFiledTierLevel) {
                        this.FQTVCarrierFiledTierLevel = FQTVCarrierFiledTierLevel;
                    }

                    /** 
                     * Get the 'Interlineable' element value.
                     * 
                     * @return value
                     */
                    public String getInterlineable() {
                        return interlineable;
                    }

                    /** 
                     * Set the 'Interlineable' element value.
                     * 
                     * @param interlineable
                     */
                    public void setInterlineable(String interlineable) {
                        this.interlineable = interlineable;
                    }

                    /** 
                     * Get the 'LastOccurrence' element value.
                     * 
                     * @return value
                     */
                    public String getLastOccurrence() {
                        return lastOccurrence;
                    }

                    /** 
                     * Set the 'LastOccurrence' element value.
                     * 
                     * @param lastOccurrence
                     */
                    public void setLastOccurrence(String lastOccurrence) {
                        this.lastOccurrence = lastOccurrence;
                    }

                    /** 
                     * Get the 'NoChargeNotAvailableIndicator' element value.
                     * 
                     * @return value
                     */
                    public String getNoChargeNotAvailableIndicator() {
                        return noChargeNotAvailableIndicator;
                    }

                    /** 
                     * Set the 'NoChargeNotAvailableIndicator' element value.
                     * 
                     * @param noChargeNotAvailableIndicator
                     */
                    public void setNoChargeNotAvailableIndicator(
                            String noChargeNotAvailableIndicator) {
                        this.noChargeNotAvailableIndicator = noChargeNotAvailableIndicator;
                    }

                    /** 
                     * Get the 'NumPiecesBDI' element value.
                     * 
                     * @return value
                     */
                    public String getNumPiecesBDI() {
                        return numPiecesBDI;
                    }

                    /** 
                     * Set the 'NumPiecesBDI' element value.
                     * 
                     * @param numPiecesBDI
                     */
                    public void setNumPiecesBDI(String numPiecesBDI) {
                        this.numPiecesBDI = numPiecesBDI;
                    }

                    /** 
                     * Get the list of 'NumPiecesITR' element items.
                     * 
                     * @return list
                     */
                    public List<String> getNumPiecesITRList() {
                        return numPiecesITRList;
                    }

                    /** 
                     * Set the list of 'NumPiecesITR' element items.
                     * 
                     * @param list
                     */
                    public void setNumPiecesITRList(List<String> list) {
                        numPiecesITRList = list;
                    }

                    /** 
                     * Get the 'PassengerType' element value.
                     * 
                     * @return value
                     */
                    public PassengerType getPassengerType() {
                        return passengerType;
                    }

                    /** 
                     * Set the 'PassengerType' element value.
                     * 
                     * @param passengerType
                     */
                    public void setPassengerType(PassengerType passengerType) {
                        this.passengerType = passengerType;
                    }

                    /** 
                     * Get the 'PriceInformation' element value.
                     * 
                     * @return value
                     */
                    public PriceInformation getPriceInformation() {
                        return priceInformation;
                    }

                    /** 
                     * Set the 'PriceInformation' element value.
                     * 
                     * @param priceInformation
                     */
                    public void setPriceInformation(
                            PriceInformation priceInformation) {
                        this.priceInformation = priceInformation;
                    }

                    /** 
                     * Get the 'ProvisionType' element value.
                     * 
                     * @return value
                     */
                    public String getProvisionType() {
                        return provisionType;
                    }

                    /** 
                     * Set the 'ProvisionType' element value.
                     * 
                     * @param provisionType
                     */
                    public void setProvisionType(String provisionType) {
                        this.provisionType = provisionType;
                    }

                    /** 
                     * Get the 'RefundForm' element value.
                     * 
                     * @return value
                     */
                    public String getRefundForm() {
                        return refundForm;
                    }

                    /** 
                     * Set the 'RefundForm' element value.
                     * 
                     * @param refundForm
                     */
                    public void setRefundForm(String refundForm) {
                        this.refundForm = refundForm;
                    }

                    /** 
                     * Get the 'RefundReissue' element value.
                     * 
                     * @return value
                     */
                    public String getRefundReissue() {
                        return refundReissue;
                    }

                    /** 
                     * Set the 'RefundReissue' element value.
                     * 
                     * @param refundReissue
                     */
                    public void setRefundReissue(String refundReissue) {
                        this.refundReissue = refundReissue;
                    }

                    /** 
                     * Get the 'SimultaneousTicketIndicator' element value.
                     * 
                     * @return value
                     */
                    public String getSimultaneousTicketIndicator() {
                        return simultaneousTicketIndicator;
                    }

                    /** 
                     * Set the 'SimultaneousTicketIndicator' element value.
                     * 
                     * @param simultaneousTicketIndicator
                     */
                    public void setSimultaneousTicketIndicator(
                            String simultaneousTicketIndicator) {
                        this.simultaneousTicketIndicator = simultaneousTicketIndicator;
                    }

                    /** 
                     * Get the 'SubCodeInfo' element value.
                     * 
                     * @return value
                     */
                    public SubCodeInfo getSubCodeInfo() {
                        return subCodeInfo;
                    }

                    /** 
                     * Set the 'SubCodeInfo' element value.
                     * 
                     * @param subCodeInfo
                     */
                    public void setSubCodeInfo(SubCodeInfo subCodeInfo) {
                        this.subCodeInfo = subCodeInfo;
                    }

                    /** 
                     * Get the 'WeightLimit' element value.
                     * 
                     * @return value
                     */
                    public WeightLimit getWeightLimit() {
                        return weightLimit;
                    }

                    /** 
                     * Set the 'WeightLimit' element value.
                     * 
                     * @param weightLimit
                     */
                    public void setWeightLimit(WeightLimit weightLimit) {
                        this.weightLimit = weightLimit;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public String getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(String RPH) {
                        this.RPH = RPH;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="CarrierCode" minOccurs="0" maxOccurs="32">
                     *         &lt;!-- Reference to inner class CarrierCode -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="CountForSegmentAssociatedID" minOccurs="0"/>
                     *       &lt;xs:element name="DepartureDate" minOccurs="0" maxOccurs="32">
                     *         &lt;!-- Reference to inner class DepartureDate -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="DestinationLocation" minOccurs="0" maxOccurs="32">
                     *         &lt;!-- Reference to inner class DestinationLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FlightNumber" minOccurs="0" maxOccurs="32">
                     *         &lt;!-- Reference to inner class FlightNumber -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="OriginLocation" minOccurs="0" maxOccurs="32">
                     *         &lt;!-- Reference to inner class OriginLocation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="PNR_Segment" minOccurs="0" maxOccurs="32">
                     *         &lt;!-- Reference to inner class PNRSegment -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="ResBookDesigCode" minOccurs="0" maxOccurs="32">
                     *         &lt;!-- Reference to inner class ResBookDesigCode -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="StatusCode" minOccurs="0" maxOccurs="32">
                     *         &lt;!-- Reference to inner class StatusCode -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Associations implements Serializable
                    {
                        private List<CarrierCode> carrierCodeList = new ArrayList<CarrierCode>();
                        private String countForSegmentAssociatedID;
                        private List<DepartureDate> departureDateList = new ArrayList<DepartureDate>();
                        private List<DestinationLocation> destinationLocationList = new ArrayList<DestinationLocation>();
                        private List<FlightNumber> flightNumberList = new ArrayList<FlightNumber>();
                        private List<OriginLocation> originLocationList = new ArrayList<OriginLocation>();
                        private List<PNRSegment> PNRSegmentList = new ArrayList<PNRSegment>();
                        private List<ResBookDesigCode> resBookDesigCodeList = new ArrayList<ResBookDesigCode>();
                        private List<StatusCode> statusCodeList = new ArrayList<StatusCode>();

                        /** 
                         * Get the list of 'CarrierCode' element items.
                         * 
                         * @return list
                         */
                        public List<CarrierCode> getCarrierCodeList() {
                            return carrierCodeList;
                        }

                        /** 
                         * Set the list of 'CarrierCode' element items.
                         * 
                         * @param list
                         */
                        public void setCarrierCodeList(List<CarrierCode> list) {
                            carrierCodeList = list;
                        }

                        /** 
                         * Get the 'CountForSegmentAssociatedID' element value.
                         * 
                         * @return value
                         */
                        public String getCountForSegmentAssociatedID() {
                            return countForSegmentAssociatedID;
                        }

                        /** 
                         * Set the 'CountForSegmentAssociatedID' element value.
                         * 
                         * @param countForSegmentAssociatedID
                         */
                        public void setCountForSegmentAssociatedID(
                                String countForSegmentAssociatedID) {
                            this.countForSegmentAssociatedID = countForSegmentAssociatedID;
                        }

                        /** 
                         * Get the list of 'DepartureDate' element items.
                         * 
                         * @return list
                         */
                        public List<DepartureDate> getDepartureDateList() {
                            return departureDateList;
                        }

                        /** 
                         * Set the list of 'DepartureDate' element items.
                         * 
                         * @param list
                         */
                        public void setDepartureDateList(
                                List<DepartureDate> list) {
                            departureDateList = list;
                        }

                        /** 
                         * Get the list of 'DestinationLocation' element items.
                         * 
                         * @return list
                         */
                        public List<DestinationLocation> getDestinationLocationList() {
                            return destinationLocationList;
                        }

                        /** 
                         * Set the list of 'DestinationLocation' element items.
                         * 
                         * @param list
                         */
                        public void setDestinationLocationList(
                                List<DestinationLocation> list) {
                            destinationLocationList = list;
                        }

                        /** 
                         * Get the list of 'FlightNumber' element items.
                         * 
                         * @return list
                         */
                        public List<FlightNumber> getFlightNumberList() {
                            return flightNumberList;
                        }

                        /** 
                         * Set the list of 'FlightNumber' element items.
                         * 
                         * @param list
                         */
                        public void setFlightNumberList(List<FlightNumber> list) {
                            flightNumberList = list;
                        }

                        /** 
                         * Get the list of 'OriginLocation' element items.
                         * 
                         * @return list
                         */
                        public List<OriginLocation> getOriginLocationList() {
                            return originLocationList;
                        }

                        /** 
                         * Set the list of 'OriginLocation' element items.
                         * 
                         * @param list
                         */
                        public void setOriginLocationList(
                                List<OriginLocation> list) {
                            originLocationList = list;
                        }

                        /** 
                         * Get the list of 'PNR_Segment' element items.
                         * 
                         * @return list
                         */
                        public List<PNRSegment> getPNRSegmentList() {
                            return PNRSegmentList;
                        }

                        /** 
                         * Set the list of 'PNR_Segment' element items.
                         * 
                         * @param list
                         */
                        public void setPNRSegmentList(List<PNRSegment> list) {
                            PNRSegmentList = list;
                        }

                        /** 
                         * Get the list of 'ResBookDesigCode' element items.
                         * 
                         * @return list
                         */
                        public List<ResBookDesigCode> getResBookDesigCodeList() {
                            return resBookDesigCodeList;
                        }

                        /** 
                         * Set the list of 'ResBookDesigCode' element items.
                         * 
                         * @param list
                         */
                        public void setResBookDesigCodeList(
                                List<ResBookDesigCode> list) {
                            resBookDesigCodeList = list;
                        }

                        /** 
                         * Get the list of 'StatusCode' element items.
                         * 
                         * @return list
                         */
                        public List<StatusCode> getStatusCodeList() {
                            return statusCodeList;
                        }

                        /** 
                         * Set the list of 'StatusCode' element items.
                         * 
                         * @param list
                         */
                        public void setStatusCodeList(List<StatusCode> list) {
                            statusCodeList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierCode" minOccurs="0" maxOccurs="32">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class CarrierCode implements Serializable
                        {
                            private String string;
                            private BigInteger RPH;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'RPH' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getRPH() {
                                return RPH;
                            }

                            /** 
                             * Set the 'RPH' attribute value.
                             * 
                             * @param RPH
                             */
                            public void setRPH(BigInteger RPH) {
                                this.RPH = RPH;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartureDate" minOccurs="0" maxOccurs="32">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class DepartureDate implements
                            Serializable
                        {
                            private String string;
                            private BigInteger RPH;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'RPH' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getRPH() {
                                return RPH;
                            }

                            /** 
                             * Set the 'RPH' attribute value.
                             * 
                             * @param RPH
                             */
                            public void setRPH(BigInteger RPH) {
                                this.RPH = RPH;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0" maxOccurs="32">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class DestinationLocation implements
                            Serializable
                        {
                            private String locationCode;
                            private BigInteger RPH;

                            /** 
                             * Get the 'LocationCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }

                            /** 
                             * Get the 'RPH' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getRPH() {
                                return RPH;
                            }

                            /** 
                             * Set the 'RPH' attribute value.
                             * 
                             * @param RPH
                             */
                            public void setRPH(BigInteger RPH) {
                                this.RPH = RPH;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightNumber" minOccurs="0" maxOccurs="32">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class FlightNumber implements
                            Serializable
                        {
                            private String string;
                            private BigInteger RPH;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'RPH' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getRPH() {
                                return RPH;
                            }

                            /** 
                             * Set the 'RPH' attribute value.
                             * 
                             * @param RPH
                             */
                            public void setRPH(BigInteger RPH) {
                                this.RPH = RPH;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0" maxOccurs="32">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                         *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OriginLocation implements
                            Serializable
                        {
                            private String locationCode;
                            private BigInteger RPH;

                            /** 
                             * Get the 'LocationCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getLocationCode() {
                                return locationCode;
                            }

                            /** 
                             * Set the 'LocationCode' attribute value.
                             * 
                             * @param locationCode
                             */
                            public void setLocationCode(String locationCode) {
                                this.locationCode = locationCode;
                            }

                            /** 
                             * Get the 'RPH' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getRPH() {
                                return RPH;
                            }

                            /** 
                             * Set the 'RPH' attribute value.
                             * 
                             * @param RPH
                             */
                            public void setRPH(BigInteger RPH) {
                                this.RPH = RPH;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PNR_Segment" minOccurs="0" maxOccurs="32">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class PNRSegment implements Serializable
                        {
                            private String string;
                            private BigInteger RPH;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'RPH' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getRPH() {
                                return RPH;
                            }

                            /** 
                             * Set the 'RPH' attribute value.
                             * 
                             * @param RPH
                             */
                            public void setRPH(BigInteger RPH) {
                                this.RPH = RPH;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResBookDesigCode" minOccurs="0" maxOccurs="32">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class ResBookDesigCode implements
                            Serializable
                        {
                            private String string;
                            private BigInteger RPH;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'RPH' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getRPH() {
                                return RPH;
                            }

                            /** 
                             * Set the 'RPH' attribute value.
                             * 
                             * @param RPH
                             */
                            public void setRPH(BigInteger RPH) {
                                this.RPH = RPH;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StatusCode" minOccurs="0" maxOccurs="32">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class StatusCode implements Serializable
                        {
                            private String string;
                            private BigInteger RPH;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'RPH' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getRPH() {
                                return RPH;
                            }

                            /** 
                             * Set the 'RPH' attribute value.
                             * 
                             * @param RPH
                             */
                            public void setRPH(BigInteger RPH) {
                                this.RPH = RPH;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerType" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PassengerType implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceInformation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Base" minOccurs="0">
                     *         &lt;!-- Reference to inner class Base -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Equiv" minOccurs="0">
                     *         &lt;!-- Reference to inner class Equiv -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="TaxIndicator" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="Total" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PriceInformation implements
                        Serializable
                    {
                        private Base base;
                        private Equiv equiv;
                        private String taxIndicator;
                        private String total;

                        /** 
                         * Get the 'Base' element value.
                         * 
                         * @return value
                         */
                        public Base getBase() {
                            return base;
                        }

                        /** 
                         * Set the 'Base' element value.
                         * 
                         * @param base
                         */
                        public void setBase(Base base) {
                            this.base = base;
                        }

                        /** 
                         * Get the 'Equiv' element value.
                         * 
                         * @return value
                         */
                        public Equiv getEquiv() {
                            return equiv;
                        }

                        /** 
                         * Set the 'Equiv' element value.
                         * 
                         * @param equiv
                         */
                        public void setEquiv(Equiv equiv) {
                            this.equiv = equiv;
                        }

                        /** 
                         * Get the 'TaxIndicator' element value.
                         * 
                         * @return value
                         */
                        public String getTaxIndicator() {
                            return taxIndicator;
                        }

                        /** 
                         * Set the 'TaxIndicator' element value.
                         * 
                         * @param taxIndicator
                         */
                        public void setTaxIndicator(String taxIndicator) {
                            this.taxIndicator = taxIndicator;
                        }

                        /** 
                         * Get the 'Total' element value.
                         * 
                         * @return value
                         */
                        public String getTotal() {
                            return total;
                        }

                        /** 
                         * Set the 'Total' element value.
                         * 
                         * @param total
                         */
                        public void setTotal(String total) {
                            this.total = total;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Base" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Base implements Serializable
                        {
                            private String amount;
                            private String currencyCode;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'CurrencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equiv" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Equiv implements Serializable
                        {
                            private String amount;
                            private String currencyCode;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'CurrencyCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value.
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubCodeInfo" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="SubCodeForAllowance" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class SubCodeForAllowance -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="xs:string" name="SubCodeForChargesOthers" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SubCodeInfo implements Serializable
                    {
                        private List<SubCodeForAllowance> subCodeForAllowanceList = new ArrayList<SubCodeForAllowance>();
                        private String subCodeForChargesOthers;

                        /** 
                         * Get the list of 'SubCodeForAllowance' element items.
                         * 
                         * @return list
                         */
                        public List<SubCodeForAllowance> getSubCodeForAllowanceList() {
                            return subCodeForAllowanceList;
                        }

                        /** 
                         * Set the list of 'SubCodeForAllowance' element items.
                         * 
                         * @param list
                         */
                        public void setSubCodeForAllowanceList(
                                List<SubCodeForAllowance> list) {
                            subCodeForAllowanceList = list;
                        }

                        /** 
                         * Get the 'SubCodeForChargesOthers' element value.
                         * 
                         * @return value
                         */
                        public String getSubCodeForChargesOthers() {
                            return subCodeForChargesOthers;
                        }

                        /** 
                         * Set the 'SubCodeForChargesOthers' element value.
                         * 
                         * @param subCodeForChargesOthers
                         */
                        public void setSubCodeForChargesOthers(
                                String subCodeForChargesOthers) {
                            this.subCodeForChargesOthers = subCodeForChargesOthers;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubCodeForAllowance" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:simpleContent>
                         *       &lt;xs:extension base="xs:string">
                         *         &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                         *       &lt;/xs:extension>
                         *     &lt;/xs:simpleContent>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SubCodeForAllowance implements
                            Serializable
                        {
                            private String string;
                            private BigInteger RPH;

                            /** 
                             * Get the extension value.
                             * 
                             * @return value
                             */
                            public String getString() {
                                return string;
                            }

                            /** 
                             * Set the extension value.
                             * 
                             * @param string
                             */
                            public void setString(String string) {
                                this.string = string;
                            }

                            /** 
                             * Get the 'RPH' attribute value.
                             * 
                             * @return value
                             */
                            public BigInteger getRPH() {
                                return RPH;
                            }

                            /** 
                             * Set the 'RPH' attribute value.
                             * 
                             * @param RPH
                             */
                            public void setRPH(BigInteger RPH) {
                                this.RPH = RPH;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WeightLimit" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" use="optional" name="Units"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class WeightLimit implements Serializable
                    {
                        private String string;
                        private String units;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'Units' attribute value.
                         * 
                         * @return value
                         */
                        public String getUnits() {
                            return units;
                        }

                        /** 
                         * Set the 'Units' attribute value.
                         * 
                         * @param units
                         */
                        public void setUnits(String units) {
                            this.units = units;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareCalculation implements Serializable
                {
                    private String text;

                    /** 
                     * Get the 'Text' element value.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculationBreakdown" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Branch" minOccurs="0">
                 *         &lt;!-- Reference to inner class Branch -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Departure" minOccurs="0">
                 *         &lt;!-- Reference to inner class Departure -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FareBasis" minOccurs="0">
                 *         &lt;!-- Reference to inner class FareBasis -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="FreeBaggageAllowance" minOccurs="0"/>
                 *       &lt;xs:element name="Mileage" minOccurs="0">
                 *         &lt;!-- Reference to inner class Mileage -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="RuleCategoryIndicator" minOccurs="0" maxOccurs="28"/>
                 *       &lt;xs:element name="Surcharges" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Surcharges -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="StopoverCharge" minOccurs="0">
                 *         &lt;!-- Reference to inner class StopoverCharge -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareCalculationBreakdown implements
                    Serializable
                {
                    private Branch branch;
                    private Departure departure;
                    private FareBasis fareBasis;
                    private String freeBaggageAllowance;
                    private Mileage mileage;
                    private List<String> ruleCategoryIndicatorList = new ArrayList<String>();
                    private List<Surcharges> surchargeList = new ArrayList<Surcharges>();
                    private StopoverCharge stopoverCharge;

                    /** 
                     * Get the 'Branch' element value.
                     * 
                     * @return value
                     */
                    public Branch getBranch() {
                        return branch;
                    }

                    /** 
                     * Set the 'Branch' element value.
                     * 
                     * @param branch
                     */
                    public void setBranch(Branch branch) {
                        this.branch = branch;
                    }

                    /** 
                     * Get the 'Departure' element value.
                     * 
                     * @return value
                     */
                    public Departure getDeparture() {
                        return departure;
                    }

                    /** 
                     * Set the 'Departure' element value.
                     * 
                     * @param departure
                     */
                    public void setDeparture(Departure departure) {
                        this.departure = departure;
                    }

                    /** 
                     * Get the 'FareBasis' element value.
                     * 
                     * @return value
                     */
                    public FareBasis getFareBasis() {
                        return fareBasis;
                    }

                    /** 
                     * Set the 'FareBasis' element value.
                     * 
                     * @param fareBasis
                     */
                    public void setFareBasis(FareBasis fareBasis) {
                        this.fareBasis = fareBasis;
                    }

                    /** 
                     * Get the 'FreeBaggageAllowance' element value.
                     * 
                     * @return value
                     */
                    public String getFreeBaggageAllowance() {
                        return freeBaggageAllowance;
                    }

                    /** 
                     * Set the 'FreeBaggageAllowance' element value.
                     * 
                     * @param freeBaggageAllowance
                     */
                    public void setFreeBaggageAllowance(
                            String freeBaggageAllowance) {
                        this.freeBaggageAllowance = freeBaggageAllowance;
                    }

                    /** 
                     * Get the 'Mileage' element value.
                     * 
                     * @return value
                     */
                    public Mileage getMileage() {
                        return mileage;
                    }

                    /** 
                     * Set the 'Mileage' element value.
                     * 
                     * @param mileage
                     */
                    public void setMileage(Mileage mileage) {
                        this.mileage = mileage;
                    }

                    /** 
                     * Get the list of 'RuleCategoryIndicator' element items.
                     * 
                     * @return list
                     */
                    public List<String> getRuleCategoryIndicatorList() {
                        return ruleCategoryIndicatorList;
                    }

                    /** 
                     * Set the list of 'RuleCategoryIndicator' element items.
                     * 
                     * @param list
                     */
                    public void setRuleCategoryIndicatorList(List<String> list) {
                        ruleCategoryIndicatorList = list;
                    }

                    /** 
                     * Get the list of 'Surcharges' element items.
                     * 
                     * @return list
                     */
                    public List<Surcharges> getSurchargeList() {
                        return surchargeList;
                    }

                    /** 
                     * Set the list of 'Surcharges' element items.
                     * 
                     * @param list
                     */
                    public void setSurchargeList(List<Surcharges> list) {
                        surchargeList = list;
                    }

                    /** 
                     * Get the 'StopoverCharge' element value.
                     * 
                     * @return value
                     */
                    public StopoverCharge getStopoverCharge() {
                        return stopoverCharge;
                    }

                    /** 
                     * Set the 'StopoverCharge' element value.
                     * 
                     * @param stopoverCharge
                     */
                    public void setStopoverCharge(StopoverCharge stopoverCharge) {
                        this.stopoverCharge = stopoverCharge;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Branch" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="PCC"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CountryOfShipRegistry"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FirstJointCarrier"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SecondJointCarrier"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="IATAAuthorizedCarrier"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Branch implements Serializable
                    {
                        private String PCC;
                        private String countryOfShipRegistry;
                        private String firstJointCarrier;
                        private String secondJointCarrier;
                        private String IATAAuthorizedCarrier;

                        /** 
                         * Get the 'PCC' attribute value.
                         * 
                         * @return value
                         */
                        public String getPCC() {
                            return PCC;
                        }

                        /** 
                         * Set the 'PCC' attribute value.
                         * 
                         * @param PCC
                         */
                        public void setPCC(String PCC) {
                            this.PCC = PCC;
                        }

                        /** 
                         * Get the 'CountryOfShipRegistry' attribute value.
                         * 
                         * @return value
                         */
                        public String getCountryOfShipRegistry() {
                            return countryOfShipRegistry;
                        }

                        /** 
                         * Set the 'CountryOfShipRegistry' attribute value.
                         * 
                         * @param countryOfShipRegistry
                         */
                        public void setCountryOfShipRegistry(
                                String countryOfShipRegistry) {
                            this.countryOfShipRegistry = countryOfShipRegistry;
                        }

                        /** 
                         * Get the 'FirstJointCarrier' attribute value.
                         * 
                         * @return value
                         */
                        public String getFirstJointCarrier() {
                            return firstJointCarrier;
                        }

                        /** 
                         * Set the 'FirstJointCarrier' attribute value.
                         * 
                         * @param firstJointCarrier
                         */
                        public void setFirstJointCarrier(
                                String firstJointCarrier) {
                            this.firstJointCarrier = firstJointCarrier;
                        }

                        /** 
                         * Get the 'SecondJointCarrier' attribute value.
                         * 
                         * @return value
                         */
                        public String getSecondJointCarrier() {
                            return secondJointCarrier;
                        }

                        /** 
                         * Set the 'SecondJointCarrier' attribute value.
                         * 
                         * @param secondJointCarrier
                         */
                        public void setSecondJointCarrier(
                                String secondJointCarrier) {
                            this.secondJointCarrier = secondJointCarrier;
                        }

                        /** 
                         * Get the 'IATAAuthorizedCarrier' attribute value.
                         * 
                         * @return value
                         */
                        public String getIATAAuthorizedCarrier() {
                            return IATAAuthorizedCarrier;
                        }

                        /** 
                         * Set the 'IATAAuthorizedCarrier' attribute value.
                         * 
                         * @param IATAAuthorizedCarrier
                         */
                        public void setIATAAuthorizedCarrier(
                                String IATAAuthorizedCarrier) {
                            this.IATAAuthorizedCarrier = IATAAuthorizedCarrier;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Departure" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CityCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="AirportCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SideTripIndicator"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="AirlineCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="GenericInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="GlobalInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalCityCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalAirportCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="InfantFareConstructionCity"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Departure implements Serializable
                    {
                        private String cityCode;
                        private String airportCode;
                        private String sideTripIndicator;
                        private String airlineCode;
                        private String genericInd;
                        private String globalInd;
                        private String arrivalCityCode;
                        private String arrivalAirportCode;
                        private String infantFareConstructionCity;

                        /** 
                         * Get the 'CityCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCityCode() {
                            return cityCode;
                        }

                        /** 
                         * Set the 'CityCode' attribute value.
                         * 
                         * @param cityCode
                         */
                        public void setCityCode(String cityCode) {
                            this.cityCode = cityCode;
                        }

                        /** 
                         * Get the 'AirportCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAirportCode() {
                            return airportCode;
                        }

                        /** 
                         * Set the 'AirportCode' attribute value.
                         * 
                         * @param airportCode
                         */
                        public void setAirportCode(String airportCode) {
                            this.airportCode = airportCode;
                        }

                        /** 
                         * Get the 'SideTripIndicator' attribute value.
                         * 
                         * @return value
                         */
                        public String getSideTripIndicator() {
                            return sideTripIndicator;
                        }

                        /** 
                         * Set the 'SideTripIndicator' attribute value.
                         * 
                         * @param sideTripIndicator
                         */
                        public void setSideTripIndicator(
                                String sideTripIndicator) {
                            this.sideTripIndicator = sideTripIndicator;
                        }

                        /** 
                         * Get the 'AirlineCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getAirlineCode() {
                            return airlineCode;
                        }

                        /** 
                         * Set the 'AirlineCode' attribute value.
                         * 
                         * @param airlineCode
                         */
                        public void setAirlineCode(String airlineCode) {
                            this.airlineCode = airlineCode;
                        }

                        /** 
                         * Get the 'GenericInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getGenericInd() {
                            return genericInd;
                        }

                        /** 
                         * Set the 'GenericInd' attribute value.
                         * 
                         * @param genericInd
                         */
                        public void setGenericInd(String genericInd) {
                            this.genericInd = genericInd;
                        }

                        /** 
                         * Get the 'GlobalInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getGlobalInd() {
                            return globalInd;
                        }

                        /** 
                         * Set the 'GlobalInd' attribute value.
                         * 
                         * @param globalInd
                         */
                        public void setGlobalInd(String globalInd) {
                            this.globalInd = globalInd;
                        }

                        /** 
                         * Get the 'ArrivalCityCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getArrivalCityCode() {
                            return arrivalCityCode;
                        }

                        /** 
                         * Set the 'ArrivalCityCode' attribute value.
                         * 
                         * @param arrivalCityCode
                         */
                        public void setArrivalCityCode(String arrivalCityCode) {
                            this.arrivalCityCode = arrivalCityCode;
                        }

                        /** 
                         * Get the 'ArrivalAirportCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getArrivalAirportCode() {
                            return arrivalAirportCode;
                        }

                        /** 
                         * Set the 'ArrivalAirportCode' attribute value.
                         * 
                         * @param arrivalAirportCode
                         */
                        public void setArrivalAirportCode(
                                String arrivalAirportCode) {
                            this.arrivalAirportCode = arrivalAirportCode;
                        }

                        /** 
                         * Get the 'InfantFareConstructionCity' attribute value.
                         * 
                         * @return value
                         */
                        public String getInfantFareConstructionCity() {
                            return infantFareConstructionCity;
                        }

                        /** 
                         * Set the 'InfantFareConstructionCity' attribute value.
                         * 
                         * @param infantFareConstructionCity
                         */
                        public void setInfantFareConstructionCity(
                                String infantFareConstructionCity) {
                            this.infantFareConstructionCity = infantFareConstructionCity;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ContractNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CorporateID"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="InclusiveTour"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FareAmount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FarePassengerType"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FareType"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FilingCarrier"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="GlobalInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="TripTypeInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Market"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SurfaceSegment"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="TicketDesignator"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Cabin"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FareBasis implements Serializable
                    {
                        private String code;
                        private String contractNumber;
                        private String corporateID;
                        private String inclusiveTour;
                        private String fareAmount;
                        private String farePassengerType;
                        private String fareType;
                        private String filingCarrier;
                        private String globalInd;
                        private String tripTypeInd;
                        private String market;
                        private String surfaceSegment;
                        private String ticketDesignator;
                        private String cabin;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'ContractNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getContractNumber() {
                            return contractNumber;
                        }

                        /** 
                         * Set the 'ContractNumber' attribute value.
                         * 
                         * @param contractNumber
                         */
                        public void setContractNumber(String contractNumber) {
                            this.contractNumber = contractNumber;
                        }

                        /** 
                         * Get the 'CorporateID' attribute value.
                         * 
                         * @return value
                         */
                        public String getCorporateID() {
                            return corporateID;
                        }

                        /** 
                         * Set the 'CorporateID' attribute value.
                         * 
                         * @param corporateID
                         */
                        public void setCorporateID(String corporateID) {
                            this.corporateID = corporateID;
                        }

                        /** 
                         * Get the 'InclusiveTour' attribute value.
                         * 
                         * @return value
                         */
                        public String getInclusiveTour() {
                            return inclusiveTour;
                        }

                        /** 
                         * Set the 'InclusiveTour' attribute value.
                         * 
                         * @param inclusiveTour
                         */
                        public void setInclusiveTour(String inclusiveTour) {
                            this.inclusiveTour = inclusiveTour;
                        }

                        /** 
                         * Get the 'FareAmount' attribute value.
                         * 
                         * @return value
                         */
                        public String getFareAmount() {
                            return fareAmount;
                        }

                        /** 
                         * Set the 'FareAmount' attribute value.
                         * 
                         * @param fareAmount
                         */
                        public void setFareAmount(String fareAmount) {
                            this.fareAmount = fareAmount;
                        }

                        /** 
                         * Get the 'FarePassengerType' attribute value.
                         * 
                         * @return value
                         */
                        public String getFarePassengerType() {
                            return farePassengerType;
                        }

                        /** 
                         * Set the 'FarePassengerType' attribute value.
                         * 
                         * @param farePassengerType
                         */
                        public void setFarePassengerType(
                                String farePassengerType) {
                            this.farePassengerType = farePassengerType;
                        }

                        /** 
                         * Get the 'FareType' attribute value.
                         * 
                         * @return value
                         */
                        public String getFareType() {
                            return fareType;
                        }

                        /** 
                         * Set the 'FareType' attribute value.
                         * 
                         * @param fareType
                         */
                        public void setFareType(String fareType) {
                            this.fareType = fareType;
                        }

                        /** 
                         * Get the 'FilingCarrier' attribute value.
                         * 
                         * @return value
                         */
                        public String getFilingCarrier() {
                            return filingCarrier;
                        }

                        /** 
                         * Set the 'FilingCarrier' attribute value.
                         * 
                         * @param filingCarrier
                         */
                        public void setFilingCarrier(String filingCarrier) {
                            this.filingCarrier = filingCarrier;
                        }

                        /** 
                         * Get the 'GlobalInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getGlobalInd() {
                            return globalInd;
                        }

                        /** 
                         * Set the 'GlobalInd' attribute value.
                         * 
                         * @param globalInd
                         */
                        public void setGlobalInd(String globalInd) {
                            this.globalInd = globalInd;
                        }

                        /** 
                         * Get the 'TripTypeInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getTripTypeInd() {
                            return tripTypeInd;
                        }

                        /** 
                         * Set the 'TripTypeInd' attribute value.
                         * 
                         * @param tripTypeInd
                         */
                        public void setTripTypeInd(String tripTypeInd) {
                            this.tripTypeInd = tripTypeInd;
                        }

                        /** 
                         * Get the 'Market' attribute value.
                         * 
                         * @return value
                         */
                        public String getMarket() {
                            return market;
                        }

                        /** 
                         * Set the 'Market' attribute value.
                         * 
                         * @param market
                         */
                        public void setMarket(String market) {
                            this.market = market;
                        }

                        /** 
                         * Get the 'SurfaceSegment' attribute value.
                         * 
                         * @return value
                         */
                        public String getSurfaceSegment() {
                            return surfaceSegment;
                        }

                        /** 
                         * Set the 'SurfaceSegment' attribute value.
                         * 
                         * @param surfaceSegment
                         */
                        public void setSurfaceSegment(String surfaceSegment) {
                            this.surfaceSegment = surfaceSegment;
                        }

                        /** 
                         * Get the 'TicketDesignator' attribute value.
                         * 
                         * @return value
                         */
                        public String getTicketDesignator() {
                            return ticketDesignator;
                        }

                        /** 
                         * Set the 'TicketDesignator' attribute value.
                         * 
                         * @param ticketDesignator
                         */
                        public void setTicketDesignator(String ticketDesignator) {
                            this.ticketDesignator = ticketDesignator;
                        }

                        /** 
                         * Get the 'Cabin' attribute value.
                         * 
                         * @return value
                         */
                        public String getCabin() {
                            return cabin;
                        }

                        /** 
                         * Set the 'Cabin' attribute value.
                         * 
                         * @param cabin
                         */
                        public void setCabin(String cabin) {
                            this.cabin = cabin;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Mileage" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ExtraAllowanceInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MileageExclusionInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MileageReductionPTInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MileageEqualizationInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MileageSymbol"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="MileageSurchargeInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="HIPConstructionCityCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="HIPCityCodes"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Mileage implements Serializable
                    {
                        private String extraAllowanceInd;
                        private String mileageExclusionInd;
                        private String mileageReductionPTInd;
                        private String mileageEqualizationInd;
                        private String mileageSymbol;
                        private String mileageSurchargeInd;
                        private String HIPConstructionCityCode;
                        private String HIPCityCodes;

                        /** 
                         * Get the 'ExtraAllowanceInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getExtraAllowanceInd() {
                            return extraAllowanceInd;
                        }

                        /** 
                         * Set the 'ExtraAllowanceInd' attribute value.
                         * 
                         * @param extraAllowanceInd
                         */
                        public void setExtraAllowanceInd(
                                String extraAllowanceInd) {
                            this.extraAllowanceInd = extraAllowanceInd;
                        }

                        /** 
                         * Get the 'MileageExclusionInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getMileageExclusionInd() {
                            return mileageExclusionInd;
                        }

                        /** 
                         * Set the 'MileageExclusionInd' attribute value.
                         * 
                         * @param mileageExclusionInd
                         */
                        public void setMileageExclusionInd(
                                String mileageExclusionInd) {
                            this.mileageExclusionInd = mileageExclusionInd;
                        }

                        /** 
                         * Get the 'MileageReductionPTInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getMileageReductionPTInd() {
                            return mileageReductionPTInd;
                        }

                        /** 
                         * Set the 'MileageReductionPTInd' attribute value.
                         * 
                         * @param mileageReductionPTInd
                         */
                        public void setMileageReductionPTInd(
                                String mileageReductionPTInd) {
                            this.mileageReductionPTInd = mileageReductionPTInd;
                        }

                        /** 
                         * Get the 'MileageEqualizationInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getMileageEqualizationInd() {
                            return mileageEqualizationInd;
                        }

                        /** 
                         * Set the 'MileageEqualizationInd' attribute value.
                         * 
                         * @param mileageEqualizationInd
                         */
                        public void setMileageEqualizationInd(
                                String mileageEqualizationInd) {
                            this.mileageEqualizationInd = mileageEqualizationInd;
                        }

                        /** 
                         * Get the 'MileageSymbol' attribute value.
                         * 
                         * @return value
                         */
                        public String getMileageSymbol() {
                            return mileageSymbol;
                        }

                        /** 
                         * Set the 'MileageSymbol' attribute value.
                         * 
                         * @param mileageSymbol
                         */
                        public void setMileageSymbol(String mileageSymbol) {
                            this.mileageSymbol = mileageSymbol;
                        }

                        /** 
                         * Get the 'MileageSurchargeInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getMileageSurchargeInd() {
                            return mileageSurchargeInd;
                        }

                        /** 
                         * Set the 'MileageSurchargeInd' attribute value.
                         * 
                         * @param mileageSurchargeInd
                         */
                        public void setMileageSurchargeInd(
                                String mileageSurchargeInd) {
                            this.mileageSurchargeInd = mileageSurchargeInd;
                        }

                        /** 
                         * Get the 'HIPConstructionCityCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getHIPConstructionCityCode() {
                            return HIPConstructionCityCode;
                        }

                        /** 
                         * Set the 'HIPConstructionCityCode' attribute value.
                         * 
                         * @param HIPConstructionCityCode
                         */
                        public void setHIPConstructionCityCode(
                                String HIPConstructionCityCode) {
                            this.HIPConstructionCityCode = HIPConstructionCityCode;
                        }

                        /** 
                         * Get the 'HIPCityCodes' attribute value.
                         * 
                         * @return value
                         */
                        public String getHIPCityCodes() {
                            return HIPCityCodes;
                        }

                        /** 
                         * Set the 'HIPCityCodes' attribute value.
                         * 
                         * @param HIPCityCodes
                         */
                        public void setHIPCityCodes(String HIPCityCodes) {
                            this.HIPCityCodes = HIPCityCodes;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                     *         &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Surcharges implements Serializable
                    {
                        private String string;
                        private String ind;
                        private String type;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public String getInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(String ind) {
                            this.ind = ind;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StopoverCharge" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CitySpecificStopoverCharge"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="TransferChargeInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="TransferCharge"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class StopoverCharge implements Serializable
                    {
                        private String ind;
                        private String citySpecificStopoverCharge;
                        private String transferChargeInd;
                        private String transferCharge;

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public String getInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(String ind) {
                            this.ind = ind;
                        }

                        /** 
                         * Get the 'CitySpecificStopoverCharge' attribute value.
                         * 
                         * @return value
                         */
                        public String getCitySpecificStopoverCharge() {
                            return citySpecificStopoverCharge;
                        }

                        /** 
                         * Set the 'CitySpecificStopoverCharge' attribute value.
                         * 
                         * @param citySpecificStopoverCharge
                         */
                        public void setCitySpecificStopoverCharge(
                                String citySpecificStopoverCharge) {
                            this.citySpecificStopoverCharge = citySpecificStopoverCharge;
                        }

                        /** 
                         * Get the 'TransferChargeInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getTransferChargeInd() {
                            return transferChargeInd;
                        }

                        /** 
                         * Set the 'TransferChargeInd' attribute value.
                         * 
                         * @param transferChargeInd
                         */
                        public void setTransferChargeInd(
                                String transferChargeInd) {
                            this.transferChargeInd = transferChargeInd;
                        }

                        /** 
                         * Get the 'TransferCharge' attribute value.
                         * 
                         * @return value
                         */
                        public String getTransferCharge() {
                            return transferCharge;
                        }

                        /** 
                         * Set the 'TransferCharge' attribute value.
                         * 
                         * @param transferCharge
                         */
                        public void setTransferCharge(String transferCharge) {
                            this.transferCharge = transferCharge;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinTotalFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BaggageInfo" minOccurs="0">
                 *         &lt;!-- Reference to inner class BaggageInfo -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="BaseFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class BaseFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Commission" minOccurs="0">
                 *         &lt;!-- Reference to inner class Commission -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Construction" minOccurs="0">
                 *         &lt;!-- Reference to inner class Construction -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="DiscountTypeMessage" minOccurs="0"/>
                 *       &lt;xs:element name="Endorsements" minOccurs="0">
                 *         &lt;!-- Reference to inner class Endorsements -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EquivFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class EquivFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="PrivateFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class PrivateFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Taxes" minOccurs="0">
                 *         &lt;!-- Reference to inner class Taxes -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="TotalFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class TotalFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Warnings" minOccurs="0">
                 *         &lt;!-- Reference to inner class Warnings -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="SellingFareData" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class SellingFareData -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="NonRefundableInd"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ItinTotalFare implements Serializable
                {
                    private BaggageInfo baggageInfo;
                    private BaseFare baseFare;
                    private Commission commission;
                    private Construction construction;
                    private String discountTypeMessage;
                    private Endorsements endorsements;
                    private EquivFare equivFare;
                    private PrivateFare privateFare;
                    private Taxes taxes;
                    private TotalFare totalFare;
                    private Warnings warnings;
                    private List<SellingFareData> sellingFareDataList = new ArrayList<SellingFareData>();
                    private String nonRefundableInd;

                    /** 
                     * Get the 'BaggageInfo' element value.
                     * 
                     * @return value
                     */
                    public BaggageInfo getBaggageInfo() {
                        return baggageInfo;
                    }

                    /** 
                     * Set the 'BaggageInfo' element value.
                     * 
                     * @param baggageInfo
                     */
                    public void setBaggageInfo(BaggageInfo baggageInfo) {
                        this.baggageInfo = baggageInfo;
                    }

                    /** 
                     * Get the 'BaseFare' element value.
                     * 
                     * @return value
                     */
                    public BaseFare getBaseFare() {
                        return baseFare;
                    }

                    /** 
                     * Set the 'BaseFare' element value.
                     * 
                     * @param baseFare
                     */
                    public void setBaseFare(BaseFare baseFare) {
                        this.baseFare = baseFare;
                    }

                    /** 
                     * Get the 'Commission' element value.
                     * 
                     * @return value
                     */
                    public Commission getCommission() {
                        return commission;
                    }

                    /** 
                     * Set the 'Commission' element value.
                     * 
                     * @param commission
                     */
                    public void setCommission(Commission commission) {
                        this.commission = commission;
                    }

                    /** 
                     * Get the 'Construction' element value.
                     * 
                     * @return value
                     */
                    public Construction getConstruction() {
                        return construction;
                    }

                    /** 
                     * Set the 'Construction' element value.
                     * 
                     * @param construction
                     */
                    public void setConstruction(Construction construction) {
                        this.construction = construction;
                    }

                    /** 
                     * Get the 'DiscountTypeMessage' element value.
                     * 
                     * @return value
                     */
                    public String getDiscountTypeMessage() {
                        return discountTypeMessage;
                    }

                    /** 
                     * Set the 'DiscountTypeMessage' element value.
                     * 
                     * @param discountTypeMessage
                     */
                    public void setDiscountTypeMessage(
                            String discountTypeMessage) {
                        this.discountTypeMessage = discountTypeMessage;
                    }

                    /** 
                     * Get the 'Endorsements' element value.
                     * 
                     * @return value
                     */
                    public Endorsements getEndorsements() {
                        return endorsements;
                    }

                    /** 
                     * Set the 'Endorsements' element value.
                     * 
                     * @param endorsements
                     */
                    public void setEndorsements(Endorsements endorsements) {
                        this.endorsements = endorsements;
                    }

                    /** 
                     * Get the 'EquivFare' element value.
                     * 
                     * @return value
                     */
                    public EquivFare getEquivFare() {
                        return equivFare;
                    }

                    /** 
                     * Set the 'EquivFare' element value.
                     * 
                     * @param equivFare
                     */
                    public void setEquivFare(EquivFare equivFare) {
                        this.equivFare = equivFare;
                    }

                    /** 
                     * Get the 'PrivateFare' element value.
                     * 
                     * @return value
                     */
                    public PrivateFare getPrivateFare() {
                        return privateFare;
                    }

                    /** 
                     * Set the 'PrivateFare' element value.
                     * 
                     * @param privateFare
                     */
                    public void setPrivateFare(PrivateFare privateFare) {
                        this.privateFare = privateFare;
                    }

                    /** 
                     * Get the 'Taxes' element value.
                     * 
                     * @return value
                     */
                    public Taxes getTaxes() {
                        return taxes;
                    }

                    /** 
                     * Set the 'Taxes' element value.
                     * 
                     * @param taxes
                     */
                    public void setTaxes(Taxes taxes) {
                        this.taxes = taxes;
                    }

                    /** 
                     * Get the 'TotalFare' element value.
                     * 
                     * @return value
                     */
                    public TotalFare getTotalFare() {
                        return totalFare;
                    }

                    /** 
                     * Set the 'TotalFare' element value.
                     * 
                     * @param totalFare
                     */
                    public void setTotalFare(TotalFare totalFare) {
                        this.totalFare = totalFare;
                    }

                    /** 
                     * Get the 'Warnings' element value.
                     * 
                     * @return value
                     */
                    public Warnings getWarnings() {
                        return warnings;
                    }

                    /** 
                     * Set the 'Warnings' element value.
                     * 
                     * @param warnings
                     */
                    public void setWarnings(Warnings warnings) {
                        this.warnings = warnings;
                    }

                    /** 
                     * Get the list of 'SellingFareData' element items.
                     * 
                     * @return list
                     */
                    public List<SellingFareData> getSellingFareDataList() {
                        return sellingFareDataList;
                    }

                    /** 
                     * Set the list of 'SellingFareData' element items.
                     * 
                     * @param list
                     */
                    public void setSellingFareDataList(
                            List<SellingFareData> list) {
                        sellingFareDataList = list;
                    }

                    /** 
                     * Get the 'NonRefundableInd' attribute value.
                     * 
                     * @return value
                     */
                    public String getNonRefundableInd() {
                        return nonRefundableInd;
                    }

                    /** 
                     * Set the 'NonRefundableInd' attribute value.
                     * 
                     * @param nonRefundableInd
                     */
                    public void setNonRefundableInd(String nonRefundableInd) {
                        this.nonRefundableInd = nonRefundableInd;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageInfo" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="NonUS_DOT_Disclosure" minOccurs="0">
                     *         &lt;!-- Reference to inner class NonUSDOTDisclosure -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="US_DOT_Disclosure" minOccurs="0">
                     *         &lt;!-- Reference to inner class USDOTDisclosure -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BaggageInfo implements Serializable
                    {
                        private NonUSDOTDisclosure nonUSDOTDisclosure;
                        private USDOTDisclosure USDOTDisclosure1;

                        /** 
                         * Get the 'NonUS_DOT_Disclosure' element value.
                         * 
                         * @return value
                         */
                        public NonUSDOTDisclosure getNonUSDOTDisclosure() {
                            return nonUSDOTDisclosure;
                        }

                        /** 
                         * Set the 'NonUS_DOT_Disclosure' element value.
                         * 
                         * @param nonUSDOTDisclosure
                         */
                        public void setNonUSDOTDisclosure(
                                NonUSDOTDisclosure nonUSDOTDisclosure) {
                            this.nonUSDOTDisclosure = nonUSDOTDisclosure;
                        }

                        /** 
                         * Get the 'US_DOT_Disclosure' element value.
                         * 
                         * @return value
                         */
                        public USDOTDisclosure getUSDOTDisclosure1() {
                            return USDOTDisclosure1;
                        }

                        /** 
                         * Set the 'US_DOT_Disclosure' element value.
                         * 
                         * @param USDOTDisclosure1
                         */
                        public void setUSDOTDisclosure1(
                                USDOTDisclosure USDOTDisclosure1) {
                            this.USDOTDisclosure1 = USDOTDisclosure1;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NonUS_DOT_Disclosure" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class NonUSDOTDisclosure implements
                            Serializable
                        {
                            private List<String> textList = new ArrayList<String>();

                            /** 
                             * Get the list of 'Text' element items.
                             * 
                             * @return list
                             */
                            public List<String> getTextList() {
                                return textList;
                            }

                            /** 
                             * Set the list of 'Text' element items.
                             * 
                             * @param list
                             */
                            public void setTextList(List<String> list) {
                                textList = list;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="US_DOT_Disclosure" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class USDOTDisclosure implements
                            Serializable
                        {
                            private List<String> textList = new ArrayList<String>();

                            /** 
                             * Get the list of 'Text' element items.
                             * 
                             * @return list
                             */
                            public List<String> getTextList() {
                                return textList;
                            }

                            /** 
                             * Set the list of 'Text' element items.
                             * 
                             * @param list
                             */
                            public void setTextList(List<String> list) {
                                textList = list;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BaseFare implements Serializable
                    {
                        private String amount;
                        private String currencyCode;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CapAmountInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Percent"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Commission implements Serializable
                    {
                        private String amount;
                        private String capAmountInd;
                        private String percent;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CapAmountInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getCapAmountInd() {
                            return capAmountInd;
                        }

                        /** 
                         * Set the 'CapAmountInd' attribute value.
                         * 
                         * @param capAmountInd
                         */
                        public void setCapAmountInd(String capAmountInd) {
                            this.capAmountInd = capAmountInd;
                        }

                        /** 
                         * Get the 'Percent' attribute value.
                         * 
                         * @return value
                         */
                        public String getPercent() {
                            return percent;
                        }

                        /** 
                         * Set the 'Percent' attribute value.
                         * 
                         * @param percent
                         */
                        public void setPercent(String percent) {
                            this.percent = percent;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Construction" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="RateOfExchange"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Construction implements Serializable
                    {
                        private String amount;
                        private String currencyCode;
                        private String rateOfExchange;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'RateOfExchange' attribute value.
                         * 
                         * @return value
                         */
                        public String getRateOfExchange() {
                            return rateOfExchange;
                        }

                        /** 
                         * Set the 'RateOfExchange' attribute value.
                         * 
                         * @param rateOfExchange
                         */
                        public void setRateOfExchange(String rateOfExchange) {
                            this.rateOfExchange = rateOfExchange;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsements" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="20"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Endorsements implements Serializable
                    {
                        private List<String> textList = new ArrayList<String>();

                        /** 
                         * Get the list of 'Text' element items.
                         * 
                         * @return list
                         */
                        public List<String> getTextList() {
                            return textList;
                        }

                        /** 
                         * Set the list of 'Text' element items.
                         * 
                         * @param list
                         */
                        public void setTextList(List<String> list) {
                            textList = list;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EquivFare implements Serializable
                    {
                        private String amount;
                        private String currencyCode;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrivateFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PrivateFare implements Serializable
                    {
                        private String ind;

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public String getInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(String ind) {
                            this.ind = ind;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Tax -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="TotalAmount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Taxes implements Serializable
                    {
                        private List<Tax> taxList = new ArrayList<Tax>();
                        private String totalAmount;

                        /** 
                         * Get the list of 'Tax' element items.
                         * 
                         * @return list
                         */
                        public List<Tax> getTaxList() {
                            return taxList;
                        }

                        /** 
                         * Set the list of 'Tax' element items.
                         * 
                         * @param list
                         */
                        public void setTaxList(List<Tax> list) {
                            taxList = list;
                        }

                        /** 
                         * Get the 'TotalAmount' attribute value.
                         * 
                         * @return value
                         */
                        public String getTotalAmount() {
                            return totalAmount;
                        }

                        /** 
                         * Set the 'TotalAmount' attribute value.
                         * 
                         * @param totalAmount
                         */
                        public void setTotalAmount(String totalAmount) {
                            this.totalAmount = totalAmount;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="TaxCode"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="TaxName"/>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="TicketingTaxCode"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Tax implements Serializable
                        {
                            private String amount;
                            private String taxCode;
                            private String taxName;
                            private String ticketingTaxCode;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }

                            /** 
                             * Get the 'TaxCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getTaxCode() {
                                return taxCode;
                            }

                            /** 
                             * Set the 'TaxCode' attribute value.
                             * 
                             * @param taxCode
                             */
                            public void setTaxCode(String taxCode) {
                                this.taxCode = taxCode;
                            }

                            /** 
                             * Get the 'TaxName' attribute value.
                             * 
                             * @return value
                             */
                            public String getTaxName() {
                                return taxName;
                            }

                            /** 
                             * Set the 'TaxName' attribute value.
                             * 
                             * @param taxName
                             */
                            public void setTaxName(String taxName) {
                                this.taxName = taxName;
                            }

                            /** 
                             * Get the 'TicketingTaxCode' attribute value.
                             * 
                             * @return value
                             */
                            public String getTicketingTaxCode() {
                                return ticketingTaxCode;
                            }

                            /** 
                             * Set the 'TicketingTaxCode' attribute value.
                             * 
                             * @param ticketingTaxCode
                             */
                            public void setTicketingTaxCode(
                                    String ticketingTaxCode) {
                                this.ticketingTaxCode = ticketingTaxCode;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class TotalFare implements Serializable
                    {
                        private String amount;
                        private String currencyCode;

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'CurrencyCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warnings" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="Warning" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Warning -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Warnings implements Serializable
                    {
                        private List<Warning> warningList = new ArrayList<Warning>();

                        /** 
                         * Get the list of 'Warning' element items.
                         * 
                         * @return list
                         */
                        public List<Warning> getWarningList() {
                            return warningList;
                        }

                        /** 
                         * Set the list of 'Warning' element items.
                         * 
                         * @param list
                         */
                        public void setWarningList(List<Warning> list) {
                            warningList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warning" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="ShortText"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Warning implements Serializable
                        {
                            private String shortText;

                            /** 
                             * Get the 'ShortText' attribute value.
                             * 
                             * @return value
                             */
                            public String getShortText() {
                                return shortText;
                            }

                            /** 
                             * Set the 'ShortText' attribute value.
                             * 
                             * @param shortText
                             */
                            public void setShortText(String shortText) {
                                this.shortText = shortText;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFareData" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="BaseFare" minOccurs="0">
                     *         &lt;!-- Reference to inner class BaseFare -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="ConstructedTotal" minOccurs="0">
                     *         &lt;!-- Reference to inner class ConstructedTotal -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Equivalent" minOccurs="0">
                     *         &lt;!-- Reference to inner class Equivalent -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="TotalTaxes" minOccurs="0">
                     *         &lt;!-- Reference to inner class TotalTaxes -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="TotalPerPassenger" minOccurs="0">
                     *         &lt;!-- Reference to inner class TotalPerPassenger -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="FareCalculation" minOccurs="0">
                     *         &lt;!-- Reference to inner class FareCalculation -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SellingFareTaxData" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class SellingFareTaxData -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="SellingFareTaxBreakdown" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class SellingFareTaxBreakdown -->
                     *       &lt;/xs:element>
                     *       &lt;xs:element name="Summary" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class Summary -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LayerTypeName"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class SellingFareData implements Serializable
                    {
                        private BaseFare baseFare;
                        private ConstructedTotal constructedTotal;
                        private Equivalent equivalent;
                        private TotalTaxes totalTaxes;
                        private TotalPerPassenger totalPerPassenger;
                        private FareCalculation fareCalculation;
                        private List<SellingFareTaxData> sellingFareTaxDataList = new ArrayList<SellingFareTaxData>();
                        private List<SellingFareTaxBreakdown> sellingFareTaxBreakdownList = new ArrayList<SellingFareTaxBreakdown>();
                        private List<Summary> summaryList = new ArrayList<Summary>();
                        private String layerTypeName;

                        /** 
                         * Get the 'BaseFare' element value.
                         * 
                         * @return value
                         */
                        public BaseFare getBaseFare() {
                            return baseFare;
                        }

                        /** 
                         * Set the 'BaseFare' element value.
                         * 
                         * @param baseFare
                         */
                        public void setBaseFare(BaseFare baseFare) {
                            this.baseFare = baseFare;
                        }

                        /** 
                         * Get the 'ConstructedTotal' element value.
                         * 
                         * @return value
                         */
                        public ConstructedTotal getConstructedTotal() {
                            return constructedTotal;
                        }

                        /** 
                         * Set the 'ConstructedTotal' element value.
                         * 
                         * @param constructedTotal
                         */
                        public void setConstructedTotal(
                                ConstructedTotal constructedTotal) {
                            this.constructedTotal = constructedTotal;
                        }

                        /** 
                         * Get the 'Equivalent' element value.
                         * 
                         * @return value
                         */
                        public Equivalent getEquivalent() {
                            return equivalent;
                        }

                        /** 
                         * Set the 'Equivalent' element value.
                         * 
                         * @param equivalent
                         */
                        public void setEquivalent(Equivalent equivalent) {
                            this.equivalent = equivalent;
                        }

                        /** 
                         * Get the 'TotalTaxes' element value.
                         * 
                         * @return value
                         */
                        public TotalTaxes getTotalTaxes() {
                            return totalTaxes;
                        }

                        /** 
                         * Set the 'TotalTaxes' element value.
                         * 
                         * @param totalTaxes
                         */
                        public void setTotalTaxes(TotalTaxes totalTaxes) {
                            this.totalTaxes = totalTaxes;
                        }

                        /** 
                         * Get the 'TotalPerPassenger' element value.
                         * 
                         * @return value
                         */
                        public TotalPerPassenger getTotalPerPassenger() {
                            return totalPerPassenger;
                        }

                        /** 
                         * Set the 'TotalPerPassenger' element value.
                         * 
                         * @param totalPerPassenger
                         */
                        public void setTotalPerPassenger(
                                TotalPerPassenger totalPerPassenger) {
                            this.totalPerPassenger = totalPerPassenger;
                        }

                        /** 
                         * Get the 'FareCalculation' element value.
                         * 
                         * @return value
                         */
                        public FareCalculation getFareCalculation() {
                            return fareCalculation;
                        }

                        /** 
                         * Set the 'FareCalculation' element value.
                         * 
                         * @param fareCalculation
                         */
                        public void setFareCalculation(
                                FareCalculation fareCalculation) {
                            this.fareCalculation = fareCalculation;
                        }

                        /** 
                         * Get the list of 'SellingFareTaxData' element items.
                         * 
                         * @return list
                         */
                        public List<SellingFareTaxData> getSellingFareTaxDataList() {
                            return sellingFareTaxDataList;
                        }

                        /** 
                         * Set the list of 'SellingFareTaxData' element items.
                         * 
                         * @param list
                         */
                        public void setSellingFareTaxDataList(
                                List<SellingFareTaxData> list) {
                            sellingFareTaxDataList = list;
                        }

                        /** 
                         * Get the list of 'SellingFareTaxBreakdown' element items.
                         * 
                         * @return list
                         */
                        public List<SellingFareTaxBreakdown> getSellingFareTaxBreakdownList() {
                            return sellingFareTaxBreakdownList;
                        }

                        /** 
                         * Set the list of 'SellingFareTaxBreakdown' element items.
                         * 
                         * @param list
                         */
                        public void setSellingFareTaxBreakdownList(
                                List<SellingFareTaxBreakdown> list) {
                            sellingFareTaxBreakdownList = list;
                        }

                        /** 
                         * Get the list of 'Summary' element items.
                         * 
                         * @return list
                         */
                        public List<Summary> getSummaryList() {
                            return summaryList;
                        }

                        /** 
                         * Set the list of 'Summary' element items.
                         * 
                         * @param list
                         */
                        public void setSummaryList(List<Summary> list) {
                            summaryList = list;
                        }

                        /** 
                         * Get the 'LayerTypeName' attribute value.
                         * 
                         * @return value
                         */
                        public String getLayerTypeName() {
                            return layerTypeName;
                        }

                        /** 
                         * Set the 'LayerTypeName' attribute value.
                         * 
                         * @param layerTypeName
                         */
                        public void setLayerTypeName(String layerTypeName) {
                            this.layerTypeName = layerTypeName;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class BaseFare implements Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConstructedTotal" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class ConstructedTotal implements
                            Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equivalent" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Equivalent implements Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTaxes" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class TotalTaxes implements Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalPerPassenger" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class TotalPerPassenger implements
                            Serializable
                        {
                            private String amount;

                            /** 
                             * Get the 'Amount' attribute value.
                             * 
                             * @return value
                             */
                            public String getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value.
                             * 
                             * @param amount
                             */
                            public void setAmount(String amount) {
                                this.amount = amount;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculation" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class FareCalculation implements
                            Serializable
                        {
                            private String text;

                            /** 
                             * Get the 'Text' element value.
                             * 
                             * @return value
                             */
                            public String getText() {
                                return text;
                            }

                            /** 
                             * Set the 'Text' element value.
                             * 
                             * @param text
                             */
                            public void setText(String text) {
                                this.text = text;
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFareTaxData" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Tax" minOccurs="0">
                         *         &lt;!-- Reference to inner class Tax -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SellingFareTaxData implements
                            Serializable
                        {
                            private Tax tax;

                            /** 
                             * Get the 'Tax' element value.
                             * 
                             * @return value
                             */
                            public Tax getTax() {
                                return tax;
                            }

                            /** 
                             * Set the 'Tax' element value.
                             * 
                             * @param tax
                             */
                            public void setTax(Tax tax) {
                                this.tax = tax;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="AmountPublished"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="PublishedCurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="StationCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CountryCode"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="GoodAndServicesInd"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Tax implements Serializable
                            {
                                private String code;
                                private String description;
                                private String amount;
                                private String currencyCode;
                                private String amountPublished;
                                private String publishedCurrencyCode;
                                private String stationCode;
                                private String countryCode;
                                private Boolean goodAndServicesInd;

                                /** 
                                 * Get the 'Code' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Description' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getDescription() {
                                    return description;
                                }

                                /** 
                                 * Set the 'Description' attribute value.
                                 * 
                                 * @param description
                                 */
                                public void setDescription(String description) {
                                    this.description = description;
                                }

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'AmountPublished' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmountPublished() {
                                    return amountPublished;
                                }

                                /** 
                                 * Set the 'AmountPublished' attribute value.
                                 * 
                                 * @param amountPublished
                                 */
                                public void setAmountPublished(
                                        String amountPublished) {
                                    this.amountPublished = amountPublished;
                                }

                                /** 
                                 * Get the 'PublishedCurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getPublishedCurrencyCode() {
                                    return publishedCurrencyCode;
                                }

                                /** 
                                 * Set the 'PublishedCurrencyCode' attribute value.
                                 * 
                                 * @param publishedCurrencyCode
                                 */
                                public void setPublishedCurrencyCode(
                                        String publishedCurrencyCode) {
                                    this.publishedCurrencyCode = publishedCurrencyCode;
                                }

                                /** 
                                 * Get the 'StationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getStationCode() {
                                    return stationCode;
                                }

                                /** 
                                 * Set the 'StationCode' attribute value.
                                 * 
                                 * @param stationCode
                                 */
                                public void setStationCode(String stationCode) {
                                    this.stationCode = stationCode;
                                }

                                /** 
                                 * Get the 'CountryCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCountryCode() {
                                    return countryCode;
                                }

                                /** 
                                 * Set the 'CountryCode' attribute value.
                                 * 
                                 * @param countryCode
                                 */
                                public void setCountryCode(String countryCode) {
                                    this.countryCode = countryCode;
                                }

                                /** 
                                 * Get the 'GoodAndServicesInd' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getGoodAndServicesInd() {
                                    return goodAndServicesInd;
                                }

                                /** 
                                 * Set the 'GoodAndServicesInd' attribute value.
                                 * 
                                 * @param goodAndServicesInd
                                 */
                                public void setGoodAndServicesInd(
                                        Boolean goodAndServicesInd) {
                                    this.goodAndServicesInd = goodAndServicesInd;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFareTaxBreakdown" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="TaxBreakDown" minOccurs="0">
                         *         &lt;!-- Reference to inner class TaxBreakDown -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class SellingFareTaxBreakdown implements
                            Serializable
                        {
                            private TaxBreakDown taxBreakDown;

                            /** 
                             * Get the 'TaxBreakDown' element value.
                             * 
                             * @return value
                             */
                            public TaxBreakDown getTaxBreakDown() {
                                return taxBreakDown;
                            }

                            /** 
                             * Set the 'TaxBreakDown' element value.
                             * 
                             * @param taxBreakDown
                             */
                            public void setTaxBreakDown(
                                    TaxBreakDown taxBreakDown) {
                                this.taxBreakDown = taxBreakDown;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxBreakDown" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="AmountPublished"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="PublishedCurrencyCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="StationCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="CountryCode"/>
                             *     &lt;xs:attribute type="xs:boolean" use="optional" name="GoodAndServicesInd"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="AirlineCode"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="TaxType"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class TaxBreakDown implements
                                Serializable
                            {
                                private String code;
                                private String description;
                                private String amount;
                                private String currencyCode;
                                private String amountPublished;
                                private String publishedCurrencyCode;
                                private String stationCode;
                                private String countryCode;
                                private Boolean goodAndServicesInd;
                                private String airlineCode;
                                private String taxType;

                                /** 
                                 * Get the 'Code' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Description' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getDescription() {
                                    return description;
                                }

                                /** 
                                 * Set the 'Description' attribute value.
                                 * 
                                 * @param description
                                 */
                                public void setDescription(String description) {
                                    this.description = description;
                                }

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }

                                /** 
                                 * Get the 'CurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCurrencyCode() {
                                    return currencyCode;
                                }

                                /** 
                                 * Set the 'CurrencyCode' attribute value.
                                 * 
                                 * @param currencyCode
                                 */
                                public void setCurrencyCode(String currencyCode) {
                                    this.currencyCode = currencyCode;
                                }

                                /** 
                                 * Get the 'AmountPublished' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmountPublished() {
                                    return amountPublished;
                                }

                                /** 
                                 * Set the 'AmountPublished' attribute value.
                                 * 
                                 * @param amountPublished
                                 */
                                public void setAmountPublished(
                                        String amountPublished) {
                                    this.amountPublished = amountPublished;
                                }

                                /** 
                                 * Get the 'PublishedCurrencyCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getPublishedCurrencyCode() {
                                    return publishedCurrencyCode;
                                }

                                /** 
                                 * Set the 'PublishedCurrencyCode' attribute value.
                                 * 
                                 * @param publishedCurrencyCode
                                 */
                                public void setPublishedCurrencyCode(
                                        String publishedCurrencyCode) {
                                    this.publishedCurrencyCode = publishedCurrencyCode;
                                }

                                /** 
                                 * Get the 'StationCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getStationCode() {
                                    return stationCode;
                                }

                                /** 
                                 * Set the 'StationCode' attribute value.
                                 * 
                                 * @param stationCode
                                 */
                                public void setStationCode(String stationCode) {
                                    this.stationCode = stationCode;
                                }

                                /** 
                                 * Get the 'CountryCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCountryCode() {
                                    return countryCode;
                                }

                                /** 
                                 * Set the 'CountryCode' attribute value.
                                 * 
                                 * @param countryCode
                                 */
                                public void setCountryCode(String countryCode) {
                                    this.countryCode = countryCode;
                                }

                                /** 
                                 * Get the 'GoodAndServicesInd' attribute value.
                                 * 
                                 * @return value
                                 */
                                public Boolean getGoodAndServicesInd() {
                                    return goodAndServicesInd;
                                }

                                /** 
                                 * Set the 'GoodAndServicesInd' attribute value.
                                 * 
                                 * @param goodAndServicesInd
                                 */
                                public void setGoodAndServicesInd(
                                        Boolean goodAndServicesInd) {
                                    this.goodAndServicesInd = goodAndServicesInd;
                                }

                                /** 
                                 * Get the 'AirlineCode' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAirlineCode() {
                                    return airlineCode;
                                }

                                /** 
                                 * Set the 'AirlineCode' attribute value.
                                 * 
                                 * @param airlineCode
                                 */
                                public void setAirlineCode(String airlineCode) {
                                    this.airlineCode = airlineCode;
                                }

                                /** 
                                 * Get the 'TaxType' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getTaxType() {
                                    return taxType;
                                }

                                /** 
                                 * Set the 'TaxType' attribute value.
                                 * 
                                 * @param taxType
                                 */
                                public void setTaxType(String taxType) {
                                    this.taxType = taxType;
                                }
                            }
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Summary" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:sequence>
                         *       &lt;xs:element name="Markup" minOccurs="0">
                         *         &lt;!-- Reference to inner class Markup -->
                         *       &lt;/xs:element>
                         *     &lt;/xs:sequence>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class Summary implements Serializable
                        {
                            private Markup markup;

                            /** 
                             * Get the 'Markup' element value.
                             * 
                             * @return value
                             */
                            public Markup getMarkup() {
                                return markup;
                            }

                            /** 
                             * Set the 'Markup' element value.
                             * 
                             * @param markup
                             */
                            public void setMarkup(Markup markup) {
                                this.markup = markup;
                            }
                            /** 
                             * Schema fragment(s) for this class:
                             * <pre>
                             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Markup" minOccurs="0">
                             *   &lt;xs:complexType>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
                             *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                             *   &lt;/xs:complexType>
                             * &lt;/xs:element>
                             * </pre>
                             */
                            public static class Markup implements Serializable
                            {
                                private String code;
                                private String description;
                                private String amount;

                                /** 
                                 * Get the 'Code' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getCode() {
                                    return code;
                                }

                                /** 
                                 * Set the 'Code' attribute value.
                                 * 
                                 * @param code
                                 */
                                public void setCode(String code) {
                                    this.code = code;
                                }

                                /** 
                                 * Get the 'Description' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getDescription() {
                                    return description;
                                }

                                /** 
                                 * Set the 'Description' attribute value.
                                 * 
                                 * @param description
                                 */
                                public void setDescription(String description) {
                                    this.description = description;
                                }

                                /** 
                                 * Get the 'Amount' attribute value.
                                 * 
                                 * @return value
                                 */
                                public String getAmount() {
                                    return amount;
                                }

                                /** 
                                 * Set the 'Amount' attribute value.
                                 * 
                                 * @param amount
                                 */
                                public void setAmount(String amount) {
                                    this.amount = amount;
                                }
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeQuantity" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Quantity"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PassengerTypeQuantity implements
                    Serializable
                {
                    private String code;
                    private String quantity;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'Quantity' attribute value.
                     * 
                     * @return value
                     */
                    public String getQuantity() {
                        return quantity;
                    }

                    /** 
                     * Set the 'Quantity' attribute value.
                     * 
                     * @param quantity
                     */
                    public void setQuantity(String quantity) {
                        this.quantity = quantity;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PTC_FareBreakdown" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BrandedFareInformation" minOccurs="0">
                 *         &lt;!-- Reference to inner class BrandedFareInformation -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="Cabin" minOccurs="0"/>
                 *       &lt;xs:element name="FareBasis" minOccurs="0">
                 *         &lt;!-- Reference to inner class FareBasis -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="FreeBaggageAllowance" minOccurs="0"/>
                 *       &lt;xs:element name="Surcharges" minOccurs="0" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class Surcharges -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PTCFareBreakdown implements Serializable
                {
                    private BrandedFareInformation brandedFareInformation;
                    private String cabin;
                    private FareBasis fareBasis;
                    private String freeBaggageAllowance;
                    private List<Surcharges> surchargeList = new ArrayList<Surcharges>();

                    /** 
                     * Get the 'BrandedFareInformation' element value.
                     * 
                     * @return value
                     */
                    public BrandedFareInformation getBrandedFareInformation() {
                        return brandedFareInformation;
                    }

                    /** 
                     * Set the 'BrandedFareInformation' element value.
                     * 
                     * @param brandedFareInformation
                     */
                    public void setBrandedFareInformation(
                            BrandedFareInformation brandedFareInformation) {
                        this.brandedFareInformation = brandedFareInformation;
                    }

                    /** 
                     * Get the 'Cabin' element value.
                     * 
                     * @return value
                     */
                    public String getCabin() {
                        return cabin;
                    }

                    /** 
                     * Set the 'Cabin' element value.
                     * 
                     * @param cabin
                     */
                    public void setCabin(String cabin) {
                        this.cabin = cabin;
                    }

                    /** 
                     * Get the 'FareBasis' element value.
                     * 
                     * @return value
                     */
                    public FareBasis getFareBasis() {
                        return fareBasis;
                    }

                    /** 
                     * Set the 'FareBasis' element value.
                     * 
                     * @param fareBasis
                     */
                    public void setFareBasis(FareBasis fareBasis) {
                        this.fareBasis = fareBasis;
                    }

                    /** 
                     * Get the 'FreeBaggageAllowance' element value.
                     * 
                     * @return value
                     */
                    public String getFreeBaggageAllowance() {
                        return freeBaggageAllowance;
                    }

                    /** 
                     * Set the 'FreeBaggageAllowance' element value.
                     * 
                     * @param freeBaggageAllowance
                     */
                    public void setFreeBaggageAllowance(
                            String freeBaggageAllowance) {
                        this.freeBaggageAllowance = freeBaggageAllowance;
                    }

                    /** 
                     * Get the list of 'Surcharges' element items.
                     * 
                     * @return list
                     */
                    public List<Surcharges> getSurchargeList() {
                        return surchargeList;
                    }

                    /** 
                     * Set the list of 'Surcharges' element items.
                     * 
                     * @param list
                     */
                    public void setSurchargeList(List<Surcharges> list) {
                        surchargeList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandedFareInformation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="BrandCode" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="BrandName" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="ProgramCode" minOccurs="0"/>
                     *       &lt;xs:element type="xs:string" name="ProgramName" minOccurs="0"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BrandedFareInformation implements
                        Serializable
                    {
                        private String brandCode;
                        private String brandName;
                        private String programCode;
                        private String programName;

                        /** 
                         * Get the 'BrandCode' element value.
                         * 
                         * @return value
                         */
                        public String getBrandCode() {
                            return brandCode;
                        }

                        /** 
                         * Set the 'BrandCode' element value.
                         * 
                         * @param brandCode
                         */
                        public void setBrandCode(String brandCode) {
                            this.brandCode = brandCode;
                        }

                        /** 
                         * Get the 'BrandName' element value.
                         * 
                         * @return value
                         */
                        public String getBrandName() {
                            return brandName;
                        }

                        /** 
                         * Set the 'BrandName' element value.
                         * 
                         * @param brandName
                         */
                        public void setBrandName(String brandName) {
                            this.brandName = brandName;
                        }

                        /** 
                         * Get the 'ProgramCode' element value.
                         * 
                         * @return value
                         */
                        public String getProgramCode() {
                            return programCode;
                        }

                        /** 
                         * Set the 'ProgramCode' element value.
                         * 
                         * @param programCode
                         */
                        public void setProgramCode(String programCode) {
                            this.programCode = programCode;
                        }

                        /** 
                         * Get the 'ProgramName' element value.
                         * 
                         * @return value
                         */
                        public String getProgramName() {
                            return programName;
                        }

                        /** 
                         * Set the 'ProgramName' element value.
                         * 
                         * @param programName
                         */
                        public void setProgramName(String programName) {
                            this.programName = programName;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ContractNumber"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="CorporateID"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FareAmount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FarePassengerType"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FareType"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FilingCarrier"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="GlobalInd"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Market"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SurfaceSegment"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="TicketDesignator"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FareBasis implements Serializable
                    {
                        private String code;
                        private String contractNumber;
                        private String corporateID;
                        private String fareAmount;
                        private String farePassengerType;
                        private String fareType;
                        private String filingCarrier;
                        private String globalInd;
                        private String market;
                        private String surfaceSegment;
                        private String ticketDesignator;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }

                        /** 
                         * Get the 'ContractNumber' attribute value.
                         * 
                         * @return value
                         */
                        public String getContractNumber() {
                            return contractNumber;
                        }

                        /** 
                         * Set the 'ContractNumber' attribute value.
                         * 
                         * @param contractNumber
                         */
                        public void setContractNumber(String contractNumber) {
                            this.contractNumber = contractNumber;
                        }

                        /** 
                         * Get the 'CorporateID' attribute value.
                         * 
                         * @return value
                         */
                        public String getCorporateID() {
                            return corporateID;
                        }

                        /** 
                         * Set the 'CorporateID' attribute value.
                         * 
                         * @param corporateID
                         */
                        public void setCorporateID(String corporateID) {
                            this.corporateID = corporateID;
                        }

                        /** 
                         * Get the 'FareAmount' attribute value.
                         * 
                         * @return value
                         */
                        public String getFareAmount() {
                            return fareAmount;
                        }

                        /** 
                         * Set the 'FareAmount' attribute value.
                         * 
                         * @param fareAmount
                         */
                        public void setFareAmount(String fareAmount) {
                            this.fareAmount = fareAmount;
                        }

                        /** 
                         * Get the 'FarePassengerType' attribute value.
                         * 
                         * @return value
                         */
                        public String getFarePassengerType() {
                            return farePassengerType;
                        }

                        /** 
                         * Set the 'FarePassengerType' attribute value.
                         * 
                         * @param farePassengerType
                         */
                        public void setFarePassengerType(
                                String farePassengerType) {
                            this.farePassengerType = farePassengerType;
                        }

                        /** 
                         * Get the 'FareType' attribute value.
                         * 
                         * @return value
                         */
                        public String getFareType() {
                            return fareType;
                        }

                        /** 
                         * Set the 'FareType' attribute value.
                         * 
                         * @param fareType
                         */
                        public void setFareType(String fareType) {
                            this.fareType = fareType;
                        }

                        /** 
                         * Get the 'FilingCarrier' attribute value.
                         * 
                         * @return value
                         */
                        public String getFilingCarrier() {
                            return filingCarrier;
                        }

                        /** 
                         * Set the 'FilingCarrier' attribute value.
                         * 
                         * @param filingCarrier
                         */
                        public void setFilingCarrier(String filingCarrier) {
                            this.filingCarrier = filingCarrier;
                        }

                        /** 
                         * Get the 'GlobalInd' attribute value.
                         * 
                         * @return value
                         */
                        public String getGlobalInd() {
                            return globalInd;
                        }

                        /** 
                         * Set the 'GlobalInd' attribute value.
                         * 
                         * @param globalInd
                         */
                        public void setGlobalInd(String globalInd) {
                            this.globalInd = globalInd;
                        }

                        /** 
                         * Get the 'Market' attribute value.
                         * 
                         * @return value
                         */
                        public String getMarket() {
                            return market;
                        }

                        /** 
                         * Set the 'Market' attribute value.
                         * 
                         * @param market
                         */
                        public void setMarket(String market) {
                            this.market = market;
                        }

                        /** 
                         * Get the 'SurfaceSegment' attribute value.
                         * 
                         * @return value
                         */
                        public String getSurfaceSegment() {
                            return surfaceSegment;
                        }

                        /** 
                         * Set the 'SurfaceSegment' attribute value.
                         * 
                         * @param surfaceSegment
                         */
                        public void setSurfaceSegment(String surfaceSegment) {
                            this.surfaceSegment = surfaceSegment;
                        }

                        /** 
                         * Get the 'TicketDesignator' attribute value.
                         * 
                         * @return value
                         */
                        public String getTicketDesignator() {
                            return ticketDesignator;
                        }

                        /** 
                         * Set the 'TicketDesignator' attribute value.
                         * 
                         * @param ticketDesignator
                         */
                        public void setTicketDesignator(String ticketDesignator) {
                            this.ticketDesignator = ticketDesignator;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                     *         &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Surcharges implements Serializable
                    {
                        private String string;
                        private String ind;
                        private String type;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'Ind' attribute value.
                         * 
                         * @return value
                         */
                        public String getInd() {
                            return ind;
                        }

                        /** 
                         * Set the 'Ind' attribute value.
                         * 
                         * @param ind
                         */
                        public void setInd(String ind) {
                            this.ind = ind;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailerRules" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="AdjustmentSellingLevel" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="PricingTransaction" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class RetailerRules implements Serializable
                {
                    private String adjustmentSellingLevel;
                    private String pricingTransaction;

                    /** 
                     * Get the 'AdjustmentSellingLevel' element value.
                     * 
                     * @return value
                     */
                    public String getAdjustmentSellingLevel() {
                        return adjustmentSellingLevel;
                    }

                    /** 
                     * Set the 'AdjustmentSellingLevel' element value.
                     * 
                     * @param adjustmentSellingLevel
                     */
                    public void setAdjustmentSellingLevel(
                            String adjustmentSellingLevel) {
                        this.adjustmentSellingLevel = adjustmentSellingLevel;
                    }

                    /** 
                     * Get the 'PricingTransaction' element value.
                     * 
                     * @return value
                     */
                    public String getPricingTransaction() {
                        return pricingTransaction;
                    }

                    /** 
                     * Set the 'PricingTransaction' element value.
                     * 
                     * @param pricingTransaction
                     */
                    public void setPricingTransaction(String pricingTransaction) {
                        this.pricingTransaction = pricingTransaction;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecificPenalty" minOccurs="0" maxOccurs="4">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="PenaltyInformation" minOccurs="0">
                 *         &lt;!-- Reference to inner class PenaltyInformation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SpecificPenalty implements Serializable
                {
                    private PenaltyInformation penaltyInformation;

                    /** 
                     * Get the 'PenaltyInformation' element value.
                     * 
                     * @return value
                     */
                    public PenaltyInformation getPenaltyInformation() {
                        return penaltyInformation;
                    }

                    /** 
                     * Set the 'PenaltyInformation' element value.
                     * 
                     * @param penaltyInformation
                     */
                    public void setPenaltyInformation(
                            PenaltyInformation penaltyInformation) {
                        this.penaltyInformation = penaltyInformation;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyInformation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0" maxOccurs="unbounded"/>
                     *       &lt;xs:element type="xs:string" name="FareComponent" minOccurs="0" maxOccurs="unbounded"/>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="Cat16"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Currency"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" name="NotApplicable"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PenaltyInformation implements
                        Serializable
                    {
                        private List<String> fareBasisCodeList = new ArrayList<String>();
                        private List<String> fareComponentList = new ArrayList<String>();
                        private String amount;
                        private Boolean cat16;
                        private String currency;
                        private Boolean notApplicable;
                        private String type;

                        /** 
                         * Get the list of 'FareBasisCode' element items.
                         * 
                         * @return list
                         */
                        public List<String> getFareBasisCodeList() {
                            return fareBasisCodeList;
                        }

                        /** 
                         * Set the list of 'FareBasisCode' element items.
                         * 
                         * @param list
                         */
                        public void setFareBasisCodeList(List<String> list) {
                            fareBasisCodeList = list;
                        }

                        /** 
                         * Get the list of 'FareComponent' element items.
                         * 
                         * @return list
                         */
                        public List<String> getFareComponentList() {
                            return fareComponentList;
                        }

                        /** 
                         * Set the list of 'FareComponent' element items.
                         * 
                         * @param list
                         */
                        public void setFareComponentList(List<String> list) {
                            fareComponentList = list;
                        }

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'Cat16' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getCat16() {
                            return cat16;
                        }

                        /** 
                         * Set the 'Cat16' attribute value.
                         * 
                         * @param cat16
                         */
                        public void setCat16(Boolean cat16) {
                            this.cat16 = cat16;
                        }

                        /** 
                         * Get the 'Currency' attribute value.
                         * 
                         * @return value
                         */
                        public String getCurrency() {
                            return currency;
                        }

                        /** 
                         * Set the 'Currency' attribute value.
                         * 
                         * @param currency
                         */
                        public void setCurrency(String currency) {
                            this.currency = currency;
                        }

                        /** 
                         * Get the 'NotApplicable' attribute value.
                         * 
                         * @return value
                         */
                        public Boolean getNotApplicable() {
                            return notApplicable;
                        }

                        /** 
                         * Set the 'NotApplicable' attribute value.
                         * 
                         * @param notApplicable
                         */
                        public void setNotApplicable(Boolean notApplicable) {
                            this.notApplicable = notApplicable;
                        }

                        /** 
                         * Get the 'Type' attribute value.
                         * 
                         * @return value
                         */
                        public String getType() {
                            return type;
                        }

                        /** 
                         * Set the 'Type' attribute value.
                         * 
                         * @param type
                         */
                        public void setType(String type) {
                            this.type = type;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingFees" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="FeeInformation" minOccurs="0">
                 *         &lt;!-- Reference to inner class FeeInformation -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TicketingFees implements Serializable
                {
                    private FeeInformation feeInformation;

                    /** 
                     * Get the 'FeeInformation' element value.
                     * 
                     * @return value
                     */
                    public FeeInformation getFeeInformation() {
                        return feeInformation;
                    }

                    /** 
                     * Set the 'FeeInformation' element value.
                     * 
                     * @param feeInformation
                     */
                    public void setFeeInformation(FeeInformation feeInformation) {
                        this.feeInformation = feeInformation;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeInformation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="AccountData"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="FunctionCode"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceType"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FeeInformation implements Serializable
                    {
                        private String accountData;
                        private String amount;
                        private String functionCode;
                        private String serviceType;

                        /** 
                         * Get the 'AccountData' attribute value.
                         * 
                         * @return value
                         */
                        public String getAccountData() {
                            return accountData;
                        }

                        /** 
                         * Set the 'AccountData' attribute value.
                         * 
                         * @param accountData
                         */
                        public void setAccountData(String accountData) {
                            this.accountData = accountData;
                        }

                        /** 
                         * Get the 'Amount' attribute value.
                         * 
                         * @return value
                         */
                        public String getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.
                         * 
                         * @param amount
                         */
                        public void setAmount(String amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'FunctionCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getFunctionCode() {
                            return functionCode;
                        }

                        /** 
                         * Set the 'FunctionCode' attribute value.
                         * 
                         * @param functionCode
                         */
                        public void setFunctionCode(String functionCode) {
                            this.functionCode = functionCode;
                        }

                        /** 
                         * Get the 'ServiceType' attribute value.
                         * 
                         * @return value
                         */
                        public String getServiceType() {
                            return serviceType;
                        }

                        /** 
                         * Set the 'ServiceType' attribute value.
                         * 
                         * @param serviceType
                         */
                        public void setServiceType(String serviceType) {
                            this.serviceType = serviceType;
                        }
                    }
                }
            }
        }
    }
}
