
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA_CancelRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Segment" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Segment -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="NumResponses"/>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.0.3" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OTACancelRQ implements Serializable
{
    private List<Segment> segmentList = new ArrayList<Segment>();
    private String numResponses;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the list of 'Segment' element items.
     * 
     * @return list
     */
    public List<Segment> getSegmentList() {
        return segmentList;
    }

    /** 
     * Set the list of 'Segment' element items.
     * 
     * @param list
     */
    public void setSegmentList(List<Segment> list) {
        segmentList = list;
    }

    /** 
     * Get the 'NumResponses' attribute value.
     * 
     * @return value
     */
    public String getNumResponses() {
        return numResponses;
    }

    /** 
     * Set the 'NumResponses' attribute value.
     * 
     * @param numResponses
     */
    public void setNumResponses(String numResponses) {
        this.numResponses = numResponses;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
     *     &lt;xs:attribute use="optional" name="Type">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Type -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Segment implements Serializable
    {
        private BigInteger endNumber;
        private BigInteger number;
        private Type type;

        /** 
         * Get the 'EndNumber' attribute value.
         * 
         * @return value
         */
        public BigInteger getEndNumber() {
            return endNumber;
        }

        /** 
         * Set the 'EndNumber' attribute value.
         * 
         * @param endNumber
         */
        public void setEndNumber(BigInteger endNumber) {
            this.endNumber = endNumber;
        }

        /** 
         * Get the 'Number' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value.
         * 
         * @param number
         */
        public void setNumber(BigInteger number) {
            this.number = number;
        }

        /** 
         * Get the 'Type' attribute value.
         * 
         * @return value
         */
        public Type getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value.
         * 
         * @param type
         */
        public void setType(Type type) {
            this.type = type;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="air"/>
         *     &lt;xs:enumeration value="vehicle"/>
         *     &lt;xs:enumeration value="entire"/>
         *     &lt;xs:enumeration value="hotel"/>
         *     &lt;xs:enumeration value="other"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Type implements Serializable {
            AIR("air"), VEHICLE("vehicle"), ENTIRE("entire"), HOTEL("hotel"), OTHER(
                    "other");
            private final String value;

            private Type(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static Type convert(String value) {
                for (Type inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
}
