
package com.sabre.webservices.sabrexml;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OWRTType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="1"/>
 *     &lt;xs:enumeration value="2"/>
 *     &lt;xs:enumeration value="3"/>
 *     &lt;xs:enumeration value="4"/>
 *     &lt;xs:enumeration value="5"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OWRTType implements Serializable {
    _1("1"), _2("2"), _3("3"), _4("4"), _5("5");
    private final String value;

    private OWRTType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static OWRTType convert(String value) {
        for (OWRTType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
