
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 Type - Indicates whether the penalty is refund or exchange
 Applicability - Indicates whether the penalty is non applicable before or after departure
 Refundable - Indicates if the fare is refundable
 Changeable - Indicates if the fare is changeable
 ConditionsApply - Indicates if there are periods when the change in a fare is non applicable
 Amount - Penalty Amount
 CurrencyCode - Penalty Currency
 Cat16Info - Indicates CAT16 information source

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Cat16TextOnly" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Cat16TextOnly -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FareComponent" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class FareComponent -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute use="optional" name="Type">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class Type -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute use="optional" name="Applicability">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class Applicability -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Refundable"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Changeable"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="ConditionsApply"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="Amount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Cat16Info"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PenaltyInfoType implements Serializable
{
    private List<Cat16TextOnly> cat16TextOnlyList = new ArrayList<Cat16TextOnly>();
    private List<FareComponent> fareComponentList = new ArrayList<FareComponent>();
    private Type type;
    private Applicability applicability;
    private Boolean refundable;
    private Boolean changeable;
    private Boolean conditionsApply;
    private Float amount;
    private String currencyCode;
    private Boolean cat16Info;

    /** 
     * Get the list of 'Cat16TextOnly' element items.
     * 
     * @return list
     */
    public List<Cat16TextOnly> getCat16TextOnlyList() {
        return cat16TextOnlyList;
    }

    /** 
     * Set the list of 'Cat16TextOnly' element items.
     * 
     * @param list
     */
    public void setCat16TextOnlyList(List<Cat16TextOnly> list) {
        cat16TextOnlyList = list;
    }

    /** 
     * Get the list of 'FareComponent' element items.
     * 
     * @return list
     */
    public List<FareComponent> getFareComponentList() {
        return fareComponentList;
    }

    /** 
     * Set the list of 'FareComponent' element items.
     * 
     * @param list
     */
    public void setFareComponentList(List<FareComponent> list) {
        fareComponentList = list;
    }

    /** 
     * Get the 'Type' attribute value.
     * 
     * @return value
     */
    public Type getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value.
     * 
     * @param type
     */
    public void setType(Type type) {
        this.type = type;
    }

    /** 
     * Get the 'Applicability' attribute value.
     * 
     * @return value
     */
    public Applicability getApplicability() {
        return applicability;
    }

    /** 
     * Set the 'Applicability' attribute value.
     * 
     * @param applicability
     */
    public void setApplicability(Applicability applicability) {
        this.applicability = applicability;
    }

    /** 
     * Get the 'Refundable' attribute value.
     * 
     * @return value
     */
    public Boolean getRefundable() {
        return refundable;
    }

    /** 
     * Set the 'Refundable' attribute value.
     * 
     * @param refundable
     */
    public void setRefundable(Boolean refundable) {
        this.refundable = refundable;
    }

    /** 
     * Get the 'Changeable' attribute value.
     * 
     * @return value
     */
    public Boolean getChangeable() {
        return changeable;
    }

    /** 
     * Set the 'Changeable' attribute value.
     * 
     * @param changeable
     */
    public void setChangeable(Boolean changeable) {
        this.changeable = changeable;
    }

    /** 
     * Get the 'ConditionsApply' attribute value.
     * 
     * @return value
     */
    public Boolean getConditionsApply() {
        return conditionsApply;
    }

    /** 
     * Set the 'ConditionsApply' attribute value.
     * 
     * @param conditionsApply
     */
    public void setConditionsApply(Boolean conditionsApply) {
        this.conditionsApply = conditionsApply;
    }

    /** 
     * Get the 'Amount' attribute value.
     * 
     * @return value
     */
    public Float getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' attribute value.
     * 
     * @param amount
     */
    public void setAmount(Float amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'CurrencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'Cat16Info' attribute value.
     * 
     * @return value
     */
    public Boolean getCat16Info() {
        return cat16Info;
    }

    /** 
     * Set the 'Cat16Info' attribute value.
     * 
     * @param cat16Info
     */
    public void setCat16Info(Boolean cat16Info) {
        this.cat16Info = cat16Info;
    }
    /** 
     * Missing Data
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cat16TextOnly" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="FareBasisCode"/>
     *     &lt;xs:attribute type="xs:integer" use="required" name="FareComponentID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Cat16TextOnly implements Serializable
    {
        private String fareBasisCode;
        private BigInteger fareComponentID;

        /** 
         * Get the 'FareBasisCode' attribute value. Fare basis code
         * 
         * @return value
         */
        public String getFareBasisCode() {
            return fareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' attribute value. Fare basis code
         * 
         * @param fareBasisCode
         */
        public void setFareBasisCode(String fareBasisCode) {
            this.fareBasisCode = fareBasisCode;
        }

        /** 
         * Get the 'FareComponentID' attribute value. Fare Component Id
         * 
         * @return value
         */
        public BigInteger getFareComponentID() {
            return fareComponentID;
        }

        /** 
         * Set the 'FareComponentID' attribute value. Fare Component Id
         * 
         * @param fareComponentID
         */
        public void setFareComponentID(BigInteger fareComponentID) {
            this.fareComponentID = fareComponentID;
        }
    }
    /** 
     * Penalty info at fare component level
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponent" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="FareBasisCode"/>
     *     &lt;xs:attribute type="xs:boolean" name="Refundable"/>
     *     &lt;xs:attribute type="xs:boolean" name="Changeable"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareComponent implements Serializable
    {
        private String fareBasisCode;
        private Boolean refundable;
        private Boolean changeable;

        /** 
         * Get the 'FareBasisCode' attribute value. Fare basis code
         * 
         * @return value
         */
        public String getFareBasisCode() {
            return fareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' attribute value. Fare basis code
         * 
         * @param fareBasisCode
         */
        public void setFareBasisCode(String fareBasisCode) {
            this.fareBasisCode = fareBasisCode;
        }

        /** 
         * Get the 'Refundable' attribute value.
         * 
         * @return value
         */
        public Boolean getRefundable() {
            return refundable;
        }

        /** 
         * Set the 'Refundable' attribute value.
         * 
         * @param refundable
         */
        public void setRefundable(Boolean refundable) {
            this.refundable = refundable;
        }

        /** 
         * Get the 'Changeable' attribute value.
         * 
         * @return value
         */
        public Boolean getChangeable() {
            return changeable;
        }

        /** 
         * Set the 'Changeable' attribute value.
         * 
         * @param changeable
         */
        public void setChangeable(Boolean changeable) {
            this.changeable = changeable;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Refund"/>
     *     &lt;xs:enumeration value="Exchange"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Type implements Serializable {
        REFUND("Refund"), EXCHANGE("Exchange");
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Type convert(String value) {
            for (Type inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="After"/>
     *     &lt;xs:enumeration value="Before"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Applicability implements Serializable {
        AFTER("After"), BEFORE("Before");
        private final String value;

        private Applicability(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Applicability convert(String value) {
            for (Applicability inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
