
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Points redemption informations
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PointsRedemptionType">
 *   &lt;xs:attribute type="xs:integer" use="optional" name="TotalPoints"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="BaseFarePoints"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="BaseFareConversionRate"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="TotalSurcharges"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="SurchargesConversionRate"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="TotalTaxes"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="TaxConversionRate"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="MinimumPoints"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PointsRedemptionType implements Serializable
{
    private BigInteger totalPoints;
    private BigInteger baseFarePoints;
    private Float baseFareConversionRate;
    private BigInteger totalSurcharges;
    private Float surchargesConversionRate;
    private BigInteger totalTaxes;
    private Float taxConversionRate;
    private BigInteger minimumPoints;

    /** 
     * Get the 'TotalPoints' attribute value. Total redemption points
     * 
     * @return value
     */
    public BigInteger getTotalPoints() {
        return totalPoints;
    }

    /** 
     * Set the 'TotalPoints' attribute value. Total redemption points
     * 
     * @param totalPoints
     */
    public void setTotalPoints(BigInteger totalPoints) {
        this.totalPoints = totalPoints;
    }

    /** 
     * Get the 'BaseFarePoints' attribute value. Base fare redemption points
     * 
     * @return value
     */
    public BigInteger getBaseFarePoints() {
        return baseFarePoints;
    }

    /** 
     * Set the 'BaseFarePoints' attribute value. Base fare redemption points
     * 
     * @param baseFarePoints
     */
    public void setBaseFarePoints(BigInteger baseFarePoints) {
        this.baseFarePoints = baseFarePoints;
    }

    /** 
     * Get the 'BaseFareConversionRate' attribute value. Base fare conversion rate (only for dynamic redemption fares)
     * 
     * @return value
     */
    public Float getBaseFareConversionRate() {
        return baseFareConversionRate;
    }

    /** 
     * Set the 'BaseFareConversionRate' attribute value. Base fare conversion rate (only for dynamic redemption fares)
     * 
     * @param baseFareConversionRate
     */
    public void setBaseFareConversionRate(Float baseFareConversionRate) {
        this.baseFareConversionRate = baseFareConversionRate;
    }

    /** 
     * Get the 'TotalSurcharges' attribute value. Total surcharges in points
     * 
     * @return value
     */
    public BigInteger getTotalSurcharges() {
        return totalSurcharges;
    }

    /** 
     * Set the 'TotalSurcharges' attribute value. Total surcharges in points
     * 
     * @param totalSurcharges
     */
    public void setTotalSurcharges(BigInteger totalSurcharges) {
        this.totalSurcharges = totalSurcharges;
    }

    /** 
     * Get the 'SurchargesConversionRate' attribute value. Surcharges conversion rate 
     * 
     * @return value
     */
    public Float getSurchargesConversionRate() {
        return surchargesConversionRate;
    }

    /** 
     * Set the 'SurchargesConversionRate' attribute value. Surcharges conversion rate 
     * 
     * @param surchargesConversionRate
     */
    public void setSurchargesConversionRate(Float surchargesConversionRate) {
        this.surchargesConversionRate = surchargesConversionRate;
    }

    /** 
     * Get the 'TotalTaxes' attribute value. Total taxes in points 
     * 
     * @return value
     */
    public BigInteger getTotalTaxes() {
        return totalTaxes;
    }

    /** 
     * Set the 'TotalTaxes' attribute value. Total taxes in points 
     * 
     * @param totalTaxes
     */
    public void setTotalTaxes(BigInteger totalTaxes) {
        this.totalTaxes = totalTaxes;
    }

    /** 
     * Get the 'TaxConversionRate' attribute value. Tax conversion rate
     * 
     * @return value
     */
    public Float getTaxConversionRate() {
        return taxConversionRate;
    }

    /** 
     * Set the 'TaxConversionRate' attribute value. Tax conversion rate
     * 
     * @param taxConversionRate
     */
    public void setTaxConversionRate(Float taxConversionRate) {
        this.taxConversionRate = taxConversionRate;
    }

    /** 
     * Get the 'MinimumPoints' attribute value. Minimum points (only for dynamic redemption fares)
     * 
     * @return value
     */
    public BigInteger getMinimumPoints() {
        return minimumPoints;
    }

    /** 
     * Set the 'MinimumPoints' attribute value. Minimum points (only for dynamic redemption fares)
     * 
     * @param minimumPoints
     */
    public void setMinimumPoints(BigInteger minimumPoints) {
        this.minimumPoints = minimumPoints;
    }
}
