
package com.sabre.webservices.sabrexml;

import java.io.Serializable;

/** 
 * Used to specify a preference level for brand filters.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferLevelType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Unacceptable"/>
 *     &lt;xs:enumeration value="Preferred"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PreferLevelType implements Serializable {
    UNACCEPTABLE("Unacceptable"), PREFERRED("Preferred");
    private final String value;

    private PreferLevelType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PreferLevelType convert(String value) {
        for (PreferLevelType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
