
package com.sabre.webservices.sabrexml;

import java.io.Serializable;

/** 
 * Price and Fulfillment Information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceAndFulfillmentInfoType">
 *   &lt;xs:attribute type="xs:string" use="required" name="FeeApplication"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FeeNotGuaranteed"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SimultaneousTicket"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="NoChargeNotAvaiable"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FormOfRefund"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RefundReissue"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Commission"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Interline"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="PassengerTypeCode"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="TotalPrice"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="BasePrice"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BaseCurrencyCode"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="EquivalentBasePrice"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EquivalentCurrencyCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TaxIndicator"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceAndFulfillmentInfoType implements Serializable
{
    private String feeApplication;
    private String feeNotGuaranteed;
    private String simultaneousTicket;
    private String noChargeNotAvaiable;
    private String formOfRefund;
    private String refundReissue;
    private String commission;
    private String interline;
    private String passengerTypeCode;
    private Float totalPrice;
    private Float basePrice;
    private String baseCurrencyCode;
    private Float equivalentBasePrice;
    private String equivalentCurrencyCode;
    private String taxIndicator;

    /** 
     * Get the 'FeeApplication' attribute value. SUM/PXI/BDI/PFF/@N41
     * 
     * @return value
     */
    public String getFeeApplication() {
        return feeApplication;
    }

    /** 
     * Set the 'FeeApplication' attribute value. SUM/PXI/BDI/PFF/@N41
     * 
     * @param feeApplication
     */
    public void setFeeApplication(String feeApplication) {
        this.feeApplication = feeApplication;
    }

    /** 
     * Get the 'FeeNotGuaranteed' attribute value. SUM/PXI/BDI/PFF/@P01
     * 
     * @return value
     */
    public String getFeeNotGuaranteed() {
        return feeNotGuaranteed;
    }

    /** 
     * Set the 'FeeNotGuaranteed' attribute value. SUM/PXI/BDI/PFF/@P01
     * 
     * @param feeNotGuaranteed
     */
    public void setFeeNotGuaranteed(String feeNotGuaranteed) {
        this.feeNotGuaranteed = feeNotGuaranteed;
    }

    /** 
     * Get the 'SimultaneousTicket' attribute value. SUM/PXI/BDI/PFF/@N42
     * 
     * @return value
     */
    public String getSimultaneousTicket() {
        return simultaneousTicket;
    }

    /** 
     * Set the 'SimultaneousTicket' attribute value. SUM/PXI/BDI/PFF/@N42
     * 
     * @param simultaneousTicket
     */
    public void setSimultaneousTicket(String simultaneousTicket) {
        this.simultaneousTicket = simultaneousTicket;
    }

    /** 
     * Get the 'NoChargeNotAvaiable' attribute value. SUM/PXI/BDI/PFF/@N43
     * 
     * @return value
     */
    public String getNoChargeNotAvaiable() {
        return noChargeNotAvaiable;
    }

    /** 
     * Set the 'NoChargeNotAvaiable' attribute value. SUM/PXI/BDI/PFF/@N43
     * 
     * @param noChargeNotAvaiable
     */
    public void setNoChargeNotAvaiable(String noChargeNotAvaiable) {
        this.noChargeNotAvaiable = noChargeNotAvaiable;
    }

    /** 
     * Get the 'FormOfRefund' attribute value. SUM/PXI/BDI/PFF/@N44
     * 
     * @return value
     */
    public String getFormOfRefund() {
        return formOfRefund;
    }

    /** 
     * Set the 'FormOfRefund' attribute value. SUM/PXI/BDI/PFF/@N44
     * 
     * @param formOfRefund
     */
    public void setFormOfRefund(String formOfRefund) {
        this.formOfRefund = formOfRefund;
    }

    /** 
     * Get the 'RefundReissue' attribute value. SUM/PXI/BDI/PFF/@N45
     * 
     * @return value
     */
    public String getRefundReissue() {
        return refundReissue;
    }

    /** 
     * Set the 'RefundReissue' attribute value. SUM/PXI/BDI/PFF/@N45
     * 
     * @param refundReissue
     */
    public void setRefundReissue(String refundReissue) {
        this.refundReissue = refundReissue;
    }

    /** 
     * Get the 'Commission' attribute value. SUM/PXI/BDI/PFF/@P03
     * 
     * @return value
     */
    public String getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' attribute value. SUM/PXI/BDI/PFF/@P03
     * 
     * @param commission
     */
    public void setCommission(String commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'Interline' attribute value. SUM/PXI/BDI/PFF/@P04
     * 
     * @return value
     */
    public String getInterline() {
        return interline;
    }

    /** 
     * Set the 'Interline' attribute value. SUM/PXI/BDI/PFF/@P04
     * 
     * @param interline
     */
    public void setInterline(String interline) {
        this.interline = interline;
    }

    /** 
     * Get the 'PassengerTypeCode' attribute value. SUM/PXI/BDI/PFF/@B70
     * 
     * @return value
     */
    public String getPassengerTypeCode() {
        return passengerTypeCode;
    }

    /** 
     * Set the 'PassengerTypeCode' attribute value. SUM/PXI/BDI/PFF/@B70
     * 
     * @param passengerTypeCode
     */
    public void setPassengerTypeCode(String passengerTypeCode) {
        this.passengerTypeCode = passengerTypeCode;
    }

    /** 
     * Get the 'TotalPrice' attribute value. SUM/PXI/BDI/PFF/@C50 This is not supported now and is just placeholder for future use
     * 
     * @return value
     */
    public Float getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' attribute value. SUM/PXI/BDI/PFF/@C50 This is not supported now and is just placeholder for future use
     * 
     * @param totalPrice
     */
    public void setTotalPrice(Float totalPrice) {
        this.totalPrice = totalPrice;
    }

    /** 
     * Get the 'BasePrice' attribute value. SUM/PXI/BDI/PFF/@C51
     * 
     * @return value
     */
    public Float getBasePrice() {
        return basePrice;
    }

    /** 
     * Set the 'BasePrice' attribute value. SUM/PXI/BDI/PFF/@C51
     * 
     * @param basePrice
     */
    public void setBasePrice(Float basePrice) {
        this.basePrice = basePrice;
    }

    /** 
     * Get the 'BaseCurrencyCode' attribute value. SUM/PXI/BDI/PFF/@C5A
     * 
     * @return value
     */
    public String getBaseCurrencyCode() {
        return baseCurrencyCode;
    }

    /** 
     * Set the 'BaseCurrencyCode' attribute value. SUM/PXI/BDI/PFF/@C5A
     * 
     * @param baseCurrencyCode
     */
    public void setBaseCurrencyCode(String baseCurrencyCode) {
        this.baseCurrencyCode = baseCurrencyCode;
    }

    /** 
     * Get the 'EquivalentBasePrice' attribute value. SUM/PXI/BDI/PFF/@C52
     * 
     * @return value
     */
    public Float getEquivalentBasePrice() {
        return equivalentBasePrice;
    }

    /** 
     * Set the 'EquivalentBasePrice' attribute value. SUM/PXI/BDI/PFF/@C52
     * 
     * @param equivalentBasePrice
     */
    public void setEquivalentBasePrice(Float equivalentBasePrice) {
        this.equivalentBasePrice = equivalentBasePrice;
    }

    /** 
     * Get the 'EquivalentCurrencyCode' attribute value. SUM/PXI/BDI/PFF/@C5B
     * 
     * @return value
     */
    public String getEquivalentCurrencyCode() {
        return equivalentCurrencyCode;
    }

    /** 
     * Set the 'EquivalentCurrencyCode' attribute value. SUM/PXI/BDI/PFF/@C5B
     * 
     * @param equivalentCurrencyCode
     */
    public void setEquivalentCurrencyCode(String equivalentCurrencyCode) {
        this.equivalentCurrencyCode = equivalentCurrencyCode;
    }

    /** 
     * Get the 'TaxIndicator' attribute value. SUM/PXI/BDI/PFF/@N21
     * 
     * @return value
     */
    public String getTaxIndicator() {
        return taxIndicator;
    }

    /** 
     * Set the 'TaxIndicator' attribute value. SUM/PXI/BDI/PFF/@N21
     * 
     * @param taxIndicator
     */
    public void setTaxIndicator(String taxIndicator) {
        this.taxIndicator = taxIndicator;
    }
}
