
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueAccessRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="Line" minOccurs="0" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Line -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Paragraph" minOccurs="0">
 *         &lt;!-- Reference to inner class Paragraph -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class QueueAccessRS implements Serializable
{
    private ApplicationResults applicationResults;
    private List<Line> lineList = new ArrayList<Line>();
    private Paragraph paragraph;
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the list of 'Line' element items.
     * 
     * @return list
     */
    public List<Line> getLineList() {
        return lineList;
    }

    /** 
     * Set the list of 'Line' element items.
     * 
     * @param list
     */
    public void setLineList(List<Line> list) {
        lineList = list;
    }

    /** 
     * Get the 'Paragraph' element value.
     * 
     * @return value
     */
    public Paragraph getParagraph() {
        return paragraph;
    }

    /** 
     * Set the 'Paragraph' element value.
     * 
     * @param paragraph
     */
    public void setParagraph(Paragraph paragraph) {
        this.paragraph = paragraph;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Line" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="DateTime" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Group" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="PassengerName" minOccurs="0"/>
     *       &lt;xs:element name="POS" minOccurs="0">
     *         &lt;!-- Reference to inner class POS -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="UniqueID" minOccurs="0">
     *         &lt;!-- Reference to inner class UniqueID -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Line implements Serializable
    {
        private String dateTime;
        private String group;
        private String passengerName;
        private POS POS1;
        private UniqueID uniqueID;
        private String number;

        /** 
         * Get the 'DateTime' element value.
         * 
         * @return value
         */
        public String getDateTime() {
            return dateTime;
        }

        /** 
         * Set the 'DateTime' element value.
         * 
         * @param dateTime
         */
        public void setDateTime(String dateTime) {
            this.dateTime = dateTime;
        }

        /** 
         * Get the 'Group' element value.
         * 
         * @return value
         */
        public String getGroup() {
            return group;
        }

        /** 
         * Set the 'Group' element value.
         * 
         * @param group
         */
        public void setGroup(String group) {
            this.group = group;
        }

        /** 
         * Get the 'PassengerName' element value.
         * 
         * @return value
         */
        public String getPassengerName() {
            return passengerName;
        }

        /** 
         * Set the 'PassengerName' element value.
         * 
         * @param passengerName
         */
        public void setPassengerName(String passengerName) {
            this.passengerName = passengerName;
        }

        /** 
         * Get the 'POS' element value.
         * 
         * @return value
         */
        public POS getPOS1() {
            return POS1;
        }

        /** 
         * Set the 'POS' element value.
         * 
         * @param POS1
         */
        public void setPOS1(POS POS1) {
            this.POS1 = POS1;
        }

        /** 
         * Get the 'UniqueID' element value.
         * 
         * @return value
         */
        public UniqueID getUniqueID() {
            return uniqueID;
        }

        /** 
         * Set the 'UniqueID' element value.
         * 
         * @param uniqueID
         */
        public void setUniqueID(UniqueID uniqueID) {
            this.uniqueID = uniqueID;
        }

        /** 
         * Get the 'Number' attribute value.
         * 
         * @return value
         */
        public String getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value.
         * 
         * @param number
         */
        public void setNumber(String number) {
            this.number = number;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Source" minOccurs="0">
         *         &lt;!-- Reference to inner class Source -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class POS implements Serializable
        {
            private Source source;

            /** 
             * Get the 'Source' element value.
             * 
             * @return value
             */
            public Source getSource() {
                return source;
            }

            /** 
             * Set the 'Source' element value.
             * 
             * @param source
             */
            public void setSource(Source source) {
                this.source = source;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Source" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="AgentSine"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Source implements Serializable
            {
                private String agentSine;
                private String pseudoCityCode;

                /** 
                 * Get the 'AgentSine' attribute value.
                 * 
                 * @return value
                 */
                public String getAgentSine() {
                    return agentSine;
                }

                /** 
                 * Set the 'AgentSine' attribute value.
                 * 
                 * @param agentSine
                 */
                public void setAgentSine(String agentSine) {
                    this.agentSine = agentSine;
                }

                /** 
                 * Get the 'PseudoCityCode' attribute value.
                 * 
                 * @return value
                 */
                public String getPseudoCityCode() {
                    return pseudoCityCode;
                }

                /** 
                 * Set the 'PseudoCityCode' attribute value.
                 * 
                 * @param pseudoCityCode
                 */
                public void setPseudoCityCode(String pseudoCityCode) {
                    this.pseudoCityCode = pseudoCityCode;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UniqueID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UniqueID implements Serializable
        {
            private String ID;

            /** 
             * Get the 'ID' attribute value.
             * 
             * @return value
             */
            public String getID() {
                return ID;
            }

            /** 
             * Set the 'ID' attribute value.
             * 
             * @param ID
             */
            public void setID(String ID) {
                this.ID = ID;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Paragraph" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Paragraph implements Serializable
    {
        private List<String> textList = new ArrayList<String>();

        /** 
         * Get the list of 'Text' element items.
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items.
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }
    }
}
