
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueuePlaceRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="QueueInfo" minOccurs="0" maxOccurs="20">
 *         &lt;!-- Reference to inner class QueueInfo -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class QueuePlaceRS implements Serializable
{
    private ApplicationResults applicationResults;
    private List<QueueInfo> queueInfoList = new ArrayList<QueueInfo>();
    private List<String> textList = new ArrayList<String>();
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the list of 'QueueInfo' element items.
     * 
     * @return list
     */
    public List<QueueInfo> getQueueInfoList() {
        return queueInfoList;
    }

    /** 
     * Set the list of 'QueueInfo' element items.
     * 
     * @param list
     */
    public void setQueueInfoList(List<QueueInfo> list) {
        queueInfoList = list;
    }

    /** 
     * Get the list of 'Text' element items.
     * 
     * @return list
     */
    public List<String> getTextList() {
        return textList;
    }

    /** 
     * Set the list of 'Text' element items.
     * 
     * @param list
     */
    public void setTextList(List<String> list) {
        textList = list;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueInfo" minOccurs="0" maxOccurs="20">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="QueueIdentifier" minOccurs="0">
     *         &lt;!-- Reference to inner class QueueIdentifier -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="UniqueID" minOccurs="0">
     *         &lt;!-- Reference to inner class UniqueID -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="DateTime"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class QueueInfo implements Serializable
    {
        private QueueIdentifier queueIdentifier;
        private UniqueID uniqueID;
        private String dateTime;

        /** 
         * Get the 'QueueIdentifier' element value.
         * 
         * @return value
         */
        public QueueIdentifier getQueueIdentifier() {
            return queueIdentifier;
        }

        /** 
         * Set the 'QueueIdentifier' element value.
         * 
         * @param queueIdentifier
         */
        public void setQueueIdentifier(QueueIdentifier queueIdentifier) {
            this.queueIdentifier = queueIdentifier;
        }

        /** 
         * Get the 'UniqueID' element value.
         * 
         * @return value
         */
        public UniqueID getUniqueID() {
            return uniqueID;
        }

        /** 
         * Set the 'UniqueID' element value.
         * 
         * @param uniqueID
         */
        public void setUniqueID(UniqueID uniqueID) {
            this.uniqueID = uniqueID;
        }

        /** 
         * Get the 'DateTime' attribute value.
         * 
         * @return value
         */
        public String getDateTime() {
            return dateTime;
        }

        /** 
         * Set the 'DateTime' attribute value.
         * 
         * @param dateTime
         */
        public void setDateTime(String dateTime) {
            this.dateTime = dateTime;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueIdentifier" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Number"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class QueueIdentifier implements Serializable
        {
            private String name;
            private String number;
            private String pseudoCityCode;

            /** 
             * Get the 'Name' attribute value.
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' attribute value.
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }

            /** 
             * Get the 'Number' attribute value.
             * 
             * @return value
             */
            public String getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value.
             * 
             * @param number
             */
            public void setNumber(String number) {
                this.number = number;
            }

            /** 
             * Get the 'PseudoCityCode' attribute value.
             * 
             * @return value
             */
            public String getPseudoCityCode() {
                return pseudoCityCode;
            }

            /** 
             * Set the 'PseudoCityCode' attribute value.
             * 
             * @param pseudoCityCode
             */
            public void setPseudoCityCode(String pseudoCityCode) {
                this.pseudoCityCode = pseudoCityCode;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UniqueID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UniqueID implements Serializable
        {
            private String ID;

            /** 
             * Get the 'ID' attribute value.
             * 
             * @return value
             */
            public String getID() {
                return ID;
            }

            /** 
             * Set the 'ID' attribute value.
             * 
             * @param ID
             */
            public void setID(String ID) {
                this.ID = ID;
            }
        }
    }
}
