
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RulesFromPriceRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="RuleReqInfo" minOccurs="0">
 *         &lt;!-- Reference to inner class RuleReqInfo -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.1.0" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class RulesFromPriceRQ implements Serializable
{
    private RuleReqInfo ruleReqInfo;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'RuleReqInfo' element value.
     * 
     * @return value
     */
    public RuleReqInfo getRuleReqInfo() {
        return ruleReqInfo;
    }

    /** 
     * Set the 'RuleReqInfo' element value.
     * 
     * @param ruleReqInfo
     */
    public void setRuleReqInfo(RuleReqInfo ruleReqInfo) {
        this.ruleReqInfo = ruleReqInfo;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleReqInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Category" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="FareBasis" minOccurs="0">
     *         &lt;!-- Reference to inner class FareBasis -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NoMatch" minOccurs="0">
     *         &lt;!-- Reference to inner class NoMatch -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Passenger" minOccurs="0">
     *         &lt;!-- Reference to inner class Passenger -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SegmentSelect" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SegmentSelect -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="LevelTwo"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RuleReqInfo implements Serializable
    {
        private List<String> categoryList = new ArrayList<String>();
        private FareBasis fareBasis;
        private NoMatch noMatch;
        private Passenger passenger;
        private List<SegmentSelect> segmentSelectList = new ArrayList<SegmentSelect>();
        private Boolean levelTwo;

        /** 
         * Get the list of 'Category' element items.
         * 
         * @return list
         */
        public List<String> getCategoryList() {
            return categoryList;
        }

        /** 
         * Set the list of 'Category' element items.
         * 
         * @param list
         */
        public void setCategoryList(List<String> list) {
            categoryList = list;
        }

        /** 
         * Get the 'FareBasis' element value.
         * 
         * @return value
         */
        public FareBasis getFareBasis() {
            return fareBasis;
        }

        /** 
         * Set the 'FareBasis' element value.
         * 
         * @param fareBasis
         */
        public void setFareBasis(FareBasis fareBasis) {
            this.fareBasis = fareBasis;
        }

        /** 
         * Get the 'NoMatch' element value.
         * 
         * @return value
         */
        public NoMatch getNoMatch() {
            return noMatch;
        }

        /** 
         * Set the 'NoMatch' element value.
         * 
         * @param noMatch
         */
        public void setNoMatch(NoMatch noMatch) {
            this.noMatch = noMatch;
        }

        /** 
         * Get the 'Passenger' element value.
         * 
         * @return value
         */
        public Passenger getPassenger() {
            return passenger;
        }

        /** 
         * Set the 'Passenger' element value.
         * 
         * @param passenger
         */
        public void setPassenger(Passenger passenger) {
            this.passenger = passenger;
        }

        /** 
         * Get the list of 'SegmentSelect' element items.
         * 
         * @return list
         */
        public List<SegmentSelect> getSegmentSelectList() {
            return segmentSelectList;
        }

        /** 
         * Set the list of 'SegmentSelect' element items.
         * 
         * @param list
         */
        public void setSegmentSelectList(List<SegmentSelect> list) {
            segmentSelectList = list;
        }

        /** 
         * Get the 'LevelTwo' attribute value.
         * 
         * @return value
         */
        public Boolean getLevelTwo() {
            return levelTwo;
        }

        /** 
         * Set the 'LevelTwo' attribute value.
         * 
         * @param levelTwo
         */
        public void setLevelTwo(Boolean levelTwo) {
            this.levelTwo = levelTwo;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="CommissionContract"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="DisplayRouting"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="TicketDesignator"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareBasis implements Serializable
        {
            private String code;
            private Boolean commissionContract;
            private Boolean displayRouting;
            private String ticketDesignator;

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'CommissionContract' attribute value.
             * 
             * @return value
             */
            public Boolean getCommissionContract() {
                return commissionContract;
            }

            /** 
             * Set the 'CommissionContract' attribute value.
             * 
             * @param commissionContract
             */
            public void setCommissionContract(Boolean commissionContract) {
                this.commissionContract = commissionContract;
            }

            /** 
             * Get the 'DisplayRouting' attribute value.
             * 
             * @return value
             */
            public Boolean getDisplayRouting() {
                return displayRouting;
            }

            /** 
             * Set the 'DisplayRouting' attribute value.
             * 
             * @param displayRouting
             */
            public void setDisplayRouting(Boolean displayRouting) {
                this.displayRouting = displayRouting;
            }

            /** 
             * Get the 'TicketDesignator' attribute value.
             * 
             * @return value
             */
            public String getTicketDesignator() {
                return ticketDesignator;
            }

            /** 
             * Set the 'TicketDesignator' attribute value.
             * 
             * @param ticketDesignator
             */
            public void setTicketDesignator(String ticketDesignator) {
                this.ticketDesignator = ticketDesignator;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NoMatch" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="required" name="LineNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NoMatch implements Serializable
        {
            private BigInteger lineNumber;

            /** 
             * Get the 'LineNumber' attribute value.
             * 
             * @return value
             */
            public BigInteger getLineNumber() {
                return lineNumber;
            }

            /** 
             * Set the 'LineNumber' attribute value.
             * 
             * @param lineNumber
             */
            public void setLineNumber(BigInteger lineNumber) {
                this.lineNumber = lineNumber;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="TypeNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Passenger implements Serializable
        {
            private String code;
            private String typeNumber;

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'TypeNumber' attribute value.
             * 
             * @return value
             */
            public String getTypeNumber() {
                return typeNumber;
            }

            /** 
             * Set the 'TypeNumber' attribute value.
             * 
             * @param typeNumber
             */
            public void setTypeNumber(String typeNumber) {
                this.typeNumber = typeNumber;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentSelect" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="EndNumber"/>
         *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SegmentSelect implements Serializable
        {
            private BigInteger endNumber;
            private BigInteger number;

            /** 
             * Get the 'EndNumber' attribute value.
             * 
             * @return value
             */
            public BigInteger getEndNumber() {
                return endNumber;
            }

            /** 
             * Set the 'EndNumber' attribute value.
             * 
             * @param endNumber
             */
            public void setEndNumber(BigInteger endNumber) {
                this.endNumber = endNumber;
            }

            /** 
             * Get the 'Number' attribute value.
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value.
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }
        }
    }
}
