
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RulesFromPriceRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="FareRuleInfo" minOccurs="0">
 *         &lt;!-- Reference to inner class FareRuleInfo -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="RoutingInfo" minOccurs="0">
 *         &lt;!-- Reference to inner class RoutingInfo -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class RulesFromPriceRS implements Serializable
{
    private ApplicationResults applicationResults;
    private FareRuleInfo fareRuleInfo;
    private RoutingInfo routingInfo;
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the 'FareRuleInfo' element value.
     * 
     * @return value
     */
    public FareRuleInfo getFareRuleInfo() {
        return fareRuleInfo;
    }

    /** 
     * Set the 'FareRuleInfo' element value.
     * 
     * @param fareRuleInfo
     */
    public void setFareRuleInfo(FareRuleInfo fareRuleInfo) {
        this.fareRuleInfo = fareRuleInfo;
    }

    /** 
     * Get the 'RoutingInfo' element value.
     * 
     * @return value
     */
    public RoutingInfo getRoutingInfo() {
        return routingInfo;
    }

    /** 
     * Set the 'RoutingInfo' element value.
     * 
     * @param routingInfo
     */
    public void setRoutingInfo(RoutingInfo routingInfo) {
        this.routingInfo = routingInfo;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRuleInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Header" minOccurs="0">
     *         &lt;!-- Reference to inner class Header -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Rules" minOccurs="0">
     *         &lt;!-- Reference to inner class Rules -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareRuleInfo implements Serializable
    {
        private Header header;
        private Rules rules;

        /** 
         * Get the 'Header' element value.
         * 
         * @return value
         */
        public Header getHeader() {
            return header;
        }

        /** 
         * Set the 'Header' element value.
         * 
         * @param header
         */
        public void setHeader(Header header) {
            this.header = header;
        }

        /** 
         * Get the 'Rules' element value.
         * 
         * @return value
         */
        public Rules getRules() {
            return rules;
        }

        /** 
         * Set the 'Rules' element value.
         * 
         * @param rules
         */
        public void setRules(Rules rules) {
            this.rules = rules;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Header" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Line" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Line -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ParsedData" minOccurs="0">
         *         &lt;!-- Reference to inner class ParsedData -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Header implements Serializable
        {
            private List<Line> lineList = new ArrayList<Line>();
            private ParsedData parsedData;

            /** 
             * Get the list of 'Line' element items.
             * 
             * @return list
             */
            public List<Line> getLineList() {
                return lineList;
            }

            /** 
             * Set the list of 'Line' element items.
             * 
             * @param list
             */
            public void setLineList(List<Line> list) {
                lineList = list;
            }

            /** 
             * Get the 'ParsedData' element value.
             * 
             * @return value
             */
            public ParsedData getParsedData() {
                return parsedData;
            }

            /** 
             * Set the 'ParsedData' element value.
             * 
             * @param parsedData
             */
            public void setParsedData(ParsedData parsedData) {
                this.parsedData = parsedData;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Line" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute use="optional" name="Type">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class Type -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Line implements Serializable
            {
                private String text;
                private Type type;

                /** 
                 * Get the 'Text' element value.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'Type' attribute value.
                 * 
                 * @return value
                 */
                public Type getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value.
                 * 
                 * @param type
                 */
                public void setType(Type type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="Legend"/>
                 *     &lt;xs:enumeration value="Fare"/>
                 *     &lt;xs:enumeration value="Passenger Type"/>
                 *     &lt;xs:enumeration value="Origin Destination"/>
                 *     &lt;xs:enumeration value="Fare Basis"/>
                 *     &lt;xs:enumeration value="Fare Type"/>
                 *     &lt;xs:enumeration value="SITA"/>
                 *     &lt;xs:enumeration value="Footnotes"/>
                 *     &lt;xs:enumeration value="Currency"/>
                 *     &lt;xs:enumeration value="System Dates"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Type implements Serializable {
                    LEGEND("Legend"), FARE("Fare"), PASSENGER_TYPE(
                            "Passenger Type"), ORIGIN_DESTINATION(
                            "Origin Destination"), FARE_BASIS("Fare Basis"), FARE_TYPE(
                            "Fare Type"), SITA("SITA"), FOOTNOTES("Footnotes"), CURRENCY(
                            "Currency"), SYSTEM_DATES("System Dates");
                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static Type convert(String value) {
                        for (Type inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ParsedData" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="CurrencyLine" minOccurs="0">
             *         &lt;!-- Reference to inner class CurrencyLine -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareBasisLine" minOccurs="0">
             *         &lt;!-- Reference to inner class FareBasisLine -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareTypeLine" minOccurs="0">
             *         &lt;!-- Reference to inner class FareTypeLine -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FootnoteLine" minOccurs="0">
             *         &lt;!-- Reference to inner class FootnoteLine -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="OriginDestinationLine" minOccurs="0">
             *         &lt;!-- Reference to inner class OriginDestinationLine -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="PassengerTypeLine" minOccurs="0">
             *         &lt;!-- Reference to inner class PassengerTypeLine -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SITA_Line" minOccurs="0">
             *         &lt;!-- Reference to inner class SITALine -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="SystemDatesLine" minOccurs="0">
             *         &lt;!-- Reference to inner class SystemDatesLine -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ParsedData implements Serializable
            {
                private CurrencyLine currencyLine;
                private FareBasisLine fareBasisLine;
                private FareTypeLine fareTypeLine;
                private FootnoteLine footnoteLine;
                private OriginDestinationLine originDestinationLine;
                private PassengerTypeLine passengerTypeLine;
                private SITALine SITALine1;
                private SystemDatesLine systemDatesLine;

                /** 
                 * Get the 'CurrencyLine' element value.
                 * 
                 * @return value
                 */
                public CurrencyLine getCurrencyLine() {
                    return currencyLine;
                }

                /** 
                 * Set the 'CurrencyLine' element value.
                 * 
                 * @param currencyLine
                 */
                public void setCurrencyLine(CurrencyLine currencyLine) {
                    this.currencyLine = currencyLine;
                }

                /** 
                 * Get the 'FareBasisLine' element value.
                 * 
                 * @return value
                 */
                public FareBasisLine getFareBasisLine() {
                    return fareBasisLine;
                }

                /** 
                 * Set the 'FareBasisLine' element value.
                 * 
                 * @param fareBasisLine
                 */
                public void setFareBasisLine(FareBasisLine fareBasisLine) {
                    this.fareBasisLine = fareBasisLine;
                }

                /** 
                 * Get the 'FareTypeLine' element value.
                 * 
                 * @return value
                 */
                public FareTypeLine getFareTypeLine() {
                    return fareTypeLine;
                }

                /** 
                 * Set the 'FareTypeLine' element value.
                 * 
                 * @param fareTypeLine
                 */
                public void setFareTypeLine(FareTypeLine fareTypeLine) {
                    this.fareTypeLine = fareTypeLine;
                }

                /** 
                 * Get the 'FootnoteLine' element value.
                 * 
                 * @return value
                 */
                public FootnoteLine getFootnoteLine() {
                    return footnoteLine;
                }

                /** 
                 * Set the 'FootnoteLine' element value.
                 * 
                 * @param footnoteLine
                 */
                public void setFootnoteLine(FootnoteLine footnoteLine) {
                    this.footnoteLine = footnoteLine;
                }

                /** 
                 * Get the 'OriginDestinationLine' element value.
                 * 
                 * @return value
                 */
                public OriginDestinationLine getOriginDestinationLine() {
                    return originDestinationLine;
                }

                /** 
                 * Set the 'OriginDestinationLine' element value.
                 * 
                 * @param originDestinationLine
                 */
                public void setOriginDestinationLine(
                        OriginDestinationLine originDestinationLine) {
                    this.originDestinationLine = originDestinationLine;
                }

                /** 
                 * Get the 'PassengerTypeLine' element value.
                 * 
                 * @return value
                 */
                public PassengerTypeLine getPassengerTypeLine() {
                    return passengerTypeLine;
                }

                /** 
                 * Set the 'PassengerTypeLine' element value.
                 * 
                 * @param passengerTypeLine
                 */
                public void setPassengerTypeLine(
                        PassengerTypeLine passengerTypeLine) {
                    this.passengerTypeLine = passengerTypeLine;
                }

                /** 
                 * Get the 'SITA_Line' element value.
                 * 
                 * @return value
                 */
                public SITALine getSITALine1() {
                    return SITALine1;
                }

                /** 
                 * Set the 'SITA_Line' element value.
                 * 
                 * @param SITALine1
                 */
                public void setSITALine1(SITALine SITALine1) {
                    this.SITALine1 = SITALine1;
                }

                /** 
                 * Get the 'SystemDatesLine' element value.
                 * 
                 * @return value
                 */
                public SystemDatesLine getSystemDatesLine() {
                    return systemDatesLine;
                }

                /** 
                 * Set the 'SystemDatesLine' element value.
                 * 
                 * @param systemDatesLine
                 */
                public void setSystemDatesLine(SystemDatesLine systemDatesLine) {
                    this.systemDatesLine = systemDatesLine;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyLine" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Amount" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Discontinue" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Effective" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="FareClass" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="RoutingNumberOrMPM" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="TariffDescriptionNumber" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class CurrencyLine implements Serializable
                {
                    private String amount;
                    private String currencyCode;
                    private String discontinue;
                    private String effective;
                    private String fareClass;
                    private String routingNumberOrMPM;
                    private String tariffDescriptionNumber;

                    /** 
                     * Get the 'Amount' element value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' element value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'CurrencyCode' element value.
                     * 
                     * @return value
                     */
                    public String getCurrencyCode() {
                        return currencyCode;
                    }

                    /** 
                     * Set the 'CurrencyCode' element value.
                     * 
                     * @param currencyCode
                     */
                    public void setCurrencyCode(String currencyCode) {
                        this.currencyCode = currencyCode;
                    }

                    /** 
                     * Get the 'Discontinue' element value.
                     * 
                     * @return value
                     */
                    public String getDiscontinue() {
                        return discontinue;
                    }

                    /** 
                     * Set the 'Discontinue' element value.
                     * 
                     * @param discontinue
                     */
                    public void setDiscontinue(String discontinue) {
                        this.discontinue = discontinue;
                    }

                    /** 
                     * Get the 'Effective' element value.
                     * 
                     * @return value
                     */
                    public String getEffective() {
                        return effective;
                    }

                    /** 
                     * Set the 'Effective' element value.
                     * 
                     * @param effective
                     */
                    public void setEffective(String effective) {
                        this.effective = effective;
                    }

                    /** 
                     * Get the 'FareClass' element value.
                     * 
                     * @return value
                     */
                    public String getFareClass() {
                        return fareClass;
                    }

                    /** 
                     * Set the 'FareClass' element value.
                     * 
                     * @param fareClass
                     */
                    public void setFareClass(String fareClass) {
                        this.fareClass = fareClass;
                    }

                    /** 
                     * Get the 'RoutingNumberOrMPM' element value.
                     * 
                     * @return value
                     */
                    public String getRoutingNumberOrMPM() {
                        return routingNumberOrMPM;
                    }

                    /** 
                     * Set the 'RoutingNumberOrMPM' element value.
                     * 
                     * @param routingNumberOrMPM
                     */
                    public void setRoutingNumberOrMPM(String routingNumberOrMPM) {
                        this.routingNumberOrMPM = routingNumberOrMPM;
                    }

                    /** 
                     * Get the 'TariffDescriptionNumber' element value.
                     * 
                     * @return value
                     */
                    public String getTariffDescriptionNumber() {
                        return tariffDescriptionNumber;
                    }

                    /** 
                     * Set the 'TariffDescriptionNumber' element value.
                     * 
                     * @param tariffDescriptionNumber
                     */
                    public void setTariffDescriptionNumber(
                            String tariffDescriptionNumber) {
                        this.tariffDescriptionNumber = tariffDescriptionNumber;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasisLine" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="DisplayType" minOccurs="0">
                 *         &lt;!-- Reference to inner class DisplayType -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FareBasis" minOccurs="0">
                 *         &lt;!-- Reference to inner class FareBasis -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="FareVendor" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareBasisLine implements Serializable
                {
                    private DisplayType displayType;
                    private FareBasis fareBasis;
                    private String fareVendor;
                    private String text;

                    /** 
                     * Get the 'DisplayType' element value.
                     * 
                     * @return value
                     */
                    public DisplayType getDisplayType() {
                        return displayType;
                    }

                    /** 
                     * Set the 'DisplayType' element value.
                     * 
                     * @param displayType
                     */
                    public void setDisplayType(DisplayType displayType) {
                        this.displayType = displayType;
                    }

                    /** 
                     * Get the 'FareBasis' element value.
                     * 
                     * @return value
                     */
                    public FareBasis getFareBasis() {
                        return fareBasis;
                    }

                    /** 
                     * Set the 'FareBasis' element value.
                     * 
                     * @param fareBasis
                     */
                    public void setFareBasis(FareBasis fareBasis) {
                        this.fareBasis = fareBasis;
                    }

                    /** 
                     * Get the 'FareVendor' element value.
                     * 
                     * @return value
                     */
                    public String getFareVendor() {
                        return fareVendor;
                    }

                    /** 
                     * Set the 'FareVendor' element value.
                     * 
                     * @param fareVendor
                     */
                    public void setFareVendor(String fareVendor) {
                        this.fareVendor = fareVendor;
                    }

                    /** 
                     * Get the 'Text' element value.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DisplayType" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class DisplayType implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasis" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FareBasis implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareTypeLine" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="FareDescription" minOccurs="0">
                 *         &lt;!-- Reference to inner class FareDescription -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="FareType" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareTypeLine implements Serializable
                {
                    private FareDescription fareDescription;
                    private String fareType;

                    /** 
                     * Get the 'FareDescription' element value.
                     * 
                     * @return value
                     */
                    public FareDescription getFareDescription() {
                        return fareDescription;
                    }

                    /** 
                     * Set the 'FareDescription' element value.
                     * 
                     * @param fareDescription
                     */
                    public void setFareDescription(
                            FareDescription fareDescription) {
                        this.fareDescription = fareDescription;
                    }

                    /** 
                     * Get the 'FareType' element value.
                     * 
                     * @return value
                     */
                    public String getFareType() {
                        return fareType;
                    }

                    /** 
                     * Set the 'FareType' element value.
                     * 
                     * @param fareType
                     */
                    public void setFareType(String fareType) {
                        this.fareType = fareType;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareDescription" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:simpleContent>
                     *       &lt;xs:extension base="xs:string">
                     *         &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *       &lt;/xs:extension>
                     *     &lt;/xs:simpleContent>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FareDescription implements Serializable
                    {
                        private String string;
                        private String code;

                        /** 
                         * Get the extension value.
                         * 
                         * @return value
                         */
                        public String getString() {
                            return string;
                        }

                        /** 
                         * Set the extension value.
                         * 
                         * @param string
                         */
                        public void setString(String string) {
                            this.string = string;
                        }

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FootnoteLine" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Footnotes" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FootnoteLine implements Serializable
                {
                    private String footnotes;

                    /** 
                     * Get the 'Footnotes' element value.
                     * 
                     * @return value
                     */
                    public String getFootnotes() {
                        return footnotes;
                    }

                    /** 
                     * Set the 'Footnotes' element value.
                     * 
                     * @param footnotes
                     */
                    public void setFootnotes(String footnotes) {
                        this.footnotes = footnotes;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationLine" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Airline" minOccurs="0">
                 *         &lt;!-- Reference to inner class Airline -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="DestinationLocation" minOccurs="0">
                 *         &lt;!-- Reference to inner class DestinationLocation -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="OriginLocation" minOccurs="0">
                 *         &lt;!-- Reference to inner class OriginLocation -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="xs:string" name="Rule" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="TariffDescriptionNumber" minOccurs="0"/>
                 *       &lt;xs:element type="xs:date" name="TravelDate" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OriginDestinationLine implements
                    Serializable
                {
                    private Airline airline;
                    private DestinationLocation destinationLocation;
                    private OriginLocation originLocation;
                    private String rule;
                    private String tariffDescriptionNumber;
                    private Date travelDate;

                    /** 
                     * Get the 'Airline' element value.
                     * 
                     * @return value
                     */
                    public Airline getAirline() {
                        return airline;
                    }

                    /** 
                     * Set the 'Airline' element value.
                     * 
                     * @param airline
                     */
                    public void setAirline(Airline airline) {
                        this.airline = airline;
                    }

                    /** 
                     * Get the 'DestinationLocation' element value.
                     * 
                     * @return value
                     */
                    public DestinationLocation getDestinationLocation() {
                        return destinationLocation;
                    }

                    /** 
                     * Set the 'DestinationLocation' element value.
                     * 
                     * @param destinationLocation
                     */
                    public void setDestinationLocation(
                            DestinationLocation destinationLocation) {
                        this.destinationLocation = destinationLocation;
                    }

                    /** 
                     * Get the 'OriginLocation' element value.
                     * 
                     * @return value
                     */
                    public OriginLocation getOriginLocation() {
                        return originLocation;
                    }

                    /** 
                     * Set the 'OriginLocation' element value.
                     * 
                     * @param originLocation
                     */
                    public void setOriginLocation(OriginLocation originLocation) {
                        this.originLocation = originLocation;
                    }

                    /** 
                     * Get the 'Rule' element value.
                     * 
                     * @return value
                     */
                    public String getRule() {
                        return rule;
                    }

                    /** 
                     * Set the 'Rule' element value.
                     * 
                     * @param rule
                     */
                    public void setRule(String rule) {
                        this.rule = rule;
                    }

                    /** 
                     * Get the 'TariffDescriptionNumber' element value.
                     * 
                     * @return value
                     */
                    public String getTariffDescriptionNumber() {
                        return tariffDescriptionNumber;
                    }

                    /** 
                     * Set the 'TariffDescriptionNumber' element value.
                     * 
                     * @param tariffDescriptionNumber
                     */
                    public void setTariffDescriptionNumber(
                            String tariffDescriptionNumber) {
                        this.tariffDescriptionNumber = tariffDescriptionNumber;
                    }

                    /** 
                     * Get the 'TravelDate' element value.
                     * 
                     * @return value
                     */
                    public Date getTravelDate() {
                        return travelDate;
                    }

                    /** 
                     * Set the 'TravelDate' element value.
                     * 
                     * @param travelDate
                     */
                    public void setTravelDate(Date travelDate) {
                        this.travelDate = travelDate;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Airline implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class DestinationLocation implements
                        Serializable
                    {
                        private String locationCode;

                        /** 
                         * Get the 'LocationCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getLocationCode() {
                            return locationCode;
                        }

                        /** 
                         * Set the 'LocationCode' attribute value.
                         * 
                         * @param locationCode
                         */
                        public void setLocationCode(String locationCode) {
                            this.locationCode = locationCode;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class OriginLocation implements Serializable
                    {
                        private String locationCode;

                        /** 
                         * Get the 'LocationCode' attribute value.
                         * 
                         * @return value
                         */
                        public String getLocationCode() {
                            return locationCode;
                        }

                        /** 
                         * Set the 'LocationCode' attribute value.
                         * 
                         * @param locationCode
                         */
                        public void setLocationCode(String locationCode) {
                            this.locationCode = locationCode;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeLine" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="AutoPrice" minOccurs="0"/>
                 *       &lt;xs:element name="PassengerType" minOccurs="0" maxOccurs="5">
                 *         &lt;!-- Reference to inner class PassengerType -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PassengerTypeLine implements Serializable
                {
                    private String autoPrice;
                    private List<PassengerType> passengerTypeList = new ArrayList<PassengerType>();

                    /** 
                     * Get the 'AutoPrice' element value.
                     * 
                     * @return value
                     */
                    public String getAutoPrice() {
                        return autoPrice;
                    }

                    /** 
                     * Set the 'AutoPrice' element value.
                     * 
                     * @param autoPrice
                     */
                    public void setAutoPrice(String autoPrice) {
                        this.autoPrice = autoPrice;
                    }

                    /** 
                     * Get the list of 'PassengerType' element items.
                     * 
                     * @return list
                     */
                    public List<PassengerType> getPassengerTypeList() {
                        return passengerTypeList;
                    }

                    /** 
                     * Set the list of 'PassengerType' element items.
                     * 
                     * @param list
                     */
                    public void setPassengerTypeList(List<PassengerType> list) {
                        passengerTypeList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerType" minOccurs="0" maxOccurs="5">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class PassengerType implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SITA_Line" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="DBE_Code" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="FareQuality" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="RouteCode" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="TariffFamily" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SITALine implements Serializable
                {
                    private String DBECode;
                    private String fareQuality;
                    private String routeCode;
                    private String tariffFamily;

                    /** 
                     * Get the 'DBE_Code' element value.
                     * 
                     * @return value
                     */
                    public String getDBECode() {
                        return DBECode;
                    }

                    /** 
                     * Set the 'DBE_Code' element value.
                     * 
                     * @param DBECode
                     */
                    public void setDBECode(String DBECode) {
                        this.DBECode = DBECode;
                    }

                    /** 
                     * Get the 'FareQuality' element value.
                     * 
                     * @return value
                     */
                    public String getFareQuality() {
                        return fareQuality;
                    }

                    /** 
                     * Set the 'FareQuality' element value.
                     * 
                     * @param fareQuality
                     */
                    public void setFareQuality(String fareQuality) {
                        this.fareQuality = fareQuality;
                    }

                    /** 
                     * Get the 'RouteCode' element value.
                     * 
                     * @return value
                     */
                    public String getRouteCode() {
                        return routeCode;
                    }

                    /** 
                     * Set the 'RouteCode' element value.
                     * 
                     * @param routeCode
                     */
                    public void setRouteCode(String routeCode) {
                        this.routeCode = routeCode;
                    }

                    /** 
                     * Get the 'TariffFamily' element value.
                     * 
                     * @return value
                     */
                    public String getTariffFamily() {
                        return tariffFamily;
                    }

                    /** 
                     * Set the 'TariffFamily' element value.
                     * 
                     * @param tariffFamily
                     */
                    public void setTariffFamily(String tariffFamily) {
                        this.tariffFamily = tariffFamily;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SystemDatesLine" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="CreateDateTime" minOccurs="0"/>
                 *       &lt;xs:element type="xs:string" name="ExpireDateTime" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class SystemDatesLine implements Serializable
                {
                    private String createDateTime;
                    private String expireDateTime;

                    /** 
                     * Get the 'CreateDateTime' element value.
                     * 
                     * @return value
                     */
                    public String getCreateDateTime() {
                        return createDateTime;
                    }

                    /** 
                     * Set the 'CreateDateTime' element value.
                     * 
                     * @param createDateTime
                     */
                    public void setCreateDateTime(String createDateTime) {
                        this.createDateTime = createDateTime;
                    }

                    /** 
                     * Get the 'ExpireDateTime' element value.
                     * 
                     * @return value
                     */
                    public String getExpireDateTime() {
                        return expireDateTime;
                    }

                    /** 
                     * Set the 'ExpireDateTime' element value.
                     * 
                     * @param expireDateTime
                     */
                    public void setExpireDateTime(String expireDateTime) {
                        this.expireDateTime = expireDateTime;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rules" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Paragraph" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Paragraph -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Rules implements Serializable
        {
            private List<Paragraph> paragraphList = new ArrayList<Paragraph>();

            /** 
             * Get the list of 'Paragraph' element items.
             * 
             * @return list
             */
            public List<Paragraph> getParagraphList() {
                return paragraphList;
            }

            /** 
             * Set the list of 'Paragraph' element items.
             * 
             * @param list
             */
            public void setParagraphList(List<Paragraph> list) {
                paragraphList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Paragraph" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Title"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Paragraph implements Serializable
            {
                private String text;
                private String RPH;
                private String title;

                /** 
                 * Get the 'Text' element value.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'RPH' attribute value.
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value.
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }

                /** 
                 * Get the 'Title' attribute value.
                 * 
                 * @return value
                 */
                public String getTitle() {
                    return title;
                }

                /** 
                 * Set the 'Title' attribute value.
                 * 
                 * @param title
                 */
                public void setTitle(String title) {
                    this.title = title;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoutingInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RoutingInfo implements Serializable
    {
        private String text;

        /** 
         * Get the 'Text' element value.
         * 
         * @return value
         */
        public String getText() {
            return text;
        }

        /** 
         * Set the 'Text' element value.
         * 
         * @param text
         */
        public void setText(String text) {
            this.text = text;
        }
    }
}
