
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SabreCommandLLSRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Request">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element type="xs:string" name="HostCommand"/>
 *           &lt;/xs:sequence>
 *           &lt;xs:attribute type="xs:string" use="optional" name="CDATA"/>
 *           &lt;xs:attribute type="xs:string" use="optional" name="MDRSubset"/>
 *           &lt;xs:attribute use="optional" name="Output">
 *             &lt;xs:simpleType>
 *               &lt;!-- Reference to inner class Output -->
 *             &lt;/xs:simpleType>
 *           &lt;/xs:attribute>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="optional" fixed="2.0.0" name="Version"/>
 *     &lt;xs:attribute type="xs:integer" use="optional" name="NumResponses"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreCommandLLSRQ implements Serializable
{
    private String requestHostCommand;
    private String requestCDATA;
    private String requestMDRSubset;
    private Output requestOutput;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;
    private BigInteger numResponses;

    /** 
     * Get the 'HostCommand' element value.
     * 
     * @return value
     */
    public String getRequestHostCommand() {
        return requestHostCommand;
    }

    /** 
     * Set the 'HostCommand' element value.
     * 
     * @param requestHostCommand
     */
    public void setRequestHostCommand(String requestHostCommand) {
        this.requestHostCommand = requestHostCommand;
    }

    /** 
     * Get the 'CDATA' attribute value.
     * 
     * @return value
     */
    public String getRequestCDATA() {
        return requestCDATA;
    }

    /** 
     * Set the 'CDATA' attribute value.
     * 
     * @param requestCDATA
     */
    public void setRequestCDATA(String requestCDATA) {
        this.requestCDATA = requestCDATA;
    }

    /** 
     * Get the 'MDRSubset' attribute value.
     * 
     * @return value
     */
    public String getRequestMDRSubset() {
        return requestMDRSubset;
    }

    /** 
     * Set the 'MDRSubset' attribute value.
     * 
     * @param requestMDRSubset
     */
    public void setRequestMDRSubset(String requestMDRSubset) {
        this.requestMDRSubset = requestMDRSubset;
    }

    /** 
     * Get the 'Output' attribute value.
     * 
     * @return value
     */
    public Output getRequestOutput() {
        return requestOutput;
    }

    /** 
     * Set the 'Output' attribute value.
     * 
     * @param requestOutput
     */
    public void setRequestOutput(Output requestOutput) {
        this.requestOutput = requestOutput;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'NumResponses' attribute value.
     * 
     * @return value
     */
    public BigInteger getNumResponses() {
        return numResponses;
    }

    /** 
     * Set the 'NumResponses' attribute value.
     * 
     * @param numResponses
     */
    public void setNumResponses(BigInteger numResponses) {
        this.numResponses = numResponses;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="SCREEN"/>
     *     &lt;xs:enumeration value="SDS"/>
     *     &lt;xs:enumeration value="SDSXML"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Output implements Serializable {
        SCREEN, SDS, SDSXML
    }
}
