
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Structure Fare Rules Response
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StructureFareRulesRS">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;!-- Reference to inner class Sequence -->
 *       &lt;/xs:sequence>
 *       &lt;xs:element ref="ns:DiagnosticInfos" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Errors" minOccurs="0"/>
 *     &lt;/xs:choice>
 *     &lt;xs:attribute type="xs:string" use="optional" name="EchoToken"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *     &lt;xs:attribute type="xs:integer" use="optional" name="SequenceNmbr"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="PrimaryLangID"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="AltLangID"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class StructureFareRulesRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int DIAGNOSTIC_INFOS_CHOICE = 1;
    private static final int ERRORS_CHOICE = 2;
    private Sequence success;
    private DiagnosticInfos diagnosticInfos;
    private Errors errors;
    private String echoToken;
    private String timeStamp;
    private Target target;
    private String version;
    private BigInteger sequenceNmbr;
    private String primaryLangID;
    private String altLangID;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getSuccess() {
        return success;
    }

    /** 
     * Set the sequence value.
     * 
     * @param success
     */
    public void setSuccess(Sequence success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Check if DiagnosticInfos is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDiagnosticInfos() {
        return choiceSelect == DIAGNOSTIC_INFOS_CHOICE;
    }

    /** 
     * Get the 'DiagnosticInfos' element value.
     * 
     * @return value
     */
    public DiagnosticInfos getDiagnosticInfos() {
        return diagnosticInfos;
    }

    /** 
     * Set the 'DiagnosticInfos' element value.
     * 
     * @param diagnosticInfos
     */
    public void setDiagnosticInfos(DiagnosticInfos diagnosticInfos) {
        setChoiceSelect(DIAGNOSTIC_INFOS_CHOICE);
        this.diagnosticInfos = diagnosticInfos;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public Errors getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(Errors errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'EchoToken' attribute value. 
    					A sequence number for additional message
    					identification, assigned by the requesting host
    					system. When a request message includes an echo
    					token the corresponding response message MUST
    					include an echo token with an identical value.
    				
     * 
     * @return value
     */
    public String getEchoToken() {
        return echoToken;
    }

    /** 
     * Set the 'EchoToken' attribute value. 
    					A sequence number for additional message
    					identification, assigned by the requesting host
    					system. When a request message includes an echo
    					token the corresponding response message MUST
    					include an echo token with an identical value.
    				
     * 
     * @param echoToken
     */
    public void setEchoToken(String echoToken) {
        this.echoToken = echoToken;
    }

    /** 
     * Get the 'TimeStamp' attribute value. 
    					Indicates the creation date and time of the
    					message in UTC using the following format
    					specified by ISO 8601; YYYY- MM- DDThh:mm:ssZ
    					with time values using the 24 hour clock (e.g.
    					20 November 2003, 1:59:38 pm UTC becomes
    					2003-11-20T13:59:38Z).
    				
     * 
     * @return value
     */
    public String getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. 
    					Indicates the creation date and time of the
    					message in UTC using the following format
    					specified by ISO 8601; YYYY- MM- DDThh:mm:ssZ
    					with time values using the 24 hour clock (e.g.
    					20 November 2003, 1:59:38 pm UTC becomes
    					2003-11-20T13:59:38Z).
    				
     * 
     * @param timeStamp
     */
    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. 
    					Used to indicate whether the request is for the
    					Test or Production system.
    				
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. 
    					Used to indicate whether the request is for the
    					Test or Production system.
    				
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. 
    					For all OTA versioned messages, the version of
    					the message is indicated by a decimal value.
    				
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. 
    					For all OTA versioned messages, the version of
    					the message is indicated by a decimal value.
    				
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'SequenceNmbr' attribute value. 
    					Used to identify the sequence number of the
    					transaction as assigned by the sending system;
    					allows for an application to process messages in
    					a certain order or to request a
    					resynchronization of messages in the event that
    					a system has been off-line and needs to retrieve
    					messages that were missed.
    				
     * 
     * @return value
     */
    public BigInteger getSequenceNmbr() {
        return sequenceNmbr;
    }

    /** 
     * Set the 'SequenceNmbr' attribute value. 
    					Used to identify the sequence number of the
    					transaction as assigned by the sending system;
    					allows for an application to process messages in
    					a certain order or to request a
    					resynchronization of messages in the event that
    					a system has been off-line and needs to retrieve
    					messages that were missed.
    				
     * 
     * @param sequenceNmbr
     */
    public void setSequenceNmbr(BigInteger sequenceNmbr) {
        this.sequenceNmbr = sequenceNmbr;
    }

    /** 
     * Get the 'PrimaryLangID' attribute value. 
    					Identifes the primary language preference for
    					the form of travel represented in a collection.
    					The human language is identified by ISO 639
    					codes.
    				
     * 
     * @return value
     */
    public String getPrimaryLangID() {
        return primaryLangID;
    }

    /** 
     * Set the 'PrimaryLangID' attribute value. 
    					Identifes the primary language preference for
    					the form of travel represented in a collection.
    					The human language is identified by ISO 639
    					codes.
    				
     * 
     * @param primaryLangID
     */
    public void setPrimaryLangID(String primaryLangID) {
        this.primaryLangID = primaryLangID;
    }

    /** 
     * Get the 'AltLangID' attribute value. 
    					Identifes the primary language preference for
    					the form of travel represented in a collection.
    					The human language is identified by ISO 639
    					codes.
    				
     * 
     * @return value
     */
    public String getAltLangID() {
        return altLangID;
    }

    /** 
     * Set the 'AltLangID' attribute value. 
    					Identifes the primary language preference for
    					the form of travel represented in a collection.
    					The human language is identified by ISO 639
    					codes.
    				
     * 
     * @param altLangID
     */
    public void setAltLangID(String altLangID) {
        this.altLangID = altLangID;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element type="xs:string" name="Success" minOccurs="0"/>
     *   &lt;xs:element name="Summary">
     *     &lt;xs:complexType>
     *       &lt;xs:sequence>
     *         &lt;xs:element name="Total">
     *           &lt;xs:complexType>
     *             &lt;xs:attribute type="xs:float" use="optional" name="Price"/>
     *             &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
     *           &lt;/xs:complexType>
     *         &lt;/xs:element>
     *         &lt;xs:element name="NetRemitTotal" minOccurs="0">
     *           &lt;!-- Reference to inner class NetRemitTotal -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="ConsolidatorPlusUp" minOccurs="0">
     *           &lt;!-- Reference to inner class ConsolidatorPlusUp -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="PurchaseSummary">
     *           &lt;xs:complexType>
     *             &lt;xs:attribute type="xs:string" use="required" name="IATASalesCode"/>
     *             &lt;xs:attribute type="xs:string" use="required" name="SalesLocation"/>
     *             &lt;xs:attribute type="xs:string" use="optional" name="TicketingLocation"/>
     *             &lt;xs:attribute type="xs:string" use="optional" name="AdvancePurchaseDate"/>
     *             &lt;xs:attribute type="xs:boolean" name="SimultaneousResInd"/>
     *             &lt;xs:attribute type="xs:boolean" name="NonRefundableInd"/>
     *             &lt;xs:attribute type="xs:string" use="optional" name="PurchaseByDate"/>
     *             &lt;xs:attribute type="xs:string" use="optional" name="LastTicketDateTime"/>
     *           &lt;/xs:complexType>
     *         &lt;/xs:element>
     *         &lt;xs:element name="ValidatingCarrier" minOccurs="0">
     *           &lt;!-- Reference to inner class ValidatingCarrier -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="ValidatingCarrierListInformation" minOccurs="0">
     *           &lt;!-- Reference to inner class ValidatingCarrierListInformation -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="PrivateFare" minOccurs="0">
     *           &lt;!-- Reference to inner class PrivateFare -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="Ancillaries" minOccurs="0">
     *           &lt;!-- Reference to inner class Ancillaries -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="FareCalcTooLong" minOccurs="0">
     *           &lt;!-- Reference to inner class FareCalcTooLong -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="PassengerDetails">
     *           &lt;xs:complexType>
     *             &lt;xs:sequence>
     *               &lt;xs:element name="PassengerDetail" maxOccurs="4">
     *                 &lt;!-- Reference to inner class PassengerDetail -->
     *               &lt;/xs:element>
     *             &lt;/xs:sequence>
     *           &lt;/xs:complexType>
     *         &lt;/xs:element>
     *       &lt;/xs:sequence>
     *     &lt;/xs:complexType>
     *   &lt;/xs:element>
     *   &lt;xs:element name="Warnings" minOccurs="0">
     *     &lt;!-- Reference to inner class Warnings -->
     *   &lt;/xs:element>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private String success;
        private Float summaryTotalPrice;
        private String summaryTotalCurrencyCode;
        private NetRemitTotal netRemitTotal;
        private ConsolidatorPlusUp consolidatorPlusUp;
        private String summaryPurchaseSummaryIATASalesCode;
        private String summaryPurchaseSummarySalesLocation;
        private String summaryPurchaseSummaryTicketingLocation;
        private String summaryPurchaseSummaryAdvancePurchaseDate;
        private Boolean summaryPurchaseSummarySimultaneousResInd;
        private Boolean summaryPurchaseSummaryNonRefundableInd;
        private String summaryPurchaseSummaryPurchaseByDate;
        private String summaryPurchaseSummaryLastTicketDateTime;
        private ValidatingCarrier validatingCarrier;
        private ValidatingCarrierListInformation validatingCarrierListInformation;
        private PrivateFare privateFare;
        private Ancillaries ancillaries;
        private FareCalcTooLong fareCalcTooLong;
        private List<PassengerDetail> summaryPassengerDetailList = new ArrayList<PassengerDetail>();
        private Warnings warnings;

        /** 
         * Get the 'Success' element value.
         * 
         * @return value
         */
        public String getSuccess() {
            return success;
        }

        /** 
         * Set the 'Success' element value.
         * 
         * @param success
         */
        public void setSuccess(String success) {
            this.success = success;
        }

        /** 
         * Get the 'Price' attribute value. Total Price /SUM/@C56
         * 
         * @return value
         */
        public Float getSummaryTotalPrice() {
            return summaryTotalPrice;
        }

        /** 
         * Set the 'Price' attribute value. Total Price /SUM/@C56
         * 
         * @param summaryTotalPrice
         */
        public void setSummaryTotalPrice(Float summaryTotalPrice) {
            this.summaryTotalPrice = summaryTotalPrice;
        }

        /** 
         * Get the 'CurrencyCode' attribute value. Total Currency Code /SUM/@C40
         * 
         * @return value
         */
        public String getSummaryTotalCurrencyCode() {
            return summaryTotalCurrencyCode;
        }

        /** 
         * Set the 'CurrencyCode' attribute value. Total Currency Code /SUM/@C40
         * 
         * @param summaryTotalCurrencyCode
         */
        public void setSummaryTotalCurrencyCode(String summaryTotalCurrencyCode) {
            this.summaryTotalCurrencyCode = summaryTotalCurrencyCode;
        }

        /** 
         * Get the 'NetRemitTotal' element value.
         * 
         * @return value
         */
        public NetRemitTotal getNetRemitTotal() {
            return netRemitTotal;
        }

        /** 
         * Set the 'NetRemitTotal' element value.
         * 
         * @param netRemitTotal
         */
        public void setNetRemitTotal(NetRemitTotal netRemitTotal) {
            this.netRemitTotal = netRemitTotal;
        }

        /** 
         * Get the 'ConsolidatorPlusUp' element value.
         * 
         * @return value
         */
        public ConsolidatorPlusUp getConsolidatorPlusUp() {
            return consolidatorPlusUp;
        }

        /** 
         * Set the 'ConsolidatorPlusUp' element value.
         * 
         * @param consolidatorPlusUp
         */
        public void setConsolidatorPlusUp(ConsolidatorPlusUp consolidatorPlusUp) {
            this.consolidatorPlusUp = consolidatorPlusUp;
        }

        /** 
         * Get the 'IATASalesCode' attribute value.  /SUM/@S69
         * 
         * @return value
         */
        public String getSummaryPurchaseSummaryIATASalesCode() {
            return summaryPurchaseSummaryIATASalesCode;
        }

        /** 
         * Set the 'IATASalesCode' attribute value.  /SUM/@S69
         * 
         * @param summaryPurchaseSummaryIATASalesCode
         */
        public void setSummaryPurchaseSummaryIATASalesCode(
                String summaryPurchaseSummaryIATASalesCode) {
            this.summaryPurchaseSummaryIATASalesCode = summaryPurchaseSummaryIATASalesCode;
        }

        /** 
         * Get the 'SalesLocation' attribute value.  /SUM/@AO0
         * 
         * @return value
         */
        public String getSummaryPurchaseSummarySalesLocation() {
            return summaryPurchaseSummarySalesLocation;
        }

        /** 
         * Set the 'SalesLocation' attribute value.  /SUM/@AO0
         * 
         * @param summaryPurchaseSummarySalesLocation
         */
        public void setSummaryPurchaseSummarySalesLocation(
                String summaryPurchaseSummarySalesLocation) {
            this.summaryPurchaseSummarySalesLocation = summaryPurchaseSummarySalesLocation;
        }

        /** 
         * Get the 'TicketingLocation' attribute value.  /SUM/@AF0
         * 
         * @return value
         */
        public String getSummaryPurchaseSummaryTicketingLocation() {
            return summaryPurchaseSummaryTicketingLocation;
        }

        /** 
         * Set the 'TicketingLocation' attribute value.  /SUM/@AF0
         * 
         * @param summaryPurchaseSummaryTicketingLocation
         */
        public void setSummaryPurchaseSummaryTicketingLocation(
                String summaryPurchaseSummaryTicketingLocation) {
            this.summaryPurchaseSummaryTicketingLocation = summaryPurchaseSummaryTicketingLocation;
        }

        /** 
         * Get the 'AdvancePurchaseDate' attribute value. Advanced Purchase Date /SUM/@D14
         * 
         * @return value
         */
        public String getSummaryPurchaseSummaryAdvancePurchaseDate() {
            return summaryPurchaseSummaryAdvancePurchaseDate;
        }

        /** 
         * Set the 'AdvancePurchaseDate' attribute value. Advanced Purchase Date /SUM/@D14
         * 
         * @param summaryPurchaseSummaryAdvancePurchaseDate
         */
        public void setSummaryPurchaseSummaryAdvancePurchaseDate(
                String summaryPurchaseSummaryAdvancePurchaseDate) {
            this.summaryPurchaseSummaryAdvancePurchaseDate = summaryPurchaseSummaryAdvancePurchaseDate;
        }

        /** 
         * Get the 'SimultaneousResInd' attribute value.  /SUM/@PBC
         * 
         * @return value
         */
        public Boolean getSummaryPurchaseSummarySimultaneousResInd() {
            return summaryPurchaseSummarySimultaneousResInd;
        }

        /** 
         * Set the 'SimultaneousResInd' attribute value.  /SUM/@PBC
         * 
         * @param summaryPurchaseSummarySimultaneousResInd
         */
        public void setSummaryPurchaseSummarySimultaneousResInd(
                Boolean summaryPurchaseSummarySimultaneousResInd) {
            this.summaryPurchaseSummarySimultaneousResInd = summaryPurchaseSummarySimultaneousResInd;
        }

        /** 
         * Get the 'NonRefundableInd' attribute value.  /SUM/PXI/@P27
         * 
         * @return value
         */
        public Boolean getSummaryPurchaseSummaryNonRefundableInd() {
            return summaryPurchaseSummaryNonRefundableInd;
        }

        /** 
         * Set the 'NonRefundableInd' attribute value.  /SUM/PXI/@P27
         * 
         * @param summaryPurchaseSummaryNonRefundableInd
         */
        public void setSummaryPurchaseSummaryNonRefundableInd(
                Boolean summaryPurchaseSummaryNonRefundableInd) {
            this.summaryPurchaseSummaryNonRefundableInd = summaryPurchaseSummaryNonRefundableInd;
        }

        /** 
         * Get the 'PurchaseByDate' attribute value. Purchase By Date /SUM/@D16
         * 
         * @return value
         */
        public String getSummaryPurchaseSummaryPurchaseByDate() {
            return summaryPurchaseSummaryPurchaseByDate;
        }

        /** 
         * Set the 'PurchaseByDate' attribute value. Purchase By Date /SUM/@D16
         * 
         * @param summaryPurchaseSummaryPurchaseByDate
         */
        public void setSummaryPurchaseSummaryPurchaseByDate(
                String summaryPurchaseSummaryPurchaseByDate) {
            this.summaryPurchaseSummaryPurchaseByDate = summaryPurchaseSummaryPurchaseByDate;
        }

        /** 
         * Get the 'LastTicketDateTime' attribute value. Last Ticket Day /SUM/@D00 Last Ticket Time /SUM/@D60
         * 
         * @return value
         */
        public String getSummaryPurchaseSummaryLastTicketDateTime() {
            return summaryPurchaseSummaryLastTicketDateTime;
        }

        /** 
         * Set the 'LastTicketDateTime' attribute value. Last Ticket Day /SUM/@D00 Last Ticket Time /SUM/@D60
         * 
         * @param summaryPurchaseSummaryLastTicketDateTime
         */
        public void setSummaryPurchaseSummaryLastTicketDateTime(
                String summaryPurchaseSummaryLastTicketDateTime) {
            this.summaryPurchaseSummaryLastTicketDateTime = summaryPurchaseSummaryLastTicketDateTime;
        }

        /** 
         * Get the 'ValidatingCarrier' element value.
         * 
         * @return value
         */
        public ValidatingCarrier getValidatingCarrier() {
            return validatingCarrier;
        }

        /** 
         * Set the 'ValidatingCarrier' element value.
         * 
         * @param validatingCarrier
         */
        public void setValidatingCarrier(ValidatingCarrier validatingCarrier) {
            this.validatingCarrier = validatingCarrier;
        }

        /** 
         * Get the 'ValidatingCarrierListInformation' element value.
         * 
         * @return value
         */
        public ValidatingCarrierListInformation getValidatingCarrierListInformation() {
            return validatingCarrierListInformation;
        }

        /** 
         * Set the 'ValidatingCarrierListInformation' element value.
         * 
         * @param validatingCarrierListInformation
         */
        public void setValidatingCarrierListInformation(
                ValidatingCarrierListInformation validatingCarrierListInformation) {
            this.validatingCarrierListInformation = validatingCarrierListInformation;
        }

        /** 
         * Get the 'PrivateFare' element value.
         * 
         * @return value
         */
        public PrivateFare getPrivateFare() {
            return privateFare;
        }

        /** 
         * Set the 'PrivateFare' element value.
         * 
         * @param privateFare
         */
        public void setPrivateFare(PrivateFare privateFare) {
            this.privateFare = privateFare;
        }

        /** 
         * Get the 'Ancillaries' element value.
         * 
         * @return value
         */
        public Ancillaries getAncillaries() {
            return ancillaries;
        }

        /** 
         * Set the 'Ancillaries' element value.
         * 
         * @param ancillaries
         */
        public void setAncillaries(Ancillaries ancillaries) {
            this.ancillaries = ancillaries;
        }

        /** 
         * Get the 'FareCalcTooLong' element value.
         * 
         * @return value
         */
        public FareCalcTooLong getFareCalcTooLong() {
            return fareCalcTooLong;
        }

        /** 
         * Set the 'FareCalcTooLong' element value.
         * 
         * @param fareCalcTooLong
         */
        public void setFareCalcTooLong(FareCalcTooLong fareCalcTooLong) {
            this.fareCalcTooLong = fareCalcTooLong;
        }

        /** 
         * Get the list of 'PassengerDetail' element items.
         * 
         * @return list
         */
        public List<PassengerDetail> getSummaryPassengerDetailList() {
            return summaryPassengerDetailList;
        }

        /** 
         * Set the list of 'PassengerDetail' element items.
         * 
         * @param list
         */
        public void setSummaryPassengerDetailList(List<PassengerDetail> list) {
            summaryPassengerDetailList = list;
        }

        /** 
         * Get the 'Warnings' element value.
         * 
         * @return value
         */
        public Warnings getWarnings() {
            return warnings;
        }

        /** 
         * Set the 'Warnings' element value.
         * 
         * @param warnings
         */
        public void setWarnings(Warnings warnings) {
            this.warnings = warnings;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemitTotal" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Price"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NetRemitTotal implements Serializable
        {
            private Float price;

            /** 
             * Get the 'Price' attribute value. Net Remit Total Price /SUM/@C51
             * 
             * @return value
             */
            public Float getPrice() {
                return price;
            }

            /** 
             * Set the 'Price' attribute value. Net Remit Total Price /SUM/@C51
             * 
             * @param price
             */
            public void setPrice(Float price) {
                this.price = price;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConsolidatorPlusUp" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
         *     &lt;xs:attribute type="xs:float" use="optional" name="FareCalcAmount"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ConsolidatorPlusUp implements Serializable
        {
            private String currencyCode;
            private Float fareCalcAmount;

            /** 
             * Get the 'CurrencyCode' attribute value. Consolidator Plus Up Currency Code /SUM/@C74
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'CurrencyCode' attribute value. Consolidator Plus Up Currency Code /SUM/@C74
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }

            /** 
             * Get the 'FareCalcAmount' attribute value. Consolidator Plus Up Fare Calc Amount /SUM/@C6Z
             * 
             * @return value
             */
            public Float getFareCalcAmount() {
                return fareCalcAmount;
            }

            /** 
             * Set the 'FareCalcAmount' attribute value. Consolidator Plus Up Fare Calc Amount /SUM/@C6Z
             * 
             * @param fareCalcAmount
             */
            public void setFareCalcAmount(Float fareCalcAmount) {
                this.fareCalcAmount = fareCalcAmount;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrier" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ValidatingCarrier implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Validating Carrier /SUM/@B00
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Validating Carrier /SUM/@B00
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrierListInformation" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="DefaultValdatingCarrierInformation" minOccurs="0">
         *         &lt;!-- Reference to inner class DefaultValdatingCarrierInformation -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="AlternateValidatingCarrierInformation" minOccurs="0" maxOccurs="24">
         *         &lt;!-- Reference to inner class AlternateValidatingCarrierInformation -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" name="TFRRestricted"/>
         *     &lt;xs:attribute type="xs:string" name="SettlementMethod"/>
         *     &lt;xs:attribute type="xs:string" name="ValidatingCarrierProcess"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ValidatingCarrierListInformation implements
            Serializable
        {
            private DefaultValdatingCarrierInformation defaultValdatingCarrierInformation;
            private List<AlternateValidatingCarrierInformation> alternateValidatingCarrierInformationList = new ArrayList<AlternateValidatingCarrierInformation>();
            private String TFRRestricted;
            private String settlementMethod;
            private String validatingCarrierProcess;

            /** 
             * Get the 'DefaultValdatingCarrierInformation' element value.
             * 
             * @return value
             */
            public DefaultValdatingCarrierInformation getDefaultValdatingCarrierInformation() {
                return defaultValdatingCarrierInformation;
            }

            /** 
             * Set the 'DefaultValdatingCarrierInformation' element value.
             * 
             * @param defaultValdatingCarrierInformation
             */
            public void setDefaultValdatingCarrierInformation(
                    DefaultValdatingCarrierInformation defaultValdatingCarrierInformation) {
                this.defaultValdatingCarrierInformation = defaultValdatingCarrierInformation;
            }

            /** 
             * Get the list of 'AlternateValidatingCarrierInformation' element items.
             * 
             * @return list
             */
            public List<AlternateValidatingCarrierInformation> getAlternateValidatingCarrierInformationList() {
                return alternateValidatingCarrierInformationList;
            }

            /** 
             * Set the list of 'AlternateValidatingCarrierInformation' element items.
             * 
             * @param list
             */
            public void setAlternateValidatingCarrierInformationList(
                    List<AlternateValidatingCarrierInformation> list) {
                alternateValidatingCarrierInformationList = list;
            }

            /** 
             * Get the 'TFRRestricted' attribute value. VCL/P3L
             * 
             * @return value
             */
            public String getTFRRestricted() {
                return TFRRestricted;
            }

            /** 
             * Set the 'TFRRestricted' attribute value. VCL/P3L
             * 
             * @param TFRRestricted
             */
            public void setTFRRestricted(String TFRRestricted) {
                this.TFRRestricted = TFRRestricted;
            }

            /** 
             * Get the 'SettlementMethod' attribute value. VCL/SM0
             * 
             * @return value
             */
            public String getSettlementMethod() {
                return settlementMethod;
            }

            /** 
             * Set the 'SettlementMethod' attribute value. VCL/SM0
             * 
             * @param settlementMethod
             */
            public void setSettlementMethod(String settlementMethod) {
                this.settlementMethod = settlementMethod;
            }

            /** 
             * Get the 'ValidatingCarrierProcess' attribute value. VCL/VC0
             * 
             * @return value
             */
            public String getValidatingCarrierProcess() {
                return validatingCarrierProcess;
            }

            /** 
             * Set the 'ValidatingCarrierProcess' attribute value. VCL/VC0
             * 
             * @param validatingCarrierProcess
             */
            public void setValidatingCarrierProcess(
                    String validatingCarrierProcess) {
                this.validatingCarrierProcess = validatingCarrierProcess;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DefaultValdatingCarrierInformation" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ParticipatingCarrierInformation" minOccurs="1" maxOccurs="23">
             *         &lt;!-- Reference to inner class ParticipatingCarrierInformation -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="ValidatingCarrierCode"/>
             *     &lt;xs:attribute type="xs:string" name="TicketingType"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DefaultValdatingCarrierInformation implements
                Serializable
            {
                private List<ParticipatingCarrierInformation> participatingCarrierInformationList = new ArrayList<ParticipatingCarrierInformation>();
                private String validatingCarrierCode;
                private String ticketingType;

                /** 
                 * Get the list of 'ParticipatingCarrierInformation' element items.
                 * 
                 * @return list
                 */
                public List<ParticipatingCarrierInformation> getParticipatingCarrierInformationList() {
                    return participatingCarrierInformationList;
                }

                /** 
                 * Set the list of 'ParticipatingCarrierInformation' element items.
                 * 
                 * @param list
                 */
                public void setParticipatingCarrierInformationList(
                        List<ParticipatingCarrierInformation> list) {
                    participatingCarrierInformationList = list;
                }

                /** 
                 * Get the 'ValidatingCarrierCode' attribute value. VCL/DCX/B00
                 * 
                 * @return value
                 */
                public String getValidatingCarrierCode() {
                    return validatingCarrierCode;
                }

                /** 
                 * Set the 'ValidatingCarrierCode' attribute value. VCL/DCX/B00
                 * 
                 * @param validatingCarrierCode
                 */
                public void setValidatingCarrierCode(
                        String validatingCarrierCode) {
                    this.validatingCarrierCode = validatingCarrierCode;
                }

                /** 
                 * Get the 'TicketingType' attribute value. VCL/DCX/TT0
                 * 
                 * @return value
                 */
                public String getTicketingType() {
                    return ticketingType;
                }

                /** 
                 * Set the 'TicketingType' attribute value. VCL/DCX/TT0
                 * 
                 * @param ticketingType
                 */
                public void setTicketingType(String ticketingType) {
                    this.ticketingType = ticketingType;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ParticipatingCarrierInformation" minOccurs="1" maxOccurs="23">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="ValidatingCarrierCode"/>
                 *     &lt;xs:attribute type="xs:string" name="AirlineInterlineAgreementTypeCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ParticipatingCarrierInformation implements
                    Serializable
                {
                    private String validatingCarrierCode;
                    private String airlineInterlineAgreementTypeCode;

                    /** 
                     * Get the 'ValidatingCarrierCode' attribute value. VCL/DCX/PCX/B00
                     * 
                     * @return value
                     */
                    public String getValidatingCarrierCode() {
                        return validatingCarrierCode;
                    }

                    /** 
                     * Set the 'ValidatingCarrierCode' attribute value. VCL/DCX/PCX/B00
                     * 
                     * @param validatingCarrierCode
                     */
                    public void setValidatingCarrierCode(
                            String validatingCarrierCode) {
                        this.validatingCarrierCode = validatingCarrierCode;
                    }

                    /** 
                     * Get the 'AirlineInterlineAgreementTypeCode' attribute value. VCL/DCX/PCX/VC1
                     * 
                     * @return value
                     */
                    public String getAirlineInterlineAgreementTypeCode() {
                        return airlineInterlineAgreementTypeCode;
                    }

                    /** 
                     * Set the 'AirlineInterlineAgreementTypeCode' attribute value. VCL/DCX/PCX/VC1
                     * 
                     * @param airlineInterlineAgreementTypeCode
                     */
                    public void setAirlineInterlineAgreementTypeCode(
                            String airlineInterlineAgreementTypeCode) {
                        this.airlineInterlineAgreementTypeCode = airlineInterlineAgreementTypeCode;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateValidatingCarrierInformation" minOccurs="0" maxOccurs="24">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ParticipatingCarrierInformation" minOccurs="1" maxOccurs="23">
             *         &lt;!-- Reference to inner class ParticipatingCarrierInformation -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="ValidatingCarrierCode"/>
             *     &lt;xs:attribute type="xs:string" name="TicketingType"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AlternateValidatingCarrierInformation implements
                Serializable
            {
                private List<ParticipatingCarrierInformation> participatingCarrierInformationList = new ArrayList<ParticipatingCarrierInformation>();
                private String validatingCarrierCode;
                private String ticketingType;

                /** 
                 * Get the list of 'ParticipatingCarrierInformation' element items.
                 * 
                 * @return list
                 */
                public List<ParticipatingCarrierInformation> getParticipatingCarrierInformationList() {
                    return participatingCarrierInformationList;
                }

                /** 
                 * Set the list of 'ParticipatingCarrierInformation' element items.
                 * 
                 * @param list
                 */
                public void setParticipatingCarrierInformationList(
                        List<ParticipatingCarrierInformation> list) {
                    participatingCarrierInformationList = list;
                }

                /** 
                 * Get the 'ValidatingCarrierCode' attribute value. VCL/DCX/B00
                 * 
                 * @return value
                 */
                public String getValidatingCarrierCode() {
                    return validatingCarrierCode;
                }

                /** 
                 * Set the 'ValidatingCarrierCode' attribute value. VCL/DCX/B00
                 * 
                 * @param validatingCarrierCode
                 */
                public void setValidatingCarrierCode(
                        String validatingCarrierCode) {
                    this.validatingCarrierCode = validatingCarrierCode;
                }

                /** 
                 * Get the 'TicketingType' attribute value. VCL/DCX/TT0
                 * 
                 * @return value
                 */
                public String getTicketingType() {
                    return ticketingType;
                }

                /** 
                 * Set the 'TicketingType' attribute value. VCL/DCX/TT0
                 * 
                 * @param ticketingType
                 */
                public void setTicketingType(String ticketingType) {
                    this.ticketingType = ticketingType;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ParticipatingCarrierInformation" minOccurs="1" maxOccurs="23">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="ValidatingCarrierCode"/>
                 *     &lt;xs:attribute type="xs:string" name="AirlineInterlineAgreementTypeCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ParticipatingCarrierInformation implements
                    Serializable
                {
                    private String validatingCarrierCode;
                    private String airlineInterlineAgreementTypeCode;

                    /** 
                     * Get the 'ValidatingCarrierCode' attribute value. VCL/DCX/PCX/B00
                     * 
                     * @return value
                     */
                    public String getValidatingCarrierCode() {
                        return validatingCarrierCode;
                    }

                    /** 
                     * Set the 'ValidatingCarrierCode' attribute value. VCL/DCX/PCX/B00
                     * 
                     * @param validatingCarrierCode
                     */
                    public void setValidatingCarrierCode(
                            String validatingCarrierCode) {
                        this.validatingCarrierCode = validatingCarrierCode;
                    }

                    /** 
                     * Get the 'AirlineInterlineAgreementTypeCode' attribute value. VCL/DCX/PCX/VC1
                     * 
                     * @return value
                     */
                    public String getAirlineInterlineAgreementTypeCode() {
                        return airlineInterlineAgreementTypeCode;
                    }

                    /** 
                     * Set the 'AirlineInterlineAgreementTypeCode' attribute value. VCL/DCX/PCX/VC1
                     * 
                     * @param airlineInterlineAgreementTypeCode
                     */
                    public void setAirlineInterlineAgreementTypeCode(
                            String airlineInterlineAgreementTypeCode) {
                        this.airlineInterlineAgreementTypeCode = airlineInterlineAgreementTypeCode;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrivateFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PrivateFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Private Fare Indication /SUM/@PAR
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Private Fare Indication /SUM/@PAR
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Ancillaries" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="NotGuaranteedInd"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Ancillaries implements Serializable
        {
            private Boolean notGuaranteedInd;

            /** 
             * Get the 'NotGuaranteedInd' attribute value. Ancillaries NonGuarantee Indicator /SUM/@ANG
             * 
             * @return value
             */
            public Boolean getNotGuaranteedInd() {
                return notGuaranteedInd;
            }

            /** 
             * Set the 'NotGuaranteedInd' attribute value. Ancillaries NonGuarantee Indicator /SUM/@ANG
             * 
             * @param notGuaranteedInd
             */
            public void setNotGuaranteedInd(Boolean notGuaranteedInd) {
                this.notGuaranteedInd = notGuaranteedInd;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalcTooLong" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareCalcTooLong implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Fare Calc Too Long /SUM/@P3J
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Fare Calc Too Long /SUM/@P3J
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerDetail" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:all minOccurs="0">
         *       &lt;!-- Reference to inner class All -->
         *     &lt;/xs:all>
         *     &lt;xs:attribute type="xs:string" use="required" name="PassengerTypeCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerDetail implements Serializable
        {
            private All all;
            private String passengerTypeCode;

            /** 
             * Get the all value.
             * 
             * @return value
             */
            public All getAll() {
                return all;
            }

            /** 
             * Set the all value.
             * 
             * @param all
             */
            public void setAll(All all) {
                this.all = all;
            }

            /** 
             * Get the 'PassengerTypeCode' attribute value.  
             * 
             * @return value
             */
            public String getPassengerTypeCode() {
                return passengerTypeCode;
            }

            /** 
             * Set the 'PassengerTypeCode' attribute value.  
             * 
             * @param passengerTypeCode
             */
            public void setPassengerTypeCode(String passengerTypeCode) {
                this.passengerTypeCode = passengerTypeCode;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:all xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
             *   &lt;xs:element name="Endorsements" minOccurs="0">
             *     &lt;!-- Reference to inner class Endorsements -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="Warnings" minOccurs="0">
             *     &lt;!-- Reference to inner class Warnings -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="TicketingRestriction" minOccurs="0">
             *     &lt;!-- Reference to inner class TicketingRestriction -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="PrivateFare" minOccurs="0">
             *     &lt;!-- Reference to inner class PrivateFare -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="PassengerFare" minOccurs="0">
             *     &lt;!-- Reference to inner class PassengerFare -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="TicketFareVendor" minOccurs="0">
             *     &lt;!-- Reference to inner class TicketFareVendor -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="AccompaniedTravelData" minOccurs="0">
             *     &lt;!-- Reference to inner class AccompaniedTravelData -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="OptionNumber" minOccurs="0">
             *     &lt;!-- Reference to inner class OptionNumber -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="ExchangeRateOne" minOccurs="0">
             *     &lt;!-- Reference to inner class ExchangeRateOne -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="Cat35" minOccurs="0">
             *     &lt;!-- Reference to inner class Cat35 -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="TextBox" minOccurs="0">
             *     &lt;!-- Reference to inner class TextBox -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="TourCode" minOccurs="0">
             *     &lt;!-- Reference to inner class TourCode -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="NetGross" minOccurs="0">
             *     &lt;!-- Reference to inner class NetGross -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="BSP" minOccurs="0">
             *     &lt;!-- Reference to inner class BSP -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="NetFare" minOccurs="0">
             *     &lt;!-- Reference to inner class NetFare -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="PaxFarePassenger" minOccurs="0">
             *     &lt;!-- Reference to inner class PaxFarePassenger -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="ValueCode" minOccurs="0">
             *     &lt;!-- Reference to inner class ValueCode -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="PrintOption" minOccurs="0">
             *     &lt;!-- Reference to inner class PrintOption -->
             *   &lt;/xs:element>
             *   &lt;xs:element name="TicketingSegmentFee" minOccurs="0">
             *     &lt;!-- Reference to inner class TicketingSegmentFee -->
             *   &lt;/xs:element>
             *   &lt;xs:element type="ns:PENResponseType" name="PenaltiesInfo" minOccurs="1"/>
             *   &lt;xs:element name="FareComponentDataList" minOccurs="1" maxOccurs="1">
             *     &lt;xs:complexType>
             *       &lt;xs:sequence>
             *         &lt;xs:element name="FareComponentData" minOccurs="1" maxOccurs="unbounded">
             *           &lt;!-- Reference to inner class FareComponentData -->
             *         &lt;/xs:element>
             *       &lt;/xs:sequence>
             *     &lt;/xs:complexType>
             *   &lt;/xs:element>
             *   &lt;xs:element name="PricingUnitDataList" minOccurs="1" maxOccurs="1">
             *     &lt;xs:complexType>
             *       &lt;xs:sequence>
             *         &lt;xs:element name="PricingUnitData" minOccurs="1" maxOccurs="unbounded">
             *           &lt;!-- Reference to inner class PricingUnitData -->
             *         &lt;/xs:element>
             *       &lt;/xs:sequence>
             *     &lt;/xs:complexType>
             *   &lt;/xs:element>
             *   &lt;xs:element name="JourneyLevelDataList" minOccurs="0" maxOccurs="1">
             *     &lt;!-- Reference to inner class JourneyLevelDataList -->
             *   &lt;/xs:element>
             * &lt;/xs:all>
             * </pre>
             */
            public static class All implements Serializable
            {
                private Endorsements endorsements;
                private Warnings warnings;
                private TicketingRestriction ticketingRestriction;
                private PrivateFare privateFare;
                private PassengerFare passengerFare;
                private TicketFareVendor ticketFareVendor;
                private AccompaniedTravelData accompaniedTravelData;
                private OptionNumber optionNumber;
                private ExchangeRateOne exchangeRateOne;
                private Cat35 cat35;
                private TextBox textBox;
                private TourCode tourCode;
                private NetGross netGross;
                private BSP BSP1;
                private NetFare netFare;
                private PaxFarePassenger paxFarePassenger;
                private ValueCode valueCode;
                private PrintOption printOption;
                private TicketingSegmentFee ticketingSegmentFee;
                private PENResponseType penaltiesInfo;
                private List<FareComponentData> fareComponentDataList = new ArrayList<FareComponentData>();
                private List<PricingUnitData> pricingUnitDataList = new ArrayList<PricingUnitData>();
                private JourneyLevelDataList journeyLevelDataList;

                /** 
                 * Get the 'Endorsements' element value.
                 * 
                 * @return value
                 */
                public Endorsements getEndorsements() {
                    return endorsements;
                }

                /** 
                 * Set the 'Endorsements' element value.
                 * 
                 * @param endorsements
                 */
                public void setEndorsements(Endorsements endorsements) {
                    this.endorsements = endorsements;
                }

                /** 
                 * Get the 'Warnings' element value.
                 * 
                 * @return value
                 */
                public Warnings getWarnings() {
                    return warnings;
                }

                /** 
                 * Set the 'Warnings' element value.
                 * 
                 * @param warnings
                 */
                public void setWarnings(Warnings warnings) {
                    this.warnings = warnings;
                }

                /** 
                 * Get the 'TicketingRestriction' element value.
                 * 
                 * @return value
                 */
                public TicketingRestriction getTicketingRestriction() {
                    return ticketingRestriction;
                }

                /** 
                 * Set the 'TicketingRestriction' element value.
                 * 
                 * @param ticketingRestriction
                 */
                public void setTicketingRestriction(
                        TicketingRestriction ticketingRestriction) {
                    this.ticketingRestriction = ticketingRestriction;
                }

                /** 
                 * Get the 'PrivateFare' element value.
                 * 
                 * @return value
                 */
                public PrivateFare getPrivateFare() {
                    return privateFare;
                }

                /** 
                 * Set the 'PrivateFare' element value.
                 * 
                 * @param privateFare
                 */
                public void setPrivateFare(PrivateFare privateFare) {
                    this.privateFare = privateFare;
                }

                /** 
                 * Get the 'PassengerFare' element value.
                 * 
                 * @return value
                 */
                public PassengerFare getPassengerFare() {
                    return passengerFare;
                }

                /** 
                 * Set the 'PassengerFare' element value.
                 * 
                 * @param passengerFare
                 */
                public void setPassengerFare(PassengerFare passengerFare) {
                    this.passengerFare = passengerFare;
                }

                /** 
                 * Get the 'TicketFareVendor' element value.
                 * 
                 * @return value
                 */
                public TicketFareVendor getTicketFareVendor() {
                    return ticketFareVendor;
                }

                /** 
                 * Set the 'TicketFareVendor' element value.
                 * 
                 * @param ticketFareVendor
                 */
                public void setTicketFareVendor(
                        TicketFareVendor ticketFareVendor) {
                    this.ticketFareVendor = ticketFareVendor;
                }

                /** 
                 * Get the 'AccompaniedTravelData' element value.
                 * 
                 * @return value
                 */
                public AccompaniedTravelData getAccompaniedTravelData() {
                    return accompaniedTravelData;
                }

                /** 
                 * Set the 'AccompaniedTravelData' element value.
                 * 
                 * @param accompaniedTravelData
                 */
                public void setAccompaniedTravelData(
                        AccompaniedTravelData accompaniedTravelData) {
                    this.accompaniedTravelData = accompaniedTravelData;
                }

                /** 
                 * Get the 'OptionNumber' element value.
                 * 
                 * @return value
                 */
                public OptionNumber getOptionNumber() {
                    return optionNumber;
                }

                /** 
                 * Set the 'OptionNumber' element value.
                 * 
                 * @param optionNumber
                 */
                public void setOptionNumber(OptionNumber optionNumber) {
                    this.optionNumber = optionNumber;
                }

                /** 
                 * Get the 'ExchangeRateOne' element value.
                 * 
                 * @return value
                 */
                public ExchangeRateOne getExchangeRateOne() {
                    return exchangeRateOne;
                }

                /** 
                 * Set the 'ExchangeRateOne' element value.
                 * 
                 * @param exchangeRateOne
                 */
                public void setExchangeRateOne(ExchangeRateOne exchangeRateOne) {
                    this.exchangeRateOne = exchangeRateOne;
                }

                /** 
                 * Get the 'Cat35' element value.
                 * 
                 * @return value
                 */
                public Cat35 getCat35() {
                    return cat35;
                }

                /** 
                 * Set the 'Cat35' element value.
                 * 
                 * @param cat35
                 */
                public void setCat35(Cat35 cat35) {
                    this.cat35 = cat35;
                }

                /** 
                 * Get the 'TextBox' element value.
                 * 
                 * @return value
                 */
                public TextBox getTextBox() {
                    return textBox;
                }

                /** 
                 * Set the 'TextBox' element value.
                 * 
                 * @param textBox
                 */
                public void setTextBox(TextBox textBox) {
                    this.textBox = textBox;
                }

                /** 
                 * Get the 'TourCode' element value.
                 * 
                 * @return value
                 */
                public TourCode getTourCode() {
                    return tourCode;
                }

                /** 
                 * Set the 'TourCode' element value.
                 * 
                 * @param tourCode
                 */
                public void setTourCode(TourCode tourCode) {
                    this.tourCode = tourCode;
                }

                /** 
                 * Get the 'NetGross' element value.
                 * 
                 * @return value
                 */
                public NetGross getNetGross() {
                    return netGross;
                }

                /** 
                 * Set the 'NetGross' element value.
                 * 
                 * @param netGross
                 */
                public void setNetGross(NetGross netGross) {
                    this.netGross = netGross;
                }

                /** 
                 * Get the 'BSP' element value.
                 * 
                 * @return value
                 */
                public BSP getBSP1() {
                    return BSP1;
                }

                /** 
                 * Set the 'BSP' element value.
                 * 
                 * @param BSP1
                 */
                public void setBSP1(BSP BSP1) {
                    this.BSP1 = BSP1;
                }

                /** 
                 * Get the 'NetFare' element value.
                 * 
                 * @return value
                 */
                public NetFare getNetFare() {
                    return netFare;
                }

                /** 
                 * Set the 'NetFare' element value.
                 * 
                 * @param netFare
                 */
                public void setNetFare(NetFare netFare) {
                    this.netFare = netFare;
                }

                /** 
                 * Get the 'PaxFarePassenger' element value.
                 * 
                 * @return value
                 */
                public PaxFarePassenger getPaxFarePassenger() {
                    return paxFarePassenger;
                }

                /** 
                 * Set the 'PaxFarePassenger' element value.
                 * 
                 * @param paxFarePassenger
                 */
                public void setPaxFarePassenger(
                        PaxFarePassenger paxFarePassenger) {
                    this.paxFarePassenger = paxFarePassenger;
                }

                /** 
                 * Get the 'ValueCode' element value.
                 * 
                 * @return value
                 */
                public ValueCode getValueCode() {
                    return valueCode;
                }

                /** 
                 * Set the 'ValueCode' element value.
                 * 
                 * @param valueCode
                 */
                public void setValueCode(ValueCode valueCode) {
                    this.valueCode = valueCode;
                }

                /** 
                 * Get the 'PrintOption' element value.
                 * 
                 * @return value
                 */
                public PrintOption getPrintOption() {
                    return printOption;
                }

                /** 
                 * Set the 'PrintOption' element value.
                 * 
                 * @param printOption
                 */
                public void setPrintOption(PrintOption printOption) {
                    this.printOption = printOption;
                }

                /** 
                 * Get the 'TicketingSegmentFee' element value.
                 * 
                 * @return value
                 */
                public TicketingSegmentFee getTicketingSegmentFee() {
                    return ticketingSegmentFee;
                }

                /** 
                 * Set the 'TicketingSegmentFee' element value.
                 * 
                 * @param ticketingSegmentFee
                 */
                public void setTicketingSegmentFee(
                        TicketingSegmentFee ticketingSegmentFee) {
                    this.ticketingSegmentFee = ticketingSegmentFee;
                }

                /** 
                 * Get the 'PenaltiesInfo' element value.
                 * 
                 * @return value
                 */
                public PENResponseType getPenaltiesInfo() {
                    return penaltiesInfo;
                }

                /** 
                 * Set the 'PenaltiesInfo' element value.
                 * 
                 * @param penaltiesInfo
                 */
                public void setPenaltiesInfo(PENResponseType penaltiesInfo) {
                    this.penaltiesInfo = penaltiesInfo;
                }

                /** 
                 * Get the list of 'FareComponentData' element items.
                 * 
                 * @return list
                 */
                public List<FareComponentData> getFareComponentDataList() {
                    return fareComponentDataList;
                }

                /** 
                 * Set the list of 'FareComponentData' element items.
                 * 
                 * @param list
                 */
                public void setFareComponentDataList(
                        List<FareComponentData> list) {
                    fareComponentDataList = list;
                }

                /** 
                 * Get the list of 'PricingUnitData' element items.
                 * 
                 * @return list
                 */
                public List<PricingUnitData> getPricingUnitDataList() {
                    return pricingUnitDataList;
                }

                /** 
                 * Set the list of 'PricingUnitData' element items.
                 * 
                 * @param list
                 */
                public void setPricingUnitDataList(List<PricingUnitData> list) {
                    pricingUnitDataList = list;
                }

                /** 
                 * Get the 'JourneyLevelDataList' element value.
                 * 
                 * @return value
                 */
                public JourneyLevelDataList getJourneyLevelDataList() {
                    return journeyLevelDataList;
                }

                /** 
                 * Set the 'JourneyLevelDataList' element value.
                 * 
                 * @param journeyLevelDataList
                 */
                public void setJourneyLevelDataList(
                        JourneyLevelDataList journeyLevelDataList) {
                    this.journeyLevelDataList = journeyLevelDataList;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsements" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Endorsements implements Serializable
                {
                    private List<String> textList = new ArrayList<String>();

                    /** 
                     * Get the list of 'Text' element items. when /SUM/PXI/MSG/@N06 is N then /SUM/PXI/MSG/@S18
                     * 
                     * @return list
                     */
                    public List<String> getTextList() {
                        return textList;
                    }

                    /** 
                     * Set the list of 'Text' element items. when /SUM/PXI/MSG/@N06 is N then /SUM/PXI/MSG/@S18
                     * 
                     * @param list
                     */
                    public void setTextList(List<String> list) {
                        textList = list;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warnings" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Warnings implements Serializable
                {
                    private List<String> textList = new ArrayList<String>();

                    /** 
                     * Get the list of 'Text' element items. when  when  is not N /SUM/PXI/MSGMSG/@N06 /SUM/PXI/MSG/@S18
                     * 
                     * @return list
                     */
                    public List<String> getTextList() {
                        return textList;
                    }

                    /** 
                     * Set the list of 'Text' element items. when  when  is not N /SUM/PXI/MSGMSG/@N06 /SUM/PXI/MSG/@S18
                     * 
                     * @param list
                     */
                    public void setTextList(List<String> list) {
                        textList = list;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingRestriction" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" name="TicketingRestrictedInd"/>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" name="TFRRestrictedInd"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TicketingRestriction implements
                    Serializable
                {
                    private Boolean ticketingRestrictedInd;
                    private Boolean TFRRestrictedInd;

                    /** 
                     * Get the 'TicketingRestrictedInd' attribute value.  /SUM/PXI/@P06
                     * 
                     * @return value
                     */
                    public Boolean getTicketingRestrictedInd() {
                        return ticketingRestrictedInd;
                    }

                    /** 
                     * Set the 'TicketingRestrictedInd' attribute value.  /SUM/PXI/@P06
                     * 
                     * @param ticketingRestrictedInd
                     */
                    public void setTicketingRestrictedInd(
                            Boolean ticketingRestrictedInd) {
                        this.ticketingRestrictedInd = ticketingRestrictedInd;
                    }

                    /** 
                     * Get the 'TFRRestrictedInd' attribute value. TFR Restricted /SUM/PXI/@P3L
                     * 
                     * @return value
                     */
                    public Boolean getTFRRestrictedInd() {
                        return TFRRestrictedInd;
                    }

                    /** 
                     * Set the 'TFRRestrictedInd' attribute value. TFR Restricted /SUM/PXI/@P3L
                     * 
                     * @param TFRRestrictedInd
                     */
                    public void setTFRRestrictedInd(Boolean TFRRestrictedInd) {
                        this.TFRRestrictedInd = TFRRestrictedInd;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrivateFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" name="DisplayIndicator"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PrivateFare implements Serializable
                {
                    private String displayIndicator;

                    /** 
                     * Get the 'DisplayIndicator' attribute value.  /SUM/PXI/@N1U
                     * 
                     * @return value
                     */
                    public String getDisplayIndicator() {
                        return displayIndicator;
                    }

                    /** 
                     * Set the 'DisplayIndicator' attribute value.  /SUM/PXI/@N1U
                     * 
                     * @param displayIndicator
                     */
                    public void setDisplayIndicator(String displayIndicator) {
                        this.displayIndicator = displayIndicator;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:all>
                 *       &lt;xs:element name="BaseFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class BaseFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="EquivalentFare" minOccurs="0">
                 *         &lt;!-- Reference to inner class EquivalentFare -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="NetRemit" minOccurs="0">
                 *         &lt;!-- Reference to inner class NetRemit -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="Commission" minOccurs="0">
                 *         &lt;!-- Reference to inner class Commission -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element name="FareRetailerInfo" minOccurs="0">
                 *         &lt;!-- Reference to inner class FareRetailerInfo -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:all>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PassengerFare implements Serializable
                {
                    private BaseFare baseFare;
                    private EquivalentFare equivalentFare;
                    private NetRemit netRemit;
                    private Commission commission;
                    private FareRetailerInfo fareRetailerInfo;

                    /** 
                     * Get the 'BaseFare' element value.
                     * 
                     * @return value
                     */
                    public BaseFare getBaseFare() {
                        return baseFare;
                    }

                    /** 
                     * Set the 'BaseFare' element value.
                     * 
                     * @param baseFare
                     */
                    public void setBaseFare(BaseFare baseFare) {
                        this.baseFare = baseFare;
                    }

                    /** 
                     * Get the 'EquivalentFare' element value.
                     * 
                     * @return value
                     */
                    public EquivalentFare getEquivalentFare() {
                        return equivalentFare;
                    }

                    /** 
                     * Set the 'EquivalentFare' element value.
                     * 
                     * @param equivalentFare
                     */
                    public void setEquivalentFare(EquivalentFare equivalentFare) {
                        this.equivalentFare = equivalentFare;
                    }

                    /** 
                     * Get the 'NetRemit' element value.
                     * 
                     * @return value
                     */
                    public NetRemit getNetRemit() {
                        return netRemit;
                    }

                    /** 
                     * Set the 'NetRemit' element value.
                     * 
                     * @param netRemit
                     */
                    public void setNetRemit(NetRemit netRemit) {
                        this.netRemit = netRemit;
                    }

                    /** 
                     * Get the 'Commission' element value.
                     * 
                     * @return value
                     */
                    public Commission getCommission() {
                        return commission;
                    }

                    /** 
                     * Set the 'Commission' element value.
                     * 
                     * @param commission
                     */
                    public void setCommission(Commission commission) {
                        this.commission = commission;
                    }

                    /** 
                     * Get the 'FareRetailerInfo' element value.
                     * 
                     * @return value
                     */
                    public FareRetailerInfo getFareRetailerInfo() {
                        return fareRetailerInfo;
                    }

                    /** 
                     * Set the 'FareRetailerInfo' element value.
                     * 
                     * @param fareRetailerInfo
                     */
                    public void setFareRetailerInfo(
                            FareRetailerInfo fareRetailerInfo) {
                        this.fareRetailerInfo = fareRetailerInfo;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:float" name="Amount"/>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="SpanishFamilyDiscountLevel"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BaseFare implements Serializable
                    {
                        private String currencyCode;
                        private Float amount;
                        private String spanishFamilyDiscountLevel;

                        /** 
                         * Get the 'CurrencyCode' attribute value.  /SUM/PXI/@C40
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.  /SUM/PXI/@C40
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'Amount' attribute value.  /SUM/PXI/@C5A
                         * 
                         * @return value
                         */
                        public Float getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.  /SUM/PXI/@C5A
                         * 
                         * @param amount
                         */
                        public void setAmount(Float amount) {
                            this.amount = amount;
                        }

                        /** 
                         * Get the 'SpanishFamilyDiscountLevel' attribute value.  Spanish Large Family Discount level /SUM/PXI/@PY5
                         * 
                         * @return value
                         */
                        public String getSpanishFamilyDiscountLevel() {
                            return spanishFamilyDiscountLevel;
                        }

                        /** 
                         * Set the 'SpanishFamilyDiscountLevel' attribute value.  Spanish Large Family Discount level /SUM/PXI/@PY5
                         * 
                         * @param spanishFamilyDiscountLevel
                         */
                        public void setSpanishFamilyDiscountLevel(
                                String spanishFamilyDiscountLevel) {
                            this.spanishFamilyDiscountLevel = spanishFamilyDiscountLevel;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentFare" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
                     *     &lt;xs:attribute type="xs:float" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class EquivalentFare implements Serializable
                    {
                        private String currencyCode;
                        private Float amount;

                        /** 
                         * Get the 'CurrencyCode' attribute value.  /SUM/PXI/@C45
                         * 
                         * @return value
                         */
                        public String getCurrencyCode() {
                            return currencyCode;
                        }

                        /** 
                         * Set the 'CurrencyCode' attribute value.  /SUM/PXI/@C45
                         * 
                         * @param currencyCode
                         */
                        public void setCurrencyCode(String currencyCode) {
                            this.currencyCode = currencyCode;
                        }

                        /** 
                         * Get the 'Amount' attribute value.  /SUM/PXI/@C5F
                         * 
                         * @return value
                         */
                        public Float getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.  /SUM/PXI/@C5F
                         * 
                         * @param amount
                         */
                        public void setAmount(Float amount) {
                            this.amount = amount;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetRemit" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="BaseFare" minOccurs="0">
                     *         &lt;!-- Reference to inner class BaseFare -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *     &lt;xs:attribute type="xs:string" use="optional" name="ConstructionCurrencyCode"/>
                     *     &lt;xs:attribute type="xs:float" use="optional" name="ConstructionTotalAmount"/>
                     *     &lt;xs:attribute type="xs:float" use="optional" name="EquivalentAmount"/>
                     *     &lt;xs:attribute type="xs:float" use="optional" name="TotalTaxes"/>
                     *     &lt;xs:attribute type="xs:float" use="optional" name="TotalPerPassenger"/>
                     *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="TicketInd"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class NetRemit implements Serializable
                    {
                        private BaseFare baseFare;
                        private String constructionCurrencyCode;
                        private Float constructionTotalAmount;
                        private Float equivalentAmount;
                        private Float totalTaxes;
                        private Float totalPerPassenger;
                        private Boolean ticketInd;

                        /** 
                         * Get the 'BaseFare' element value.
                         * 
                         * @return value
                         */
                        public BaseFare getBaseFare() {
                            return baseFare;
                        }

                        /** 
                         * Set the 'BaseFare' element value.
                         * 
                         * @param baseFare
                         */
                        public void setBaseFare(BaseFare baseFare) {
                            this.baseFare = baseFare;
                        }

                        /** 
                         * Get the 'ConstructionCurrencyCode' attribute value. Net Remit Construction Currency Code /SUM/PXI/@C4B
                         * 
                         * @return value
                         */
                        public String getConstructionCurrencyCode() {
                            return constructionCurrencyCode;
                        }

                        /** 
                         * Set the 'ConstructionCurrencyCode' attribute value. Net Remit Construction Currency Code /SUM/PXI/@C4B
                         * 
                         * @param constructionCurrencyCode
                         */
                        public void setConstructionCurrencyCode(
                                String constructionCurrencyCode) {
                            this.constructionCurrencyCode = constructionCurrencyCode;
                        }

                        /** 
                         * Get the 'ConstructionTotalAmount' attribute value. Net Remit Construction Total Amount /SUM/PXI/@C52
                         * 
                         * @return value
                         */
                        public Float getConstructionTotalAmount() {
                            return constructionTotalAmount;
                        }

                        /** 
                         * Set the 'ConstructionTotalAmount' attribute value. Net Remit Construction Total Amount /SUM/PXI/@C52
                         * 
                         * @param constructionTotalAmount
                         */
                        public void setConstructionTotalAmount(
                                Float constructionTotalAmount) {
                            this.constructionTotalAmount = constructionTotalAmount;
                        }

                        /** 
                         * Get the 'EquivalentAmount' attribute value. Net Remit Equivalent Amount /SUM/PXI/@C53
                         * 
                         * @return value
                         */
                        public Float getEquivalentAmount() {
                            return equivalentAmount;
                        }

                        /** 
                         * Set the 'EquivalentAmount' attribute value. Net Remit Equivalent Amount /SUM/PXI/@C53
                         * 
                         * @param equivalentAmount
                         */
                        public void setEquivalentAmount(Float equivalentAmount) {
                            this.equivalentAmount = equivalentAmount;
                        }

                        /** 
                         * Get the 'TotalTaxes' attribute value. Net Remit Total Taxes /SUM/PXI/@C6A
                         * 
                         * @return value
                         */
                        public Float getTotalTaxes() {
                            return totalTaxes;
                        }

                        /** 
                         * Set the 'TotalTaxes' attribute value. Net Remit Total Taxes /SUM/PXI/@C6A
                         * 
                         * @param totalTaxes
                         */
                        public void setTotalTaxes(Float totalTaxes) {
                            this.totalTaxes = totalTaxes;
                        }

                        /** 
                         * Get the 'TotalPerPassenger' attribute value. Net Remit Total Per Passenger /SUM/PXI/@C6B
                         * 
                         * @return value
                         */
                        public Float getTotalPerPassenger() {
                            return totalPerPassenger;
                        }

                        /** 
                         * Set the 'TotalPerPassenger' attribute value. Net Remit Total Per Passenger /SUM/PXI/@C6B
                         * 
                         * @param totalPerPassenger
                         */
                        public void setTotalPerPassenger(Float totalPerPassenger) {
                            this.totalPerPassenger = totalPerPassenger;
                        }

                        /** 
                         * Get the 'TicketInd' attribute value. Net Remit Ticket Indicator /SUM/PXI/@PY3
                         * 
                         * @return value
                         */
                        public Boolean getTicketInd() {
                            return ticketInd;
                        }

                        /** 
                         * Set the 'TicketInd' attribute value. Net Remit Ticket Indicator /SUM/PXI/@PY3
                         * 
                         * @param ticketInd
                         */
                        public void setTicketInd(Boolean ticketInd) {
                            this.ticketInd = ticketInd;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseFare" minOccurs="0">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
                         *     &lt;xs:attribute type="xs:float" use="optional" name="Amount"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class BaseFare implements Serializable
                        {
                            private String currencyCode;
                            private Float amount;

                            /** 
                             * Get the 'CurrencyCode' attribute value. Net Remit Base Fare Currency Code /SUM/PXI/@C4A
                             * 
                             * @return value
                             */
                            public String getCurrencyCode() {
                                return currencyCode;
                            }

                            /** 
                             * Set the 'CurrencyCode' attribute value. Net Remit Base Fare Currency Code /SUM/PXI/@C4A
                             * 
                             * @param currencyCode
                             */
                            public void setCurrencyCode(String currencyCode) {
                                this.currencyCode = currencyCode;
                            }

                            /** 
                             * Get the 'Amount' attribute value. Net Remit Base Fare Amount /SUM/PXI/@C51
                             * 
                             * @return value
                             */
                            public Float getAmount() {
                                return amount;
                            }

                            /** 
                             * Set the 'Amount' attribute value. Net Remit Base Fare Amount /SUM/PXI/@C51
                             * 
                             * @param amount
                             */
                            public void setAmount(Float amount) {
                                this.amount = amount;
                            }
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:double" name="Percentage"/>
                     *     &lt;xs:attribute type="xs:float" name="Amount"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Commission implements Serializable
                    {
                        private Double percentage;
                        private Float amount;

                        /** 
                         * Get the 'Percentage' attribute value.  /SUM/PXI/@C5D
                         * 
                         * @return value
                         */
                        public Double getPercentage() {
                            return percentage;
                        }

                        /** 
                         * Set the 'Percentage' attribute value.  /SUM/PXI/@C5D
                         * 
                         * @param percentage
                         */
                        public void setPercentage(Double percentage) {
                            this.percentage = percentage;
                        }

                        /** 
                         * Get the 'Amount' attribute value.  /SUM/PXI/@C5B
                         * 
                         * @return value
                         */
                        public Float getAmount() {
                            return amount;
                        }

                        /** 
                         * Set the 'Amount' attribute value.  /SUM/PXI/@C5B
                         * 
                         * @param amount
                         */
                        public void setAmount(Float amount) {
                            this.amount = amount;
                        }
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRetailerInfo" minOccurs="0">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element name="FareRetailerRule" minOccurs="1" maxOccurs="2">
                     *         &lt;!-- Reference to inner class FareRetailerRule -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class FareRetailerInfo implements
                        Serializable
                    {
                        private List<FareRetailerRule> fareRetailerRuleList = new ArrayList<FareRetailerRule>();

                        /** 
                         * Get the list of 'FareRetailerRule' element items.
                         * 
                         * @return list
                         */
                        public List<FareRetailerRule> getFareRetailerRuleList() {
                            return fareRetailerRuleList;
                        }

                        /** 
                         * Set the list of 'FareRetailerRule' element items.
                         * 
                         * @param list
                         */
                        public void setFareRetailerRuleList(
                                List<FareRetailerRule> list) {
                            fareRetailerRuleList = list;
                        }
                        /** 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRetailerRule" minOccurs="1" maxOccurs="2">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="TransactionType"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class FareRetailerRule implements
                            Serializable
                        {
                            private String transactionType;
                            private String code;

                            /** 
                             * Get the 'TransactionType' attribute value.
                             * 
                             * @return value
                             */
                            public String getTransactionType() {
                                return transactionType;
                            }

                            /** 
                             * Set the 'TransactionType' attribute value.
                             * 
                             * @param transactionType
                             */
                            public void setTransactionType(
                                    String transactionType) {
                                this.transactionType = transactionType;
                            }

                            /** 
                             * Get the 'Code' attribute value.
                             * 
                             * @return value
                             */
                            public String getCode() {
                                return code;
                            }

                            /** 
                             * Set the 'Code' attribute value.
                             * 
                             * @param code
                             */
                            public void setCode(String code) {
                                this.code = code;
                            }
                        }
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketFareVendor" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Source"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TicketFareVendor implements Serializable
                {
                    private String source;

                    /** 
                     * Get the 'Source' attribute value. Ticket Fare Vendor Source /SUM/PXI/@S83
                     * 
                     * @return value
                     */
                    public String getSource() {
                        return source;
                    }

                    /** 
                     * Set the 'Source' attribute value. Ticket Fare Vendor Source /SUM/PXI/@S83
                     * 
                     * @param source
                     */
                    public void setSource(String source) {
                        this.source = source;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccompaniedTravelData" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Data"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RequestedData"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class AccompaniedTravelData implements
                    Serializable
                {
                    private String data;
                    private String requestedData;

                    /** 
                     * Get the 'Data' attribute value. Accompanied Travel Data /SUM/PXI/@S85
                     * 
                     * @return value
                     */
                    public String getData() {
                        return data;
                    }

                    /** 
                     * Set the 'Data' attribute value. Accompanied Travel Data /SUM/PXI/@S85
                     * 
                     * @param data
                     */
                    public void setData(String data) {
                        this.data = data;
                    }

                    /** 
                     * Get the 'RequestedData' attribute value. Requested Accompanied Travel Data /SUM/PXI/@PBS
                     * 
                     * @return value
                     */
                    public String getRequestedData() {
                        return requestedData;
                    }

                    /** 
                     * Set the 'RequestedData' attribute value. Requested Accompanied Travel Data /SUM/PXI/@PBS
                     * 
                     * @param requestedData
                     */
                    public void setRequestedData(String requestedData) {
                        this.requestedData = requestedData;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionNumber" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:short" use="optional" name="Value"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OptionNumber implements Serializable
                {
                    private Short value;

                    /** 
                     * Get the 'Value' attribute value. Option Number /SUM/PXI/@Q4P
                     * 
                     * @return value
                     */
                    public Short getValue() {
                        return value;
                    }

                    /** 
                     * Set the 'Value' attribute value. Option Number /SUM/PXI/@Q4P
                     * 
                     * @param value
                     */
                    public void setValue(Short value) {
                        this.value = value;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeRateOne" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:float" use="optional" name="Value"/>
                 *     &lt;xs:attribute type="xs:short" use="optional" name="NumberOfDecimalPlaces"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ExchangeRateOne implements Serializable
                {
                    private Float value;
                    private Short numberOfDecimalPlaces;

                    /** 
                     * Get the 'Value' attribute value. Exchange Rate One /SUM/PXI/@C54
                     * 
                     * @return value
                     */
                    public Float getValue() {
                        return value;
                    }

                    /** 
                     * Set the 'Value' attribute value. Exchange Rate One /SUM/PXI/@C54
                     * 
                     * @param value
                     */
                    public void setValue(Float value) {
                        this.value = value;
                    }

                    /** 
                     * Get the 'NumberOfDecimalPlaces' attribute value. Number Decimal Places Exchange Rate One /SUM/PXI/@Q05
                     * 
                     * @return value
                     */
                    public Short getNumberOfDecimalPlaces() {
                        return numberOfDecimalPlaces;
                    }

                    /** 
                     * Set the 'NumberOfDecimalPlaces' attribute value. Number Decimal Places Exchange Rate One /SUM/PXI/@Q05
                     * 
                     * @param numberOfDecimalPlaces
                     */
                    public void setNumberOfDecimalPlaces(
                            Short numberOfDecimalPlaces) {
                        this.numberOfDecimalPlaces = numberOfDecimalPlaces;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cat35" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
                 *     &lt;xs:attribute type="xs:short" use="optional" name="Warning"/>
                 *     &lt;xs:attribute type="xs:float" use="optional" name="CommisionPercentage"/>
                 *     &lt;xs:attribute type="xs:float" use="optional" name="CommisionAmount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Cat35 implements Serializable
                {
                    private Boolean ind;
                    private Short warning;
                    private Float commisionPercentage;
                    private Float commisionAmount;

                    /** 
                     * Get the 'Ind' attribute value. Cat 35 Used /SUM/PXI/@P26
                     * 
                     * @return value
                     */
                    public Boolean getInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. Cat 35 Used /SUM/PXI/@P26
                     * 
                     * @param ind
                     */
                    public void setInd(Boolean ind) {
                        this.ind = ind;
                    }

                    /** 
                     * Get the 'Warning' attribute value. Cat 35 Warning /SUM/PXI/@Q0V
                     * 
                     * @return value
                     */
                    public Short getWarning() {
                        return warning;
                    }

                    /** 
                     * Set the 'Warning' attribute value. Cat 35 Warning /SUM/PXI/@Q0V
                     * 
                     * @param warning
                     */
                    public void setWarning(Short warning) {
                        this.warning = warning;
                    }

                    /** 
                     * Get the 'CommisionPercentage' attribute value. Cat 35 Commission Percentage /SUM/PXI/@C61
                     * 
                     * @return value
                     */
                    public Float getCommisionPercentage() {
                        return commisionPercentage;
                    }

                    /** 
                     * Set the 'CommisionPercentage' attribute value. Cat 35 Commission Percentage /SUM/PXI/@C61
                     * 
                     * @param commisionPercentage
                     */
                    public void setCommisionPercentage(Float commisionPercentage) {
                        this.commisionPercentage = commisionPercentage;
                    }

                    /** 
                     * Get the 'CommisionAmount' attribute value. Cat 35 Commission Amount /SUM/PXI/@C60
                     * 
                     * @return value
                     */
                    public Float getCommisionAmount() {
                        return commisionAmount;
                    }

                    /** 
                     * Set the 'CommisionAmount' attribute value. Cat 35 Commission Amount /SUM/PXI/@C60
                     * 
                     * @param commisionAmount
                     */
                    public void setCommisionAmount(Float commisionAmount) {
                        this.commisionAmount = commisionAmount;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TextBox" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TextBox implements Serializable
                {
                    private String value;

                    /** 
                     * Get the 'Value' attribute value. Text Box /SUM/PXI/@S01
                     * 
                     * @return value
                     */
                    public String getValue() {
                        return value;
                    }

                    /** 
                     * Set the 'Value' attribute value. Text Box /SUM/PXI/@S01
                     * 
                     * @param value
                     */
                    public void setValue(String value) {
                        this.value = value;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TourCode" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Ind"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TourCode implements Serializable
                {
                    private String ind;
                    private String description;

                    /** 
                     * Get the 'Ind' attribute value. Tour Indicator /SUM/PXI/@N0C
                     * 
                     * @return value
                     */
                    public String getInd() {
                        return ind;
                    }

                    /** 
                     * Set the 'Ind' attribute value. Tour Indicator /SUM/PXI/@N0C
                     * 
                     * @param ind
                     */
                    public void setInd(String ind) {
                        this.ind = ind;
                    }

                    /** 
                     * Get the 'Description' attribute value. Tour Code Description /SUM/PXI/@S02
                     * 
                     * @return value
                     */
                    public String getDescription() {
                        return description;
                    }

                    /** 
                     * Set the 'Description' attribute value. Tour Code Description /SUM/PXI/@S02
                     * 
                     * @param description
                     */
                    public void setDescription(String description) {
                        this.description = description;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetGross" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NetGross implements Serializable
                {
                    private String value;

                    /** 
                     * Get the 'Value' attribute value. Net Gross /SUM/PXI/@N0B
                     * 
                     * @return value
                     */
                    public String getValue() {
                        return value;
                    }

                    /** 
                     * Set the 'Value' attribute value. Net Gross /SUM/PXI/@N0B
                     * 
                     * @param value
                     */
                    public void setValue(String value) {
                        this.value = value;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BSP" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="MethodType"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class BSP implements Serializable
                {
                    private String methodType;

                    /** 
                     * Get the 'MethodType' attribute value. BSP Method Type /SUM/PXI/@N0A
                     * 
                     * @return value
                     */
                    public String getMethodType() {
                        return methodType;
                    }

                    /** 
                     * Set the 'MethodType' attribute value. BSP Method Type /SUM/PXI/@N0A
                     * 
                     * @param methodType
                     */
                    public void setMethodType(String methodType) {
                        this.methodType = methodType;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:float" use="optional" name="BaseAmount"/>
                 *     &lt;xs:attribute type="xs:float" use="optional" name="Amount"/>
                 *     &lt;xs:attribute type="xs:float" use="optional" name="AmountWithCharges"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class NetFare implements Serializable
                {
                    private Float baseAmount;
                    private Float amount;
                    private Float amountWithCharges;

                    /** 
                     * Get the 'BaseAmount' attribute value. Net Fare Base Amount /SUM/PXI/@C5M
                     * 
                     * @return value
                     */
                    public Float getBaseAmount() {
                        return baseAmount;
                    }

                    /** 
                     * Set the 'BaseAmount' attribute value. Net Fare Base Amount /SUM/PXI/@C5M
                     * 
                     * @param baseAmount
                     */
                    public void setBaseAmount(Float baseAmount) {
                        this.baseAmount = baseAmount;
                    }

                    /** 
                     * Get the 'Amount' attribute value. Net Fare Equivalent Amount /SUM/PXI/@C62
                     * 
                     * @return value
                     */
                    public Float getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value. Net Fare Equivalent Amount /SUM/PXI/@C62
                     * 
                     * @param amount
                     */
                    public void setAmount(Float amount) {
                        this.amount = amount;
                    }

                    /** 
                     * Get the 'AmountWithCharges' attribute value. Net Fare Equivalent Amount plus cat8 9 12 charges /SUM/PXI/@C5G
                     * 
                     * @return value
                     */
                    public Float getAmountWithCharges() {
                        return amountWithCharges;
                    }

                    /** 
                     * Set the 'AmountWithCharges' attribute value. Net Fare Equivalent Amount plus cat8 9 12 charges /SUM/PXI/@C5G
                     * 
                     * @param amountWithCharges
                     */
                    public void setAmountWithCharges(Float amountWithCharges) {
                        this.amountWithCharges = amountWithCharges;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxFarePassenger" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:short" use="required" name="Number"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PaxFarePassenger implements Serializable
                {
                    private short number;

                    /** 
                     * Get the 'Number' attribute value. Pax Fare Passenger Number /SUM/PXI/@Q0W
                     * 
                     * @return value
                     */
                    public short getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Pax Fare Passenger Number /SUM/PXI/@Q0W
                     * 
                     * @param number
                     */
                    public void setNumber(short number) {
                        this.number = number;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValueCode" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ValueCode implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value. Value Code /SUM/PXI/@S87
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. Value Code /SUM/PXI/@S87
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrintOption" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Option"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PrintOption implements Serializable
                {
                    private String option;

                    /** 
                     * Get the 'Option' attribute value. Print Option /SUM/PXI/@N1S
                     * 
                     * @return value
                     */
                    public String getOption() {
                        return option;
                    }

                    /** 
                     * Set the 'Option' attribute value. Print Option /SUM/PXI/@N1S
                     * 
                     * @param option
                     */
                    public void setOption(String option) {
                        this.option = option;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingSegmentFee" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:boolean" use="required" name="Message"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TicketingSegmentFee implements Serializable
                {
                    private boolean message;

                    /** 
                     * Get the 'Message' attribute value. Ticketing Segment Fee Message /SUM/PXI/@P3J
                     * 
                     * @return value
                     */
                    public boolean isMessage() {
                        return message;
                    }

                    /** 
                     * Set the 'Message' attribute value. Ticketing Segment Fee Message /SUM/PXI/@P3J
                     * 
                     * @param message
                     */
                    public void setMessage(boolean message) {
                        this.message = message;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponentData" minOccurs="1" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:AdvancedPurchaseDataType" name="AdvancedPurchaseData" minOccurs="0" maxOccurs="unbounded"/>
                 *       &lt;xs:element type="ns:MinimumStayDataType" name="MinimumStayData" minOccurs="0" maxOccurs="unbounded"/>
                 *       &lt;xs:element type="ns:MaximumStayDataType" name="MaximumStayData" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="PricingUnitNumber"/>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="FareComponentNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareComponentData implements Serializable
                {
                    private List<AdvancedPurchaseDataType> advancedPurchaseDataList = new ArrayList<AdvancedPurchaseDataType>();
                    private List<MinimumStayDataType> minimumStayDataList = new ArrayList<MinimumStayDataType>();
                    private List<MaximumStayDataType> maximumStayDataList = new ArrayList<MaximumStayDataType>();
                    private BigInteger pricingUnitNumber;
                    private BigInteger fareComponentNumber;

                    /** 
                     * Get the list of 'AdvancedPurchaseData' element items.
                     * 
                     * @return list
                     */
                    public List<AdvancedPurchaseDataType> getAdvancedPurchaseDataList() {
                        return advancedPurchaseDataList;
                    }

                    /** 
                     * Set the list of 'AdvancedPurchaseData' element items.
                     * 
                     * @param list
                     */
                    public void setAdvancedPurchaseDataList(
                            List<AdvancedPurchaseDataType> list) {
                        advancedPurchaseDataList = list;
                    }

                    /** 
                     * Get the list of 'MinimumStayData' element items.
                     * 
                     * @return list
                     */
                    public List<MinimumStayDataType> getMinimumStayDataList() {
                        return minimumStayDataList;
                    }

                    /** 
                     * Set the list of 'MinimumStayData' element items.
                     * 
                     * @param list
                     */
                    public void setMinimumStayDataList(
                            List<MinimumStayDataType> list) {
                        minimumStayDataList = list;
                    }

                    /** 
                     * Get the list of 'MaximumStayData' element items.
                     * 
                     * @return list
                     */
                    public List<MaximumStayDataType> getMaximumStayDataList() {
                        return maximumStayDataList;
                    }

                    /** 
                     * Set the list of 'MaximumStayData' element items.
                     * 
                     * @param list
                     */
                    public void setMaximumStayDataList(
                            List<MaximumStayDataType> list) {
                        maximumStayDataList = list;
                    }

                    /** 
                     * Get the 'PricingUnitNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPricingUnitNumber() {
                        return pricingUnitNumber;
                    }

                    /** 
                     * Set the 'PricingUnitNumber' attribute value.
                     * 
                     * @param pricingUnitNumber
                     */
                    public void setPricingUnitNumber(
                            BigInteger pricingUnitNumber) {
                        this.pricingUnitNumber = pricingUnitNumber;
                    }

                    /** 
                     * Get the 'FareComponentNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getFareComponentNumber() {
                        return fareComponentNumber;
                    }

                    /** 
                     * Set the 'FareComponentNumber' attribute value.
                     * 
                     * @param fareComponentNumber
                     */
                    public void setFareComponentNumber(
                            BigInteger fareComponentNumber) {
                        this.fareComponentNumber = fareComponentNumber;
                    }
                }
                /** 
                 * Pricing Unit Most Restictive Data 
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingUnitData" minOccurs="1" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="ns:MinimumStayDataType" name="MinimumStayData" minOccurs="0" maxOccurs="unbounded"/>
                 *       &lt;xs:element type="ns:MaximumStayDataType" name="MaximumStayData" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:integer" name="PricingUnitNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PricingUnitData implements Serializable
                {
                    private List<MinimumStayDataType> minimumStayDataList = new ArrayList<MinimumStayDataType>();
                    private List<MaximumStayDataType> maximumStayDataList = new ArrayList<MaximumStayDataType>();
                    private BigInteger pricingUnitNumber;

                    /** 
                     * Get the list of 'MinimumStayData' element items.
                     * 
                     * @return list
                     */
                    public List<MinimumStayDataType> getMinimumStayDataList() {
                        return minimumStayDataList;
                    }

                    /** 
                     * Set the list of 'MinimumStayData' element items.
                     * 
                     * @param list
                     */
                    public void setMinimumStayDataList(
                            List<MinimumStayDataType> list) {
                        minimumStayDataList = list;
                    }

                    /** 
                     * Get the list of 'MaximumStayData' element items.
                     * 
                     * @return list
                     */
                    public List<MaximumStayDataType> getMaximumStayDataList() {
                        return maximumStayDataList;
                    }

                    /** 
                     * Set the list of 'MaximumStayData' element items.
                     * 
                     * @param list
                     */
                    public void setMaximumStayDataList(
                            List<MaximumStayDataType> list) {
                        maximumStayDataList = list;
                    }

                    /** 
                     * Get the 'PricingUnitNumber' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getPricingUnitNumber() {
                        return pricingUnitNumber;
                    }

                    /** 
                     * Set the 'PricingUnitNumber' attribute value.
                     * 
                     * @param pricingUnitNumber
                     */
                    public void setPricingUnitNumber(
                            BigInteger pricingUnitNumber) {
                        this.pricingUnitNumber = pricingUnitNumber;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="JourneyLevelDataList" minOccurs="0" maxOccurs="1">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="JourneyLevelData" minOccurs="1" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class JourneyLevelData -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class JourneyLevelDataList implements
                    Serializable
                {
                    private List<JourneyLevelData> journeyLevelDataList = new ArrayList<JourneyLevelData>();

                    /** 
                     * Get the list of 'JourneyLevelData' element items.
                     * 
                     * @return list
                     */
                    public List<JourneyLevelData> getJourneyLevelDataList() {
                        return journeyLevelDataList;
                    }

                    /** 
                     * Set the list of 'JourneyLevelData' element items.
                     * 
                     * @param list
                     */
                    public void setJourneyLevelDataList(
                            List<JourneyLevelData> list) {
                        journeyLevelDataList = list;
                    }
                    /** 
                     * Journey Level Most restrictive data
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="JourneyLevelData" minOccurs="1" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="ns:AdvancedPurchaseDataType" name="AdvancedPurchaseData" minOccurs="0" maxOccurs="unbounded"/>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class JourneyLevelData implements
                        Serializable
                    {
                        private List<AdvancedPurchaseDataType> advancedPurchaseDataList = new ArrayList<AdvancedPurchaseDataType>();

                        /** 
                         * Get the list of 'AdvancedPurchaseData' element items.
                         * 
                         * @return list
                         */
                        public List<AdvancedPurchaseDataType> getAdvancedPurchaseDataList() {
                            return advancedPurchaseDataList;
                        }

                        /** 
                         * Set the list of 'AdvancedPurchaseData' element items.
                         * 
                         * @param list
                         */
                        public void setAdvancedPurchaseDataList(
                                List<AdvancedPurchaseDataType> list) {
                            advancedPurchaseDataList = list;
                        }
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warnings" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Warning" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Warning -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Warnings implements Serializable
        {
            private List<Warning> warningList = new ArrayList<Warning>();

            /** 
             * Get the list of 'Warning' element items.
             * 
             * @return list
             */
            public List<Warning> getWarningList() {
                return warningList;
            }

            /** 
             * Set the list of 'Warning' element items.
             * 
             * @param list
             */
            public void setWarningList(List<Warning> list) {
                warningList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warning" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="WarningCode"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="WarningMessage"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Warning implements Serializable
            {
                private String warningCode;
                private String warningMessage;

                /** 
                 * Get the 'WarningCode' attribute value.
                 * 
                 * @return value
                 */
                public String getWarningCode() {
                    return warningCode;
                }

                /** 
                 * Set the 'WarningCode' attribute value.
                 * 
                 * @param warningCode
                 */
                public void setWarningCode(String warningCode) {
                    this.warningCode = warningCode;
                }

                /** 
                 * Get the 'WarningMessage' attribute value.
                 * 
                 * @return value
                 */
                public String getWarningMessage() {
                    return warningMessage;
                }

                /** 
                 * Set the 'WarningMessage' attribute value.
                 * 
                 * @param warningMessage
                 */
                public void setWarningMessage(String warningMessage) {
                    this.warningMessage = warningMessage;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
