
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelItineraryDivideRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Divide" minOccurs="0">
 *         &lt;!-- Reference to inner class Divide -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="File" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.0.3" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class TravelItineraryDivideRQ implements Serializable
{
    private Divide divide;
    private boolean file;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'Divide' element value.
     * 
     * @return value
     */
    public Divide getDivide() {
        return divide;
    }

    /** 
     * Set the 'Divide' element value.
     * 
     * @param divide
     */
    public void setDivide(Divide divide) {
        this.divide = divide;
    }

    /** 
     * Check if the 'File' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifFilePresent() {
        return file;
    }

    /** 
     * Set flag for 'File' element present.
     * 
     * @param file
     */
    public void flagFilePresent(boolean file) {
        this.file = file;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Divide" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="CustomerInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class CustomerInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="GroupInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class GroupInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Divide implements Serializable
    {
        private CustomerInfo customerInfo;
        private GroupInfo groupInfo;

        /** 
         * Get the 'CustomerInfo' element value.
         * 
         * @return value
         */
        public CustomerInfo getCustomerInfo() {
            return customerInfo;
        }

        /** 
         * Set the 'CustomerInfo' element value.
         * 
         * @param customerInfo
         */
        public void setCustomerInfo(CustomerInfo customerInfo) {
            this.customerInfo = customerInfo;
        }

        /** 
         * Get the 'GroupInfo' element value.
         * 
         * @return value
         */
        public GroupInfo getGroupInfo() {
            return groupInfo;
        }

        /** 
         * Set the 'GroupInfo' element value.
         * 
         * @param groupInfo
         */
        public void setGroupInfo(GroupInfo groupInfo) {
            this.groupInfo = groupInfo;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="PersonName" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PersonName -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CustomerInfo implements Serializable
        {
            private List<PersonName> personNameList = new ArrayList<PersonName>();

            /** 
             * Get the list of 'PersonName' element items.
             * 
             * @return list
             */
            public List<PersonName> getPersonNameList() {
                return personNameList;
            }

            /** 
             * Set the list of 'PersonName' element items.
             * 
             * @param list
             */
            public void setPersonNameList(List<PersonName> list) {
                personNameList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="EndNameNumber"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="NameNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PersonName implements Serializable
            {
                private String endNameNumber;
                private String nameNumber;

                /** 
                 * Get the 'EndNameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getEndNameNumber() {
                    return endNameNumber;
                }

                /** 
                 * Set the 'EndNameNumber' attribute value.
                 * 
                 * @param endNameNumber
                 */
                public void setEndNameNumber(String endNameNumber) {
                    this.endNameNumber = endNameNumber;
                }

                /** 
                 * Get the 'NameNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getNameNumber() {
                    return nameNumber;
                }

                /** 
                 * Set the 'NameNumber' attribute value.
                 * 
                 * @param nameNumber
                 */
                public void setNameNumber(String nameNumber) {
                    this.nameNumber = nameNumber;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroupInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="NumSeats"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class GroupInfo implements Serializable
        {
            private String numSeats;

            /** 
             * Get the 'NumSeats' attribute value.
             * 
             * @return value
             */
            public String getNumSeats() {
                return numSeats;
            }

            /** 
             * Set the 'NumSeats' attribute value.
             * 
             * @param numSeats
             */
            public void setNumSeats(String numSeats) {
                this.numSeats = numSeats;
            }
        }
    }
}
