
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrierCommissionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="FareComponentBreakdowns" minOccurs="0">
 *       &lt;!-- Reference to inner class FareComponentBreakdowns -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="LaunchRuleInformations" minOccurs="0">
 *       &lt;!-- Reference to inner class LaunchRuleInformations -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:TicketingInstructionType" name="TicketingInstruction" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ValidatingCarrier"/>
 *   &lt;xs:attribute type="xs:float" use="required" name="CommissionAmount"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="EarnedCommissionAmount"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="TotalAmountIncludingMarkUp"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="CommissionPercent"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CommissionContractQualifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SourcePCC"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ValidatingCarrierCommissionType implements Serializable
{
    private FareComponentBreakdowns fareComponentBreakdowns;
    private LaunchRuleInformations launchRuleInformations;
    private TicketingInstructionType ticketingInstruction;
    private String validatingCarrier;
    private Float commissionAmount;
    private Float earnedCommissionAmount;
    private Float totalAmountIncludingMarkUp;
    private Float commissionPercent;
    private String commissionContractQualifier;
    private String sourcePCC;

    /** 
     * Get the 'FareComponentBreakdowns' element value.
     * 
     * @return value
     */
    public FareComponentBreakdowns getFareComponentBreakdowns() {
        return fareComponentBreakdowns;
    }

    /** 
     * Set the 'FareComponentBreakdowns' element value.
     * 
     * @param fareComponentBreakdowns
     */
    public void setFareComponentBreakdowns(
            FareComponentBreakdowns fareComponentBreakdowns) {
        this.fareComponentBreakdowns = fareComponentBreakdowns;
    }

    /** 
     * Get the 'LaunchRuleInformations' element value.
     * 
     * @return value
     */
    public LaunchRuleInformations getLaunchRuleInformations() {
        return launchRuleInformations;
    }

    /** 
     * Set the 'LaunchRuleInformations' element value.
     * 
     * @param launchRuleInformations
     */
    public void setLaunchRuleInformations(
            LaunchRuleInformations launchRuleInformations) {
        this.launchRuleInformations = launchRuleInformations;
    }

    /** 
     * Get the 'TicketingInstruction' element value.
     * 
     * @return value
     */
    public TicketingInstructionType getTicketingInstruction() {
        return ticketingInstruction;
    }

    /** 
     * Set the 'TicketingInstruction' element value.
     * 
     * @param ticketingInstruction
     */
    public void setTicketingInstruction(
            TicketingInstructionType ticketingInstruction) {
        this.ticketingInstruction = ticketingInstruction;
    }

    /** 
     * Get the 'ValidatingCarrier' attribute value. Validating Carrier Commission Validating Carrier /SUM/PXI/VCC/@B00
     * 
     * @return value
     */
    public String getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' attribute value. Validating Carrier Commission Validating Carrier /SUM/PXI/VCC/@B00
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the 'CommissionAmount' attribute value. Validating Carrier Commission Commission Amount /SUM/PXI/VCC/@C58
     * 
     * @return value
     */
    public Float getCommissionAmount() {
        return commissionAmount;
    }

    /** 
     * Set the 'CommissionAmount' attribute value. Validating Carrier Commission Commission Amount /SUM/PXI/VCC/@C58
     * 
     * @param commissionAmount
     */
    public void setCommissionAmount(Float commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    /** 
     * Get the 'EarnedCommissionAmount' attribute value. Validating Carrier Earned Commission Amount /SUM/PXI/VCC/@C59
     * 
     * @return value
     */
    public Float getEarnedCommissionAmount() {
        return earnedCommissionAmount;
    }

    /** 
     * Set the 'EarnedCommissionAmount' attribute value. Validating Carrier Earned Commission Amount /SUM/PXI/VCC/@C59
     * 
     * @param earnedCommissionAmount
     */
    public void setEarnedCommissionAmount(Float earnedCommissionAmount) {
        this.earnedCommissionAmount = earnedCommissionAmount;
    }

    /** 
     * Get the 'TotalAmountIncludingMarkUp' attribute value. Total Commission amount including Mark-Up /SUM/PXI/VCC/@C60
     * 
     * @return value
     */
    public Float getTotalAmountIncludingMarkUp() {
        return totalAmountIncludingMarkUp;
    }

    /** 
     * Set the 'TotalAmountIncludingMarkUp' attribute value. Total Commission amount including Mark-Up /SUM/PXI/VCC/@C60
     * 
     * @param totalAmountIncludingMarkUp
     */
    public void setTotalAmountIncludingMarkUp(Float totalAmountIncludingMarkUp) {
        this.totalAmountIncludingMarkUp = totalAmountIncludingMarkUp;
    }

    /** 
     * Get the 'CommissionPercent' attribute value. Commission Percent /SUM/PXI/VCC/@C61
     * 
     * @return value
     */
    public Float getCommissionPercent() {
        return commissionPercent;
    }

    /** 
     * Set the 'CommissionPercent' attribute value. Commission Percent /SUM/PXI/VCC/@C61
     * 
     * @param commissionPercent
     */
    public void setCommissionPercent(Float commissionPercent) {
        this.commissionPercent = commissionPercent;
    }

    /** 
     * Get the 'CommissionContractQualifier' attribute value. Commission Code /SUM/PXI/VCC/@CCQ
     * 
     * @return value
     */
    public String getCommissionContractQualifier() {
        return commissionContractQualifier;
    }

    /** 
     * Set the 'CommissionContractQualifier' attribute value. Commission Code /SUM/PXI/VCC/@CCQ
     * 
     * @param commissionContractQualifier
     */
    public void setCommissionContractQualifier(
            String commissionContractQualifier) {
        this.commissionContractQualifier = commissionContractQualifier;
    }

    /** 
     * Get the 'SourcePCC' attribute value. Source PCC /SUM/PXI/VCC/@S40
     * 
     * @return value
     */
    public String getSourcePCC() {
        return sourcePCC;
    }

    /** 
     * Set the 'SourcePCC' attribute value. Source PCC /SUM/PXI/VCC/@S40
     * 
     * @param sourcePCC
     */
    public void setSourcePCC(String sourcePCC) {
        this.sourcePCC = sourcePCC;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponentBreakdowns" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FareComponentBreakdownType" name="FareComponentBreakdown" minOccurs="1" maxOccurs="24"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareComponentBreakdowns implements Serializable
    {
        private List<FareComponentBreakdownType> fareComponentBreakdownList = new ArrayList<FareComponentBreakdownType>();

        /** 
         * Get the list of 'FareComponentBreakdown' element items.
         * 
         * @return list
         */
        public List<FareComponentBreakdownType> getFareComponentBreakdownList() {
            return fareComponentBreakdownList;
        }

        /** 
         * Set the list of 'FareComponentBreakdown' element items.
         * 
         * @param list
         */
        public void setFareComponentBreakdownList(
                List<FareComponentBreakdownType> list) {
            fareComponentBreakdownList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2003/07" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LaunchRuleInformations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:LaunchRuleInformationType" name="LaunchRuleInformation" minOccurs="0" maxOccurs="24"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class LaunchRuleInformations implements Serializable
    {
        private List<LaunchRuleInformationType> launchRuleInformationList = new ArrayList<LaunchRuleInformationType>();

        /** 
         * Get the list of 'LaunchRuleInformation' element items.
         * 
         * @return list
         */
        public List<LaunchRuleInformationType> getLaunchRuleInformationList() {
            return launchRuleInformationList;
        }

        /** 
         * Set the list of 'LaunchRuleInformation' element items.
         * 
         * @param list
         */
        public void setLaunchRuleInformationList(
                List<LaunchRuleInformationType> list) {
            launchRuleInformationList = list;
        }
    }
}
