
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorCodesRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="Table" minOccurs="0" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Table -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class VendorCodesRS implements Serializable
{
    private ApplicationResults applicationResults;
    private List<Table> tableList = new ArrayList<Table>();
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the list of 'Table' element items.
     * 
     * @return list
     */
    public List<Table> getTableList() {
        return tableList;
    }

    /** 
     * Set the list of 'Table' element items.
     * 
     * @param list
     */
    public void setTableList(List<Table> list) {
        tableList = list;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Table" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Row" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Row -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SubTable" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SubTable -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Table implements Serializable
    {
        private List<Row> rowList = new ArrayList<Row>();
        private List<SubTable> subTableList = new ArrayList<SubTable>();
        private String name;

        /** 
         * Get the list of 'Row' element items.
         * 
         * @return list
         */
        public List<Row> getRowList() {
            return rowList;
        }

        /** 
         * Set the list of 'Row' element items.
         * 
         * @param list
         */
        public void setRowList(List<Row> list) {
            rowList = list;
        }

        /** 
         * Get the list of 'SubTable' element items.
         * 
         * @return list
         */
        public List<SubTable> getSubTableList() {
            return subTableList;
        }

        /** 
         * Set the list of 'SubTable' element items.
         * 
         * @param list
         */
        public void setSubTableList(List<SubTable> list) {
            subTableList = list;
        }

        /** 
         * Get the 'Name' attribute value.
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value.
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Row" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Column" minOccurs="0" maxOccurs="3">
         *         &lt;!-- Reference to inner class Column -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Row implements Serializable
        {
            private List<Column> columnList = new ArrayList<Column>();
            private BigInteger RPH;

            /** 
             * Get the list of 'Column' element items.
             * 
             * @return list
             */
            public List<Column> getColumnList() {
                return columnList;
            }

            /** 
             * Set the list of 'Column' element items.
             * 
             * @param list
             */
            public void setColumnList(List<Column> list) {
                columnList = list;
            }

            /** 
             * Get the 'RPH' attribute value.
             * 
             * @return value
             */
            public BigInteger getRPH() {
                return RPH;
            }

            /** 
             * Set the 'RPH' attribute value.
             * 
             * @param RPH
             */
            public void setRPH(BigInteger RPH) {
                this.RPH = RPH;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Column" minOccurs="0" maxOccurs="3">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Column implements Serializable
            {
                private String text;
                private BigInteger RPH;

                /** 
                 * Get the 'Text' element value.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' element value.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'RPH' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value.
                 * 
                 * @param RPH
                 */
                public void setRPH(BigInteger RPH) {
                    this.RPH = RPH;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubTable" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Row" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Row -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SubTable implements Serializable
        {
            private List<Row> rowList = new ArrayList<Row>();
            private String name;

            /** 
             * Get the list of 'Row' element items.
             * 
             * @return list
             */
            public List<Row> getRowList() {
                return rowList;
            }

            /** 
             * Set the list of 'Row' element items.
             * 
             * @param list
             */
            public void setRowList(List<Row> list) {
                rowList = list;
            }

            /** 
             * Get the 'Name' attribute value.
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' attribute value.
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Row" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Column" minOccurs="0" maxOccurs="3">
             *         &lt;!-- Reference to inner class Column -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Row implements Serializable
            {
                private List<Column> columnList = new ArrayList<Column>();
                private BigInteger RPH;

                /** 
                 * Get the list of 'Column' element items.
                 * 
                 * @return list
                 */
                public List<Column> getColumnList() {
                    return columnList;
                }

                /** 
                 * Set the list of 'Column' element items.
                 * 
                 * @param list
                 */
                public void setColumnList(List<Column> list) {
                    columnList = list;
                }

                /** 
                 * Get the 'RPH' attribute value.
                 * 
                 * @return value
                 */
                public BigInteger getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value.
                 * 
                 * @param RPH
                 */
                public void setRPH(BigInteger RPH) {
                    this.RPH = RPH;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Column" minOccurs="0" maxOccurs="3">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:integer" use="optional" name="RPH"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Column implements Serializable
                {
                    private String text;
                    private BigInteger RPH;

                    /** 
                     * Get the 'Text' element value.
                     * 
                     * @return value
                     */
                    public String getText() {
                        return text;
                    }

                    /** 
                     * Set the 'Text' element value.
                     * 
                     * @param text
                     */
                    public void setText(String text) {
                        this.text = text;
                    }

                    /** 
                     * Get the 'RPH' attribute value.
                     * 
                     * @return value
                     */
                    public BigInteger getRPH() {
                        return RPH;
                    }

                    /** 
                     * Set the 'RPH' attribute value.
                     * 
                     * @param RPH
                     */
                    public void setRPH(BigInteger RPH) {
                        this.RPH = RPH;
                    }
                }
            }
        }
    }
}
