
package com.sabre.webservices.sabrexml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VerifyFlightDetailsRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="AvailabilityDetails" minOccurs="0">
 *         &lt;!-- Reference to inner class AvailabilityDetails -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="OriginDestinationInformation" minOccurs="0">
 *         &lt;!-- Reference to inner class OriginDestinationInformation -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnHostCommand"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute type="xs:string" use="required" fixed="2.0.1" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class VerifyFlightDetailsRQ implements Serializable
{
    private AvailabilityDetails availabilityDetails;
    private OriginDestinationInformation originDestinationInformation;
    private Boolean returnHostCommand;
    private Date timeStamp;
    private String version;

    /** 
     * Get the 'AvailabilityDetails' element value.
     * 
     * @return value
     */
    public AvailabilityDetails getAvailabilityDetails() {
        return availabilityDetails;
    }

    /** 
     * Set the 'AvailabilityDetails' element value.
     * 
     * @param availabilityDetails
     */
    public void setAvailabilityDetails(AvailabilityDetails availabilityDetails) {
        this.availabilityDetails = availabilityDetails;
    }

    /** 
     * Get the 'OriginDestinationInformation' element value.
     * 
     * @return value
     */
    public OriginDestinationInformation getOriginDestinationInformation() {
        return originDestinationInformation;
    }

    /** 
     * Set the 'OriginDestinationInformation' element value.
     * 
     * @param originDestinationInformation
     */
    public void setOriginDestinationInformation(
            OriginDestinationInformation originDestinationInformation) {
        this.originDestinationInformation = originDestinationInformation;
    }

    /** 
     * Get the 'ReturnHostCommand' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnHostCommand() {
        return returnHostCommand;
    }

    /** 
     * Set the 'ReturnHostCommand' attribute value.
     * 
     * @param returnHostCommand
     */
    public void setReturnHostCommand(Boolean returnHostCommand) {
        this.returnHostCommand = returnHostCommand;
    }

    /** 
     * Get the 'TimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AvailabilityDetails" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Line" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Line -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AvailabilityDetails implements Serializable
    {
        private List<Line> lineList = new ArrayList<Line>();

        /** 
         * Get the list of 'Line' element items.
         * 
         * @return list
         */
        public List<Line> getLineList() {
            return lineList;
        }

        /** 
         * Set the list of 'Line' element items.
         * 
         * @param list
         */
        public void setLineList(List<Line> list) {
            lineList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Line" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="EndNumber"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Number"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Line implements Serializable
        {
            private String endNumber;
            private String number;

            /** 
             * Get the 'EndNumber' attribute value.
             * 
             * @return value
             */
            public String getEndNumber() {
                return endNumber;
            }

            /** 
             * Set the 'EndNumber' attribute value.
             * 
             * @param endNumber
             */
            public void setEndNumber(String endNumber) {
                this.endNumber = endNumber;
            }

            /** 
             * Get the 'Number' attribute value.
             * 
             * @return value
             */
            public String getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value.
             * 
             * @param number
             */
            public void setNumber(String number) {
                this.number = number;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationInformation" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FlightSegment" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightSegment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationInformation implements Serializable
    {
        private FlightSegment flightSegment;

        /** 
         * Get the 'FlightSegment' element value.
         * 
         * @return value
         */
        public FlightSegment getFlightSegment() {
            return flightSegment;
        }

        /** 
         * Set the 'FlightSegment' element value.
         * 
         * @param flightSegment
         */
        public void setFlightSegment(FlightSegment flightSegment) {
            this.flightSegment = flightSegment;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="DestinationLocation" minOccurs="0">
         *         &lt;!-- Reference to inner class DestinationLocation -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MarketingAirline" minOccurs="0">
         *         &lt;!-- Reference to inner class MarketingAirline -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OriginLocation" minOccurs="0">
         *         &lt;!-- Reference to inner class OriginLocation -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightSegment implements Serializable
        {
            private DestinationLocation destinationLocation;
            private MarketingAirline marketingAirline;
            private OriginLocation originLocation;
            private String departureDateTime;
            private String flightNumber;

            /** 
             * Get the 'DestinationLocation' element value.
             * 
             * @return value
             */
            public DestinationLocation getDestinationLocation() {
                return destinationLocation;
            }

            /** 
             * Set the 'DestinationLocation' element value.
             * 
             * @param destinationLocation
             */
            public void setDestinationLocation(
                    DestinationLocation destinationLocation) {
                this.destinationLocation = destinationLocation;
            }

            /** 
             * Get the 'MarketingAirline' element value.
             * 
             * @return value
             */
            public MarketingAirline getMarketingAirline() {
                return marketingAirline;
            }

            /** 
             * Set the 'MarketingAirline' element value.
             * 
             * @param marketingAirline
             */
            public void setMarketingAirline(MarketingAirline marketingAirline) {
                this.marketingAirline = marketingAirline;
            }

            /** 
             * Get the 'OriginLocation' element value.
             * 
             * @return value
             */
            public OriginLocation getOriginLocation() {
                return originLocation;
            }

            /** 
             * Set the 'OriginLocation' element value.
             * 
             * @param originLocation
             */
            public void setOriginLocation(OriginLocation originLocation) {
                this.originLocation = originLocation;
            }

            /** 
             * Get the 'DepartureDateTime' attribute value.
             * 
             * @return value
             */
            public String getDepartureDateTime() {
                return departureDateTime;
            }

            /** 
             * Set the 'DepartureDateTime' attribute value.
             * 
             * @param departureDateTime
             */
            public void setDepartureDateTime(String departureDateTime) {
                this.departureDateTime = departureDateTime;
            }

            /** 
             * Get the 'FlightNumber' attribute value.
             * 
             * @return value
             */
            public String getFlightNumber() {
                return flightNumber;
            }

            /** 
             * Set the 'FlightNumber' attribute value.
             * 
             * @param flightNumber
             */
            public void setFlightNumber(String flightNumber) {
                this.flightNumber = flightNumber;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DestinationLocation implements Serializable
            {
                private String locationCode;

                /** 
                 * Get the 'LocationCode' attribute value.
                 * 
                 * @return value
                 */
                public String getLocationCode() {
                    return locationCode;
                }

                /** 
                 * Set the 'LocationCode' attribute value.
                 * 
                 * @param locationCode
                 */
                public void setLocationCode(String locationCode) {
                    this.locationCode = locationCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MarketingAirline implements Serializable
            {
                private String code;
                private String flightNumber;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'FlightNumber' attribute value.
                 * 
                 * @return value
                 */
                public String getFlightNumber() {
                    return flightNumber;
                }

                /** 
                 * Set the 'FlightNumber' attribute value.
                 * 
                 * @param flightNumber
                 */
                public void setFlightNumber(String flightNumber) {
                    this.flightNumber = flightNumber;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OriginLocation implements Serializable
            {
                private String locationCode;

                /** 
                 * Get the 'LocationCode' attribute value.
                 * 
                 * @return value
                 */
                public String getLocationCode() {
                    return locationCode;
                }

                /** 
                 * Set the 'LocationCode' attribute value.
                 * 
                 * @param locationCode
                 */
                public void setLocationCode(String locationCode) {
                    this.locationCode = locationCode;
                }
            }
        }
    }
}
