
package com.sabre.webservices.sabrexml;

import com.sabre.services.stl.v01.ApplicationResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VerifyFlightDetailsRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:ApplicationResults"/>
 *       &lt;xs:element name="OriginDestinationOptions" minOccurs="0">
 *         &lt;!-- Reference to inner class OriginDestinationOptions -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class VerifyFlightDetailsRS implements Serializable
{
    private ApplicationResults applicationResults;
    private OriginDestinationOptions originDestinationOptions;
    private String version;

    /** 
     * Get the 'ApplicationResults' element value.
     * 
     * @return value
     */
    public ApplicationResults getApplicationResults() {
        return applicationResults;
    }

    /** 
     * Set the 'ApplicationResults' element value.
     * 
     * @param applicationResults
     */
    public void setApplicationResults(ApplicationResults applicationResults) {
        this.applicationResults = applicationResults;
    }

    /** 
     * Get the 'OriginDestinationOptions' element value.
     * 
     * @return value
     */
    public OriginDestinationOptions getOriginDestinationOptions() {
        return originDestinationOptions;
    }

    /** 
     * Set the 'OriginDestinationOptions' element value.
     * 
     * @param originDestinationOptions
     */
    public void setOriginDestinationOptions(
            OriginDestinationOptions originDestinationOptions) {
        this.originDestinationOptions = originDestinationOptions;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOptions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OriginDestinationOption" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OriginDestinationOption -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationOptions implements Serializable
    {
        private List<OriginDestinationOption> originDestinationOptionList = new ArrayList<OriginDestinationOption>();

        /** 
         * Get the list of 'OriginDestinationOption' element items.
         * 
         * @return list
         */
        public List<OriginDestinationOption> getOriginDestinationOptionList() {
            return originDestinationOptionList;
        }

        /** 
         * Set the list of 'OriginDestinationOption' element items.
         * 
         * @param list
         */
        public void setOriginDestinationOptionList(
                List<OriginDestinationOption> list) {
            originDestinationOptionList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOption" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class FlightSegment -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="DestinationTimeZone"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="OriginTimeZone"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginDestinationOption implements Serializable
        {
            private List<FlightSegment> flightSegmentList = new ArrayList<FlightSegment>();
            private String destinationTimeZone;
            private String originTimeZone;

            /** 
             * Get the list of 'FlightSegment' element items.
             * 
             * @return list
             */
            public List<FlightSegment> getFlightSegmentList() {
                return flightSegmentList;
            }

            /** 
             * Set the list of 'FlightSegment' element items.
             * 
             * @param list
             */
            public void setFlightSegmentList(List<FlightSegment> list) {
                flightSegmentList = list;
            }

            /** 
             * Get the 'DestinationTimeZone' attribute value. is used to return destination time zone-related information
             * 
             * @return value
             */
            public String getDestinationTimeZone() {
                return destinationTimeZone;
            }

            /** 
             * Set the 'DestinationTimeZone' attribute value. is used to return destination time zone-related information
             * 
             * @param destinationTimeZone
             */
            public void setDestinationTimeZone(String destinationTimeZone) {
                this.destinationTimeZone = destinationTimeZone;
            }

            /** 
             * Get the 'OriginTimeZone' attribute value. is used to return origin time zone-related information
             * 
             * @return value
             */
            public String getOriginTimeZone() {
                return originTimeZone;
            }

            /** 
             * Set the 'OriginTimeZone' attribute value. is used to return origin time zone-related information
             * 
             * @param originTimeZone
             */
            public void setOriginTimeZone(String originTimeZone) {
                this.originTimeZone = originTimeZone;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegment" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="DestinationLocation" minOccurs="0">
             *         &lt;!-- Reference to inner class DestinationLocation -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Equipment" minOccurs="0">
             *         &lt;!-- Reference to inner class Equipment -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FlightDetails" minOccurs="0">
             *         &lt;!-- Reference to inner class FlightDetails -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="MarketingAirline" minOccurs="0">
             *         &lt;!-- Reference to inner class MarketingAirline -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Meal" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Meal -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="OriginLocation" minOccurs="0">
             *         &lt;!-- Reference to inner class OriginLocation -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="optional" name="AirMilesFlown"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDateTime"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="DepartureDateTime"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ElapsedTime"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="AccumulatedElapsedTime"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FlightSegment implements Serializable
            {
                private DestinationLocation destinationLocation;
                private Equipment equipment;
                private FlightDetails flightDetails;
                private MarketingAirline marketingAirline;
                private List<Meal> mealList = new ArrayList<Meal>();
                private OriginLocation originLocation;
                private String airMilesFlown;
                private String arrivalDateTime;
                private String departureDateTime;
                private String elapsedTime;
                private String accumulatedElapsedTime;
                private String flightNumber;
                private String RPH;

                /** 
                 * Get the 'DestinationLocation' element value.
                 * 
                 * @return value
                 */
                public DestinationLocation getDestinationLocation() {
                    return destinationLocation;
                }

                /** 
                 * Set the 'DestinationLocation' element value.
                 * 
                 * @param destinationLocation
                 */
                public void setDestinationLocation(
                        DestinationLocation destinationLocation) {
                    this.destinationLocation = destinationLocation;
                }

                /** 
                 * Get the 'Equipment' element value.
                 * 
                 * @return value
                 */
                public Equipment getEquipment() {
                    return equipment;
                }

                /** 
                 * Set the 'Equipment' element value.
                 * 
                 * @param equipment
                 */
                public void setEquipment(Equipment equipment) {
                    this.equipment = equipment;
                }

                /** 
                 * Get the 'FlightDetails' element value.
                 * 
                 * @return value
                 */
                public FlightDetails getFlightDetails() {
                    return flightDetails;
                }

                /** 
                 * Set the 'FlightDetails' element value.
                 * 
                 * @param flightDetails
                 */
                public void setFlightDetails(FlightDetails flightDetails) {
                    this.flightDetails = flightDetails;
                }

                /** 
                 * Get the 'MarketingAirline' element value.
                 * 
                 * @return value
                 */
                public MarketingAirline getMarketingAirline() {
                    return marketingAirline;
                }

                /** 
                 * Set the 'MarketingAirline' element value.
                 * 
                 * @param marketingAirline
                 */
                public void setMarketingAirline(
                        MarketingAirline marketingAirline) {
                    this.marketingAirline = marketingAirline;
                }

                /** 
                 * Get the list of 'Meal' element items.
                 * 
                 * @return list
                 */
                public List<Meal> getMealList() {
                    return mealList;
                }

                /** 
                 * Set the list of 'Meal' element items.
                 * 
                 * @param list
                 */
                public void setMealList(List<Meal> list) {
                    mealList = list;
                }

                /** 
                 * Get the 'OriginLocation' element value.
                 * 
                 * @return value
                 */
                public OriginLocation getOriginLocation() {
                    return originLocation;
                }

                /** 
                 * Set the 'OriginLocation' element value.
                 * 
                 * @param originLocation
                 */
                public void setOriginLocation(OriginLocation originLocation) {
                    this.originLocation = originLocation;
                }

                /** 
                 * Get the 'AirMilesFlown' attribute value. is used to return the air miles flown associated with the particular flight segment
                 * 
                 * @return value
                 */
                public String getAirMilesFlown() {
                    return airMilesFlown;
                }

                /** 
                 * Set the 'AirMilesFlown' attribute value. is used to return the air miles flown associated with the particular flight segment
                 * 
                 * @param airMilesFlown
                 */
                public void setAirMilesFlown(String airMilesFlown) {
                    this.airMilesFlown = airMilesFlown;
                }

                /** 
                 * Get the 'ArrivalDateTime' attribute value. is used to return the scheduled arrival date/time associated with the particular flight segmentfollows this format: MM-DDTHH:MM
                 * 
                 * @return value
                 */
                public String getArrivalDateTime() {
                    return arrivalDateTime;
                }

                /** 
                 * Set the 'ArrivalDateTime' attribute value. is used to return the scheduled arrival date/time associated with the particular flight segmentfollows this format: MM-DDTHH:MM
                 * 
                 * @param arrivalDateTime
                 */
                public void setArrivalDateTime(String arrivalDateTime) {
                    this.arrivalDateTime = arrivalDateTime;
                }

                /** 
                 * Get the 'DepartureDateTime' attribute value. is used to return the scheduled departure date/time associated with the particular flight segmentfollows this format: MM-DDTHH:MM
                 * 
                 * @return value
                 */
                public String getDepartureDateTime() {
                    return departureDateTime;
                }

                /** 
                 * Set the 'DepartureDateTime' attribute value. is used to return the scheduled departure date/time associated with the particular flight segmentfollows this format: MM-DDTHH:MM
                 * 
                 * @param departureDateTime
                 */
                public void setDepartureDateTime(String departureDateTime) {
                    this.departureDateTime = departureDateTime;
                }

                /** 
                 * Get the 'ElapsedTime' attribute value.
                 * 
                 * @return value
                 */
                public String getElapsedTime() {
                    return elapsedTime;
                }

                /** 
                 * Set the 'ElapsedTime' attribute value.
                 * 
                 * @param elapsedTime
                 */
                public void setElapsedTime(String elapsedTime) {
                    this.elapsedTime = elapsedTime;
                }

                /** 
                 * Get the 'AccumulatedElapsedTime' attribute value.
                 * 
                 * @return value
                 */
                public String getAccumulatedElapsedTime() {
                    return accumulatedElapsedTime;
                }

                /** 
                 * Set the 'AccumulatedElapsedTime' attribute value.
                 * 
                 * @param accumulatedElapsedTime
                 */
                public void setAccumulatedElapsedTime(
                        String accumulatedElapsedTime) {
                    this.accumulatedElapsedTime = accumulatedElapsedTime;
                }

                /** 
                 * Get the 'FlightNumber' attribute value. is used to return the flight number associated with the particular flight segment
                 * 
                 * @return value
                 */
                public String getFlightNumber() {
                    return flightNumber;
                }

                /** 
                 * Set the 'FlightNumber' attribute value. is used to return the flight number associated with the particular flight segment
                 * 
                 * @param flightNumber
                 */
                public void setFlightNumber(String flightNumber) {
                    this.flightNumber = flightNumber;
                }

                /** 
                 * Get the 'RPH' attribute value. is used as a reference place holder
                 * 
                 * @return value
                 */
                public String getRPH() {
                    return RPH;
                }

                /** 
                 * Set the 'RPH' attribute value. is used as a reference place holder
                 * 
                 * @param RPH
                 */
                public void setRPH(String RPH) {
                    this.RPH = RPH;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestinationLocation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Terminal"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class DestinationLocation implements Serializable
                {
                    private String locationCode;
                    private String terminal;

                    /** 
                     * Get the 'LocationCode' attribute value. is used to return the destination airport code
                     * 
                     * @return value
                     */
                    public String getLocationCode() {
                        return locationCode;
                    }

                    /** 
                     * Set the 'LocationCode' attribute value. is used to return the destination airport code
                     * 
                     * @param locationCode
                     */
                    public void setLocationCode(String locationCode) {
                        this.locationCode = locationCode;
                    }

                    /** 
                     * Get the 'Terminal' attribute value. is used to return the destination airport terminal
                     * 
                     * @return value
                     */
                    public String getTerminal() {
                        return terminal;
                    }

                    /** 
                     * Set the 'Terminal' attribute value. is used to return the destination airport terminal
                     * 
                     * @param terminal
                     */
                    public void setTerminal(String terminal) {
                        this.terminal = terminal;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Equipment" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="AirEquipType"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Equipment implements Serializable
                {
                    private String airEquipType;

                    /** 
                     * Get the 'AirEquipType' attribute value. is used to return the aircraft equipment type associated with the particular flight segment
                     * 
                     * @return value
                     */
                    public String getAirEquipType() {
                        return airEquipType;
                    }

                    /** 
                     * Set the 'AirEquipType' attribute value. is used to return the aircraft equipment type associated with the particular flight segment
                     * 
                     * @param airEquipType
                     */
                    public void setAirEquipType(String airEquipType) {
                        this.airEquipType = airEquipType;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDetails" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="unbounded"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FlightDetails implements Serializable
                {
                    private List<String> textList = new ArrayList<String>();

                    /** 
                     * Get the list of 'Text' element items. "Text" is used to return miscellaneous free text information
                     * 
                     * @return list
                     */
                    public List<String> getTextList() {
                        return textList;
                    }

                    /** 
                     * Set the list of 'Text' element items. "Text" is used to return miscellaneous free text information
                     * 
                     * @param list
                     */
                    public void setTextList(List<String> list) {
                        textList = list;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingAirline" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class MarketingAirline implements Serializable
                {
                    private String code;
                    private String flightNumber;

                    /** 
                     * Get the 'Code' attribute value. is used to return the marketing airline code associated with the particular flight segment
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. is used to return the marketing airline code associated with the particular flight segment
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }

                    /** 
                     * Get the 'FlightNumber' attribute value. is used to return the flight number associated with the particular flight segment
                     * 
                     * @return value
                     */
                    public String getFlightNumber() {
                        return flightNumber;
                    }

                    /** 
                     * Set the 'FlightNumber' attribute value. is used to return the flight number associated with the particular flight segment
                     * 
                     * @param flightNumber
                     */
                    public void setFlightNumber(String flightNumber) {
                        this.flightNumber = flightNumber;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Meal" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Meal implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value. is used to return the meal code associated with the particular flight segment if applicable
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. is used to return the meal code associated with the particular flight segment if applicable
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/sabreXML/2011/10" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginLocation" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="Terminal"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OriginLocation implements Serializable
                {
                    private String locationCode;
                    private String terminal;

                    /** 
                     * Get the 'LocationCode' attribute value. is used to return the origin airport code
                     * 
                     * @return value
                     */
                    public String getLocationCode() {
                        return locationCode;
                    }

                    /** 
                     * Set the 'LocationCode' attribute value. is used to return the origin airport code
                     * 
                     * @param locationCode
                     */
                    public void setLocationCode(String locationCode) {
                        this.locationCode = locationCode;
                    }

                    /** 
                     * Get the 'Terminal' attribute value. is used to return the origin airport terminal
                     * 
                     * @return value
                     */
                    public String getTerminal() {
                        return terminal;
                    }

                    /** 
                     * Set the 'Terminal' attribute value. is used to return the origin airport terminal
                     * 
                     * @param terminal
                     */
                    public void setTerminal(String terminal) {
                        this.terminal = terminal;
                    }
                }
            }
        }
    }
}
