
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaseTripAttributes">
 *   &lt;xs:attribute type="xs:string" use="optional" name="ConversationId"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Compression"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EchoToken"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *   &lt;xs:attribute type="xs:string" use="optional" default="Production" name="Target"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="SequenceNmbr"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PrimaryLangID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AltLangID"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="ReturnContent"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BaseTripAttributes implements Serializable
{
    private String conversationId;
    private Boolean compression;
    private String echoToken;
    private Date timeStamp;
    private String target;
    private String version;
    private BigInteger sequenceNmbr;
    private String primaryLangID;
    private String altLangID;
    private Boolean returnContent;

    /** 
     * Get the 'ConversationId' attribute value.
     * 
     * @return value
     */
    public String getConversationId() {
        return conversationId;
    }

    /** 
     * Set the 'ConversationId' attribute value.
     * 
     * @param conversationId
     */
    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    /** 
     * Get the 'Compression' attribute value.
     * 
     * @return value
     */
    public Boolean getCompression() {
        return compression;
    }

    /** 
     * Set the 'Compression' attribute value.
     * 
     * @param compression
     */
    public void setCompression(Boolean compression) {
        this.compression = compression;
    }

    /** 
     * Get the 'EchoToken' attribute value. 
    				A sequence number for additional message
    				identification, assigned by
    				the requesting host system.
    				When a
    				request message includes an echo
    				token the corresponding response
    				message MUST include an echo token
    				with an
    				identical value.
    			
     * 
     * @return value
     */
    public String getEchoToken() {
        return echoToken;
    }

    /** 
     * Set the 'EchoToken' attribute value. 
    				A sequence number for additional message
    				identification, assigned by
    				the requesting host system.
    				When a
    				request message includes an echo
    				token the corresponding response
    				message MUST include an echo token
    				with an
    				identical value.
    			
     * 
     * @param echoToken
     */
    public void setEchoToken(String echoToken) {
        this.echoToken = echoToken;
    }

    /** 
     * Get the 'TimeStamp' attribute value. 
    				Indicates the creation date and time of the
    				message in UTC using the
    				following format specified by
    				ISO 8601;
    				YYYY- MM- DDThh:mm:ssZ with
    				time values using the 24 hour clock
    				(e.g. 20 November 2003, 1:59:38
    				pm UTC
    				becomes 2003-11-
    				20T13:59:38Z).
          
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. 
    				Indicates the creation date and time of the
    				message in UTC using the
    				following format specified by
    				ISO 8601;
    				YYYY- MM- DDThh:mm:ssZ with
    				time values using the 24 hour clock
    				(e.g. 20 November 2003, 1:59:38
    				pm UTC
    				becomes 2003-11-
    				20T13:59:38Z).
          
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for
    				the
    				Test or Production system.
     * 
     * @return value
     */
    public String getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for
    				the
    				Test or Production system.
     * 
     * @param target
     */
    public void setTarget(String target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of
    				the
    				message is indicated by a decimal value.
    			
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of
    				the
    				message is indicated by a decimal value.
    			
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'SequenceNmbr' attribute value. 
    				Used to identify the sequence number of the
    				transaction as assigned by
    				the sending system; allows
    				for an
    				application to process messages
    				in
    				a certain order or to request a
    				resynchronization of messages in the
    				event
    				that a system has been
    				off-line and needs to retrieve
    				messages
    				that were missed.
    			
     * 
     * @return value
     */
    public BigInteger getSequenceNmbr() {
        return sequenceNmbr;
    }

    /** 
     * Set the 'SequenceNmbr' attribute value. 
    				Used to identify the sequence number of the
    				transaction as assigned by
    				the sending system; allows
    				for an
    				application to process messages
    				in
    				a certain order or to request a
    				resynchronization of messages in the
    				event
    				that a system has been
    				off-line and needs to retrieve
    				messages
    				that were missed.
    			
     * 
     * @param sequenceNmbr
     */
    public void setSequenceNmbr(BigInteger sequenceNmbr) {
        this.sequenceNmbr = sequenceNmbr;
    }

    /** 
     * Get the 'PrimaryLangID' attribute value. 
    				Identifies the primary language preference for the
    				form of travel represented
    				in a collection. The
    				human language is
    				identified by ISO 639
    				codes.
          
     * 
     * @return value
     */
    public String getPrimaryLangID() {
        return primaryLangID;
    }

    /** 
     * Set the 'PrimaryLangID' attribute value. 
    				Identifies the primary language preference for the
    				form of travel represented
    				in a collection. The
    				human language is
    				identified by ISO 639
    				codes.
          
     * 
     * @param primaryLangID
     */
    public void setPrimaryLangID(String primaryLangID) {
        this.primaryLangID = primaryLangID;
    }

    /** 
     * Get the 'AltLangID' attribute value. 
    				Identifies the primary language preference for the
    				form of travel represented
    				in a collection. The
    				human language is
    				identified by ISO 639
    				codes.
          
     * 
     * @return value
     */
    public String getAltLangID() {
        return altLangID;
    }

    /** 
     * Set the 'AltLangID' attribute value. 
    				Identifies the primary language preference for the
    				form of travel represented
    				in a collection. The
    				human language is
    				identified by ISO 639
    				codes.
          
     * 
     * @param altLangID
     */
    public void setAltLangID(String altLangID) {
        this.altLangID = altLangID;
    }

    /** 
     * Get the 'ReturnContent' attribute value.
     * 
     * @return value
     */
    public Boolean getReturnContent() {
        return returnContent;
    }

    /** 
     * Set the 'ReturnContent' attribute value.
     * 
     * @param returnContent
     */
    public void setReturnContent(Boolean returnContent) {
        this.returnContent = returnContent;
    }
}
