
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" abstract="true" name="BaseTripResponse">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Success" minOccurs="0"/>
 *     &lt;xs:element name="Warnings" minOccurs="0">
 *       &lt;!-- Reference to inner class Warnings -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Errors" minOccurs="0">
 *       &lt;!-- Reference to inner class Errors -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:BaseTripAttributes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public abstract class BaseTripResponse implements Serializable
{
    private String success;
    private Warnings warnings;
    private Errors errors;
    private BaseTripAttributes baseTripAttributes;

    /** 
     * Get the 'Success' element value.
     * 
     * @return value
     */
    public String getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value.
     * 
     * @param success
     */
    public void setSuccess(String success) {
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value.
     * 
     * @return value
     */
    public Warnings getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value.
     * 
     * @param warnings
     */
    public void setWarnings(Warnings warnings) {
        this.warnings = warnings;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public Errors getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    /** 
     * Get the 'BaseTripAttributes' attributeGroup value.
     * 
     * @return value
     */
    public BaseTripAttributes getBaseTripAttributes() {
        return baseTripAttributes;
    }

    /** 
     * Set the 'BaseTripAttributes' attributeGroup value.
     * 
     * @param baseTripAttributes
     */
    public void setBaseTripAttributes(BaseTripAttributes baseTripAttributes) {
        this.baseTripAttributes = baseTripAttributes;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warnings" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Warning" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Warning -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Warnings implements Serializable
    {
        private List<Warning> warningList = new ArrayList<Warning>();

        /** 
         * Get the list of 'Warning' element items.
         * 
         * @return list
         */
        public List<Warning> getWarningList() {
            return warningList;
        }

        /** 
         * Set the list of 'Warning' element items.
         * 
         * @param list
         */
        public void setWarningList(List<Warning> list) {
            warningList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warning" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="ShortText"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Warning implements Serializable
        {
            private String string;
            private String shortText;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'ShortText' attribute value.
             * 
             * @return value
             */
            public String getShortText() {
                return shortText;
            }

            /** 
             * Set the 'ShortText' attribute value.
             * 
             * @param shortText
             */
            public void setShortText(String shortText) {
                this.shortText = shortText;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Errors" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Error" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class _Error -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Errors implements Serializable
    {
        private List<_Error> errorList = new ArrayList<_Error>();

        /** 
         * Get the list of 'Error' element items.
         * 
         * @return list
         */
        public List<_Error> getErrorList() {
            return errorList;
        }

        /** 
         * Set the list of 'Error' element items.
         * 
         * @param list
         */
        public void setErrorList(List<_Error> list) {
            errorList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Error" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="ErrorInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class ErrorInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ErrorCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Severity"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ErrorMessage"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class _Error implements Serializable
        {
            private ErrorInfo errorInfo;
            private String errorCode;
            private String severity;
            private String errorMessage;

            /** 
             * Get the 'ErrorInfo' element value.
             * 
             * @return value
             */
            public ErrorInfo getErrorInfo() {
                return errorInfo;
            }

            /** 
             * Set the 'ErrorInfo' element value.
             * 
             * @param errorInfo
             */
            public void setErrorInfo(ErrorInfo errorInfo) {
                this.errorInfo = errorInfo;
            }

            /** 
             * Get the 'ErrorCode' attribute value.
             * 
             * @return value
             */
            public String getErrorCode() {
                return errorCode;
            }

            /** 
             * Set the 'ErrorCode' attribute value.
             * 
             * @param errorCode
             */
            public void setErrorCode(String errorCode) {
                this.errorCode = errorCode;
            }

            /** 
             * Get the 'Severity' attribute value.
             * 
             * @return value
             */
            public String getSeverity() {
                return severity;
            }

            /** 
             * Set the 'Severity' attribute value.
             * 
             * @param severity
             */
            public void setSeverity(String severity) {
                this.severity = severity;
            }

            /** 
             * Get the 'ErrorMessage' attribute value.
             * 
             * @return value
             */
            public String getErrorMessage() {
                return errorMessage;
            }

            /** 
             * Set the 'ErrorMessage' attribute value.
             * 
             * @param errorMessage
             */
            public void setErrorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ErrorInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Message" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ErrorInfo implements Serializable
            {
                private String message;

                /** 
                 * Get the 'Message' element value.
                 * 
                 * @return value
                 */
                public String getMessage() {
                    return message;
                }

                /** 
                 * Set the 'Message' element value.
                 * 
                 * @param message
                 */
                public void setMessage(String message) {
                    this.message = message;
                }
            }
        }
    }
}
