
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PassengerNameType" name="Name" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:EmailType" name="Email" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ProfileType" name="Profile" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:LoyaltyType" name="Loyalty" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Phone" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ContactType" name="Contact" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:UpdateAttributes"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="ProfileStoredItem"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CustomerType implements Serializable
{
    private List<PassengerNameType> nameList = new ArrayList<PassengerNameType>();
    private List<EmailType> emailList = new ArrayList<EmailType>();
    private List<ProfileType> profileList = new ArrayList<ProfileType>();
    private List<LoyaltyType> loyaltyList = new ArrayList<LoyaltyType>();
    private List<TelephoneType> phoneList = new ArrayList<TelephoneType>();
    private List<AddressType> addressList = new ArrayList<AddressType>();
    private List<ContactType> contactList = new ArrayList<ContactType>();
    private UpdateAttributes updateAttributes;
    private Boolean profileStoredItem;

    /** 
     * Get the list of 'Name' element items.
     * 
     * @return list
     */
    public List<PassengerNameType> getNameList() {
        return nameList;
    }

    /** 
     * Set the list of 'Name' element items.
     * 
     * @param list
     */
    public void setNameList(List<PassengerNameType> list) {
        nameList = list;
    }

    /** 
     * Get the list of 'Email' element items.
     * 
     * @return list
     */
    public List<EmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items.
     * 
     * @param list
     */
    public void setEmailList(List<EmailType> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'Profile' element items.
     * 
     * @return list
     */
    public List<ProfileType> getProfileList() {
        return profileList;
    }

    /** 
     * Set the list of 'Profile' element items.
     * 
     * @param list
     */
    public void setProfileList(List<ProfileType> list) {
        profileList = list;
    }

    /** 
     * Get the list of 'Loyalty' element items.
     * 
     * @return list
     */
    public List<LoyaltyType> getLoyaltyList() {
        return loyaltyList;
    }

    /** 
     * Set the list of 'Loyalty' element items.
     * 
     * @param list
     */
    public void setLoyaltyList(List<LoyaltyType> list) {
        loyaltyList = list;
    }

    /** 
     * Get the list of 'Phone' element items.
     * 
     * @return list
     */
    public List<TelephoneType> getPhoneList() {
        return phoneList;
    }

    /** 
     * Set the list of 'Phone' element items.
     * 
     * @param list
     */
    public void setPhoneList(List<TelephoneType> list) {
        phoneList = list;
    }

    /** 
     * Get the list of 'Address' element items.
     * 
     * @return list
     */
    public List<AddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items.
     * 
     * @param list
     */
    public void setAddressList(List<AddressType> list) {
        addressList = list;
    }

    /** 
     * Get the list of 'Contact' element items.
     * 
     * @return list
     */
    public List<ContactType> getContactList() {
        return contactList;
    }

    /** 
     * Set the list of 'Contact' element items.
     * 
     * @param list
     */
    public void setContactList(List<ContactType> list) {
        contactList = list;
    }

    /** 
     * Get the 'UpdateAttributes' attributeGroup value.
     * 
     * @return value
     */
    public UpdateAttributes getUpdateAttributes() {
        return updateAttributes;
    }

    /** 
     * Set the 'UpdateAttributes' attributeGroup value.
     * 
     * @param updateAttributes
     */
    public void setUpdateAttributes(UpdateAttributes updateAttributes) {
        this.updateAttributes = updateAttributes;
    }

    /** 
     * Get the 'ProfileStoredItem' attribute value.
     * 
     * @return value
     */
    public Boolean getProfileStoredItem() {
        return profileStoredItem;
    }

    /** 
     * Set the 'ProfileStoredItem' attribute value.
     * 
     * @param profileStoredItem
     */
    public void setProfileStoredItem(Boolean profileStoredItem) {
        this.profileStoredItem = profileStoredItem;
    }
}
