
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AirlineCode"/>
 *     &lt;xs:element type="xs:string" name="FlightNumber"/>
 *     &lt;xs:element type="xs:string" name="DepartureAirport"/>
 *     &lt;xs:element type="xs:string" name="ArrivalAirport" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDateTime" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightType implements Serializable
{
    private String airlineCode;
    private String flightNumber;
    private String departureAirport;
    private String arrivalAirport;
    private Date departureDateTime;

    /** 
     * Get the 'AirlineCode' element value. The IATA assigned
    					airline code.
    				
     * 
     * @return value
     */
    public String getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'AirlineCode' element value. The IATA assigned
    					airline code.
    				
     * 
     * @param airlineCode
     */
    public void setAirlineCode(String airlineCode) {
        this.airlineCode = airlineCode;
    }

    /** 
     * Get the 'FlightNumber' element value.  The number of the flight.
    				
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value.  The number of the flight.
    				
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'DepartureAirport' element value. Departure point of flight segment.
    				
     * 
     * @return value
     */
    public String getDepartureAirport() {
        return departureAirport;
    }

    /** 
     * Set the 'DepartureAirport' element value. Departure point of flight segment.
    				
     * 
     * @param departureAirport
     */
    public void setDepartureAirport(String departureAirport) {
        this.departureAirport = departureAirport;
    }

    /** 
     * Get the 'ArrivalAirport' element value. Arrival point of flight segment.
    				
     * 
     * @return value
     */
    public String getArrivalAirport() {
        return arrivalAirport;
    }

    /** 
     * Set the 'ArrivalAirport' element value. Arrival point of flight segment.
    				
     * 
     * @param arrivalAirport
     */
    public void setArrivalAirport(String arrivalAirport) {
        this.arrivalAirport = arrivalAirport;
    }

    /** 
     * Get the 'DepartureDateTime' element value. Departure data for given flight. It uses
    					the
    					following format specified by ISO 8601;
    					YYYY-MM-DDThh:mm:ssZ
    					with
    					time values using the 24 hour clock (e.g. 20 November 2009,
    					1:59:38 pm UTC becomes
    					2009-11-20T13:59:38Z).
    			
     * 
     * @return value
     */
    public Date getDepartureDateTime() {
        return departureDateTime;
    }

    /** 
     * Set the 'DepartureDateTime' element value. Departure data for given flight. It uses
    					the
    					following format specified by ISO 8601;
    					YYYY-MM-DDThh:mm:ssZ
    					with
    					time values using the 24 hour clock (e.g. 20 November 2009,
    					1:59:38 pm UTC becomes
    					2009-11-20T13:59:38Z).
    			
     * 
     * @param departureDateTime
     */
    public void setDepartureDateTime(Date departureDateTime) {
        this.departureDateTime = departureDateTime;
    }
}
