
package com.sabre.webservices.triprecord;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GenericFieldType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="FirstName"/>
 *     &lt;xs:enumeration value="LastName"/>
 *     &lt;xs:enumeration value="Email"/>
 *     &lt;xs:enumeration value="ProfileID"/>
 *     &lt;xs:enumeration value="ProfileDomain"/>
 *     &lt;xs:enumeration value="ReservationID"/>
 *     &lt;xs:enumeration value="ReservationDomain"/>
 *     &lt;xs:enumeration value="FlightNumber"/>
 *     &lt;xs:enumeration value="DepartureDate"/>
 *     &lt;xs:enumeration value="ArrivalDate"/>
 *     &lt;xs:enumeration value="DepartureAirport"/>
 *     &lt;xs:enumeration value="ArrivalAirport"/>
 *     &lt;xs:enumeration value="MarketingAirline"/>
 *     &lt;xs:enumeration value="OperatingAirline"/>
 *     &lt;xs:enumeration value="LoyaltyID"/>
 *     &lt;xs:enumeration value="LoyaltyDomain"/>
 *     &lt;xs:enumeration value="PhoneAreaCityCode"/>
 *     &lt;xs:enumeration value="PhoneNumber"/>
 *     &lt;xs:enumeration value="TripName"/>
 *     &lt;xs:enumeration value="ComponentFirstName"/>
 *     &lt;xs:enumeration value="ComponentLastName"/>
 *     &lt;xs:enumeration value="ComponentLoyaltyID"/>
 *     &lt;xs:enumeration value="ComponentLoyaltyDomain"/>
 *     &lt;xs:enumeration value="ComponentPhoneAreaCityCode"/>
 *     &lt;xs:enumeration value="ComponentPhoneNumber"/>
 *     &lt;xs:enumeration value="ComponentEmail"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum GenericFieldType implements Serializable {
    FIRST_NAME("FirstName"), LAST_NAME("LastName"), EMAIL("Email"), PROFILE_ID(
            "ProfileID"), PROFILE_DOMAIN("ProfileDomain"), RESERVATION_ID(
            "ReservationID"), RESERVATION_DOMAIN("ReservationDomain"), FLIGHT_NUMBER(
            "FlightNumber"), DEPARTURE_DATE("DepartureDate"), ARRIVAL_DATE(
            "ArrivalDate"), DEPARTURE_AIRPORT("DepartureAirport"), ARRIVAL_AIRPORT(
            "ArrivalAirport"), MARKETING_AIRLINE("MarketingAirline"), OPERATING_AIRLINE(
            "OperatingAirline"), LOYALTY_ID("LoyaltyID"), LOYALTY_DOMAIN(
            "LoyaltyDomain"), PHONE_AREA_CITY_CODE("PhoneAreaCityCode"), PHONE_NUMBER(
            "PhoneNumber"), TRIP_NAME("TripName"), COMPONENT_FIRST_NAME(
            "ComponentFirstName"), COMPONENT_LAST_NAME("ComponentLastName"), COMPONENT_LOYALTY_ID(
            "ComponentLoyaltyID"), COMPONENT_LOYALTY_DOMAIN(
            "ComponentLoyaltyDomain"), COMPONENT_PHONE_AREA_CITY_CODE(
            "ComponentPhoneAreaCityCode"), COMPONENT_PHONE_NUMBER(
            "ComponentPhoneNumber"), COMPONENT_EMAIL("ComponentEmail");
    private final String value;

    private GenericFieldType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static GenericFieldType convert(String value) {
        for (GenericFieldType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
