
package com.sabre.webservices.triprecord;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroupActions">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="DeleteAll"/>
 *     &lt;xs:enumeration value="ReplaceAll"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum GroupActions implements Serializable {
    DELETE_ALL("DeleteAll"), REPLACE_ALL("ReplaceAll");
    private final String value;

    private GroupActions(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static GroupActions convert(String value) {
        for (GroupActions inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
