
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartnershipRecord">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AirlineCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element name="PartnershipAirlineCode" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class PartnershipAirlineCode -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="SegmentAssociationAllowed"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PartnershipRecord implements Serializable
{
    private String airlineCode;
    private List<PartnershipAirlineCode> partnershipAirlineCodeList = new ArrayList<PartnershipAirlineCode>();
    private Boolean segmentAssociationAllowed;

    /** 
     * Get the 'AirlineCode' element value.
     * 
     * @return value
     */
    public String getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'AirlineCode' element value.
     * 
     * @param airlineCode
     */
    public void setAirlineCode(String airlineCode) {
        this.airlineCode = airlineCode;
    }

    /** 
     * Get the list of 'PartnershipAirlineCode' element items.
     * 
     * @return list
     */
    public List<PartnershipAirlineCode> getPartnershipAirlineCodeList() {
        return partnershipAirlineCodeList;
    }

    /** 
     * Set the list of 'PartnershipAirlineCode' element items.
     * 
     * @param list
     */
    public void setPartnershipAirlineCodeList(List<PartnershipAirlineCode> list) {
        partnershipAirlineCodeList = list;
    }

    /** 
     * Get the 'SegmentAssociationAllowed' attribute value.
     * 
     * @return value
     */
    public Boolean getSegmentAssociationAllowed() {
        return segmentAssociationAllowed;
    }

    /** 
     * Set the 'SegmentAssociationAllowed' attribute value.
     * 
     * @param segmentAssociationAllowed
     */
    public void setSegmentAssociationAllowed(Boolean segmentAssociationAllowed) {
        this.segmentAssociationAllowed = segmentAssociationAllowed;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartnershipAirlineCode" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="ns:PartnershipType" name="type"/>
     *         &lt;xs:attribute type="xs:boolean" default="false" name="segmentAssociationAllowed"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PartnershipAirlineCode implements Serializable
    {
        private String string;
        private PartnershipType type;
        private Boolean segmentAssociationAllowed;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'type' attribute value.
         * 
         * @return value
         */
        public PartnershipType getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value.
         * 
         * @param type
         */
        public void setType(PartnershipType type) {
            this.type = type;
        }

        /** 
         * Get the 'segmentAssociationAllowed' attribute value.
         * 
         * @return value
         */
        public Boolean getSegmentAssociationAllowed() {
            return segmentAssociationAllowed;
        }

        /** 
         * Set the 'segmentAssociationAllowed' attribute value.
         * 
         * @param segmentAssociationAllowed
         */
        public void setSegmentAssociationAllowed(
                Boolean segmentAssociationAllowed) {
            this.segmentAssociationAllowed = segmentAssociationAllowed;
        }
    }
}
