
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetryRecord">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:RetryRecordRequestType" name="RequestType" minOccurs="1" maxOccurs="1"/>
 *       &lt;xs:element type="ns:RetryRecordServiceLocation" name="ServiceLocation" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="RequestData" minOccurs="0"/>
 *       &lt;xs:element type="xs:dateTime" name="LastRetryAttempt" minOccurs="0"/>
 *       &lt;xs:element type="xs:int" name="TotalNumberOfRetryAttempts" minOccurs="0"/>
 *       &lt;xs:element type="xs:int" name="CurrentNumberOfRetryAttempt" minOccurs="0"/>
 *       &lt;xs:element type="xs:dateTime" name="RetryDueTime" minOccurs="0"/>
 *       &lt;xs:element type="xs:int" name="FrequencyOfRetries" minOccurs="0"/>
 *       &lt;xs:element type="xs:dateTime" name="EndOfRetry" minOccurs="0"/>
 *       &lt;xs:element type="ns:RetryRecordStatus" name="Status" minOccurs="0"/>
 *       &lt;xs:element type="xs:dateTime" name="CreationTimestamp" minOccurs="1"/>
 *       &lt;xs:element type="xs:string" name="ErrorCause" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="AdditionalData" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="UniqueId" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="PnrLocator" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="PnrPartition" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class RetryRecord implements Serializable
{
    private RetryRecordRequestType requestType;
    private RetryRecordServiceLocation serviceLocation;
    private String requestData;
    private Date lastRetryAttempt;
    private Integer totalNumberOfRetryAttempts;
    private Integer currentNumberOfRetryAttempt;
    private Date retryDueTime;
    private Integer frequencyOfRetries;
    private Date endOfRetry;
    private RetryRecordStatus status;
    private Date creationTimestamp;
    private String errorCause;
    private String additionalData;
    private String uniqueId;
    private String pnrLocator;
    private String pnrPartition;

    /** 
     * Get the 'RequestType' element value. Type of request, for example SPANISH
    					
     * 
     * @return value
     */
    public RetryRecordRequestType getRequestType() {
        return requestType;
    }

    /** 
     * Set the 'RequestType' element value. Type of request, for example SPANISH
    					
     * 
     * @param requestType
     */
    public void setRequestType(RetryRecordRequestType requestType) {
        this.requestType = requestType;
    }

    /** 
     * Get the 'ServiceLocation' element value. Location of service (TRIP, S2,..)
    					
     * 
     * @return value
     */
    public RetryRecordServiceLocation getServiceLocation() {
        return serviceLocation;
    }

    /** 
     * Set the 'ServiceLocation' element value. Location of service (TRIP, S2,..)
    					
     * 
     * @param serviceLocation
     */
    public void setServiceLocation(RetryRecordServiceLocation serviceLocation) {
        this.serviceLocation = serviceLocation;
    }

    /** 
     * Get the 'RequestData' element value. Payload of request that need to be retried.
    					
     * 
     * @return value
     */
    public String getRequestData() {
        return requestData;
    }

    /** 
     * Set the 'RequestData' element value. Payload of request that need to be retried.
    					
     * 
     * @param requestData
     */
    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    /** 
     * Get the 'LastRetryAttempt' element value. Timestamp of last retry attempt
    					
     * 
     * @return value
     */
    public Date getLastRetryAttempt() {
        return lastRetryAttempt;
    }

    /** 
     * Set the 'LastRetryAttempt' element value. Timestamp of last retry attempt
    					
     * 
     * @param lastRetryAttempt
     */
    public void setLastRetryAttempt(Date lastRetryAttempt) {
        this.lastRetryAttempt = lastRetryAttempt;
    }

    /** 
     * Get the 'TotalNumberOfRetryAttempts' element value. This field may be also calculated basing on
    						values FrequencyOfRetries and EndOfRetry.
    					
     * 
     * @return value
     */
    public Integer getTotalNumberOfRetryAttempts() {
        return totalNumberOfRetryAttempts;
    }

    /** 
     * Set the 'TotalNumberOfRetryAttempts' element value. This field may be also calculated basing on
    						values FrequencyOfRetries and EndOfRetry.
    					
     * 
     * @param totalNumberOfRetryAttempts
     */
    public void setTotalNumberOfRetryAttempts(Integer totalNumberOfRetryAttempts) {
        this.totalNumberOfRetryAttempts = totalNumberOfRetryAttempts;
    }

    /** 
     * Get the 'CurrentNumberOfRetryAttempt' element value. Value of CurrentNumberOfRetryAttempt is
    						incremented after each retry execution
    					
     * 
     * @return value
     */
    public Integer getCurrentNumberOfRetryAttempt() {
        return currentNumberOfRetryAttempt;
    }

    /** 
     * Set the 'CurrentNumberOfRetryAttempt' element value. Value of CurrentNumberOfRetryAttempt is
    						incremented after each retry execution
    					
     * 
     * @param currentNumberOfRetryAttempt
     */
    public void setCurrentNumberOfRetryAttempt(
            Integer currentNumberOfRetryAttempt) {
        this.currentNumberOfRetryAttempt = currentNumberOfRetryAttempt;
    }

    /** 
     * Get the 'RetryDueTime' element value. Timestamp of next retry execution
    					
     * 
     * @return value
     */
    public Date getRetryDueTime() {
        return retryDueTime;
    }

    /** 
     * Set the 'RetryDueTime' element value. Timestamp of next retry execution
    					
     * 
     * @param retryDueTime
     */
    public void setRetryDueTime(Date retryDueTime) {
        this.retryDueTime = retryDueTime;
    }

    /** 
     * Get the 'FrequencyOfRetries' element value. Frequency of retries in minutes
    					
     * 
     * @return value
     */
    public Integer getFrequencyOfRetries() {
        return frequencyOfRetries;
    }

    /** 
     * Set the 'FrequencyOfRetries' element value. Frequency of retries in minutes
    					
     * 
     * @param frequencyOfRetries
     */
    public void setFrequencyOfRetries(Integer frequencyOfRetries) {
        this.frequencyOfRetries = frequencyOfRetries;
    }

    /** 
     * Get the 'EndOfRetry' element value. Timestamp of scheduled end of retry execution.
    					
     * 
     * @return value
     */
    public Date getEndOfRetry() {
        return endOfRetry;
    }

    /** 
     * Set the 'EndOfRetry' element value. Timestamp of scheduled end of retry execution.
    					
     * 
     * @param endOfRetry
     */
    public void setEndOfRetry(Date endOfRetry) {
        this.endOfRetry = endOfRetry;
    }

    /** 
     * Get the 'Status' element value. Status of retry execution. Currently supported
    						statuses are: NEW, IN_PROGRESS, COMPLETED, FAILED, POST_PROCESSSING_NEEDED
    					
     * 
     * @return value
     */
    public RetryRecordStatus getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. Status of retry execution. Currently supported
    						statuses are: NEW, IN_PROGRESS, COMPLETED, FAILED, POST_PROCESSSING_NEEDED
    					
     * 
     * @param status
     */
    public void setStatus(RetryRecordStatus status) {
        this.status = status;
    }

    /** 
     * Get the 'CreationTimestamp' element value. Timestamp of requestCreation. Used in file name.
    					
     * 
     * @return value
     */
    public Date getCreationTimestamp() {
        return creationTimestamp;
    }

    /** 
     * Set the 'CreationTimestamp' element value. Timestamp of requestCreation. Used in file name.
    					
     * 
     * @param creationTimestamp
     */
    public void setCreationTimestamp(Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    /** 
     * Get the 'ErrorCause' element value. Cause of retry, for example stack trace of exception
    					
     * 
     * @return value
     */
    public String getErrorCause() {
        return errorCause;
    }

    /** 
     * Set the 'ErrorCause' element value. Cause of retry, for example stack trace of exception
    					
     * 
     * @param errorCause
     */
    public void setErrorCause(String errorCause) {
        this.errorCause = errorCause;
    }

    /** 
     * Get the 'AdditionalData' element value. Addidional data needed for retry execution
    					
     * 
     * @return value
     */
    public String getAdditionalData() {
        return additionalData;
    }

    /** 
     * Set the 'AdditionalData' element value. Addidional data needed for retry execution
    					
     * 
     * @param additionalData
     */
    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    /** 
     * Get the 'UniqueId' element value. Unique Identifier of retry record
    					
     * 
     * @return value
     */
    public String getUniqueId() {
        return uniqueId;
    }

    /** 
     * Set the 'UniqueId' element value. Unique Identifier of retry record
    					
     * 
     * @param uniqueId
     */
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    /** 
     * Get the 'PnrLocator' element value. Pnr Locator used for Update
    					
     * 
     * @return value
     */
    public String getPnrLocator() {
        return pnrLocator;
    }

    /** 
     * Set the 'PnrLocator' element value. Pnr Locator used for Update
    					
     * 
     * @param pnrLocator
     */
    public void setPnrLocator(String pnrLocator) {
        this.pnrLocator = pnrLocator;
    }

    /** 
     * Get the 'PnrPartition' element value. Partition Pnr resides in
    					
     * 
     * @return value
     */
    public String getPnrPartition() {
        return pnrPartition;
    }

    /** 
     * Set the 'PnrPartition' element value. Partition Pnr resides in
    					
     * 
     * @param pnrPartition
     */
    public void setPnrPartition(String pnrPartition) {
        this.pnrPartition = pnrPartition;
    }
}
