
package com.sabre.webservices.triprecord;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TelephoneType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:string" name="FullPhoneNumber"/>
 *       &lt;xs:element type="ns:ParsedPhoneNumberType" name="ParsedPhoneNumber"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="DeviceType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Vendor"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Comment"/>
 *   &lt;xs:attributeGroup ref="ns:UpdateAttributes"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="ProfileStoredItem"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TelephoneType implements Serializable
{
    private int choiceSelect = -1;
    private static final int FULL_PHONE_NUMBER_CHOICE = 0;
    private static final int PARSED_PHONE_NUMBER_CHOICE = 1;
    private String fullPhoneNumber;
    private ParsedPhoneNumberType parsedPhoneNumber;
    private String deviceType;
    private String vendor;
    private String comment;
    private UpdateAttributes updateAttributes;
    private Boolean profileStoredItem;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FullPhoneNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFullPhoneNumber() {
        return choiceSelect == FULL_PHONE_NUMBER_CHOICE;
    }

    /** 
     * Get the 'FullPhoneNumber' element value.
     * 
     * @return value
     */
    public String getFullPhoneNumber() {
        return fullPhoneNumber;
    }

    /** 
     * Set the 'FullPhoneNumber' element value.
     * 
     * @param fullPhoneNumber
     */
    public void setFullPhoneNumber(String fullPhoneNumber) {
        setChoiceSelect(FULL_PHONE_NUMBER_CHOICE);
        this.fullPhoneNumber = fullPhoneNumber;
    }

    /** 
     * Check if ParsedPhoneNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifParsedPhoneNumber() {
        return choiceSelect == PARSED_PHONE_NUMBER_CHOICE;
    }

    /** 
     * Get the 'ParsedPhoneNumber' element value.
     * 
     * @return value
     */
    public ParsedPhoneNumberType getParsedPhoneNumber() {
        return parsedPhoneNumber;
    }

    /** 
     * Set the 'ParsedPhoneNumber' element value.
     * 
     * @param parsedPhoneNumber
     */
    public void setParsedPhoneNumber(ParsedPhoneNumberType parsedPhoneNumber) {
        setChoiceSelect(PARSED_PHONE_NUMBER_CHOICE);
        this.parsedPhoneNumber = parsedPhoneNumber;
    }

    /** 
     * Get the 'DeviceType' attribute value.
     * 
     * @return value
     */
    public String getDeviceType() {
        return deviceType;
    }

    /** 
     * Set the 'DeviceType' attribute value.
     * 
     * @param deviceType
     */
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    /** 
     * Get the 'Vendor' attribute value.
     * 
     * @return value
     */
    public String getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' attribute value.
     * 
     * @param vendor
     */
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'Comment' attribute value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' attribute value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'UpdateAttributes' attributeGroup value.
     * 
     * @return value
     */
    public UpdateAttributes getUpdateAttributes() {
        return updateAttributes;
    }

    /** 
     * Set the 'UpdateAttributes' attributeGroup value.
     * 
     * @param updateAttributes
     */
    public void setUpdateAttributes(UpdateAttributes updateAttributes) {
        this.updateAttributes = updateAttributes;
    }

    /** 
     * Get the 'ProfileStoredItem' attribute value.
     * 
     * @return value
     */
    public Boolean getProfileStoredItem() {
        return profileStoredItem;
    }

    /** 
     * Set the 'ProfileStoredItem' attribute value.
     * 
     * @param profileStoredItem
     */
    public void setProfileStoredItem(Boolean profileStoredItem) {
        this.profileStoredItem = profileStoredItem;
    }
}
