
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TripUpdate">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:TripIDType" name="TripID"/>
 *       &lt;xs:element type="ns:TripHeaderType" name="Header" minOccurs="0"/>
 *       &lt;xs:element type="ns:POSInfoType" name="POS"/>
 *       &lt;xs:element type="ns:CustomerType" name="Customer" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element type="ns:TripComponentType" name="Component" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element type="ns:ModificationTimestampType" name="ModificationTimestamp"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:UpdateAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class TripUpdate implements Serializable
{
    private TripIDType tripID;
    private TripHeaderType header;
    private POSInfoType POS;
    private List<CustomerType> customerList = new ArrayList<CustomerType>();
    private List<TripComponentType> componentList = new ArrayList<TripComponentType>();
    private ModificationTimestampType modificationTimestamp;
    private UpdateAttributes updateAttributes;

    /** 
     * Get the 'TripID' element value.
     * 
     * @return value
     */
    public TripIDType getTripID() {
        return tripID;
    }

    /** 
     * Set the 'TripID' element value.
     * 
     * @param tripID
     */
    public void setTripID(TripIDType tripID) {
        this.tripID = tripID;
    }

    /** 
     * Get the 'Header' element value.
     * 
     * @return value
     */
    public TripHeaderType getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value.
     * 
     * @param header
     */
    public void setHeader(TripHeaderType header) {
        this.header = header;
    }

    /** 
     * Get the 'POS' element value.
     * 
     * @return value
     */
    public POSInfoType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value.
     * 
     * @param POS
     */
    public void setPOS(POSInfoType POS) {
        this.POS = POS;
    }

    /** 
     * Get the list of 'Customer' element items.
     * 
     * @return list
     */
    public List<CustomerType> getCustomerList() {
        return customerList;
    }

    /** 
     * Set the list of 'Customer' element items.
     * 
     * @param list
     */
    public void setCustomerList(List<CustomerType> list) {
        customerList = list;
    }

    /** 
     * Get the list of 'Component' element items.
     * 
     * @return list
     */
    public List<TripComponentType> getComponentList() {
        return componentList;
    }

    /** 
     * Set the list of 'Component' element items.
     * 
     * @param list
     */
    public void setComponentList(List<TripComponentType> list) {
        componentList = list;
    }

    /** 
     * Get the 'ModificationTimestamp' element value.
     * 
     * @return value
     */
    public ModificationTimestampType getModificationTimestamp() {
        return modificationTimestamp;
    }

    /** 
     * Set the 'ModificationTimestamp' element value.
     * 
     * @param modificationTimestamp
     */
    public void setModificationTimestamp(
            ModificationTimestampType modificationTimestamp) {
        this.modificationTimestamp = modificationTimestamp;
    }

    /** 
     * Get the 'UpdateAttributes' attributeGroup value.
     * 
     * @return value
     */
    public UpdateAttributes getUpdateAttributes() {
        return updateAttributes;
    }

    /** 
     * Set the 'UpdateAttributes' attributeGroup value.
     * 
     * @param updateAttributes
     */
    public void setUpdateAttributes(UpdateAttributes updateAttributes) {
        this.updateAttributes = updateAttributes;
    }
}
