
package org.ebxml.namespaces.messageheader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ErrorList">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Error" maxOccurs="unbounded"/>
 *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:headerExtension.grp"/>
 *     &lt;xs:attribute type="ns:severity.type" use="required" name="highestSeverity"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ErrorList implements Serializable
{
    private List<_Error> errorList = new ArrayList<_Error>();
    private List<Element> anyList = new ArrayList<Element>();
    private HeaderExtensionGrp headerExtensionGrp;
    private SeverityType highestSeverity;

    /** 
     * Get the list of 'Error' element items.
     * 
     * @return list
     */
    public List<_Error> getErrorList() {
        return errorList;
    }

    /** 
     * Set the list of 'Error' element items.
     * 
     * @param list
     */
    public void setErrorList(List<_Error> list) {
        errorList = list;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }

    /** 
     * Get the 'headerExtension.grp' attributeGroup value.
     * 
     * @return value
     */
    public HeaderExtensionGrp getHeaderExtensionGrp() {
        return headerExtensionGrp;
    }

    /** 
     * Set the 'headerExtension.grp' attributeGroup value.
     * 
     * @param headerExtensionGrp
     */
    public void setHeaderExtensionGrp(HeaderExtensionGrp headerExtensionGrp) {
        this.headerExtensionGrp = headerExtensionGrp;
    }

    /** 
     * Get the 'highestSeverity' attribute value.
     * 
     * @return value
     */
    public SeverityType getHighestSeverity() {
        return highestSeverity;
    }

    /** 
     * Set the 'highestSeverity' attribute value.
     * 
     * @param highestSeverity
     */
    public void setHighestSeverity(SeverityType highestSeverity) {
        this.highestSeverity = highestSeverity;
    }
}
