
package org.ebxml.namespaces.messageheader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageHeader">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:From"/>
 *       &lt;xs:element ref="ns:To"/>
 *       &lt;xs:element ref="ns:CPAId"/>
 *       &lt;xs:element ref="ns:ConversationId"/>
 *       &lt;xs:element ref="ns:Service"/>
 *       &lt;xs:element ref="ns:Action"/>
 *       &lt;xs:element ref="ns:MessageData"/>
 *       &lt;xs:element ref="ns:DuplicateElimination" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Description" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:headerExtension.grp"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class MessageHeader implements Serializable
{
    private From from;
    private To to;
    private CPAId CPAId;
    private ConversationId conversationId;
    private Service service;
    private Action action;
    private MessageData messageData;
    private DuplicateElimination duplicateElimination;
    private List<Description> descriptionList = new ArrayList<Description>();
    private List<Element> anyList = new ArrayList<Element>();
    private HeaderExtensionGrp headerExtensionGrp;

    /** 
     * Get the 'From' element value.
     * 
     * @return value
     */
    public From getFrom() {
        return from;
    }

    /** 
     * Set the 'From' element value.
     * 
     * @param from
     */
    public void setFrom(From from) {
        this.from = from;
    }

    /** 
     * Get the 'To' element value.
     * 
     * @return value
     */
    public To getTo() {
        return to;
    }

    /** 
     * Set the 'To' element value.
     * 
     * @param to
     */
    public void setTo(To to) {
        this.to = to;
    }

    /** 
     * Get the 'CPAId' element value.
     * 
     * @return value
     */
    public CPAId getCPAId() {
        return CPAId;
    }

    /** 
     * Set the 'CPAId' element value.
     * 
     * @param CPAId
     */
    public void setCPAId(CPAId CPAId) {
        this.CPAId = CPAId;
    }

    /** 
     * Get the 'ConversationId' element value.
     * 
     * @return value
     */
    public ConversationId getConversationId() {
        return conversationId;
    }

    /** 
     * Set the 'ConversationId' element value.
     * 
     * @param conversationId
     */
    public void setConversationId(ConversationId conversationId) {
        this.conversationId = conversationId;
    }

    /** 
     * Get the 'Service' element value.
     * 
     * @return value
     */
    public Service getService() {
        return service;
    }

    /** 
     * Set the 'Service' element value.
     * 
     * @param service
     */
    public void setService(Service service) {
        this.service = service;
    }

    /** 
     * Get the 'Action' element value.
     * 
     * @return value
     */
    public Action getAction() {
        return action;
    }

    /** 
     * Set the 'Action' element value.
     * 
     * @param action
     */
    public void setAction(Action action) {
        this.action = action;
    }

    /** 
     * Get the 'MessageData' element value.
     * 
     * @return value
     */
    public MessageData getMessageData() {
        return messageData;
    }

    /** 
     * Set the 'MessageData' element value.
     * 
     * @param messageData
     */
    public void setMessageData(MessageData messageData) {
        this.messageData = messageData;
    }

    /** 
     * Get the 'DuplicateElimination' element value.
     * 
     * @return value
     */
    public DuplicateElimination getDuplicateElimination() {
        return duplicateElimination;
    }

    /** 
     * Set the 'DuplicateElimination' element value.
     * 
     * @param duplicateElimination
     */
    public void setDuplicateElimination(
            DuplicateElimination duplicateElimination) {
        this.duplicateElimination = duplicateElimination;
    }

    /** 
     * Get the list of 'Description' element items.
     * 
     * @return list
     */
    public List<Description> getDescriptionList() {
        return descriptionList;
    }

    /** 
     * Set the list of 'Description' element items.
     * 
     * @param list
     */
    public void setDescriptionList(List<Description> list) {
        descriptionList = list;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }

    /** 
     * Get the 'headerExtension.grp' attributeGroup value.
     * 
     * @return value
     */
    public HeaderExtensionGrp getHeaderExtensionGrp() {
        return headerExtensionGrp;
    }

    /** 
     * Set the 'headerExtension.grp' attributeGroup value.
     * 
     * @param headerExtensionGrp
     */
    public void setHeaderExtensionGrp(HeaderExtensionGrp headerExtensionGrp) {
        this.headerExtensionGrp = headerExtensionGrp;
    }
}
