
package org.ebxml.namespaces.messageheader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:tns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Reference">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="tns:Schema" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element ref="tns:Description" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute ref="tns:id">
 *       &lt;!-- Reference to inner class Id -->
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute fixed="simple" ref="xlink:type">
 *       &lt;!-- Reference to inner class Type -->
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute use="required" ref="xlink:href"/>
 *     &lt;xs:attribute ref="xlink:role">
 *       &lt;!-- Reference to inner class Role -->
 *     &lt;/xs:attribute>
 *     &lt;xs:anyAttribute processContents="lax" namespace="##other"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * 
 * &lt;xs:attribute xmlns:tns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" type="xs:string" name="href"/>
 * </pre>
 */
public class Reference implements Serializable
{
    private List<Schema> schemaList = new ArrayList<Schema>();
    private List<Description> descriptionList = new ArrayList<Description>();
    private List<Element> anyList = new ArrayList<Element>();
    private Id id;
    private Type type;
    private String href;
    private Role role;

    /** 
     * Get the list of 'Schema' element items.
     * 
     * @return list
     */
    public List<Schema> getSchemaList() {
        return schemaList;
    }

    /** 
     * Set the list of 'Schema' element items.
     * 
     * @param list
     */
    public void setSchemaList(List<Schema> list) {
        schemaList = list;
    }

    /** 
     * Get the list of 'Description' element items.
     * 
     * @return list
     */
    public List<Description> getDescriptionList() {
        return descriptionList;
    }

    /** 
     * Set the list of 'Description' element items.
     * 
     * @param list
     */
    public void setDescriptionList(List<Description> list) {
        descriptionList = list;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public Id getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(Id id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value.
     * 
     * @return value
     */
    public Type getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value.
     * 
     * @param type
     */
    public void setType(Type type) {
        this.type = type;
    }

    /** 
     * Get the 'href' attribute value.
     * 
     * @return value
     */
    public String getHref() {
        return href;
    }

    /** 
     * Set the 'href' attribute value.
     * 
     * @param href
     */
    public void setHref(String href) {
        this.href = href;
    }

    /** 
     * Get the 'role' attribute value.
     * 
     * @return value
     */
    public Role getRole() {
        return role;
    }

    /** 
     * Set the 'role' attribute value.
     * 
     * @param role
     */
    public void setRole(Role role) {
        this.role = role;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:attribute xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xs="http://www.w3.org/2001/XMLSchema" ref="ns:id"/>
     * 
     * &lt;xs:attribute xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xs="http://www.w3.org/2001/XMLSchema" type="xs:string" name="id"/>
     * </pre>
     */
    public static class Id implements Serializable
    {
        private String id;

        /** 
         * Get the 'id' attribute value.
         * 
         * @return value
         */
        public String getId() {
            return id;
        }

        /** 
         * Set the 'id' attribute value.
         * 
         * @param id
         */
        public void setId(String id) {
            this.id = id;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:attribute xmlns:ns="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" fixed="simple" ref="ns:type"/>
     * 
     * &lt;xs:attribute xmlns:ns="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="type">
     *   &lt;xs:simpleType>
     *     &lt;!-- Reference to inner class TypeInner -->
     *   &lt;/xs:simpleType>
     * &lt;/xs:attribute>
     * </pre>
     */
    public static class Type implements Serializable
    {
        private TypeInner type;

        /** 
         * Get the 'type' attribute value.
         * 
         * @return value
         */
        public TypeInner getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value.
         * 
         * @param type
         */
        public void setType(TypeInner type) {
            this.type = type;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="simple"/>
         *     &lt;xs:enumeration value="extended"/>
         *     &lt;xs:enumeration value="locator"/>
         *     &lt;xs:enumeration value="arc"/>
         *     &lt;xs:enumeration value="resource"/>
         *     &lt;xs:enumeration value="title"/>
         *     &lt;xs:enumeration value="none"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum TypeInner implements Serializable {
            SIMPLE("simple"), EXTENDED("extended"), LOCATOR("locator"), ARC(
                    "arc"), RESOURCE("resource"), TITLE("title"), NONE("none");
            private final String value;

            private TypeInner(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static TypeInner convert(String value) {
                for (TypeInner inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:attribute xmlns:ns="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" ref="ns:role"/>
     * 
     * &lt;xs:attribute xmlns:ns="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" type="xs:string" name="role"/>
     * </pre>
     */
    public static class Role implements Serializable
    {
        private String role;

        /** 
         * Get the 'role' attribute value.
         * 
         * @return value
         */
        public String getRole() {
            return role;
        }

        /** 
         * Set the 'role' attribute value.
         * 
         * @param role
         */
        public void setRole(String role) {
            this.role = role;
        }
    }
}
