
package org.ebxml.namespaces.messageheader;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="severity.type">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Warning"/>
 *     &lt;xs:enumeration value="Error"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SeverityType implements Serializable {
    WARNING("Warning"), ERROR("Error");
    private final String value;

    private SeverityType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SeverityType convert(String value) {
        for (SeverityType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
