
package org.ebxml.namespaces.messageheader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StatusResponse">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:RefToMessageId"/>
 *       &lt;xs:element ref="ns:Timestamp" minOccurs="0"/>
 *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:bodyExtension.grp"/>
 *     &lt;xs:attribute type="ns:messageStatus.type" use="required" name="messageStatus"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class StatusResponse implements Serializable
{
    private RefToMessageId refToMessageId;
    private Timestamp timestamp;
    private List<Element> anyList = new ArrayList<Element>();
    private BodyExtensionGrp bodyExtensionGrp;
    private MessageStatusType messageStatus;

    /** 
     * Get the 'RefToMessageId' element value.
     * 
     * @return value
     */
    public RefToMessageId getRefToMessageId() {
        return refToMessageId;
    }

    /** 
     * Set the 'RefToMessageId' element value.
     * 
     * @param refToMessageId
     */
    public void setRefToMessageId(RefToMessageId refToMessageId) {
        this.refToMessageId = refToMessageId;
    }

    /** 
     * Get the 'Timestamp' element value.
     * 
     * @return value
     */
    public Timestamp getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' element value.
     * 
     * @param timestamp
     */
    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }

    /** 
     * Get the 'bodyExtension.grp' attributeGroup value.
     * 
     * @return value
     */
    public BodyExtensionGrp getBodyExtensionGrp() {
        return bodyExtensionGrp;
    }

    /** 
     * Set the 'bodyExtension.grp' attributeGroup value.
     * 
     * @param bodyExtensionGrp
     */
    public void setBodyExtensionGrp(BodyExtensionGrp bodyExtensionGrp) {
        this.bodyExtensionGrp = bodyExtensionGrp;
    }

    /** 
     * Get the 'messageStatus' attribute value.
     * 
     * @return value
     */
    public MessageStatusType getMessageStatus() {
        return messageStatus;
    }

    /** 
     * Set the 'messageStatus' attribute value.
     * 
     * @param messageStatus
     */
    public void setMessageStatus(MessageStatusType messageStatus) {
        this.messageStatus = messageStatus;
    }
}
