
package org.ebxml.namespaces.messageheader;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="status.type">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Reset"/>
 *     &lt;xs:enumeration value="Continue"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum StatusType implements Serializable {
    RESET("Reset"), CONTINUE("Continue");
    private final String value;

    private StatusType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static StatusType convert(String value) {
        for (StatusType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
