
package org.opentravel.common.message.v02;

import java.io.Serializable;

/** 
 * Processing Condition types. Open enumerated list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_ProcessingCondition">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Advisory"/>
 *     &lt;xs:enumeration value="ApplicationError"/>
 *     &lt;xs:enumeration value="AuthenticalModel"/>
 *     &lt;xs:enumeration value="Authentication"/>
 *     &lt;xs:enumeration value="AuthenticationTimeout"/>
 *     &lt;xs:enumeration value="Authorization"/>
 *     &lt;xs:enumeration value="BusinessRule"/>
 *     &lt;xs:enumeration value="NoImplementation"/>
 *     &lt;xs:enumeration value="ProcessingException"/>
 *     &lt;xs:enumeration value="ProtocolViolation"/>
 *     &lt;xs:enumeration value="RequiredFieldMissing"/>
 *     &lt;xs:enumeration value="TransactionModel"/>
 *     &lt;xs:enumeration value="Unknown"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumProcessingCondition implements Serializable {
    ADVISORY("Advisory"), /** 
                           * Indicates that an involved backend application returned an error or warning, which is
                          passed back in the response message.
                          
                           */
    APPLICATION_ERROR("ApplicationError"), /** 
                                            * Indicates the type of authentication requested is not recognized.
                                            */
    AUTHENTICAL_MODEL("AuthenticalModel"), /** 
                                            * Indicates the message lacks adequate security credentials.
                                            */
    AUTHENTICATION("Authentication"), /** 
                                       * Indicates that the security credentials in the message have expired.
                                      
                                       */
    AUTHENTICATION_TIMEOUT("AuthenticationTimeout"), /** 
                                                      * Indicates the message lacks adequate security credentials.
                                                      */
    AUTHORIZATION("Authorization"), /** 
                                     * Indicates that the XML message has passed a low-level validation check, but that the
                                    business rules for the request message were not met.
                                    
                                     */
    BUSINESS_RULE("BusinessRule"), /** 
                                    * Indicates that the target business system has no implementation for the intended
                                   request.
                                   
                                    */
    NO_IMPLEMENTATION("NoImplementation"), /** 
                                            * Indicates that during processing of the request that a not further defined exception
                                           occurred.
                                           
                                            */
    PROCESSING_EXCEPTION("ProcessingException"), /** 
                                                  * Indicates that a request was sent within a message exchange that does not align to the
                                                 message.
                                                 
                                                  */
    PROTOCOL_VIOLATION("ProtocolViolation"), /** 
                                              * Indicates that an element or attribute that is required in by the schema (or required
                                             by agreement between trading partners) is missing from the message.
                                             
                                              */
    REQUIRED_FIELD_MISSING("RequiredFieldMissing"), /** 
                                                     * Indicates that the target business system does not support the intended
                                                    transaction-oriented operation.
                                                    
                                                     */
    TRANSACTION_MODEL("TransactionModel"), /** 
                                            * Indicates an unknown error.
                                            */
    UNKNOWN("Unknown"), OTHER_("Other_");
    private final String value;

    private EnumProcessingCondition(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumProcessingCondition convert(String value) {
        for (EnumProcessingCondition inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
