
package org.opentravel.common.message.v02;

import java.io.Serializable;

/** 
 * Message and/or Record Processing Status types. Open enumerated list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_ProcessingStatus">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Complete"/>
 *     &lt;xs:enumeration value="Incomplete"/>
 *     &lt;xs:enumeration value="NotProcessed"/>
 *     &lt;xs:enumeration value="Unknown"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumProcessingStatus implements Serializable {
    COMPLETE("Complete"), INCOMPLETE("Incomplete"), NOT_PROCESSED(
            "NotProcessed"), UNKNOWN("Unknown");
    private final String value;

    private EnumProcessingStatus(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumProcessingStatus convert(String value) {
        for (EnumProcessingStatus inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
