
package org.opentravel.common.message.v02;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opentravel.common.v02.EnumBookingChannelBase;
import org.opentravel.common.v02.EnumTravelSectorBase;
import org.opentravel.common.v02.TimeZone;

/** 
 * Message Header definition: The standard element that appears on the root all OpenTravel 2
 messages.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageHeader">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Identification">
 *       &lt;xs:complexType>
 *         &lt;xs:attribute type="xs:dateTime" use="required" name="timeStamp"/>
 *         &lt;xs:attribute type="xs:string" use="optional" name="messageID"/>
 *         &lt;xs:attribute type="xs:string" use="optional" name="correlationID"/>
 *         &lt;xs:attribute type="xs:integer" use="optional" name="sequenceNbr"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="TargetSystem" minOccurs="0">
 *       &lt;!-- Reference to inner class TargetSystem -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Language" minOccurs="0">
 *       &lt;!-- Reference to inner class Language -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Correlation" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:attribute use="prohibited" name="sequenceLocation">
 *           &lt;xs:simpleType>
 *             &lt;xs:restriction base="xs:string">
 *               &lt;xs:enumeration value="First"/>
 *               &lt;xs:enumeration value="Last"/>
 *               &lt;xs:enumeration value="InSeries"/>
 *               &lt;xs:enumeration value="SubsequentRequest"/>
 *               &lt;xs:enumeration value="Rollback"/>
 *             &lt;/xs:restriction>
 *           &lt;/xs:simpleType>
 *         &lt;/xs:attribute>
 *         &lt;xs:attribute type="xs:boolean" use="prohibited" name="followupRequestInd"/>
 *         &lt;xs:attribute type="xs:boolean" use="prohibited" name="rollbackInd"/>
 *         &lt;xs:attribute type="xs:string" use="prohibited" name="logID"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="PointOfSale" maxOccurs="99">
 *       &lt;!-- Reference to inner class PointOfSale -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Results" minOccurs="0">
 *       &lt;!-- Reference to inner class Results -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="prohibited" name="retransmissionInd"/>
 *   &lt;xs:attribute type="xs:string" use="prohibited" name="maxResponses"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MessageHeader implements Serializable
{
    private Date identificationTimeStamp;
    private String identificationMessageID;
    private String identificationCorrelationID;
    private BigInteger identificationSequenceNbr;
    private TargetSystem targetSystem;
    private Language language;
    private boolean correlation;
    private List<PointOfSale> pointOfSaleList = new ArrayList<PointOfSale>();
    private Results results;

    /** 
     * Get the 'timeStamp' attribute value. The creation date and time of the message in UTC in ISO 8601 format
                                  (YYYY-MM-DDThh:mm:ssZ). Source: http://bit.ly/OTA2_ISO8601
                              
     * 
     * @return value
     */
    public Date getIdentificationTimeStamp() {
        return identificationTimeStamp;
    }

    /** 
     * Set the 'timeStamp' attribute value. The creation date and time of the message in UTC in ISO 8601 format
                                  (YYYY-MM-DDThh:mm:ssZ). Source: http://bit.ly/OTA2_ISO8601
                              
     * 
     * @param identificationTimeStamp
     */
    public void setIdentificationTimeStamp(Date identificationTimeStamp) {
        this.identificationTimeStamp = identificationTimeStamp;
    }

    /** 
     * Get the 'messageID' attribute value. A reference for additional message identification, assigned by the requesting
                                  system. When a request message includes an echo token the corresponding response message MUST include an
                                  echo token with an identical value.
                              
     * 
     * @return value
     */
    public String getIdentificationMessageID() {
        return identificationMessageID;
    }

    /** 
     * Set the 'messageID' attribute value. A reference for additional message identification, assigned by the requesting
                                  system. When a request message includes an echo token the corresponding response message MUST include an
                                  echo token with an identical value.
                              
     * 
     * @param identificationMessageID
     */
    public void setIdentificationMessageID(String identificationMessageID) {
        this.identificationMessageID = identificationMessageID;
    }

    /** 
     * Get the 'correlationID' attribute value. A unique identifier that may be specified to relate all messages within a
                                  transaction (e.g. this would be sent in all request and response messages that are part of an on-going
                                  transaction).
                              
     * 
     * @return value
     */
    public String getIdentificationCorrelationID() {
        return identificationCorrelationID;
    }

    /** 
     * Set the 'correlationID' attribute value. A unique identifier that may be specified to relate all messages within a
                                  transaction (e.g. this would be sent in all request and response messages that are part of an on-going
                                  transaction).
                              
     * 
     * @param identificationCorrelationID
     */
    public void setIdentificationCorrelationID(
            String identificationCorrelationID) {
        this.identificationCorrelationID = identificationCorrelationID;
    }

    /** 
     * Get the 'sequenceNbr' attribute value. A sequence number for the transaction assigned by the sending system that
                                  allows for an application to process messages in a certain order or to request a resynchronization of
                                  messages in the event that a system has been off-line and needs to retrieve messages that were missed.
                              
     * 
     * @return value
     */
    public BigInteger getIdentificationSequenceNbr() {
        return identificationSequenceNbr;
    }

    /** 
     * Set the 'sequenceNbr' attribute value. A sequence number for the transaction assigned by the sending system that
                                  allows for an application to process messages in a certain order or to request a resynchronization of
                                  messages in the event that a system has been off-line and needs to retrieve messages that were missed.
                              
     * 
     * @param identificationSequenceNbr
     */
    public void setIdentificationSequenceNbr(
            BigInteger identificationSequenceNbr) {
        this.identificationSequenceNbr = identificationSequenceNbr;
    }

    /** 
     * Get the 'TargetSystem' element value.
     * 
     * @return value
     */
    public TargetSystem getTargetSystem() {
        return targetSystem;
    }

    /** 
     * Set the 'TargetSystem' element value.
     * 
     * @param targetSystem
     */
    public void setTargetSystem(TargetSystem targetSystem) {
        this.targetSystem = targetSystem;
    }

    /** 
     * Get the 'Language' element value.
     * 
     * @return value
     */
    public Language getLanguage() {
        return language;
    }

    /** 
     * Set the 'Language' element value.
     * 
     * @param language
     */
    public void setLanguage(Language language) {
        this.language = language;
    }

    /** 
     * Check if the 'Correlation' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifCorrelationPresent() {
        return correlation;
    }

    /** 
     * Set flag for 'Correlation' element present.
     * 
     * @param correlation
     */
    public void flagCorrelationPresent(boolean correlation) {
        this.correlation = correlation;
    }

    /** 
     * Get the list of 'PointOfSale' element items.
     * 
     * @return list
     */
    public List<PointOfSale> getPointOfSaleList() {
        return pointOfSaleList;
    }

    /** 
     * Set the list of 'PointOfSale' element items.
     * 
     * @param list
     */
    public void setPointOfSaleList(List<PointOfSale> list) {
        pointOfSaleList = list;
    }

    /** 
     * Get the 'Results' element value.
     * 
     * @return value
     */
    public Results getResults() {
        return results;
    }

    /** 
     * Set the 'Results' element value.
     * 
     * @param results
     */
    public void setResults(Results results) {
        this.results = results;
    }
    /** 
     * Attributes that identify the target message processing system.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TargetSystem" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute use="optional" name="type">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Type -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute type="xs:string" use="optional" name="name"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TargetSystem implements Serializable
    {
        private Type type;
        private String name;

        /** 
         * Get the 'type' attribute value. The type of the target system to process this message that may be specified,
                                    e.g. a production or test system.
                                
         * 
         * @return value
         */
        public Type getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. The type of the target system to process this message that may be specified,
                                    e.g. a production or test system.
                                
         * 
         * @param type
         */
        public void setType(Type type) {
            this.type = type;
        }

        /** 
         * Get the 'name' attribute value. The name of the target system that may be specified if there are more than one
                                    system for a specified system type, e.g. "Test System 23."
                                
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'name' attribute value. The name of the target system that may be specified if there are more than one
                                    system for a specified system type, e.g. "Test System 23."
                                
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="Production"/>
         *     &lt;xs:enumeration value="Test"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Type implements Serializable {
            PRODUCTION("Production"), TEST("Test");
            private final String value;

            private Type(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static Type convert(String value) {
                for (Type inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
    /** 
     * Attributes used to identify the language preference for the message.
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Language" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="primary"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="secondary"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Language implements Serializable
    {
        private String primary;
        private String secondary;

        /** 
         * Get the 'primary' attribute value. The primary human language preference to use for message processing in ISO 639
                                    code format. Source: http://bit.ly/OTA2_ISO639
                                
         * 
         * @return value
         */
        public String getPrimary() {
            return primary;
        }

        /** 
         * Set the 'primary' attribute value. The primary human language preference to use for message processing in ISO 639
                                    code format. Source: http://bit.ly/OTA2_ISO639
                                
         * 
         * @param primary
         */
        public void setPrimary(String primary) {
            this.primary = primary;
        }

        /** 
         * Get the 'secondary' attribute value. The secondary human language preference to use for message processing in ISO
                                    639 code format. Source: http://bit.ly/OTA2_ISO639
                                
         * 
         * @return value
         */
        public String getSecondary() {
            return secondary;
        }

        /** 
         * Set the 'secondary' attribute value. The secondary human language preference to use for message processing in ISO
                                    639 code format. Source: http://bit.ly/OTA2_ISO639
                                
         * 
         * @param secondary
         */
        public void setSecondary(String secondary) {
            this.secondary = secondary;
        }
    }
    /** 
     * Contains point of sale metadata that identifies the party or connection channel making
                          a request or responding to a request, including requestor ID and type, company information and other authentication
                          information such as a message password.
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://opentravel.org/common/v02" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PointOfSale" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Type">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="optional" name="extension"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Company" minOccurs="0"/>
     *       &lt;xs:element name="BookingChannelInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class BookingChannelInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Agent" minOccurs="0">
     *         &lt;!-- Reference to inner class Agent -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AirInfo" minOccurs="0">
     *         &lt;!-- Reference to inner class AirInfo -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Location" minOccurs="0">
     *         &lt;!-- Reference to inner class Location -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Position" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="requestorID"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="idContext"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="url"/>
     *     &lt;xs:attribute type="ns:Enum_TravelSector_Base" name="travelSegment"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="messagePassword"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="domain"/>
     *     &lt;xs:attribute type="xs:string" use="prohibited" name="instance"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PointOfSale implements Serializable
    {
        private String type;
        private String company;
        private BookingChannelInfo bookingChannelInfo;
        private Agent agent;
        private AirInfo airInfo;
        private Location location;
        private String position;
        private String requestorID;
        private String idContext;
        private String url;
        private EnumTravelSectorBase travelSegment;
        private String messagePassword;
        private String domain;

        /** 
         * Get the 'extension' attribute value. A string value that represents an "Other_", or extended, enumerated
                                                value agreed upon between trading partners.

                                                NOTE: It is recommended that you submit an OpenTravel comment to formally add any extended
                                                enumerations to the OpenTravel Specification to maximize trading partner interoperability.
                                            
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'extension' attribute value. A string value that represents an "Other_", or extended, enumerated
                                                value agreed upon between trading partners.

                                                NOTE: It is recommended that you submit an OpenTravel comment to formally add any extended
                                                enumerations to the OpenTravel Specification to maximize trading partner interoperability.
                                            
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'Company' element value. Requestor company code and short name.
         * 
         * @return value
         */
        public String getCompany() {
            return company;
        }

        /** 
         * Set the 'Company' element value. Requestor company code and short name.
         * 
         * @param company
         */
        public void setCompany(String company) {
            this.company = company;
        }

        /** 
         * Get the 'BookingChannelInfo' element value.
         * 
         * @return value
         */
        public BookingChannelInfo getBookingChannelInfo() {
            return bookingChannelInfo;
        }

        /** 
         * Set the 'BookingChannelInfo' element value.
         * 
         * @param bookingChannelInfo
         */
        public void setBookingChannelInfo(BookingChannelInfo bookingChannelInfo) {
            this.bookingChannelInfo = bookingChannelInfo;
        }

        /** 
         * Get the 'Agent' element value.
         * 
         * @return value
         */
        public Agent getAgent() {
            return agent;
        }

        /** 
         * Set the 'Agent' element value.
         * 
         * @param agent
         */
        public void setAgent(Agent agent) {
            this.agent = agent;
        }

        /** 
         * Get the 'AirInfo' element value.
         * 
         * @return value
         */
        public AirInfo getAirInfo() {
            return airInfo;
        }

        /** 
         * Set the 'AirInfo' element value.
         * 
         * @param airInfo
         */
        public void setAirInfo(AirInfo airInfo) {
            this.airInfo = airInfo;
        }

        /** 
         * Get the 'Location' element value.
         * 
         * @return value
         */
        public Location getLocation() {
            return location;
        }

        /** 
         * Set the 'Location' element value.
         * 
         * @param location
         */
        public void setLocation(Location location) {
            this.location = location;
        }

        /** 
         * Get the 'Position' element value. Specifies the geographical position of a requestor.
         * 
         * @return value
         */
        public String getPosition() {
            return position;
        }

        /** 
         * Set the 'Position' element value. Specifies the geographical position of a requestor.
         * 
         * @param position
         */
        public void setPosition(String position) {
            this.position = position;
        }

        /** 
         * Get the 'requestorID' attribute value. A unique identification for the requestor that is known between trading
                                    partners and other basic identifying information for the entity making the request.
                                    NOTE: This ID is typically a unique ID agreed upon between trading partners, or the some other entity
                                    assigned ID, including ATA/IATA number, Electronic Reservation Service Provider ID and/or Association of
                                    British Travel Agents ID.
                                    NOTE: The type specified is associated with this ID.
                                
         * 
         * @return value
         */
        public String getRequestorID() {
            return requestorID;
        }

        /** 
         * Set the 'requestorID' attribute value. A unique identification for the requestor that is known between trading
                                    partners and other basic identifying information for the entity making the request.
                                    NOTE: This ID is typically a unique ID agreed upon between trading partners, or the some other entity
                                    assigned ID, including ATA/IATA number, Electronic Reservation Service Provider ID and/or Association of
                                    British Travel Agents ID.
                                    NOTE: The type specified is associated with this ID.
                                
         * 
         * @param requestorID
         */
        public void setRequestorID(String requestorID) {
            this.requestorID = requestorID;
        }

        /** 
         * Get the 'idContext' attribute value. May be used to specifiy the source of the requestor ID, such as IATA, ARC, and
                                    ERSP.
                                
         * 
         * @return value
         */
        public String getIdContext() {
            return idContext;
        }

        /** 
         * Set the 'idContext' attribute value. May be used to specifiy the source of the requestor ID, such as IATA, ARC, and
                                    ERSP.
                                
         * 
         * @param idContext
         */
        public void setIdContext(String idContext) {
            this.idContext = idContext;
        }

        /** 
         * Get the 'url' attribute value. A URL that identifies the location associated with the ID in a W3C recommended
                                    format. Source: http://bit.ly/W3C_Specification
                                
         * 
         * @return value
         */
        public String getUrl() {
            return url;
        }

        /** 
         * Set the 'url' attribute value. A URL that identifies the location associated with the ID in a W3C recommended
                                    format. Source: http://bit.ly/W3C_Specification
                                
         * 
         * @param url
         */
        public void setUrl(String url) {
            this.url = url;
        }

        /** 
         * Get the 'travelSegment' attribute value. The travel segment associated with the requestor type, e.g. hotel, cruise, day
                                    tour, rental car and airline.
                                
         * 
         * @return value
         */
        public EnumTravelSectorBase getTravelSegment() {
            return travelSegment;
        }

        /** 
         * Set the 'travelSegment' attribute value. The travel segment associated with the requestor type, e.g. hotel, cruise, day
                                    tour, rental car and airline.
                                
         * 
         * @param travelSegment
         */
        public void setTravelSegment(EnumTravelSectorBase travelSegment) {
            this.travelSegment = travelSegment;
        }

        /** 
         * Get the 'messagePassword' attribute value. A message password that provides an additional level of security that the
                                    recipient can use to validate the sending party's authority to use the message.
                                
         * 
         * @return value
         */
        public String getMessagePassword() {
            return messagePassword;
        }

        /** 
         * Set the 'messagePassword' attribute value. A message password that provides an additional level of security that the
                                    recipient can use to validate the sending party's authority to use the message.
                                
         * 
         * @param messagePassword
         */
        public void setMessagePassword(String messagePassword) {
            this.messagePassword = messagePassword;
        }

        /** 
         * Get the 'domain' attribute value. The domain associated with the message password and/or requestor ID.
                                
         * 
         * @return value
         */
        public String getDomain() {
            return domain;
        }

        /** 
         * Set the 'domain' attribute value. The domain associated with the message password and/or requestor ID.
                                
         * 
         * @param domain
         */
        public void setDomain(String domain) {
            this.domain = domain;
        }
        /** 
         * Booking channel metadata, cincluding type, ID and name.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingChannelInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence minOccurs="0">
         *       &lt;!-- Reference to inner class Sequence -->
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:boolean" name="primaryInd"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="id"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BookingChannelInfo implements Serializable
        {
            private Sequence type;
            private Boolean primaryInd;
            private String id;

            /** 
             * Get the sequence value.
             * 
             * @return value
             */
            public Sequence getType() {
                return type;
            }

            /** 
             * Set the sequence value.
             * 
             * @param type
             */
            public void setType(Sequence type) {
                this.type = type;
            }

            /** 
             * Get the 'primaryInd' attribute value. Indicates whether the enumerated booking channel type is the
                                                  primary means of connectivity used by the source.
                                              
             * 
             * @return value
             */
            public Boolean getPrimaryInd() {
                return primaryInd;
            }

            /** 
             * Set the 'primaryInd' attribute value. Indicates whether the enumerated booking channel type is the
                                                  primary means of connectivity used by the source.
                                              
             * 
             * @param primaryInd
             */
            public void setPrimaryInd(Boolean primaryInd) {
                this.primaryInd = primaryInd;
            }

            /** 
             * Get the 'id' attribute value. A unique booking channel ID.
             * 
             * @return value
             */
            public String getId() {
                return id;
            }

            /** 
             * Set the 'id' attribute value. A unique booking channel ID.
             * 
             * @param id
             */
            public void setId(String id) {
                this.id = id;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:sequence xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
             *   &lt;xs:element name="Type">
             *     &lt;xs:complexType>
             *       &lt;xs:simpleContent>
             *         &lt;xs:extension base="ns:Enum_BookingChannel_Base">
             *           &lt;xs:attribute type="xs:string" use="optional" name="extension"/>
             *         &lt;/xs:extension>
             *       &lt;/xs:simpleContent>
             *     &lt;/xs:complexType>
             *   &lt;/xs:element>
             *   &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
             * &lt;/xs:sequence>
             * </pre>
             */
            public static class Sequence implements Serializable
            {
                private EnumBookingChannelBase typeEnumBookingChannelBase;
                private String typeExtension;
                private String name;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public EnumBookingChannelBase getTypeEnumBookingChannelBase() {
                    return typeEnumBookingChannelBase;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param typeEnumBookingChannelBase
                 */
                public void setTypeEnumBookingChannelBase(
                        EnumBookingChannelBase typeEnumBookingChannelBase) {
                    this.typeEnumBookingChannelBase = typeEnumBookingChannelBase;
                }

                /** 
                 * Get the 'extension' attribute value. A string value that represents an "Other_", or
                                                                        extended, enumerated value agreed upon between trading partners.

                                                                        NOTE: It is recommended that you submit an OpenTravel comment to formally
                                                                        add any extended enumerations to the OpenTravel Specification to maximize
                                                                        trading partner interoperability.
                                                                    
                 * 
                 * @return value
                 */
                public String getTypeExtension() {
                    return typeExtension;
                }

                /** 
                 * Set the 'extension' attribute value. A string value that represents an "Other_", or
                                                                        extended, enumerated value agreed upon between trading partners.

                                                                        NOTE: It is recommended that you submit an OpenTravel comment to formally
                                                                        add any extended enumerations to the OpenTravel Specification to maximize
                                                                        trading partner interoperability.
                                                                    
                 * 
                 * @param typeExtension
                 */
                public void setTypeExtension(String typeExtension) {
                    this.typeExtension = typeExtension;
                }

                /** 
                 * Get the 'Name' element value. The code and short nameof the booking channel.
                                                    
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' element value. The code and short nameof the booking channel.
                                                    
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }
            }
        }
        /** 
         * Travel agent identification and authentication information.
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Agent" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="sine"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="pseudoCityCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="dutyCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="terminalID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Agent implements Serializable
        {
            private String sine;
            private String pseudoCityCode;
            private String dutyCode;
            private String terminalID;

            /** 
             * Get the 'sine' attribute value. A unique identification of an agent location that typically
                                                  includes a four digit personal identification number, a two character agent identifier and a
                                                  duty code.
                                              
             * 
             * @return value
             */
            public String getSine() {
                return sine;
            }

            /** 
             * Set the 'sine' attribute value. A unique identification of an agent location that typically
                                                  includes a four digit personal identification number, a two character agent identifier and a
                                                  duty code.
                                              
             * 
             * @param sine
             */
            public void setSine(String sine) {
                this.sine = sine;
            }

            /** 
             * Get the 'pseudoCityCode' attribute value. A three to five character code (alpha, numeric, or combination)
                                                  that specifies a GDS code used to identify a travel agency location. Typically required when
                                                  using negotiated rates to associate the rates to an agency.
                                              
             * 
             * @return value
             */
            public String getPseudoCityCode() {
                return pseudoCityCode;
            }

            /** 
             * Set the 'pseudoCityCode' attribute value. A three to five character code (alpha, numeric, or combination)
                                                  that specifies a GDS code used to identify a travel agency location. Typically required when
                                                  using negotiated rates to associate the rates to an agency.
                                              
             * 
             * @param pseudoCityCode
             */
            public void setPseudoCityCode(String pseudoCityCode) {
                this.pseudoCityCode = pseudoCityCode;
            }

            /** 
             * Get the 'dutyCode' attribute value. Typically a two to five character code (alpha, numeric, or
                                                  combination) code that specifies a travel agents duty code that is used for agency
                                                  authentication.
                                              
             * 
             * @return value
             */
            public String getDutyCode() {
                return dutyCode;
            }

            /** 
             * Set the 'dutyCode' attribute value. Typically a two to five character code (alpha, numeric, or
                                                  combination) code that specifies a travel agents duty code that is used for agency
                                                  authentication.
                                              
             * 
             * @param dutyCode
             */
            public void setDutyCode(String dutyCode) {
                this.dutyCode = dutyCode;
            }

            /** 
             * Get the 'terminalID' attribute value. The electronic address of the device from which information is
                                                  entered.
                                              
             * 
             * @return value
             */
            public String getTerminalID() {
                return terminalID;
            }

            /** 
             * Set the 'terminalID' attribute value. The electronic address of the device from which information is
                                                  entered.
                                              
             * 
             * @param terminalID
             */
            public void setTerminalID(String terminalID) {
                this.terminalID = terminalID;
            }
        }
        /** 
         * Identification and authentication information related to airline travel
                                        requests.
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirInfo" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ERSP"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="airlineVendorID"/>
         *     &lt;xs:attribute type="xs:anySimpleType" name="airportCode"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="firstDeparturePoint"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirInfo implements Serializable
        {
            private String ERSP;
            private String airlineVendorID;
            private String airportCode;
            private String firstDeparturePoint;

            /** 
             * Get the 'ERSP' attribute value. A unique IATA (in cooperation with ATA and ARC) code used as a
                                                  means of identification when performing online bookings with airlines. Source:
                                                  http://bit.ly/OTA2_ERSP
                                              
             * 
             * @return value
             */
            public String getERSP() {
                return ERSP;
            }

            /** 
             * Set the 'ERSP' attribute value. A unique IATA (in cooperation with ATA and ARC) code used as a
                                                  means of identification when performing online bookings with airlines. Source:
                                                  http://bit.ly/OTA2_ERSP
                                              
             * 
             * @param ERSP
             */
            public void setERSP(String ERSP) {
                this.ERSP = ERSP;
            }

            /** 
             * Get the 'airlineVendorID' attribute value. A two character IATA assigned airline code. Source:
                                                  http://bit.ly/OTA2_IATA_AirlineCode
                                              
             * 
             * @return value
             */
            public String getAirlineVendorID() {
                return airlineVendorID;
            }

            /** 
             * Set the 'airlineVendorID' attribute value. A two character IATA assigned airline code. Source:
                                                  http://bit.ly/OTA2_IATA_AirlineCode
                                              
             * 
             * @param airlineVendorID
             */
            public void setAirlineVendorID(String airlineVendorID) {
                this.airlineVendorID = airlineVendorID;
            }

            /** 
             * Get the 'airportCode' attribute value. A three character IATA assigned airport code. Source:
                                                  http://bit.ly/OTA2_IATA_AirportCodes
                                              
             * 
             * @return value
             */
            public String getAirportCode() {
                return airportCode;
            }

            /** 
             * Set the 'airportCode' attribute value. A three character IATA assigned airport code. Source:
                                                  http://bit.ly/OTA2_IATA_AirportCodes
                                              
             * 
             * @param airportCode
             */
            public void setAirportCode(String airportCode) {
                this.airportCode = airportCode;
            }

            /** 
             * Get the 'firstDeparturePoint' attribute value. An IATA airline or city code for the point of first departure in a
                                                  trip. Source: http://bit.ly/OTA2_IATA_AirportOrLocationCode
                                              
             * 
             * @return value
             */
            public String getFirstDeparturePoint() {
                return firstDeparturePoint;
            }

            /** 
             * Set the 'firstDeparturePoint' attribute value. An IATA airline or city code for the point of first departure in a
                                                  trip. Source: http://bit.ly/OTA2_IATA_AirportOrLocationCode
                                              
             * 
             * @param firstDeparturePoint
             */
            public void setFirstDeparturePoint(String firstDeparturePoint) {
                this.firstDeparturePoint = firstDeparturePoint;
            }
        }
        /** 
         * Localization information, including requestor country and local currency.
                                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://opentravel.org/common/v02" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:TimeZone" name="TimeZone" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:anySimpleType" name="ISOCountry"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="ISOCurrency"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Location implements Serializable
        {
            private TimeZone timeZone;
            private String ISOCountry;
            private String ISOCurrency;

            /** 
             * Get the 'TimeZone' element value. The time zone of the requestor.
             * 
             * @return value
             */
            public TimeZone getTimeZone() {
                return timeZone;
            }

            /** 
             * Set the 'TimeZone' element value. The time zone of the requestor.
             * 
             * @param timeZone
             */
            public void setTimeZone(TimeZone timeZone) {
                this.timeZone = timeZone;
            }

            /** 
             * Get the 'ISOCountry' attribute value. The country code of the requesting party in ISO 3166 format.
                                                  Source: http://bit.ly/OTA2_ISO3166
                                              
             * 
             * @return value
             */
            public String getISOCountry() {
                return ISOCountry;
            }

            /** 
             * Set the 'ISOCountry' attribute value. The country code of the requesting party in ISO 3166 format.
                                                  Source: http://bit.ly/OTA2_ISO3166
                                              
             * 
             * @param ISOCountry
             */
            public void setISOCountry(String ISOCountry) {
                this.ISOCountry = ISOCountry;
            }

            /** 
             * Get the 'ISOCurrency' attribute value. Specifies a three character currency code in ISO 4217 format.
                                                  Source: http://bit.ly/OTA2_ISO4217
                                              
             * 
             * @return value
             */
            public String getISOCurrency() {
                return ISOCurrency;
            }

            /** 
             * Set the 'ISOCurrency' attribute value. Specifies a three character currency code in ISO 4217 format.
                                                  Source: http://bit.ly/OTA2_ISO4217
                                              
             * 
             * @param ISOCurrency
             */
            public void setISOCurrency(String ISOCurrency) {
                this.ISOCurrency = ISOCurrency;
            }
        }
    }
    /** 
     * This element contains the transaction processing status and conditions.

                          NOTE: If any processing conditions have ocurred, there will be a compensation (human intervention) or resend
                          indicator.
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Results" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="failureInd"/>
     *     &lt;xs:attribute type="ns:Enum_ProcessingStatus" use="required" name="status"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="retryInd"/>
     *     &lt;xs:attribute type="xs:boolean" name="compensationInd"/>
     *     &lt;xs:attribute type="xs:string" use="prohibited" name="moreDataToken"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Results implements Serializable
    {
        private Boolean failureInd;
        private EnumProcessingStatus status;
        private Boolean retryInd;
        private Boolean compensationInd;

        /** 
         * Get the 'failureInd' attribute value. When TRUE, a transport, validation, application and/or business logic condition
                                    has ocurred.
                                
         * 
         * @return value
         */
        public Boolean getFailureInd() {
            return failureInd;
        }

        /** 
         * Set the 'failureInd' attribute value. When TRUE, a transport, validation, application and/or business logic condition
                                    has ocurred.
                                
         * 
         * @param failureInd
         */
        public void setFailureInd(Boolean failureInd) {
            this.failureInd = failureInd;
        }

        /** 
         * Get the 'status' attribute value. The status of the transaction processing.
                                    1. If Complete, the transaction was processed with no business warnings or errors generated.
                                    2. If NotProcessed, a condition ocurred and the failureInd will be TRUE.
                                    3. If Incomplete, a condition ocurred that prevented the completion of the requested action.
                                    4. If Unknown, a condition has ocurred and either the retryInd or compensationInd may be set to TRUE.
                                
         * 
         * @return value
         */
        public EnumProcessingStatus getStatus() {
            return status;
        }

        /** 
         * Set the 'status' attribute value. The status of the transaction processing.
                                    1. If Complete, the transaction was processed with no business warnings or errors generated.
                                    2. If NotProcessed, a condition ocurred and the failureInd will be TRUE.
                                    3. If Incomplete, a condition ocurred that prevented the completion of the requested action.
                                    4. If Unknown, a condition has ocurred and either the retryInd or compensationInd may be set to TRUE.
                                
         * 
         * @param status
         */
        public void setStatus(EnumProcessingStatus status) {
            this.status = status;
        }

        /** 
         * Get the 'retryInd' attribute value. When the failureInd is TRUE and the retryInd is TRUE, a condition has ocurred
                                    that does not require human intervention and the transaction may be resent.
                                
         * 
         * @return value
         */
        public Boolean getRetryInd() {
            return retryInd;
        }

        /** 
         * Set the 'retryInd' attribute value. When the failureInd is TRUE and the retryInd is TRUE, a condition has ocurred
                                    that does not require human intervention and the transaction may be resent.
                                
         * 
         * @param retryInd
         */
        public void setRetryInd(Boolean retryInd) {
            this.retryInd = retryInd;
        }

        /** 
         * Get the 'compensationInd' attribute value. When the failureInd is TRUE and this compensationInd is TRUE, a condition has
                                    ocurred that may require human intervention.
                                
         * 
         * @return value
         */
        public Boolean getCompensationInd() {
            return compensationInd;
        }

        /** 
         * Set the 'compensationInd' attribute value. When the failureInd is TRUE and this compensationInd is TRUE, a condition has
                                    ocurred that may require human intervention.
                                
         * 
         * @param compensationInd
         */
        public void setCompensationInd(Boolean compensationInd) {
            this.compensationInd = compensationInd;
        }
    }
}
