
package org.opentravel.common.message.v02;

import java.io.Serializable;

/** 
 * All messages contain service and header elements followed by RQ/RS elements.
 the RQ/RS elements
 must be a member of the OTA2_Payload substitution group.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA2_Envelope">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ServiceIdentifier" name="Service" minOccurs="1"/>
 *     &lt;xs:element ref="ns:MessageHeader" minOccurs="1"/>
 *     &lt;xs:element ref="ns:OTA2_Payload"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OTA2Envelope implements Serializable
{
    private ServiceIdentifier service;
    private MessageHeader messageHeader;
    private OTA2Payload OTA2Payload;

    /** 
     * Get the 'Service' element value.
     * 
     * @return value
     */
    public ServiceIdentifier getService() {
        return service;
    }

    /** 
     * Set the 'Service' element value.
     * 
     * @param service
     */
    public void setService(ServiceIdentifier service) {
        this.service = service;
    }

    /** 
     * Get the 'MessageHeader' element value.
     * 
     * @return value
     */
    public MessageHeader getMessageHeader() {
        return messageHeader;
    }

    /** 
     * Set the 'MessageHeader' element value.
     * 
     * @param messageHeader
     */
    public void setMessageHeader(MessageHeader messageHeader) {
        this.messageHeader = messageHeader;
    }

    /** 
     * Get the 'OTA2_Payload' element value.
     * 
     * @return value
     */
    public OTA2Payload getOTA2Payload() {
        return OTA2Payload;
    }

    /** 
     * Set the 'OTA2_Payload' element value.
     * 
     * @param OTA2Payload
     */
    public void setOTA2Payload(OTA2Payload OTA2Payload) {
        this.OTA2Payload = OTA2Payload;
    }
}
