
package org.opentravel.common.message.v02;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opentravel.common.v02.DataPolicySubGrp;
import org.opentravel.common.v02.EncryptionSubGrp;
import org.opentravel.common.v02.TargetSystem;
import org.opentravel.common.v02.Transaction;

/** 
 * Payload base type for declaring message elements. All messages
 elements must extend this type AND must end with a Extension element.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OTA2_Payload">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:DataPolicySubGrp" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element ref="ns:EncryptionSubGrp" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:TargetSystem" name="TargetSystem" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:Transaction" name="Transaction" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="timeStamp"/>
 *   &lt;xs:attribute type="xs:decimal" use="required" name="version"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="dataPolicyInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="encryptionInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OTA2Payload1 implements Serializable
{
    private List<DataPolicySubGrp> dataPolicySubGrpList = new ArrayList<DataPolicySubGrp>();
    private List<EncryptionSubGrp> encryptionSubGrpList = new ArrayList<EncryptionSubGrp>();
    private TargetSystem targetSystem;
    private Transaction transaction;
    private Date timeStamp;
    private BigDecimal version;
    private Boolean dataPolicyInd;
    private Boolean encryptionInd;

    /** 
     * Get the list of 'DataPolicySubGrp' element items. Details about data policy(s) that apply to all or a portion of this message.
     * 
     * @return list
     */
    public List<DataPolicySubGrp> getDataPolicySubGrpList() {
        return dataPolicySubGrpList;
    }

    /** 
     * Set the list of 'DataPolicySubGrp' element items. Details about data policy(s) that apply to all or a portion of this message.
     * 
     * @param list
     */
    public void setDataPolicySubGrpList(List<DataPolicySubGrp> list) {
        dataPolicySubGrpList = list;
    }

    /** 
     * Get the list of 'EncryptionSubGrp' element items. Details about encrypted information within this message.
     * 
     * @return list
     */
    public List<EncryptionSubGrp> getEncryptionSubGrpList() {
        return encryptionSubGrpList;
    }

    /** 
     * Set the list of 'EncryptionSubGrp' element items. Details about encrypted information within this message.
     * 
     * @param list
     */
    public void setEncryptionSubGrpList(List<EncryptionSubGrp> list) {
        encryptionSubGrpList = list;
    }

    /** 
     * Get the 'TargetSystem' element value. The target (or receiving) processing system.
     * 
     * @return value
     */
    public TargetSystem getTargetSystem() {
        return targetSystem;
    }

    /** 
     * Set the 'TargetSystem' element value. The target (or receiving) processing system.
     * 
     * @param targetSystem
     */
    public void setTargetSystem(TargetSystem targetSystem) {
        this.targetSystem = targetSystem;
    }

    /** 
     * Get the 'Transaction' element value. Transactional processing information.
     * 
     * @return value
     */
    public Transaction getTransaction() {
        return transaction;
    }

    /** 
     * Set the 'Transaction' element value. Transactional processing information.
     * 
     * @param transaction
     */
    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    /** 
     * Get the 'timeStamp' attribute value. A timestamp for when the message was created.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'timeStamp' attribute value. A timestamp for when the message was created.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'version' attribute value. The OpenTravel message version indicated by a decimal value.
                  
     * 
     * @return value
     */
    public BigDecimal getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. The OpenTravel message version indicated by a decimal value.
                  
     * 
     * @param version
     */
    public void setVersion(BigDecimal version) {
        this.version = version;
    }

    /** 
     * Get the 'dataPolicyInd' attribute value. If true, data policy information has been specified and is contained
                      in the DataPolicy element.
                  
     * 
     * @return value
     */
    public Boolean getDataPolicyInd() {
        return dataPolicyInd;
    }

    /** 
     * Set the 'dataPolicyInd' attribute value. If true, data policy information has been specified and is contained
                      in the DataPolicy element.
                  
     * 
     * @param dataPolicyInd
     */
    public void setDataPolicyInd(Boolean dataPolicyInd) {
        this.dataPolicyInd = dataPolicyInd;
    }

    /** 
     * Get the 'encryptionInd' attribute value. If true, all or portions of this message are encrypted and the Encryption
                      element should be parsed.
                  
     * 
     * @return value
     */
    public Boolean getEncryptionInd() {
        return encryptionInd;
    }

    /** 
     * Set the 'encryptionInd' attribute value. If true, all or portions of this message are encrypted and the Encryption
                      element should be parsed.
                  
     * 
     * @param encryptionInd
     */
    public void setEncryptionInd(Boolean encryptionInd) {
        this.encryptionInd = encryptionInd;
    }
}
