
package org.opentravel.common.message.v02;

import java.io.Serializable;

/** 
 * Processing Condition: Descriptive information for conditions that occured during the processing
 of the transaction.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProcessingCondition">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Type">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="ns:Enum_ProcessingCondition">
 *             &lt;xs:attribute type="xs:string" use="optional" name="extension"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="recordID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="code"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="description"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="url"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="language"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="xmlTag"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProcessingCondition implements Serializable
{
    private EnumProcessingCondition typeEnumProcessingCondition;
    private String typeExtension;
    private String recordID;
    private String code;
    private String description;
    private String url;
    private String language;
    private String xmlTag;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public EnumProcessingCondition getTypeEnumProcessingCondition() {
        return typeEnumProcessingCondition;
    }

    /** 
     * Set the extension value.
     * 
     * @param typeEnumProcessingCondition
     */
    public void setTypeEnumProcessingCondition(
            EnumProcessingCondition typeEnumProcessingCondition) {
        this.typeEnumProcessingCondition = typeEnumProcessingCondition;
    }

    /** 
     * Get the 'extension' attribute value. A string value that represents an "Other_", or extended, enumerated
                                          value agreed upon between trading partners.

                                          NOTE: It is recommended that you submit an OpenTravel comment to formally add any extended
                                          enumerations to the OpenTravel Specification to maximize trading partner interoperability.
                                      
     * 
     * @return value
     */
    public String getTypeExtension() {
        return typeExtension;
    }

    /** 
     * Set the 'extension' attribute value. A string value that represents an "Other_", or extended, enumerated
                                          value agreed upon between trading partners.

                                          NOTE: It is recommended that you submit an OpenTravel comment to formally add any extended
                                          enumerations to the OpenTravel Specification to maximize trading partner interoperability.
                                      
     * 
     * @param typeExtension
     */
    public void setTypeExtension(String typeExtension) {
        this.typeExtension = typeExtension;
    }

    /** 
     * Get the 'recordID' attribute value. The record ID of the record within a group of records that failed successful processing and
                      generated a processing condition.

                      NOTE: Typically used for batch processing and this value may contain a concatenation of a unique failed transaction ID
                      with specific record(s) associated with that transaction.
                  
     * 
     * @return value
     */
    public String getRecordID() {
        return recordID;
    }

    /** 
     * Set the 'recordID' attribute value. The record ID of the record within a group of records that failed successful processing and
                      generated a processing condition.

                      NOTE: Typically used for batch processing and this value may contain a concatenation of a unique failed transaction ID
                      with specific record(s) associated with that transaction.
                  
     * 
     * @param recordID
     */
    public void setRecordID(String recordID) {
        this.recordID = recordID;
    }

    /** 
     * Get the 'code' attribute value. A value from the OpenTravel Code List Error Codes (ERR) table to describe this processing
                      condition in more detail.
                  
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. A value from the OpenTravel Code List Error Codes (ERR) table to describe this processing
                      condition in more detail.
                  
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'description' attribute value. Additional information about this processing condition.
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'description' attribute value. Additional information about this processing condition.
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'url' attribute value. A URL to a source that further describes this processing condition.
     * 
     * @return value
     */
    public String getUrl() {
        return url;
    }

    /** 
     * Set the 'url' attribute value. A URL to a source that further describes this processing condition.
     * 
     * @param url
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /** 
     * Get the 'language' attribute value. The ISO-639-2 language identification code for the language that this processing condition
                      description is in. Source: http://bit.ly/OTA2_ISO639
                  
     * 
     * @return value
     */
    public String getLanguage() {
        return language;
    }

    /** 
     * Set the 'language' attribute value. The ISO-639-2 language identification code for the language that this processing condition
                      description is in. Source: http://bit.ly/OTA2_ISO639
                  
     * 
     * @param language
     */
    public void setLanguage(String language) {
        this.language = language;
    }

    /** 
     * Get the 'xmlTag' attribute value. Identifies an unknown or misspelled tag that caused a processing condition. It is
                      recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one
                      tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data,
                      e.g. [Type=ReqFieldMissing].
                      Source: http://bit.ly/OTA2_XpathSyntax
                  
     * 
     * @return value
     */
    public String getXmlTag() {
        return xmlTag;
    }

    /** 
     * Set the 'xmlTag' attribute value. Identifies an unknown or misspelled tag that caused a processing condition. It is
                      recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one
                      tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data,
                      e.g. [Type=ReqFieldMissing].
                      Source: http://bit.ly/OTA2_XpathSyntax
                  
     * 
     * @param xmlTag
     */
    public void setXmlTag(String xmlTag) {
        this.xmlTag = xmlTag;
    }
}
