
package org.opentravel.common.message.v02;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * 
 For all OpenTravel versioned messages, the version of the message is indicated by a decimal value.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceIdentifier">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="operation"/>
 *       &lt;xs:attribute type="xs:decimal" name="version"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceIdentifier implements Serializable
{
    private String string;
    private String operation;
    private BigDecimal version;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'operation' attribute value.
     * 
     * @return value
     */
    public String getOperation() {
        return operation;
    }

    /** 
     * Set the 'operation' attribute value.
     * 
     * @param operation
     */
    public void setOperation(String operation) {
        this.operation = operation;
    }

    /** 
     * Get the 'version' attribute value.
     * 
     * @return value
     */
    public BigDecimal getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value.
     * 
     * @param version
     */
    public void setVersion(BigDecimal version) {
        this.version = version;
    }
}
